/*
 * Decompiled with CFR 0.152.
 */
package hec.geometry;

import hec.geometry.RatingFunction;

public class DefaultRatingFunction
implements RatingFunction {
    double[] m_baseValues = null;
    double[] m_ratedValues = null;

    public double[] getBaseValues() {
        return this.m_baseValues;
    }

    public double[] getRatedValues() {
        return this.m_ratedValues;
    }

    public void setRatingFunction(double[] baseValues, double[] ratedValues) {
        this.m_baseValues = baseValues;
        this.m_ratedValues = ratedValues;
    }

    @Override
    public double getMax() {
        if (this.m_baseValues == null || this.m_baseValues.length == 0) {
            return 0.0;
        }
        return this.m_baseValues[this.m_baseValues.length - 1];
    }

    @Override
    public double getMin() {
        if (this.m_baseValues == null || this.m_baseValues.length == 0) {
            return 0.0;
        }
        return this.m_baseValues[0];
    }

    @Override
    public double getRatedMax() {
        if (this.m_ratedValues == null || this.m_ratedValues.length == 0) {
            return 0.0;
        }
        return this.m_ratedValues[this.m_ratedValues.length - 1];
    }

    @Override
    public double getRatedMin() {
        if (this.m_ratedValues == null || this.m_ratedValues.length == 0) {
            return 0.0;
        }
        return this.m_ratedValues[0];
    }

    @Override
    public double getRatedValue(double baseValue) {
        if (this.m_baseValues == null || this.m_baseValues.length == 0) {
            return Double.NEGATIVE_INFINITY;
        }
        int loIndex = 0;
        int hiIndex = 0;
        if (baseValue <= this.m_baseValues[0]) {
            loIndex = 0;
            hiIndex = 1;
        } else if (baseValue >= this.m_baseValues[this.m_baseValues.length - 1]) {
            loIndex = this.m_baseValues.length - 2;
            hiIndex = this.m_baseValues.length - 1;
        } else {
            int i = 0;
            for (i = 0; i < this.m_baseValues.length; ++i) {
                if (this.m_baseValues[i] <= baseValue) continue;
                hiIndex = i;
                loIndex = i - 1;
                break;
            }
        }
        double deltaX = this.m_baseValues[hiIndex] - this.m_baseValues[loIndex];
        if (deltaX == 0.0) {
            return this.m_ratedValues[hiIndex];
        }
        return this.m_ratedValues[loIndex] + (this.m_ratedValues[hiIndex] - this.m_ratedValues[loIndex]) * ((baseValue - this.m_baseValues[loIndex]) / deltaX);
    }

    @Override
    public double getBaseValue(double ratedValue) {
        if (this.m_ratedValues == null || this.m_ratedValues.length == 0) {
            return Double.NEGATIVE_INFINITY;
        }
        int loIndex = 0;
        int hiIndex = 0;
        if (ratedValue <= this.m_ratedValues[0]) {
            loIndex = 0;
            hiIndex = 1;
        } else if (ratedValue >= this.m_ratedValues[this.m_ratedValues.length - 1]) {
            loIndex = this.m_ratedValues.length - 2;
            hiIndex = this.m_ratedValues.length - 1;
        } else {
            int i = 0;
            for (i = 0; i < this.m_ratedValues.length; ++i) {
                if (this.m_ratedValues[i] <= ratedValue) continue;
                hiIndex = i;
                loIndex = i - 1;
                break;
            }
        }
        double deltaX = this.m_ratedValues[hiIndex] - this.m_ratedValues[loIndex];
        if (deltaX == 0.0) {
            return this.m_baseValues[hiIndex];
        }
        return this.m_baseValues[loIndex] + (this.m_baseValues[hiIndex] - this.m_baseValues[loIndex]) * ((ratedValue - this.m_ratedValues[loIndex]) / deltaX);
    }

    public static void main(String[] args) {
        DefaultRatingFunction df = new DefaultRatingFunction();
        df.m_baseValues = new double[]{1.0, 10.0};
        df.m_ratedValues = new double[]{1.0, 20.0};
        System.out.println("Base = 5 , Rated = " + df.getRatedValue(5.0));
        System.out.println("Base = 1 , Rated = " + df.getRatedValue(1.0));
        System.out.println("Base = 10 , Rated = " + df.getRatedValue(10.0));
        System.out.println("Base = 0 , Rated = " + df.getRatedValue(0.0));
        System.out.println("Base = 25 , Rated = " + df.getRatedValue(25.0));
        System.out.println("Rated = 10 , Base = " + df.getBaseValue(10.0));
        System.out.println("Rated = 2 , Base = " + df.getBaseValue(2.0));
        System.out.println("Rated = 20 , Base = " + df.getBaseValue(20.0));
        System.out.println("Rated = 0 , Base = " + df.getBaseValue(0.0));
        System.out.println("Rated = 25 , Base = " + df.getBaseValue(25.0));
    }
}

