/*
 * Decompiled with CFR 0.152.
 */
package hec.geometry;

import hec.geometry.WorldPt;

public class LocalPt {
    public int x;
    public int y;

    public LocalPt() {
    }

    public LocalPt(int px, int py) {
        this.x = px;
        this.y = py;
    }

    public LocalPt(LocalPt p) {
        this.x = p.x;
        this.y = p.y;
    }

    public void init(int px, int py) {
        this.x = px;
        this.y = py;
    }

    public void init(LocalPt p) {
        this.x = p.x;
        this.y = p.y;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public WorldPt getNormal() {
        double len = Math.sqrt(this.x * this.x + this.y * this.y);
        WorldPt p = new WorldPt();
        if (len == 0.0) {
            p.init(this.x, this.y);
        } else {
            p.init((double)this.x / len, (double)this.y / len);
        }
        return p;
    }

    public double ptNearLineSeg(LocalPt pt0, LocalPt pt1, LocalPt ptn) {
        double dx = pt1.x - pt0.x;
        double dy = pt1.y - pt0.y;
        if (dx == 0.0 && dy == 0.0) {
            dx = this.x - pt0.x;
            dy = this.y - pt0.y;
            ptn = pt0;
            if (dx == 0.0 && dy == 0.0) {
                return 0.0;
            }
            return Math.sqrt(dx * dx + dy * dy);
        }
        double t = ((double)(this.x - pt0.x) * dx + (double)(this.y - pt0.y) * dy) / (dx * dx + dy * dy);
        if (t < 0.0) {
            t = 0.0;
        } else if (t > 1.0) {
            t = 1.0;
        }
        double xc = (double)pt0.x + t * dx;
        double yc = (double)pt0.y + t * dy;
        dx = (double)this.x - xc;
        dy = (double)this.y - yc;
        ptn.x = (int)xc;
        ptn.y = (int)yc;
        if (dx == 0.0 && dy == 0.0) {
            return 0.0;
        }
        return Math.sqrt(dx * dx + dy * dy);
    }

    public boolean isValid() {
        return this.x != Integer.MIN_VALUE && this.y != Integer.MIN_VALUE;
    }

    public boolean equals(LocalPt p) {
        return this.x == p.x && this.y == p.y;
    }
}

