/*
 * Decompiled with CFR 0.152.
 */
package hec.geometry;

import hec.geometry.Axis;
import hec.geometry.RatingFunction;
import hec.geometry.WorldPt;
import java.awt.event.AdjustmentEvent;
import rma.lang.RmaMath;

public class LogAxis
extends Axis {
    public LogAxis(String n) {
        super(n);
        this._axisProp.type = this.getType();
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public void unZoom() {
        this.zoomIn(this._min, this._max);
        this.zoomByFactor(2.0);
    }

    @Override
    public void computeScaling(double min, double max) {
        double lmin;
        if (this._localRange <= 0) {
            return;
        }
        if (max <= 0.0 || min <= 0.0) {
            return;
        }
        double lmax = RmaMath.log10(max);
        double lwview = lmax - (lmin = RmaMath.log10(min));
        if (lwview == 0.0) {
            throw new RuntimeException("WORLD VIEW EQUAL TO ZERO in computeScaling(double,double)");
        }
        this._scale = (double)this._localRange / lwview;
        double log_w = (double)this._localRange / this._scale;
        this._actmin = Math.pow(10.0, this._origin - log_w * 0.5);
        if (this._actmin < this._min) {
            this._actmin = this._min;
            this._origin = RmaMath.log10(this._actmin) + log_w * 0.5;
        }
        this._actmax = Math.pow(10.0, RmaMath.log10(this._actmin) + log_w);
        if (this._actmax > this._max) {
            this._actmax = this._max;
            this._origin = RmaMath.log10(this._actmax) - log_w * 0.5;
            this._actmin = Math.pow(10.0, RmaMath.log10(this._actmax) - log_w);
        }
        if ((lwview = RmaMath.log10(this.getRatedValue(max)) - RmaMath.log10(this.getRatedValue(min))) == 0.0) {
            throw new RuntimeException("WORLD VIEW EQUAL TO ZERO in computeScaling(double,double)");
        }
        this._scale = (double)this._localRange / lwview;
    }

    @Override
    public void computeScaling() {
        double lmin;
        if (this._localRange <= 0) {
            return;
        }
        double lmax = RmaMath.log10(this._max);
        double lwview = (lmax - (lmin = RmaMath.log10(this._min))) * this._zoom;
        if (lwview == 0.0) {
            throw new RuntimeException("WORLD VIEW EQUAL TO ZERO in computeScaling()");
        }
        this._scale = (double)this._localRange / lwview;
        double logw = (double)this._localRange / this._scale;
        this._actmin = Math.pow(10.0, this._origin - logw * 0.5);
        if (this._actmin < this._min) {
            this._actmin = this._min;
            this._origin = RmaMath.log10(this._actmin) + logw * 0.5;
        }
        this._actmax = Math.pow(10.0, RmaMath.log10(this._actmin) + logw);
        if (this._actmax > this._max) {
            this._actmax = this._max;
            this._origin = RmaMath.log10(this._actmax) - logw * 0.5;
            this._actmin = Math.pow(10.0, RmaMath.log10(this._actmax) - logw);
        }
        if ((lwview = (RmaMath.log10(this.getRatedValue(this._max)) - RmaMath.log10(this.getRatedValue(this._min))) * this._zoom) == 0.0) {
            throw new RuntimeException("WORLD VIEW EQUAL TO ZERO in computeScaling()");
        }
        this._scale = (double)this._localRange / lwview;
    }

    @Override
    public int computeScrollPosition() {
        int ival;
        double max = this.getMax();
        double min = this.getMin();
        double actmax = this.getActMax();
        double actmin = this.getActMin();
        double logratedMax = RmaMath.log10(this.getRatedValue(max));
        double logratedMin = RmaMath.log10(this.getRatedValue(min));
        double worldRange = logratedMax - logratedMin;
        if (this.isReversed()) {
            double logRatedActMax = RmaMath.log10(this.getRatedValue(actmax));
            ival = (int)((logratedMax - logRatedActMax) / worldRange * 10000.0);
        } else {
            double logRatedActMin = RmaMath.log10(this.getRatedValue(actmin));
            ival = (int)((logRatedActMin - logratedMin) / worldRange * 10000.0);
        }
        return ival;
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        if ((e.getAdjustmentType() & 0x259) > 0) {
            int ival = e.getValue();
            double logMax = RmaMath.log10(this._max);
            double logMin = RmaMath.log10(this._min);
            double logActMax = RmaMath.log10(this._actmax);
            double logActMin = RmaMath.log10(this._actmin);
            if (this._isReversed) {
                this._origin = logMax - (double)ival / 10000.0 * (logMax - logMin) - (logActMax - logActMin) * 0.5;
            } else {
                double maxRange = 10000.0;
                double thumPos = ival;
                this._origin = thumPos / maxRange * (this._max - logMin) + logMin + (logActMax - logActMin) * 0.5;
            }
            this.computeScaling(this._actmin, this._actmax);
            this._axisProp.actmax = this._actmax;
            this._axisProp.actmin = this._actmin;
            this.computeAutoViewValues();
            this.setChanged();
            this.notifyObservers("COMPUTED_SCALE");
        }
    }

    @Override
    public void updateRatedFunctionScroll(Axis baseAxis, AdjustmentEvent e) {
        RatingFunction rf = this.getRatingFunction();
        if (rf == null) {
            this.adjustmentValueChanged(e);
            return;
        }
        if (baseAxis == null) {
            return;
        }
        double vmax = rf.getBaseValue(baseAxis.getActMax());
        double vmin = rf.getBaseValue(baseAxis.getActMin());
        double amax = this.getMax();
        double amin = this.getMin();
        int ival = e.getValue();
        this._origin = this.isReversed() ? amax - (double)ival / 10000.0 * (amax - amin) - (vmax - vmin) * 0.5 : (double)ival / 10000.0 * (amax - amin) + amin + (vmax - vmin) * 0.5;
        double wview = this.getRatedValue(vmax) - this.getRatedValue(vmin);
        if (wview == 0.0) {
            throw new RuntimeException("WORLD VIEW EQUAL TO ZERO in computeScaling(double,double)");
        }
        this._scale = (double)this._localRange / wview;
        this._axisProp.actmax = this._actmax = vmax;
        this._axisProp.actmin = this._actmin = vmin;
        this.computeAutoViewValues();
        this.setChanged();
        this.notifyObservers("COMPUTED_SCALE");
    }

    @Override
    public void zoomInUnMod(double wmin, double wmax) {
        double imax;
        double imin;
        if (!this._isReversed) {
            imin = this.w2lE(wmin);
            imax = this.w2lE(wmax);
        } else {
            imin = this.w2lE(wmax);
            imax = this.w2lE(wmin);
        }
        if (this._localRange < 0 || imax <= imin) {
            return;
        }
        double factor = (imax - imin) / (double)this._localRange;
        this._origin = (RmaMath.log10(wmax) + RmaMath.log10(wmin)) / 2.0;
        double zm = this._zoom * factor;
        if (zm < 1.0E-5) {
            zm = 1.0E-5;
        }
        if (zm > 1.0) {
            zm = 1.0;
        }
        this._zoom = zm;
        this.computeScaling(wmin, wmax);
        this.computeTicInterval();
        this.setChanged();
        this.notifyObservers("NEW_ZOOM");
    }

    @Override
    public void zoomIn(double wmin, double wmax) {
        double imax;
        double imin;
        if (!this._isReversed) {
            imin = this.w2lE(wmin);
            imax = this.w2lE(wmax);
        } else {
            imin = this.w2lE(wmax);
            imax = this.w2lE(wmin);
        }
        if (this._localRange < 0 || imax <= imin) {
            return;
        }
        double factor = (imax - imin) / (double)this._localRange;
        this._origin = (RmaMath.log10(wmax) + RmaMath.log10(wmin)) / 2.0;
        double zm = this._zoom * factor;
        if (zm < 1.0E-5) {
            zm = 1.0E-5;
        }
        if (zm > 1.0) {
            zm = 1.0;
        }
        this._zoom = zm;
        this.computeScaling(wmin, wmax);
        this.computeTicInterval();
        this.computeAutoViewValues();
        this._axisProp.actmax = this._actmax;
        this._axisProp.actmin = this._actmin;
        this.setChanged();
        this.notifyObservers("NEW_ZOOM");
    }

    @Override
    public void zoomIn(int imin, int imax) {
        double logt2;
        if (this._localRange < 0 || imax <= imin) {
            return;
        }
        double t1 = this.l2w(imax);
        double t2 = this.l2w(imin);
        double logt1 = RmaMath.log10(t1);
        if (Math.abs(logt1 - (logt2 = RmaMath.log10(t2))) < 1.0E-6) {
            return;
        }
        double factor = (double)(imax - imin) / (double)this._localRange;
        int x = (imax + imin) / 2;
        this._origin = (logt2 + logt1) / 2.0;
        double zm = this._zoom * factor;
        if (zm < 1.0E-5) {
            zm = 1.0E-5;
        }
        if (zm > 1.0) {
            zm = 1.0;
        }
        this._zoom = zm;
        if (logt1 < logt2) {
            this.computeScaling(t1, t2);
        } else {
            this.computeScaling(t2, t1);
        }
        this.computeTicInterval();
        this.computeAutoViewValues();
        this._axisProp.actmax = this._actmax;
        this._axisProp.actmin = this._actmin;
        this.setChanged();
        this.notifyObservers("NEW_ZOOM");
    }

    @Override
    public void zoomByFactor(double factor) {
        double lrAMax = RmaMath.log10(this.getRatedValue(this._actmax));
        double lrAMin = RmaMath.log10(this.getRatedValue(this._actmin));
        factor = factor * (lrAMax - lrAMin) / (RmaMath.log10(this._actmax) - RmaMath.log10(this._actmin));
        factor = this.getRatedValue(factor);
        if (this._localRange < 0) {
            return;
        }
        double zm = this._zoom * factor;
        if (zm < 1.0E-5) {
            zm = 1.0E-5;
        }
        if (zm > 1.0) {
            zm = 1.0;
        }
        this._zoom = zm;
        this.computeScaling();
        this.computeTicInterval();
        this._axisProp.actmax = this._actmax;
        this._axisProp.actmin = this._actmin;
        this.computeAutoViewValues();
        this.setChanged();
        this.notifyObservers("NEW_ZOOM");
    }

    @Override
    public boolean isValidMinMax(double min, double max) {
        boolean valid = super.isValidMinMax(min, max);
        return valid && min > 0.0 && max > 0.0;
    }

    @Override
    public void setWorldExtents(double min, double max) {
        if (min > max) {
            double temp = max;
            max = min;
            min = temp;
        }
        min = min > 0.0 ? min : 1.0;
        double d = max = max > 0.0 ? max : 10.0;
        if (Math.abs(max - min) <= 1.0E-10) {
            double maxExp = Math.ceil(Math.log10(max));
            double minExp = Math.floor(Math.log10(max));
            min = Math.pow(10.0, minExp);
            max = Math.pow(10.0, maxExp);
        }
        this._min = this._axisProp.automin ? min : this._axisProp.min;
        this._max = this._axisProp.automax ? max : this._axisProp.max;
        this._dataMin = min;
        this._dataMax = max;
        this.computeNiceMinMax();
        if (this._axisProp.autoviewmin) {
            this._actmin = this._min;
            this._axisProp.actmin = this._min;
        } else {
            this._actmin = this._axisProp.actmin;
        }
        if (this._axisProp.autoviewmax) {
            this._actmax = this._max;
            this._axisProp.actmax = this._max;
        } else {
            this._actmax = this._axisProp.actmax;
        }
        this._origin = (RmaMath.log10(this._min) + RmaMath.log10(this._max)) * 0.5;
        this._zoom = 1.0;
        this._defaultExtents = false;
        this.computeScaling();
        this.computeTicInterval();
        this.setChanged();
        this.notifyObservers("COMPUTED_SCALE");
        this.setChanged();
        this.notifyObservers("NEW_ZOOM");
    }

    @Override
    public void growWorldExtents(double min, double max) {
        if (min > max) {
            double temp = max;
            max = min;
            min = temp;
        }
        min = min > 0.0 ? min : 1.0;
        double d = max = max > 0.0 ? max : 10.0;
        if (Math.abs(max - min) <= 1.0E-10) {
            double maxExp = Math.ceil(Math.log10(max));
            double minExp = Math.floor(Math.log10(max));
            min = Math.pow(10.0, minExp);
            max = Math.pow(10.0, maxExp);
        }
        if (this._defaultExtents) {
            this.setWorldExtents(min, max);
            return;
        }
        if (this._dataMin > min) {
            this._dataMin = min;
        }
        if (this._dataMax < max) {
            this._dataMax = max;
        }
        this.computeNiceMinMax();
        if (!this._axisProp.automin) {
            this._min = this._axisProp.min;
        }
        if (!this._axisProp.automax) {
            this._max = this._axisProp.max;
        }
        this._origin = (RmaMath.log10(this._min) + RmaMath.log10(this._max)) * 0.5;
        this._actmin = this._axisProp.autoviewmin ? this._min : this._axisProp.actmin;
        this._actmax = this._axisProp.autoviewmax ? this._max : this._axisProp.actmax;
        this._zoom = 1.0;
        this._defaultExtents = false;
        this.computeScaling(this._actmin, this._actmax);
        this.computeTicInterval();
        this.setChanged();
        this.notifyObservers("COMPUTED_SCALE");
        this.setChanged();
        this.notifyObservers("NEW_ZOOM");
    }

    @Override
    public WorldPt getWorldExtents() {
        return new WorldPt(this._min, this._max);
    }

    @Override
    public double getMin() {
        return this._min;
    }

    @Override
    public void computeScaling(int iview) {
        this._localRange = iview;
        this.computeScaling(this._actmin, this._actmax);
    }

    @Override
    public int w2l(double w) {
        double logw = RmaMath.log10(this.getRatedValue(w));
        double logActMin = RmaMath.log10(this.getRatedValue(this._actmin));
        double logActMax = RmaMath.log10(this.getRatedValue(this._actmax));
        if (this._isReversed) {
            return (int)((logActMax - logw) * this._scale);
        }
        return (int)((logw - logActMin) * this._scale);
    }

    @Override
    public double w2lE(double w) {
        double logw = RmaMath.log10(this.getRatedValue(w));
        double logActMin = RmaMath.log10(this.getRatedValue(this._actmin));
        double logActMax = RmaMath.log10(this.getRatedValue(this._actmax));
        if (this._isReversed) {
            return (int)((logActMax - logw) * this._scale);
        }
        return (int)((logw - logActMin) * this._scale);
    }

    @Override
    public double l2w(int l) {
        double logActMin = RmaMath.log10(this.getRatedValue(this._actmin));
        double logActMax = RmaMath.log10(this.getRatedValue(this._actmax));
        double val = this._isReversed ? logActMax - (double)l / this._scale : (double)l / this._scale + logActMin;
        return Math.pow(10.0, this.getUnRatedValue(val));
    }

    @Override
    public double l2wE(double l) {
        double logActMin = RmaMath.log10(this.getRatedValue(this._actmin));
        double logActMax = RmaMath.log10(this.getRatedValue(this._actmax));
        double val = this._isReversed ? logActMax - l / this._scale : l / this._scale + logActMin;
        return Math.pow(10.0, this.getUnRatedValue(val));
    }

    @Override
    public void computeNiceMinMax() {
        boolean i = false;
        double exp = Math.ceil(RmaMath.log10(this._dataMax));
        this._max = this._actmax = Math.pow(10.0, exp);
        i = false;
        exp = Math.floor(RmaMath.log10(this._dataMin));
        this._min = this._actmin = Math.pow(10.0, exp);
    }

    @Override
    public void computeTicInterval() {
    }
}

