/*
 * Decompiled with CFR 0.152.
 */
package hec.geometry;

import hec.geometry.AxisIterator;
import hec.geometry.LogAxis;
import java.math.BigDecimal;
import rma.util.RMAIO;

public class LogAxisIterator
extends AxisIterator {
    private boolean _iterateMinorScale = false;
    private boolean _iterateMajorScale = true;
    private double _oldVal;
    private double _minorTic = 1.0;
    private double _majorTic = 1.0;
    private int _exponent = 0;

    public LogAxisIterator(LogAxis ax, double del) {
        super(ax, del);
        this.reset();
        this._iterateMajorScale = true;
        this._oldVal = del;
        this._majorTic = ax.getMajorTic();
        this._minorTic = ax.getMinorTic();
    }

    @Override
    public void iterateMinorScale() {
        this._iterateMinorScale = true;
        this._iterateMajorScale = false;
    }

    @Override
    public String getValueString() {
        System.out.println("LogAxisIterator.getValueString() - " + this.getValue());
        return RMAIO.setPrecision2(this.getValue(), this._axis.getSigFig());
    }

    @Override
    public boolean next() {
        if (!this._iterateMinorScale) {
            if (Math.pow(10.0, this._exponent) > this._max) {
                return false;
            }
            this._curval = Math.pow(10.0, this._exponent);
            ++this._exponent;
        } else {
            if (Math.pow(10.0, this._exponent) >= this._max) {
                return false;
            }
            BigDecimal tempDecimal = new BigDecimal(this._curval);
            tempDecimal = tempDecimal.add(new BigDecimal(Math.pow(10.0, this._exponent)));
            tempDecimal = tempDecimal.setScale(Math.abs(this._exponent), 6);
            double value = Math.pow(10.0, this._exponent);
            String val = tempDecimal.toString();
            BigDecimal bd = new BigDecimal(Math.pow(10.0, this._exponent + 1)).setScale(Math.abs(this._exponent + 1), 6);
            String val2 = bd.toString();
            int result = tempDecimal.compareTo(bd);
            if (result == 0) {
                ++this._exponent;
            }
            this._curval = tempDecimal.doubleValue();
        }
        return true;
    }

    @Override
    public void reset() {
        this._min = this._axis.getActMin();
        this._max = this._axis.getActMax();
        this._thscl = this._axis.getThousScale();
        this._sigfig = this._axis.getSigFig();
        this._exponent = (int)Math.floor(Math.log(this._min) / Math.log(10.0));
        this._curval = Math.pow(10.0, this._exponent);
    }

    @Override
    public double getValue() {
        return this._curval;
    }

    @Override
    public int getLocalValue() {
        return this._axis.w2l(this.getValue());
    }
}

