/*
 * Decompiled with CFR 0.152.
 */
package hec.geometry;

import hec.geometry.Axis;
import hec.geometry.AxisProp;
import hec.geometry.RatingFunction;
import hec.geometry.WorldPt;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.SimpleArray;
import hec.statistics.NormalDist;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.AdjustmentEvent;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ProbabilityAxis
extends Axis {
    public static final double[] PROBABILITY_AXIS_VALUES = new double[]{0.9999999999, 0.999999999, 0.99999999, 0.9999999, 0.999999, 0.99999, 0.9999, 0.999, 0.99, 0.9, 0.5, 0.1, 0.01, 0.001, 1.0E-4, 1.0E-5, 1.0E-6, 1.0E-7, 1.0E-8, 1.0E-9, 1.0E-10};
    public static final String[] PROBABILITY_AXIS_LABELS = new String[]{"0.9999999999", "0.999999999", "0.99999999", "0.9999999", "0.999999", "0.99999", "0.9999", "0.999", "0.99", "0.9", "0.5", "0.1", "0.01", "0.001", "0.0001", "0.00001", "0.000001", "0.0000001", "0.00000001", "0.000000001", "0.0000000001"};
    public static final double AXIS_MINIMUM = 1.0E-4;
    public static final double AXIS_MAXIMUM = 0.9999;
    private double[] _axisValues;
    private String[] _axisLabels;
    static DecimalFormat df = new DecimalFormat("0.###########");
    static NormalDist normalDistribution = new NormalDist();

    public ProbabilityAxis(String n) {
        super(n);
        this._actmax = 0.9999;
        this._actmin = 1.0E-4;
        this._defaultMax = this._actmax;
        this._defaultMin = this._actmin;
        this._min = this._actmin;
        this._max = this._actmax;
        this._origin = 0.5;
        this._axisProp.type = this.getType();
        this._axisValues = PROBABILITY_AXIS_VALUES;
        this._axisLabels = PROBABILITY_AXIS_LABELS;
    }

    @Override
    public int getType() {
        return 4;
    }

    @Override
    public void invalidateWorldExtents() {
        this._defaultExtents = true;
        this._axisProp.isDefaultLimits = true;
        this._actmax = 0.9999;
        this._actmin = 1.0E-4;
        this._defaultMax = this._actmax;
        this._defaultMin = this._actmin;
        this._min = this._actmin;
        this._max = this._actmax;
        this.computeNiceMinMax();
        this.computeScaling(this._min, this._max);
    }

    private static int significantDigits(BigDecimal input) {
        return (input = input.stripTrailingZeros()).scale() < 0 ? input.precision() - input.scale() : input.precision();
    }

    @Override
    public void computeNiceMinMax() {
    }

    @Override
    public int getSigFig() {
        int index = -1;
        for (int i = 0; i < PROBABILITY_AXIS_VALUES.length; ++i) {
            if (!(PROBABILITY_AXIS_VALUES[i] >= this._max)) continue;
            index = i;
        }
        int sigFig = 4;
        if (index != -1 && (sigFig = Double.toString(PROBABILITY_AXIS_VALUES[index]).length() - 2) < 0) {
            sigFig = 0;
        }
        return sigFig;
    }

    @Override
    public void setAxisProp(AxisProp prop) {
        if (prop == null) {
            return;
        }
        this.setReversed(prop.isReversed);
        this.setNumTicLabelLevels(prop.numTicLabelLayers);
        double min = prop.automin ? 1.0E-4 : prop.min;
        double max = prop.automax ? 0.9999 : prop.max;
        double vmax = prop.autoviewmax ? max : prop.actmax;
        double vmin = prop.autoviewmin ? min : prop.actmin;
        this._actmax = vmax;
        this._actmin = vmin;
        this._max = max;
        this._min = min;
        this._scale = Math.abs((double)this._localRange / (ProbabilityAxis.getNormalDistribution(this._actmax) - ProbabilityAxis.getNormalDistribution(this._actmin)));
        double w = (double)this._localRange / this._scale;
        this._origin = ProbabilityAxis.getNormalDistribution(this._actmax) + w * 0.5;
        this._defaultExtents = prop.isDefaultLimits;
        this.getAxisProp();
        if (prop.label != null) {
            this.setLabel(prop.label);
        }
        this.setChanged();
        this.notifyObservers("COMPUTED_SCALE");
        this.setChanged();
        this.notifyObservers("NEW_ZOOM");
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        if ((e.getAdjustmentType() & 0x259) > 0) {
            double nMax = ProbabilityAxis.getNormalDistribution(this._max);
            double nMin = ProbabilityAxis.getNormalDistribution(this._min);
            double nActMax = ProbabilityAxis.getNormalDistribution(this._actmax);
            double nActMin = ProbabilityAxis.getNormalDistribution(this._actmin);
            int ival = e.getValue();
            if (this._isReversed) {
                this._origin = nMin - (double)ival / 10000.0 * Math.abs(nMax - nMin) - Math.abs(nActMax - nActMin) * 0.5;
            } else {
                double maxRange = 10000.0;
                double thumPos = ival;
                this._origin = thumPos / maxRange * Math.abs(nMax - nMin) + nMax + Math.abs(nActMax - nActMin) * 0.5;
            }
            this.computeScaling(this._actmin, this._actmax);
            this._axisProp.actmax = this._actmax;
            this._axisProp.actmin = this._actmin;
            this.computeAutoViewValues();
            this.setChanged();
            this.notifyObservers("COMPUTED_SCALE");
        }
    }

    @Override
    public void updateRatedFunctionScroll(Axis baseAxis, AdjustmentEvent e) {
        RatingFunction rf = this.getRatingFunction();
        if (rf == null) {
            this.adjustmentValueChanged(e);
            return;
        }
        if (baseAxis == null) {
            return;
        }
        double vmax = rf.getBaseValue(ProbabilityAxis.getNormalDistribution(baseAxis.getActMax()));
        double vmin = rf.getBaseValue(ProbabilityAxis.getNormalDistribution(baseAxis.getActMin()));
        double amax = ProbabilityAxis.getNormalDistribution(this.getMax());
        double amin = ProbabilityAxis.getNormalDistribution(this.getMin());
        int ival = e.getValue();
        double maxRange = 10000.0;
        this._origin = this.isReversed() ? amin - (double)ival / maxRange * (amax - amin) - (vmax - vmin) * 0.5 : (double)ival / maxRange * (amax - amin) + amax + (vmax - vmin) * 0.5;
        double wview = this.getRatedValue(vmax) - this.getRatedValue(vmin);
        if (wview == 0.0) {
            throw new RuntimeException("WORLD VIEW EQUAL TO ZERO in computeScaling(double,double)");
        }
        this._scale = (double)this._localRange / wview;
        this._axisProp.actmax = this._actmax = vmax;
        this._axisProp.actmin = this._actmin = vmin;
        this.computeAutoViewValues();
        this.setChanged();
        this.notifyObservers("COMPUTED_SCALE");
    }

    @Override
    public int computeScrollPosition() {
        double max = ProbabilityAxis.getNormalDistribution(this.getMax());
        double min = ProbabilityAxis.getNormalDistribution(this.getMin());
        double actmax = ProbabilityAxis.getNormalDistribution(this.getActMax());
        double actmin = ProbabilityAxis.getNormalDistribution(this.getActMin());
        double worldRange = Math.abs(max - min);
        int ival = this.getReversed() ? (int)(Math.abs(max + actmax) / worldRange * 10000.0) : (int)(Math.abs(actmin + min) / worldRange * 10000.0);
        return ival;
    }

    @Override
    public int w2l(double w) {
        return (int)this.w2lE(w);
    }

    @Override
    public double w2lE(double w) {
        if (this._isReversed) {
            return (this.getRatedValue(ProbabilityAxis.getNormalDistribution(this._actmin)) - this.getRatedValue(ProbabilityAxis.getNormalDistribution(w))) * this._scale;
        }
        return (this.getRatedValue(ProbabilityAxis.getNormalDistribution(w)) - this.getRatedValue(ProbabilityAxis.getNormalDistribution(this._actmax))) * this._scale;
    }

    @Override
    public double l2w(int l) {
        return this.l2wE(l);
    }

    @Override
    public double l2wE(double l) {
        double val = !this._isReversed ? this.getRatedValue(ProbabilityAxis.getNormalDistribution(this._actmax)) + l / this._scale : ProbabilityAxis.getNormalDistribution(this._actmin) - 100.0 / this._scale;
        return ProbabilityAxis.getInverseNormalDistribution(this.getUnRatedValue(val));
    }

    @Override
    public void growWorldExtents(double min, double max) {
        double tempMax = this._max;
        double tempMin = this._min;
        if (max > this._max) {
            tempMax = max;
        }
        if (min < this._min) {
            tempMin = min;
        }
        this.setWorldExtents(tempMin, tempMax);
    }

    @Override
    public void growToGlyphBounds(double min, double max) {
    }

    @Override
    public void setWorldExtents(double min, double max) {
        if (!this.isValidMinMax(min, max)) {
            return;
        }
        if (Math.abs(max - min) <= 1.0E-10 * Math.abs(max)) {
            if (max == 0.0) {
                max = 1.0;
            } else {
                double mag = Math.floor(0.4342944819 * Math.log(Math.abs(max)));
                double x = Math.exp(2.302585093 * mag);
                if (x > 10.0) {
                    x = 10.0;
                }
                max += x;
            }
        }
        this._max = max;
        this._min = min;
        this._axisProp.max = max;
        this._axisProp.min = min;
        this._origin = (ProbabilityAxis.getNormalDistribution(this._min) + ProbabilityAxis.getNormalDistribution(this._max)) * 0.5;
        this._zoom = 1.0;
        this._defaultExtents = false;
        this.computeScaling();
        this.computeTicInterval();
        this.setChanged();
        this.notifyObservers("COMPUTED_SCALE");
        this.setChanged();
        this.notifyObservers("NEW_ZOOM");
    }

    @Override
    public void computeScaling(double min, double max) {
        if (this._localRange <= 0) {
            return;
        }
        double tmin = ProbabilityAxis.getNormalDistribution(max);
        double tmax = ProbabilityAxis.getNormalDistribution(min);
        this._scale = tmax - tmin == 0.0 ? (double)this._localRange : Math.abs((double)this._localRange / (tmax - tmin));
        double w = (double)this._localRange / this._scale;
        this._actmin = ProbabilityAxis.getInverseNormalDistribution(this._origin + w * 0.5);
        if (this._actmin < this._min) {
            this._actmin = this._min;
            this._origin = ProbabilityAxis.getNormalDistribution(this._actmin) - w * 0.5;
        }
        this._actmax = ProbabilityAxis.getInverseNormalDistribution(ProbabilityAxis.getNormalDistribution(this._actmin) - w);
        if (this._actmax > this._max) {
            this._actmax = this._max;
            this._origin = ProbabilityAxis.getNormalDistribution(this._actmax) + w * 0.5;
            this._actmin = ProbabilityAxis.getInverseNormalDistribution(ProbabilityAxis.getNormalDistribution(this._actmax) + w);
        }
    }

    @Override
    public void computeScaling() {
        this.computeScaling(this._min, this._max);
    }

    @Override
    public void zoomIn(double wmin, double wmax) {
        double imax;
        double imin;
        if (!this._isReversed) {
            imin = this.w2lE(wmin);
            imax = this.w2lE(wmax);
        } else {
            imin = this.w2lE(wmax);
            imax = this.w2lE(wmin);
        }
        if (this._localRange < 0) {
            return;
        }
        double factor = Math.abs(imax - imin) / (double)this._localRange;
        this._origin = (ProbabilityAxis.getNormalDistribution(wmax) + ProbabilityAxis.getNormalDistribution(wmin)) / 2.0;
        double zm = this._zoom * factor;
        if (zm < 1.0E-5) {
            zm = 1.0E-5;
        }
        if (zm > 1.0) {
            zm = 1.0;
        }
        this._zoom = zm;
        this.computeScaling(wmin, wmax);
        this.computeTicInterval();
        this.computeAutoViewValues();
        this._axisProp.actmax = this._actmax;
        this._axisProp.actmin = this._actmin;
        this.setChanged();
        this.notifyObservers("NEW_ZOOM");
    }

    @Override
    public void zoomByFactor(double factor) {
        double tmin = ProbabilityAxis.getNormalDistribution(this._actmin);
        double tmax = ProbabilityAxis.getNormalDistribution(this._actmax);
        double rAMax = this.getRatedValue(tmax);
        double rAMin = this.getRatedValue(tmin);
        factor *= Math.abs((rAMax - rAMin) / (tmax - tmin));
        factor = this.getRatedValue(factor);
        if (this._localRange < 0) {
            return;
        }
        double zm = this._zoom * factor;
        if (zm < 1.0E-5) {
            zm = 1.0E-5;
        }
        if (zm > 1.0) {
            zm = 1.0;
        }
        this._zoom = zm;
        this.computeScaling();
        this.computeTicInterval();
        this._axisProp.actmax = this._actmax;
        this._axisProp.actmin = this._actmin;
        this.computeAutoViewValues();
        this.setChanged();
        this.notifyObservers("NEW_ZOOM");
    }

    @Override
    public void zoomIn(int imin, int imax) {
        double zm;
        double t2;
        if (this._localRange < 0 || imax <= imin) {
            return;
        }
        double t1 = ProbabilityAxis.getNormalDistribution(this.l2w(imax));
        if (Math.abs(t1 - (t2 = ProbabilityAxis.getNormalDistribution(this.l2w(imin)))) < 1.0E-6) {
            return;
        }
        double factor = (double)(imax - imin) / (double)this._localRange;
        int x = (imax + imin) / 2;
        this._origin = (t2 + t1) / 2.0;
        if (factor < 0.1) {
            factor = 0.1;
        }
        if ((zm = this._zoom * factor) < 1.0E-5) {
            zm = 1.0E-5;
        }
        if (zm > 1.0) {
            zm = 1.0;
        }
        this._zoom = zm;
        if (t1 > t2) {
            this.computeScaling(ProbabilityAxis.getInverseNormalDistribution(t1), ProbabilityAxis.getInverseNormalDistribution(t2));
        } else {
            this.computeScaling(ProbabilityAxis.getInverseNormalDistribution(t2), ProbabilityAxis.getInverseNormalDistribution(t1));
        }
        this.computeTicInterval();
        this._axisProp.autoviewmax = this._actmax == this._max;
        this._axisProp.autoviewmin = this._actmin == this._min;
        this._axisProp.actmax = this._actmax;
        this._axisProp.actmin = this._actmin;
        this.setChanged();
        this.notifyObservers("NEW_ZOOM");
    }

    public static double getInverseNormalDistribution(double x) {
        return normalDistribution.getCDF(-1.0 * x);
    }

    public static double getNormalDistribution(double p) {
        return -1.0 * normalDistribution.invCDF(p);
    }

    public static void main(String[] args) {
        int i;
        double p = 1.0E-5;
        ProbabilityAxis axis = new ProbabilityAxis("Y ME");
        for (i = 0; i < 5; ++i) {
            System.out.println((float)p + " " + ProbabilityAxis.getNormalDistribution(p));
            p /= 0.1;
        }
        System.out.println("0.5 " + ProbabilityAxis.getNormalDistribution(0.5));
        System.out.println("0.9 " + ProbabilityAxis.getNormalDistribution(0.9));
        System.out.println("0.99 " + ProbabilityAxis.getNormalDistribution(0.99));
        System.out.println("0.999 " + ProbabilityAxis.getNormalDistribution(0.999));
        System.out.println("0.9999 " + ProbabilityAxis.getNormalDistribution(0.9999));
        p = 1.0E-5;
        for (i = 0; i < 5; ++i) {
            System.out.println((float)ProbabilityAxis.getNormalDistribution(p) + " " + ProbabilityAxis.getInverseNormalDistribution(ProbabilityAxis.getNormalDistribution(p)));
            p /= 0.1;
        }
        System.out.println((float)ProbabilityAxis.getNormalDistribution(0.5) + " " + ProbabilityAxis.getInverseNormalDistribution(ProbabilityAxis.getNormalDistribution(0.5)));
        System.out.println((float)ProbabilityAxis.getNormalDistribution(0.9) + " " + ProbabilityAxis.getInverseNormalDistribution(ProbabilityAxis.getNormalDistribution(0.9)));
        System.out.println((float)ProbabilityAxis.getNormalDistribution(0.99) + " " + ProbabilityAxis.getInverseNormalDistribution(ProbabilityAxis.getNormalDistribution(0.99)));
        System.out.println((float)ProbabilityAxis.getNormalDistribution(0.999) + " " + ProbabilityAxis.getInverseNormalDistribution(ProbabilityAxis.getNormalDistribution(0.999)));
        System.out.println((float)ProbabilityAxis.getNormalDistribution(0.9999) + " " + ProbabilityAxis.getInverseNormalDistribution(ProbabilityAxis.getNormalDistribution(0.9999)));
        System.out.println((float)ProbabilityAxis.getNormalDistribution(1.0E-9) + " " + ProbabilityAxis.getInverseNormalDistribution(ProbabilityAxis.getNormalDistribution(1.0E-9)));
        JFrame frame = new JFrame();
        frame.getContentPane().setLayout(new GridBagLayout());
        JPanel x = new JPanel();
        G2dPanel panel = new G2dPanel();
        frame.getContentPane().add((Component)panel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        SimpleArray arrayObj = new SimpleArray(){

            @Override
            public String getXAxisName() {
                return "Probability";
            }

            @Override
            public String getYAxisName() {
                return "Stage";
            }

            @Override
            public int getXAxisType() {
                return 4;
            }

            @Override
            public int getYAxisType() {
                return 3;
            }
        };
        arrayObj.setData(new double[]{0.999999999, 0.9999, 0.999, 0.99, 0.9, 0.5, 0.1, 0.01, 0.001, 1.0E-4, 1.0E-9}, new double[]{1.0, 2.0, 5.0, 16.0, 32.0, 64.0, 128.0, 256.0, 512.0, 1024.0, 2048.0});
        Vector<SimpleArray> v = new Vector<SimpleArray>();
        v.addElement(arrayObj);
        panel.buildComponents(v);
        frame.setLocation(450, 250);
        frame.setSize(500, 450);
        frame.setVisible(true);
        panel = new G2dPanel();
        frame = new JFrame();
        frame.getContentPane().setLayout(new GridBagLayout());
        frame.getContentPane().add((Component)panel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        arrayObj = new SimpleArray(){

            @Override
            public String getXAxisName() {
                return "Probability";
            }

            @Override
            public String getYAxisName() {
                return "Stage";
            }

            @Override
            public int getXAxisType() {
                return 4;
            }

            @Override
            public int getYAxisType() {
                return 3;
            }
        };
        arrayObj.setData(new double[]{0.9999, 0.999, 0.99, 0.9, 0.5, 0.1, 0.01, 0.001, 1.0E-4}, new double[]{1.0, 2.0, 5.0, 16.0, 32.0, 64.0, 128.0, 256.0, 512.0});
        v = new Vector();
        v.addElement(arrayObj);
        panel.buildComponents(v);
        frame.setLocation(450, 250);
        frame.setSize(500, 450);
        frame.setVisible(true);
    }

    @Override
    public WorldPt getWorldExtents() {
        return new WorldPt(this.getMin(), this.getMax());
    }

    @Override
    public double getWorldRange() {
        return Math.abs(this._max - this._min);
    }

    @Override
    public double getMin() {
        return this._min;
    }

    @Override
    public double getMax() {
        return this._max;
    }

    @Override
    public double getDataMax() {
        return this._dataMax;
    }

    @Override
    public double getDataMin() {
        return this._dataMin;
    }

    @Override
    public double getActMin() {
        return this._actmin;
    }

    @Override
    public double getActMax() {
        return this._actmax;
    }

    public double[] getProbabilityAxisValues() {
        return this._axisValues;
    }

    public String[] getProbabilityAxisLabels() {
        return this._axisLabels;
    }

    public void setProbabilityAxisArrays(String[] labels, double[] values) {
        double tempAxisMax;
        double tempAxisMin;
        if (this._axisValues[0] > this._axisValues[this._axisValues.length - 1]) {
            tempAxisMin = this._axisValues[this._axisValues.length - 1];
            tempAxisMax = this._axisValues[0];
        } else {
            tempAxisMax = this._axisValues[this._axisValues.length - 1];
            tempAxisMin = this._axisValues[0];
        }
        this.setProbabilityAxisArrays(labels, values, tempAxisMin, tempAxisMax);
    }

    public void setProbabilityAxisArrays(String[] labels, double[] values, double minAxisValue, double maxAxisValue) {
        if (labels.length != values.length) {
            return;
        }
        this._axisValues = values;
        this._axisLabels = labels;
        this._actmax = maxAxisValue;
        this._actmin = minAxisValue;
        this._defaultMax = this._actmax;
        this._defaultMin = this._actmin;
        this._min = this._actmin;
        this._max = this._actmax;
        this.computeScaling();
        this.notifyObservers("COMPUTED_SCALE");
    }

    public int getIndexFor(double value) {
        for (int i = 0; i < this._axisValues.length; ++i) {
            if (value != this._axisValues[i]) continue;
            return i;
        }
        return -1;
    }

    public String getValueStringAt(int idx) {
        if (idx < 0 || idx >= this._axisLabels.length) {
            return null;
        }
        return this._axisLabels[idx];
    }
}

