/*
 * Decompiled with CFR 0.152.
 */
package hec.geometry;

import hec.data.DataSetException;
import hec.data.Parameter;
import hec.data.Units;
import hec.geometry.Axis;
import hec.geometry.IScale;
import hec.geometry.TSAxis;
import hec.geometry.WorldRect;
import hec.heclib.util.HecTime;
import java.awt.Dimension;
import java.io.Serializable;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Objects;
import java.util.TimeZone;
import java.util.Vector;
import rma.util.RMAConst;

public class Scale
implements IScale,
Serializable {
    static boolean DEBUG = false;
    String _name = "Scale";
    Axis[] _axis = null;
    double _parameterYScale = 1.0;
    double _parameterXScale = 1.0;
    int _parameterXId = -1;
    int _parameterYId = -1;
    int _dataUnitSystem = 0;
    int _displayUnitSystem = 0;
    int _gmtOffset = Integer.MIN_VALUE;
    TimeZone _displayTimeZone = null;
    Vector _modelVariables = new Vector();
    double _rowWeight = 1.0;
    private ZoneId _dataZoneId;
    public static MessageFormat SCALE_NAME_FORMAT;

    public Scale(String n) {
        this._name = n;
        this._axis = new Axis[2];
        this._axis[0] = new Axis("x");
        this._axis[1] = new Axis("y");
    }

    public void setDisplayUnitSystem(int system) {
        if (!Units.isValidUnitsSystem(system)) {
            throw new IllegalArgumentException("ERROR <Scale.setDisplayUnitsSystem()> : Invalid Unit System Id " + system);
        }
        this._displayUnitSystem = system;
        this._axis[0].setDisplayUnitSystem(system);
        this._axis[1].setDisplayUnitSystem(system);
    }

    public void setDataUnitSystem(int system) {
        this._dataUnitSystem = system;
        this._axis[0].setDataUnitSystem(system);
        this._axis[1].setDataUnitSystem(system);
    }

    public void setDisplayTimeZone(TimeZone timeZone) {
        this._displayTimeZone = timeZone;
    }

    public void setDisplayScaleFactor(int paramId, double scale) {
        if (this._parameterXId == paramId) {
            this._parameterXScale = scale;
            this._axis[0].setDisplayScaleFactor(paramId, scale);
        } else if (this._parameterYId == paramId) {
            this._parameterYScale = scale;
            this._axis[1].setDisplayScaleFactor(paramId, scale);
        }
    }

    public int getParameterXId() {
        return this._parameterXId;
    }

    public int getParameterYId() {
        return this._parameterYId;
    }

    public void setParameterId(int id, int axis) {
        if (axis == 0) {
            this._parameterXId = id;
            this._axis[0].setParameterId(id);
        } else {
            this._parameterYId = id;
            this._axis[1].setParameterId(id);
        }
    }

    public void setGmtOffset(int offset) {
        if (offset == Integer.MIN_VALUE) {
            return;
        }
        this._gmtOffset = offset;
    }

    public int getGmtOffset() {
        return this._gmtOffset;
    }

    public final ZoneId getDataZoneId() {
        return this._dataZoneId;
    }

    public final void setDataZoneId(ZoneId dataZoneId) {
        this._dataZoneId = dataZoneId;
    }

    public TimeZone getDisplayTimeZone() {
        return this._displayTimeZone;
    }

    public String getDisplayUnitsString(int system) {
        return "";
    }

    public int getDataUnitSystem() {
        return this._dataUnitSystem;
    }

    public int getDisplayUnitSystem() {
        return this._displayUnitSystem;
    }

    public String getName() {
        return this._name;
    }

    public void invalidateRegionExtents() {
        this._axis[0].invalidateWorldExtents();
        this._axis[1].invalidateWorldExtents();
    }

    public void setRegionExtents(WorldRect rc) {
        if (rc == null || !rc.isValid()) {
            return;
        }
        double w = rc.w;
        double e = rc.e;
        double s = rc.s;
        double n = rc.n;
        if (this._dataUnitSystem != 0 && this._displayUnitSystem != this._dataUnitSystem) {
            w = this.covertUnitSystems(this._dataUnitSystem, this._displayUnitSystem, this._parameterXId, w);
            e = this.covertUnitSystems(this._dataUnitSystem, this._displayUnitSystem, this._parameterXId, e);
            s = this.covertUnitSystems(this._dataUnitSystem, this._displayUnitSystem, this._parameterYId, s);
            n = this.covertUnitSystems(this._dataUnitSystem, this._displayUnitSystem, this._parameterYId, n);
        }
        if (this._axis[0] instanceof TSAxis) {
            w = this.convertTimeZones(w, true);
            e = this.convertTimeZones(e, true);
        }
        this._axis[0].setWorldExtents(this.scaleParameterValue(w, this._parameterXScale), this.scaleParameterValue(e, this._parameterXScale));
        this._axis[1].setWorldExtents(this.scaleParameterValue(s, this._parameterYScale), this.scaleParameterValue(n, this._parameterYScale));
    }

    public void growRegionExtents(WorldRect rc) {
        if (rc == null || !rc.isValid()) {
            return;
        }
        double w = rc.w;
        double e = rc.e;
        double s = rc.s;
        double n = rc.n;
        if (this._dataUnitSystem != 0 && this._displayUnitSystem != this._dataUnitSystem) {
            w = this.covertUnitSystems(this._dataUnitSystem, this._displayUnitSystem, this._parameterXId, w);
            e = this.covertUnitSystems(this._dataUnitSystem, this._displayUnitSystem, this._parameterXId, e);
            s = this.covertUnitSystems(this._dataUnitSystem, this._displayUnitSystem, this._parameterYId, s);
            n = this.covertUnitSystems(this._dataUnitSystem, this._displayUnitSystem, this._parameterYId, n);
        }
        if (this._axis[0] instanceof TSAxis) {
            w = this.convertTimeZones(w, true);
            e = this.convertTimeZones(e, true);
        }
        this._axis[0].growWorldExtents(this.scaleParameterValue(w, this._parameterXScale), this.scaleParameterValue(e, this._parameterXScale));
        this._axis[1].growWorldExtents(this.scaleParameterValue(s, this._parameterYScale), this.scaleParameterValue(n, this._parameterYScale));
    }

    public void setAxis(Axis ax, int ord) {
        if (ord > this._axis.length) {
            return;
        }
        this._axis[ord] = ax;
    }

    public Axis getAxis(int ord) {
        if (ord > this._axis.length) {
            return null;
        }
        return this._axis[ord];
    }

    public void computeScaling(Dimension dim) {
        this._axis[0].computeScaling(dim.width);
        this._axis[1].computeScaling(dim.height);
    }

    @Override
    public int e2x(double e) {
        if (this._axis[0] instanceof TSAxis) {
            e = this.convertTimeZones(e, true);
        } else if (this._dataUnitSystem != this._displayUnitSystem) {
            e = this.covertUnitSystems(this._dataUnitSystem, this._displayUnitSystem, this._parameterXId, e);
        }
        return this._axis[0].w2l(this.scaleParameterValue(e, this._parameterXScale));
    }

    @Override
    public int n2y(double n) {
        if (this._dataUnitSystem != this._displayUnitSystem) {
            n = this.covertUnitSystems(this._dataUnitSystem, this._displayUnitSystem, this._parameterYId, n);
        }
        return this._axis[1].w2l(this.scaleParameterValue(n, this._parameterYScale));
    }

    @Override
    public double x2e(int x) {
        double xout = this._axis[0].l2w(x);
        if (this._axis[0] instanceof TSAxis) {
            return this.convertTimeZones(xout, false);
        }
        if (this._displayUnitSystem == this._dataUnitSystem) {
            return this.scaleParameterValue(xout, 1.0 / this._parameterXScale);
        }
        return this.covertUnitSystems(this._displayUnitSystem, this._dataUnitSystem, this._parameterXId, this.scaleParameterValue(xout, 1.0 / this._parameterXScale));
    }

    @Override
    public double y2n(int y) {
        double yout = this._axis[1].l2w(y);
        if (this._displayUnitSystem == this._dataUnitSystem) {
            return this.scaleParameterValue(yout, 1.0 / this._parameterYScale);
        }
        return this.covertUnitSystems(this._displayUnitSystem, this._dataUnitSystem, this._parameterYId, this.scaleParameterValue(yout, 1.0 / this._parameterYScale));
    }

    public void clearRegionExtents() {
        this._axis[0].setWorldExtents(1.0, 10.0);
        this._axis[1].setWorldExtents(1.0, 10.0);
        this._axis[0].invalidateWorldExtents();
        this._axis[1].invalidateWorldExtents();
    }

    private double scaleParameterValue(double value, double scaleValue) {
        return value * scaleValue;
    }

    public double covertUnitSystems(int fromUS, int toUS, int parameterId, double value) {
        if (fromUS == 0 || toUS == 0 || parameterId == -1) {
            return value;
        }
        String fromUnits = Parameter.getUnitsStringForSystem(parameterId, fromUS);
        String toUnits = Parameter.getUnitsStringForSystem(parameterId, toUS);
        if (fromUnits.equals("undef") || toUnits.equals("undef")) {
            return value;
        }
        try {
            return Units.convertUnits(value, fromUnits, toUnits);
        }
        catch (DataSetException e) {
            System.out.println("EXCEPTION <Scale.covertUnitSystems()> " + e.getMessage());
            return value;
        }
    }

    final double convertTimeZones(double timeValue, boolean fromDataToDisplay) {
        if (this._displayTimeZone == null) {
            return timeValue;
        }
        if (this._gmtOffset == Integer.MIN_VALUE && this._dataZoneId == null) {
            return timeValue;
        }
        ZoneId dataHourOffset = this._dataZoneId == null ? ZoneId.ofOffset("GMT", ZoneOffset.ofHours(this._gmtOffset)) : this._dataZoneId;
        TimeZone dataTimeZone = TimeZone.getTimeZone(dataHourOffset);
        if (fromDataToDisplay) {
            return this.convertTimeZones(timeValue, dataTimeZone, this._displayTimeZone);
        }
        return this.convertTimeZones(timeValue, this._displayTimeZone, dataTimeZone);
    }

    private double convertTimeZones(double timeValue, TimeZone fromTimeZone, TimeZone toTimeZone) {
        if (Objects.equals(fromTimeZone, toTimeZone)) {
            return timeValue;
        }
        HecTime time = new HecTime();
        time.setMinutes(timeValue);
        return HecTime.convertToTimeZone(time, fromTimeZone, toTimeZone).value();
    }

    public Vector getModelVariables() {
        return this._modelVariables;
    }

    public void setRowWeight(double weight) {
        this._rowWeight = weight;
    }

    public double getRowWeight() {
        return this._rowWeight;
    }

    public void convertDataTime(HecTime hecTime) {
        int dataHourOffset = this.getGmtOffset();
        TimeZone dispTimeZone = this.getDisplayTimeZone();
        if (dispTimeZone != null) {
            ZoneId dataZoneId = this.getDataZoneId();
            if (dataZoneId == null && RMAConst.isValidValue(dataHourOffset)) {
                int diff;
                int dispHourOffset = dispTimeZone.getRawOffset() / 3600000;
                if (dispTimeZone.inDaylightTime(hecTime.getJavaDate(0))) {
                    ++dispHourOffset;
                }
                if ((diff = dataHourOffset - dispHourOffset) != 0) {
                    hecTime.subtract(diff * 60);
                }
            } else if (dataZoneId != null) {
                LocalDateTime localDateTime = hecTime.getLocalDateTime();
                int displayOffset = dispTimeZone.toZoneId().getRules().getOffset(localDateTime).getTotalSeconds();
                int dataOffset = dataZoneId.getRules().getOffset(localDateTime).getTotalSeconds();
                int diff = dataOffset - displayOffset;
                if (diff != 0) {
                    hecTime.subtractSeconds(diff);
                }
            }
        }
    }

    static {
        DEBUG = Boolean.getBoolean("DEBUG");
        SCALE_NAME_FORMAT = new MessageFormat("{0} vs {1}");
    }
}

