/*
 * Decompiled with CFR 0.152.
 */
package hec.geometry;

import hec.geometry.TSAxis;
import hec.geometry.TSAxisIterator;
import rma.util.RMAIO;

public class SeasonalAxisIterator
extends TSAxisIterator {
    public SeasonalAxisIterator(TSAxis ax, double del) {
        super(ax, del);
    }

    public SeasonalAxisIterator(TSAxis ax, double del, int units, int pos) {
        super(ax, del, units, pos);
    }

    @Override
    public String getValueString() {
        if (this._units == 1 || this._units == 60) {
            return this._hectime.time();
        }
        if (this._units == 1440) {
            return Integer.toString(this._hectime.day());
        }
        if (this._units == 10080) {
            return Integer.toString(this._hectime.day());
        }
        if (this._units == 43920) {
            return TSAxis.MONTH_STR[this._hectime.month() - 1];
        }
        if (this._units == 525600) {
            return Integer.toString(this._hectime.year() - 1900);
        }
        return RMAIO.setPrecision(this._curval / this._thscl, this._sigfig);
    }

    @Override
    public String getValueStringLong() {
        if (this._units == 1 || this._units == 60) {
            return this._hectime.dateAndTime(4);
        }
        if (this._units == 1440) {
            return this._hectime.date(4);
        }
        if (this._units == 10080) {
            return this._hectime.date(4);
        }
        if (this._units == 43920) {
            return TSAxis.MONTH_STR[this._hectime.month() - 1] + Integer.toString(this._hectime.year() - 1900);
        }
        if (this._units == 525600) {
            return Integer.toString(this._hectime.year());
        }
        return RMAIO.setPrecision(this._curval / this._thscl, this._sigfig);
    }
}

