/*
 * Decompiled with CFR 0.152.
 */
package hec.geometry;

import hec.geometry.Axis;
import hec.heclib.util.HecTime;
import java.awt.Color;
import java.awt.event.AdjustmentListener;

public class TSAxis
extends Axis
implements AdjustmentListener {
    public static final int MIN = 1;
    public static final int HR = 60;
    public static final int DAY = 1440;
    public static final int WK = 10080;
    public static final int MON = 43920;
    public static final int YR = 525600;
    public static final int BEG_PERIOD = -1;
    public static final int END_PERIOD = -2;
    public static final int AVG_PERIOD = -3;
    public static final String[] DAYOFWEEK_STR = new String[]{"Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"};
    public static final String[] MONTH_STR = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    static final int[] _majorIntervals = new int[]{1, 5, 15, 30, 60, 120, 180, 360, 720, 1440, 10080, 20160, 43920, 87840, 131760, 263520, 525600, 2628000, 5256000, 10512000, 26280000};
    static final int[] _minorIntervals = new int[]{1, 1, 3, 5, 10, 30, 30, 60, 120, 120, 1440, 2880, 10080, 20160, 20160, 43920, 43920, 263520, 525600, 1051200, 2628000};
    static final int[] _ticUnits = new int[]{1, 1, 1, 1, 60, 60, 60, 60, 60, 1440, 10080, 10080, 43920, 43920, 43920, 43920, 525600, 525600, 525600, 525600, 525600};
    int _intervalIndex = 8;
    Color _ticColor = new Color(0, 0, 0);
    Color _ticTextColor = new Color(0, 0, 0);

    public TSAxis(String n) {
        super(n);
        this._axisProp.type = this.getType();
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public void computeTicInterval() {
        HecTime minTime = new HecTime();
        minTime.setMinutes(this._min);
        HecTime maxTime = new HecTime();
        maxTime.setMinutes(this._max);
        int minyear = minTime.year();
        int minmonth = minTime.month();
        int minday = minTime.day();
        int minmin = minTime.minute();
        int minsec = minTime.second();
        int maxyear = maxTime.year();
        int maxmonth = maxTime.month();
        int maxday = maxTime.day();
        int maxmin = maxTime.minute();
        int maxsec = maxTime.second();
        double delta = this._actmax - this._actmin;
        int maxNumTic = 10;
        int desNumTic = 5;
        int minNumTic = 3;
        int minintv = (int)delta / desNumTic;
        int desintv = (int)delta / desNumTic;
        int maxintv = (int)delta / desNumTic;
        int ibest = this._intervalIndex;
        int best = _majorIntervals[ibest];
        for (int i = 1; i < _majorIntervals.length && _majorIntervals[i] <= maxintv; ++i) {
            if (Math.abs(_majorIntervals[i] - desintv) >= Math.abs(best - desintv)) continue;
            ibest = i;
            best = _majorIntervals[i];
        }
        this._majortic = best;
        this._minortic = _minorIntervals[ibest];
        this._intervalIndex = ibest;
    }

    @Override
    public void computeNiceMinMax() {
        this._min = this._dataMin;
        this._max = this._dataMax;
    }

    public int getTicUnits() {
        return _ticUnits[this._intervalIndex];
    }

    @Override
    public Color getTicColor() {
        return this._ticColor;
    }

    @Override
    public void setTicColor(Color c2) {
        this._ticColor = c2;
    }

    @Override
    public Color getTicTextColor() {
        return this._ticTextColor;
    }

    @Override
    public void setTicTextColor(Color c2) {
        this._ticTextColor = c2;
    }
}

