/*
 * Decompiled with CFR 0.152.
 */
package hec.geometry;

import hec.geometry.AxisIterator;
import hec.geometry.TSAxis;
import hec.heclib.util.HecTime;
import rma.util.RMAIO;

public class TSAxisIterator
extends AxisIterator {
    TSAxis _tsaxis = null;
    int _units = 1;
    int _periodPosition = -1;
    long _year;
    int _month;
    long _day;
    long _julian;
    int _minutesSinceMidnight;
    boolean _goAgain = true;
    HecTime _hectime = new HecTime();

    public TSAxisIterator(TSAxis ax, double del) {
        super(ax, del);
        this._tsaxis = ax;
        this._units = this._tsaxis.getTicUnits();
        this._periodPosition = -1;
        this.reset();
    }

    public TSAxisIterator(TSAxis ax, double del, int units, int pos) {
        super(ax, del);
        this._tsaxis = ax;
        this._units = units;
        this._periodPosition = pos;
        this.reset();
    }

    public TSAxisIterator(TSAxis ax, int ldel) {
        super(ax, ldel);
        this._tsaxis = ax;
        this._units = this._tsaxis.getTicUnits();
        this._periodPosition = -1;
        this.reset();
    }

    public TSAxisIterator(TSAxis ax, int ldel, int units, int pos) {
        super(ax, ldel);
        this._tsaxis = ax;
        this._units = units;
        this._periodPosition = pos;
        this.reset();
    }

    public void setPeriodPosition(int periodPosition) {
        this._periodPosition = periodPosition;
    }

    @Override
    public void reset() {
        if (this._tsaxis == null) {
            return;
        }
        this._goAgain = true;
        this._min = this._axis.getActMin();
        this._max = this._axis.getActMax();
        this._hectime.showTimeAsBeginningOfDay(true);
        this._hectime.setMinutes(this._min);
        if (this._units == 1) {
            int istart = (int)Math.ceil(this._min / this._delta) - 1;
            this._curval = (double)istart * this._delta;
            this._hectime.setMinutes(this._curval);
        } else if (this._units == 60) {
            long istart = (long)Math.ceil(this._min / this._delta) - 1L;
            this._curval = (double)istart * this._delta;
            this._hectime.setMinutes(this._curval);
        } else if (this._units == 1440) {
            this._julian = this._hectime.julian();
            double deldays = this._delta / 1440.0;
            long istart = (long)Math.ceil((double)this._julian / deldays) - 1L;
            this._julian = (long)((double)istart * deldays);
            this._hectime.setJulian((int)this._julian, 0);
            this._curval = this._hectime.getMinutes();
        } else if (this._units == 10080) {
            this._julian = this._hectime.julian();
            double deldays = this._delta / 10080.0;
            int istart = (int)Math.ceil((double)this._julian / deldays) - 1;
            this._julian = istart * (int)deldays;
            this._hectime.setJulian((int)this._julian, 0);
            int dow = this._hectime.dayOfWeek() - 1;
            this._julian -= (long)dow;
            this._hectime.setJulian((int)this._julian, 0);
            this._curval = this._hectime.getMinutes();
        } else if (this._units == 43920) {
            this._year = this._hectime.year();
            this._month = this._hectime.month() - 1;
            double delmon = this._delta / 43920.0;
            long istart = (long)Math.ceil((double)this._month / delmon) - 1L;
            this._month = (int)((double)istart * delmon + 1.0);
            if (this._month < 1) {
                this._month += 12;
                --this._year;
            }
            int julian = HecTime.iymdjl((int)this._year, this._month, 1);
            this._hectime.setJulian(julian, 1);
            this._curval = this._hectime.getMinutes();
        } else if (this._units == 525600) {
            this._year = this._hectime.year();
            double delyr = this._delta / 525600.0;
            int istart = (int)Math.ceil((double)this._year / delyr) - 1;
            this._year = istart * (int)delyr;
            int julian = HecTime.iymdjl((int)this._year, 1, 1);
            this._hectime.setJulian(julian, 1);
            this._curval = this._hectime.getMinutes();
        } else {
            int istart = (int)Math.ceil(this._min / this._delta) - 1;
            this._curval = (double)istart * this._delta;
            this._hectime.setMinutes(this._curval);
        }
    }

    @Override
    public void setInterval(double del) {
        this._delta = del;
        this.reset();
    }

    @Override
    public boolean next() {
        boolean value = this._goAgain;
        if (this._units == 1) {
            this._curval += this._delta;
            this._hectime.setMinutes(this._curval);
        } else if (this._units == 60) {
            this._curval += this._delta;
            this._hectime.setMinutes(this._curval);
        } else if (this._units == 1440) {
            this._curval += this._delta;
            this._hectime.setMinutes(this._curval);
        } else if (this._units == 10080) {
            this._curval += this._delta;
            this._hectime.setMinutes(this._curval);
        } else if (this._units == 43920) {
            int delmon = (int)Math.ceil(this._delta / 43920.0);
            this._month += delmon;
            if (this._month > 12) {
                this._month -= 12;
                ++this._year;
            }
            int julian = HecTime.iymdjl((int)this._year, this._month, 1);
            this._hectime.setJulian(julian, 1);
            this._curval = this._hectime.getMinutes();
        } else if (this._units == 525600) {
            int delyr = (int)Math.ceil(this._delta / 525600.0);
            this._year += (long)delyr;
            int julian = HecTime.iymdjl((int)this._year, 1, 1);
            this._hectime.setJulian(julian, 1);
            this._curval = this._hectime.getMinutes();
        } else {
            this._curval += this._delta;
            this._hectime.setMinutes(this._curval);
        }
        if (this._curval > this._max) {
            this._goAgain = false;
        }
        if (!this._hectime.isDefined()) {
            this._goAgain = false;
        }
        return this._goAgain;
    }

    @Override
    public double getValue() {
        if (this._periodPosition == -1) {
            return this._curval;
        }
        if (this._periodPosition == -3) {
            return this._curval + this._delta / 2.0;
        }
        if (this._periodPosition == -2) {
            return this._curval + this._delta;
        }
        return this._curval;
    }

    @Override
    public int getLocalValue() {
        return this._axis.w2l(this.getValue());
    }

    @Override
    public String getValueString() {
        if (this._units == 1 || this._units == 60) {
            return this._hectime.time();
        }
        if (this._units == 1440) {
            return Integer.toString(this._hectime.day());
        }
        if (this._units == 10080) {
            return Integer.toString(this._hectime.day());
        }
        if (this._units == 43920) {
            if (this._hectime.month() - 1 < 0) {
                return TSAxis.MONTH_STR[0];
            }
            return TSAxis.MONTH_STR[this._hectime.month() - 1];
        }
        if (this._units == 525600) {
            return Integer.toString(this._hectime.year());
        }
        return RMAIO.setPrecision(this._curval / this._thscl, this._sigfig);
    }

    public String getValueStringLong() {
        if (this._units == 1 || this._units == 60) {
            return this._hectime.dateAndTime(4);
        }
        if (this._units == 1440) {
            return this._hectime.date(4);
        }
        if (this._units == 10080) {
            return this._hectime.date(4);
        }
        if (this._units == 43920) {
            return TSAxis.MONTH_STR[this._hectime.month() - 1] + Integer.toString(this._hectime.year());
        }
        if (this._units == 525600) {
            return Integer.toString(this._hectime.year());
        }
        return RMAIO.setPrecision(this._curval / this._thscl, this._sigfig);
    }

    public boolean getGoAgain() {
        return this._goAgain;
    }
}

