/*
 * Decompiled with CFR 0.152.
 */
package hec.geometry;

import hec.geometry.Scale;
import hec.geometry.WorldLineSeg;
import hec.geometry.WorldPt;
import hec.geometry.WorldRect;
import java.io.Serializable;
import java.util.Vector;

public class WorldLine
implements Serializable {
    public static final int RIGHTBANK = 1;
    public static final int LEFTBANK = -1;
    public Vector pts = new Vector();
    protected transient double _length = Double.NEGATIVE_INFINITY;
    protected transient double[] _coordAtPt;

    public WorldPt newPt() {
        return new WorldPt();
    }

    public WorldPt getFirstPt() {
        if (this.pts.size() < 1) {
            return null;
        }
        return (WorldPt)this.pts.elementAt(0);
    }

    public WorldPt getLastPt() {
        if (this.pts.size() < 1) {
            return null;
        }
        return (WorldPt)this.pts.elementAt(this.pts.size() - 1);
    }

    public WorldPt getCenterPt() {
        WorldPt refpt = new WorldPt();
        for (int i = 0; i < this.pts.size(); ++i) {
            WorldPt pt = (WorldPt)this.pts.elementAt(i);
            if (pt == null) continue;
            if (i == 0) {
                refpt.init(pt);
                continue;
            }
            refpt.e += pt.e;
            refpt.n += pt.n;
        }
        double xnum = this.pts.size();
        if (xnum > 1.0) {
            refpt.e /= xnum;
            refpt.n /= xnum;
        }
        return refpt;
    }

    public int getPtIndexBeforeCoord(double coord) {
        int npts;
        boolean ipt = false;
        if (this._coordAtPt == null) {
            this.getLength();
        }
        if ((npts = this.pts.size()) < 2) {
            return -1;
        }
        for (int i = 1; i < npts; ++i) {
            if (!(this._coordAtPt[i] > coord)) continue;
            return i - 1;
        }
        return npts - 1;
    }

    public int getPtIndexNearCoord(double coord) {
        int npts;
        boolean ipt = false;
        if (this._coordAtPt == null) {
            this.getLength();
        }
        if ((npts = this.pts.size()) < 2) {
            return -1;
        }
        for (int i = 1; i < npts; ++i) {
            if (!(this._coordAtPt[i] >= coord)) continue;
            if (coord - this._coordAtPt[i - 1] < this._coordAtPt[i] - coord) {
                return i - 1;
            }
            return i;
        }
        return npts - 1;
    }

    public boolean nearPt(WorldPt wpt, double tol) {
        double dist;
        WorldPt pt;
        int i;
        if (wpt == null || this.pts.size() < 2) {
            return false;
        }
        WorldLineSeg l = new WorldLineSeg();
        WorldPt ptn = new WorldPt();
        WorldPt ptnbest = new WorldPt();
        double mindist = Double.MAX_VALUE;
        int ifound = -1;
        l.pt1 = (WorldPt)this.pts.elementAt(0);
        for (i = 1; i < this.pts.size(); ++i) {
            pt = (WorldPt)this.pts.elementAt(i);
            if (pt == null) continue;
            l.pt0 = l.pt1;
            l.pt1 = pt;
            dist = wpt.ptNearLineSeg(l, ptn);
            if (!(dist < mindist) || !(dist <= tol)) continue;
            mindist = dist;
            ptnbest.init(ptn);
            ifound = i;
        }
        pt = (WorldPt)this.pts.elementAt(0);
        l.pt0 = l.pt1;
        l.pt1 = pt;
        dist = wpt.ptNearLineSeg(l, ptn);
        if (dist < mindist && dist <= tol) {
            mindist = dist;
            ptnbest.init(ptn);
            ifound = i;
        }
        return ifound >= 0;
    }

    public double getNearestLocation(WorldPt wpt, WorldPt ptnbest) {
        if (wpt == null || ptnbest == null || this.pts.size() < 2) {
            return Double.NEGATIVE_INFINITY;
        }
        WorldLineSeg l = new WorldLineSeg();
        WorldPt ptn = new WorldPt();
        double mindist = Double.MAX_VALUE;
        int ifound = -1;
        l.pt1 = (WorldPt)this.pts.elementAt(0);
        for (int i = 1; i < this.pts.size(); ++i) {
            WorldPt pt = (WorldPt)this.pts.elementAt(i);
            if (pt == null) continue;
            l.pt0 = l.pt1;
            l.pt1 = pt;
            double dist = wpt.ptNearLineSeg(l, ptn);
            if (!(dist < mindist)) continue;
            mindist = dist;
            ptnbest.init(ptn);
            ifound = i;
        }
        return mindist;
    }

    public double getLength() {
        WorldLineSeg l = new WorldLineSeg();
        double length = 0.0;
        if (this._coordAtPt == null || this._coordAtPt.length != this.pts.size()) {
            this._coordAtPt = new double[this.pts.size()];
        }
        l.pt1 = (WorldPt)this.pts.elementAt(0);
        for (int i = 1; i < this.pts.size(); ++i) {
            WorldPt pt = (WorldPt)this.pts.elementAt(i);
            if (pt == null) continue;
            l.pt0 = l.pt1;
            l.pt1 = pt;
            length += l.length();
        }
        return length;
    }

    public double getCoordAtLocation(WorldPt wpt) {
        if (wpt == null || this.pts.size() < 2) {
            return Double.NEGATIVE_INFINITY;
        }
        WorldLineSeg l = new WorldLineSeg();
        WorldPt ptn = new WorldPt();
        WorldPt ptnbest = new WorldPt();
        double cumlen = 0.0;
        double mindist = Double.MAX_VALUE;
        double coord = Double.NEGATIVE_INFINITY;
        int ifound = -1;
        double length = this.getLength();
        if (length == 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        l.pt1 = (WorldPt)this.pts.elementAt(0);
        for (int i = 1; i < this.pts.size(); ++i) {
            WorldPt pt = (WorldPt)this.pts.elementAt(i);
            if (pt == null) continue;
            l.pt0 = l.pt1;
            l.pt1 = pt;
            double dist = wpt.ptNearLineSeg(l, ptn);
            if (dist < mindist) {
                mindist = dist;
                ptnbest.init(ptn);
                ifound = i;
                double seglen = l.pt0.distToPoint(ptnbest);
                coord = (cumlen + seglen) / length;
            }
            cumlen += l.length();
        }
        return coord;
    }

    public WorldPt getLocationByCoord(double coord) {
        double length = this.getLength();
        double dist = coord * length;
        double cumdist = 0.0;
        WorldPt spt0 = (WorldPt)this.pts.elementAt(0);
        for (int i = 1; i < this.pts.size(); ++i) {
            WorldPt spt = (WorldPt)this.pts.elementAt(i);
            double seglen = spt0.distToPoint(spt);
            if (cumdist + seglen >= dist) {
                WorldPt pt = spt0.interpolateLocation(spt, (dist - cumdist) / seglen);
                return pt;
            }
            cumdist += seglen;
            spt0 = spt;
        }
        return new WorldPt();
    }

    public boolean insertPt(WorldPt wpt, double tol) {
        if (wpt == null || this.pts.size() < 2) {
            return false;
        }
        WorldLineSeg l = new WorldLineSeg();
        WorldPt ptn = new WorldPt();
        WorldPt ptnbest = this.newPt();
        double mindist = Double.MAX_VALUE;
        int ifound = -1;
        l.pt1 = (WorldPt)this.pts.elementAt(0);
        for (int i = 1; i < this.pts.size(); ++i) {
            WorldPt pt = (WorldPt)this.pts.elementAt(i);
            if (pt == null) continue;
            l.pt0 = l.pt1;
            l.pt1 = pt;
            double dist = wpt.ptNearLineSeg(l, ptn);
            if (!(dist < mindist) || !(dist <= tol)) continue;
            mindist = dist;
            ptnbest.init(ptn);
            ifound = i;
        }
        if (ifound >= 0) {
            this.pts.insertElementAt(ptnbest, ifound);
            return true;
        }
        return false;
    }

    public boolean removePt(WorldPt wpt, double tol) {
        if (wpt == null || this.pts.size() <= 3) {
            return false;
        }
        WorldRect rc = new WorldRect(wpt.e - tol, wpt.n + tol, wpt.e + tol, wpt.n - tol);
        for (int i = 0; i < this.pts.size(); ++i) {
            WorldPt pt = (WorldPt)this.pts.elementAt(i);
            if (pt == null || !rc.contains(pt)) continue;
            this.pts.removeElementAt(i);
            return true;
        }
        return false;
    }

    public String toString() {
        String str = "";
        for (int i = 0; i < this.pts.size(); ++i) {
            WorldPt pt = (WorldPt)this.pts.elementAt(i);
            if (pt == null) continue;
            if (i > 0) {
                str = str.concat(", ");
            }
            str = str.concat(pt.toString());
        }
        return str;
    }

    public void parseString(String str) {
        String substr = str;
        this.pts.removeAllElements();
        while (substr != null) {
            WorldPt pt = this.newPt();
            substr = pt.parseString(substr);
            if (!pt.isValid()) continue;
            this.pts.addElement(pt);
        }
    }

    static boolean calcSlope(WorldPt p0, WorldPt p1, WorldPt slope) {
        if (p0 == null || p1 == null) {
            return false;
        }
        double dx = p1.e - p0.e;
        double dy = p1.n - p0.n;
        double distsq = dx * dx + dy * dy;
        if (distsq == 0.0) {
            return false;
        }
        double dist = Math.sqrt(distsq);
        slope.e = dx / dist;
        slope.n = dy / dist;
        return true;
    }

    public WorldLine createOffsetLine(double c0, double c1, double offset, int bank) {
        WorldLine newline = new WorldLine();
        if (c1 < c0) {
            double c2 = c1;
            c0 = c1 = c0;
        }
        if (c0 < 0.0) {
            c0 = 0.0;
        }
        if (c1 > 1.0) {
            c1 = 1.0;
        }
        if (c0 == c1) {
            return newline;
        }
        WorldPt ptStart = this.getLocationByCoord(c0);
        WorldPt ptEnd = this.getLocationByCoord(c1);
        WorldPt slope0 = new WorldPt();
        WorldPt slope1 = new WorldPt();
        double cumdist = 0.0;
        double length = this.getLength();
        int imax = this.pts.size();
        WorldPt pt0 = (WorldPt)this.pts.elementAt(0);
        double wc0 = 0.0;
        for (int i = 1; i < imax; ++i) {
            double n;
            double e;
            WorldPt pt1 = (WorldPt)this.pts.elementAt(i);
            double dist = pt0.distToPoint(pt1);
            double wc1 = (cumdist += dist) / length;
            if (wc1 < c0) continue;
            WorldLine.calcSlope(pt0, pt1, slope1);
            if (wc0 <= c0 && c0 < wc1) {
                e = ptStart.e + slope1.n * (double)bank * offset;
                n = ptStart.n + slope1.e * (double)bank * offset;
                newline.pts.addElement(new WorldPt(e, n));
            } else if (wc0 > c0) {
                e = pt0.e + (slope0.n + slope1.n) / 2.0 * (double)bank * offset;
                n = pt0.n + (slope0.e + slope1.e) / 2.0 * (double)bank * offset;
                newline.pts.addElement(new WorldPt(e, n));
            }
            if (wc1 >= c1) {
                e = ptEnd.e + slope1.n * (double)bank * offset;
                n = ptEnd.n + slope1.e * (double)bank * offset;
                newline.pts.addElement(new WorldPt(e, n));
                break;
            }
            pt0 = pt1;
            wc0 = wc1;
            slope0.init(slope1);
        }
        return newline;
    }

    public int getLocalRegionArrays(Scale scl, int[] xarray, int[] yarray) {
        return this.getLocalRegionArrays(scl, xarray, yarray, 6.0);
    }

    public int getLocalRegionArrays(Scale scl, int[] xarray, int[] yarray, double width) {
        if (this.pts.size() < 2) {
            return 0;
        }
        int mpt = this.pts.size() * 2 - 1;
        WorldPt slope0 = new WorldPt();
        WorldPt slope1 = new WorldPt();
        double halfwidth = width / 2.0;
        WorldPt pt0 = (WorldPt)this.pts.elementAt(0);
        WorldPt pt1 = (WorldPt)this.pts.elementAt(1);
        WorldLine.calcSlope(pt0, pt1, slope1);
        int x = scl.e2x(pt0.e);
        int y = scl.n2y(pt0.n);
        int ix = (int)(slope1.e * halfwidth);
        int iy = (int)(slope1.n * halfwidth);
        xarray[0] = x - iy;
        yarray[0] = y - ix;
        xarray[mpt] = x + iy;
        yarray[mpt] = y + ix;
        for (int i = 2; i < this.pts.size(); ++i) {
            pt0 = pt1;
            slope0.init(slope1);
            pt1 = (WorldPt)this.pts.elementAt(i);
            WorldLine.calcSlope(pt0, pt1, slope1);
            slope0.e = (slope0.e + slope1.e) / 2.0;
            slope0.n = (slope0.n + slope1.n) / 2.0;
            double dist = Math.sqrt(slope0.e * slope0.e + slope0.n * slope0.n);
            x = scl.e2x(pt0.e);
            y = scl.n2y(pt0.n);
            ix = (int)(slope0.e * halfwidth / dist);
            iy = (int)(slope0.n * halfwidth / dist);
            xarray[i - 1] = x - iy;
            yarray[i - 1] = y - ix;
            xarray[mpt - (i - 1)] = x + iy;
            yarray[mpt - (i - 1)] = y + ix;
        }
        x = scl.e2x(pt1.e);
        y = scl.n2y(pt1.n);
        ix = (int)(slope1.e * halfwidth);
        iy = (int)(slope1.n * halfwidth);
        xarray[i - 1] = x - iy;
        yarray[i - 1] = y - ix;
        xarray[mpt - (i - 1)] = x + iy;
        yarray[mpt - (i - 1)] = y + ix;
        return mpt + 1;
    }

    public boolean getSlopeAtCoord(double coord, WorldPt wpt, WorldPt slope) {
        if (coord == Double.NEGATIVE_INFINITY || wpt == null || slope == null) {
            return false;
        }
        double len = this.getLength() * coord;
        WorldLineSeg l = new WorldLineSeg();
        double length = 0.0;
        l.pt1 = (WorldPt)this.pts.elementAt(0);
        for (int i = 1; i < this.pts.size(); ++i) {
            WorldPt pt = (WorldPt)this.pts.elementAt(i);
            if (pt == null) continue;
            l.pt0 = l.pt1;
            l.pt1 = pt;
            double slen = l.length();
            if (!((length += slen) >= len)) continue;
            double scl = (length - len) / slen;
            wpt.init(l.pt1.e - (l.pt1.e - l.pt0.e) * scl, l.pt1.n - (l.pt1.n - l.pt0.n) * scl);
            slope.init((l.pt1.e - l.pt0.e) / slen, (l.pt1.n - l.pt0.n) / slen);
            return true;
        }
        return false;
    }

    public void setLinePoint(double coord, WorldPt wpt) {
        WorldPt existingPt;
        if (this.pts.size() <= 0) {
            return;
        }
        if (coord == 0.0) {
            existingPt = (WorldPt)this.pts.elementAt(0);
        } else if (coord == 1.0) {
            existingPt = (WorldPt)this.pts.elementAt(this.pts.size() - 1);
        } else {
            return;
        }
        if (existingPt != null) {
            existingPt.init(wpt);
        }
    }
}

