/*
 * Decompiled with CFR 0.152.
 */
package hec.geometry;

import hec.geometry.WorldLineSeg;
import java.io.Serializable;
import rma.util.RMAIO;

public class WorldPt
implements Serializable {
    public double e = Double.NEGATIVE_INFINITY;
    public double n = Double.NEGATIVE_INFINITY;

    public WorldPt() {
    }

    public WorldPt(double pe, double pn) {
        this.e = pe;
        this.n = pn;
    }

    public WorldPt(WorldPt p) {
        this.e = p.e;
        this.n = p.n;
    }

    public void init(double pe, double pn) {
        this.e = pe;
        this.n = pn;
    }

    public void init(WorldPt p) {
        this.e = p.e;
        this.n = p.n;
    }

    public double length() {
        return Math.sqrt(this.e * this.e + this.n * this.n);
    }

    public void normalize() {
        double len = Math.sqrt(this.e * this.e + this.n * this.n);
        if (len == 0.0) {
            return;
        }
        this.e /= len;
        this.n /= len;
    }

    public WorldPt getNormal() {
        double len = Math.sqrt(this.e * this.e + this.n * this.n);
        WorldPt p = new WorldPt();
        if (len == 0.0) {
            p.init(this);
        } else {
            p.init(this.e / len, this.n / len);
        }
        return p;
    }

    public double distToPoint(WorldPt pt) {
        double dx = pt.e - this.e;
        double dy = pt.n - this.n;
        if (dx == 0.0 && dy == 0.0) {
            return 0.0;
        }
        return Math.sqrt(dx * dx + dy * dy);
    }

    public double distToLineSeg(WorldPt pt0, WorldPt pt1) {
        double dx = pt1.e - pt0.e;
        double dy = pt1.n - pt0.n;
        if (dx == 0.0 && dy == 0.0) {
            dx = this.e - pt0.e;
            dy = this.n - pt0.n;
            if (dx == 0.0 && dy == 0.0) {
                return 0.0;
            }
            return Math.sqrt(dx * dx + dy * dy);
        }
        double t = ((this.e - pt0.e) * dx + (this.n - pt0.n) * dy) / (dx * dx + dy * dy);
        if (t < 0.0) {
            t = 0.0;
        } else if (t > 1.0) {
            t = 1.0;
        }
        double xc = pt0.e + t * dx;
        double yc = pt0.n + t * dy;
        dx = this.e - xc;
        dy = this.n - yc;
        if (dx == 0.0 && dy == 0.0) {
            return 0.0;
        }
        return Math.sqrt(dx * dx + dy * dy);
    }

    public double distToLineSeg(WorldLineSeg l) {
        return this.distToLineSeg(l.pt0, l.pt1);
    }

    public double ptNearLineSeg(WorldPt pt0, WorldPt pt1, WorldPt ptn) {
        double dx = pt1.e - pt0.e;
        double dy = pt1.n - pt0.n;
        if (dx == 0.0 && dy == 0.0) {
            dx = this.e - pt0.e;
            dy = this.n - pt0.n;
            ptn = pt0;
            if (dx == 0.0 && dy == 0.0) {
                return 0.0;
            }
            return Math.sqrt(dx * dx + dy * dy);
        }
        double t = ((this.e - pt0.e) * dx + (this.n - pt0.n) * dy) / (dx * dx + dy * dy);
        if (t < 0.0) {
            t = 0.0;
        } else if (t > 1.0) {
            t = 1.0;
        }
        double xc = pt0.e + t * dx;
        double yc = pt0.n + t * dy;
        dx = this.e - xc;
        dy = this.n - yc;
        ptn.e = xc;
        ptn.n = yc;
        if (dx == 0.0 && dy == 0.0) {
            return 0.0;
        }
        return Math.sqrt(dx * dx + dy * dy);
    }

    public double ptNearLineSeg(WorldLineSeg l, WorldPt ptn) {
        return this.ptNearLineSeg(l.pt0, l.pt1, ptn);
    }

    public boolean isValid() {
        return this.n != Double.NEGATIVE_INFINITY && this.e != Double.NEGATIVE_INFINITY;
    }

    public String toString() {
        String str = RMAIO.toString(this.e) + ", " + RMAIO.toString(this.n);
        return str;
    }

    public String parseString(String str) {
        int idx = str.indexOf(",");
        if (idx < 0) {
            return null;
        }
        this.e = RMAIO.parseDouble(str.substring(0, idx));
        String str2 = str.substring(idx + 1);
        int idx2 = str2.indexOf(",");
        if (idx2 < 0) {
            this.n = RMAIO.parseDouble(str2);
            return null;
        }
        this.n = RMAIO.parseDouble(str2.substring(0, idx2));
        return str2.substring(idx2 + 1);
    }

    WorldPt interpolateLocation(WorldPt spt, double dist) {
        double dx = spt.e - this.e;
        double dy = spt.n - this.n;
        WorldPt p = new WorldPt();
        p.e = this.e + dx * dist;
        p.n = this.n + dy * dist;
        return p;
    }
}

