/*
 * Decompiled with CFR 0.152.
 */
package hec.geometry;

import hec.geometry.WorldPt;
import java.io.Serializable;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class WorldRect
implements Serializable {
    public double w = Double.NEGATIVE_INFINITY;
    public double n = Double.NEGATIVE_INFINITY;
    public double e = Double.NEGATIVE_INFINITY;
    public double s = Double.NEGATIVE_INFINITY;

    public WorldRect() {
    }

    public WorldRect(double rw, double rn, double re, double rs) {
        this.w = rw;
        this.n = rn;
        this.e = re;
        this.s = rs;
        this.justify();
    }

    public WorldRect(WorldPt nw, WorldPt se) {
        this.w = nw.e;
        this.n = nw.n;
        this.e = se.e;
        this.s = se.n;
        this.justify();
    }

    public WorldRect(WorldPt p, double radius) {
        this.w = p.e - radius;
        this.e = p.e + radius;
        this.n = p.n + radius;
        this.s = p.n - radius;
    }

    public WorldRect(WorldRect r) {
        this.set(r);
    }

    public void set(WorldRect r) {
        this.e = r.e;
        this.w = r.w;
        this.n = r.n;
        this.s = r.s;
        this.justify();
    }

    public double width() {
        return this.e - this.w;
    }

    public double height() {
        return this.n - this.s;
    }

    public double area() {
        return (this.e - this.w) * (this.n - this.s);
    }

    public void copy(WorldRect r) {
        this.e = r.e;
        this.w = r.w;
        this.n = r.n;
        this.s = r.s;
        this.justify();
    }

    public void init(double pw, double pn, double pe, double ps) {
        this.w = pw;
        this.n = pn;
        this.e = pe;
        this.s = ps;
        this.justify();
    }

    public void init(WorldPt nw, WorldPt se) {
        this.w = nw.e;
        this.n = nw.n;
        this.e = se.e;
        this.s = se.n;
        this.justify();
    }

    public void init(WorldRect rc) {
        this.e = rc.e;
        this.w = rc.w;
        this.n = rc.n;
        this.s = rc.s;
        this.justify();
    }

    public void init(WorldPt p) {
        this.e = this.w = p.e;
        this.n = this.s = p.n;
    }

    @Deprecated
    public void initToPoint(WorldPt p) {
        this.init(p);
    }

    public void grow(WorldPt p) {
        if (!RMAConst.isValidValue(this.e)) {
            this.e = p.e;
        }
        if (!RMAConst.isValidValue(this.w)) {
            this.w = p.e;
        }
        if (!RMAConst.isValidValue(this.n)) {
            this.n = p.n;
        }
        if (!RMAConst.isValidValue(this.s)) {
            this.s = p.n;
        }
        if (RMAConst.isValidValue(p.e)) {
            if (this.e < p.e) {
                this.e = p.e;
            }
            if (this.w > p.e) {
                this.w = p.e;
            }
        }
        if (RMAConst.isValidValue(p.n)) {
            if (this.n < p.n) {
                this.n = p.n;
            }
            if (this.s > p.n) {
                this.s = p.n;
            }
        }
    }

    @Deprecated
    public void growToPoint(WorldPt p) {
        this.grow(p);
    }

    public void grow(WorldRect r) {
        if (!RMAConst.isValidValue(this.e)) {
            this.e = r.e;
        }
        if (!RMAConst.isValidValue(this.w)) {
            this.w = r.w;
        }
        if (!RMAConst.isValidValue(this.n)) {
            this.n = r.n;
        }
        if (!RMAConst.isValidValue(this.s)) {
            this.s = r.s;
        }
        if (RMAConst.isValidValue(r.e)) {
            if (this.e < r.e) {
                this.e = r.e;
            }
            if (this.w > r.e) {
                this.w = r.e;
            }
        }
        if (RMAConst.isValidValue(r.w)) {
            if (this.e < r.w) {
                this.e = r.w;
            }
            if (this.w > r.w) {
                this.w = r.w;
            }
        }
        if (RMAConst.isValidValue(r.n)) {
            if (this.n < r.n) {
                this.n = r.n;
            }
            if (this.s > r.n) {
                this.s = r.n;
            }
        }
        if (RMAConst.isValidValue(r.s)) {
            if (this.n < r.s) {
                this.n = r.s;
            }
            if (this.s > r.s) {
                this.s = r.s;
            }
        }
    }

    @Deprecated
    public void growToRect(WorldRect r) {
        this.grow(r);
    }

    public void justify() {
        double tmp;
        if (this.w > this.e) {
            tmp = this.e;
            this.e = this.w;
            this.w = tmp;
        }
        if (this.s > this.n) {
            tmp = this.n;
            this.n = this.s;
            this.s = tmp;
        }
    }

    public boolean isValid() {
        if (this.w == Double.NEGATIVE_INFINITY || this.n == Double.NEGATIVE_INFINITY || this.e == Double.NEGATIVE_INFINITY || this.s == Double.NEGATIVE_INFINITY) {
            return false;
        }
        this.justify();
        return true;
    }

    public boolean contains(double pte, double ptn) {
        return pte >= this.w && pte <= this.e && ptn >= this.s && ptn <= this.n;
    }

    public boolean contains(WorldPt pt) {
        return pt.e >= this.w && pt.e <= this.e && pt.n >= this.s && pt.n <= this.n;
    }

    public boolean intersects(WorldRect rc) {
        if (rc.e < this.w) {
            return false;
        }
        if (rc.w > this.e) {
            return false;
        }
        if (rc.n < this.s) {
            return false;
        }
        return !(rc.s > this.n);
    }

    public WorldRect getIntersection(WorldRect rc) {
        if (!this.intersects(rc)) {
            return null;
        }
        WorldRect irc = new WorldRect(this);
        if (rc.w > this.w) {
            irc.w = rc.w;
        }
        if (rc.e < this.e) {
            irc.e = rc.e;
        }
        if (rc.n < this.n) {
            irc.n = rc.n;
        }
        if (rc.s > this.s) {
            irc.s = rc.s;
        }
        return irc;
    }

    public String toString() {
        return this.w + "," + this.n + "," + this.e + "," + this.s;
    }

    public String paramString() {
        return "W:" + RMAIO.setPrecision(this.w, 3) + " N:" + RMAIO.setPrecision(this.n, 3) + " E:" + RMAIO.setPrecision(this.e, 3) + " S:" + RMAIO.setPrecision(this.s, 3);
    }
}

