/*
 * Decompiled with CFR 0.152.
 */
package hec.geometry;

import hec.geometry.WorldLineSeg;
import hec.geometry.WorldPt;
import hec.geometry.WorldRect;
import java.io.Serializable;
import java.util.Vector;

public class WorldRegion
implements Serializable {
    public Vector pts = new Vector();
    public boolean _isInterior = false;

    public WorldPt getCenterPt() {
        WorldPt refpt = new WorldPt();
        for (int i = 0; i < this.pts.size(); ++i) {
            WorldPt pt = (WorldPt)this.pts.elementAt(i);
            if (pt == null) continue;
            if (i == 0) {
                refpt.init(pt);
                continue;
            }
            refpt.e += pt.e;
            refpt.n += pt.n;
        }
        double xnum = this.pts.size();
        if (xnum > 1.0) {
            refpt.e /= xnum;
            refpt.n /= xnum;
        }
        return refpt;
    }

    public boolean contains(WorldPt wpt) {
        Double dbl;
        int i;
        if (this.pts.size() < 3) {
            return false;
        }
        Vector<Double> xvec = new Vector<Double>();
        WorldPt pt1 = null;
        for (i = 0; i <= this.pts.size(); ++i) {
            WorldPt pt = i < this.pts.size() ? (WorldPt)this.pts.elementAt(i) : (WorldPt)this.pts.elementAt(0);
            if (pt == null) continue;
            WorldPt pt0 = pt1;
            pt1 = pt;
            if (pt0 == null) continue;
            if (pt0.e == pt1.e && pt0.n == pt1.n) {
                if (wpt.e != pt1.e || wpt.n != pt1.n) continue;
                return true;
            }
            if (wpt.n == pt0.n && wpt.n == pt1.n) {
                if (!(wpt.e >= pt0.e && wpt.e <= pt1.e) && (!(wpt.e <= pt0.e) || !(wpt.e >= pt1.e))) continue;
                return true;
            }
            if (pt0.n == pt1.n || !(wpt.n >= pt0.n && wpt.n <= pt1.n) && (!(wpt.n <= pt0.n) || !(wpt.n >= pt1.n))) continue;
            double xdist = pt0.e + (pt1.e - pt0.e) * (wpt.n - pt0.n) / (pt1.n - pt0.n);
            boolean found = false;
            for (int j = 0; j < xvec.size(); ++j) {
                dbl = (Double)xvec.elementAt(j);
                if (!(xdist < dbl)) continue;
                xvec.insertElementAt(new Double(xdist), j);
                found = true;
                break;
            }
            if (found) continue;
            xvec.addElement(new Double(xdist));
        }
        for (i = 1; i < xvec.size(); i += 2) {
            dbl = (Double)xvec.elementAt(i - 1);
            Double dbl2 = (Double)xvec.elementAt(i);
            if (!(wpt.e >= dbl) || !(wpt.e <= dbl2)) continue;
            return true;
        }
        return false;
    }

    public boolean insertPt(WorldPt wpt, double tol) {
        double dist;
        WorldPt pt;
        int i;
        if (wpt == null || this.pts.size() < 2) {
            return false;
        }
        WorldLineSeg l = new WorldLineSeg();
        WorldPt ptn = new WorldPt();
        WorldPt ptnbest = new WorldPt();
        double mindist = Double.MAX_VALUE;
        int ifound = -1;
        l.pt1 = (WorldPt)this.pts.elementAt(0);
        for (i = 1; i < this.pts.size(); ++i) {
            pt = (WorldPt)this.pts.elementAt(i);
            if (pt == null) continue;
            l.pt0 = l.pt1;
            l.pt1 = pt;
            dist = wpt.ptNearLineSeg(l, ptn);
            if (!(dist < mindist) || !(dist <= tol)) continue;
            mindist = dist;
            ptnbest.init(ptn);
            ifound = i;
        }
        pt = (WorldPt)this.pts.elementAt(0);
        l.pt0 = l.pt1;
        l.pt1 = pt;
        dist = wpt.ptNearLineSeg(l, ptn);
        if (dist < mindist && dist <= tol) {
            mindist = dist;
            ptnbest.init(ptn);
            ifound = i;
        }
        if (ifound >= 0) {
            this.pts.insertElementAt(ptnbest, ifound);
            return true;
        }
        return false;
    }

    public boolean removePt(WorldPt wpt, double tol) {
        if (wpt == null || this.pts.size() <= 3) {
            return false;
        }
        WorldRect rc = new WorldRect(wpt.e - tol, wpt.n + tol, wpt.e + tol, wpt.n - tol);
        for (int i = 0; i < this.pts.size(); ++i) {
            WorldPt pt = (WorldPt)this.pts.elementAt(i);
            if (pt == null || !rc.contains(pt)) continue;
            this.pts.removeElementAt(i);
            return true;
        }
        return false;
    }

    public String toString() {
        String str = "";
        for (int i = 0; i < this.pts.size(); ++i) {
            WorldPt pt = (WorldPt)this.pts.elementAt(i);
            if (pt == null) continue;
            if (i > 0) {
                str = str.concat(", ");
            }
            str = str.concat(pt.toString());
        }
        return str;
    }

    public void parseString(String str) {
        String substr = str;
        this.pts.removeAllElements();
        while (substr != null) {
            WorldPt pt = new WorldPt();
            substr = pt.parseString(substr);
            if (!pt.isValid()) continue;
            this.pts.addElement(pt);
        }
    }

    public boolean isInterior() {
        return this._isInterior;
    }

    public void setIsInterior(boolean tf) {
        this._isInterior = tf;
    }
}

