/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.gfx2d.AxisLabelDrawProp;
import hec.gfx2d.AxisTicsDrawProp;
import hec.gfx2d.G2dLabelDrawProp;
import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.G2dMarkerProperties;
import hec.gfx2d.G2dPanelProp;
import hec.gfx2d.LegendPanelProp;
import hec.gfx2d.PlotDefaults;
import hec.gfx2d.PlotDefaultsManager;
import hec.gfx2d.TitleDrawProp;
import hec.gfx2d.ViewportDrawProp;
import java.io.BufferedReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractPlotDefaults
implements PlotDefaults {
    protected static Map PROGRAM_DEFAULTS = new HashMap();
    protected static Class[] emptyClsArgs = new Class[0];
    protected static Class[] loadDefaultsClsArgs;
    protected static Object[] emptyObjArgs;
    protected Map m_plotDefaultsTable = new HashMap();

    protected static boolean loadDefaults(BufferedReader reader, Class plotCompClass) {
        if (reader == null) {
            return false;
        }
        Method m = null;
        try {
            m = plotCompClass.getMethod("loadDefaults", loadDefaultsClsArgs);
        }
        catch (NoSuchMethodException nsme) {
            System.out.println("loadDefaults:No such method " + nsme);
            return false;
        }
        if (m == null) {
            System.out.println("loadDefaults:Can't find 'loadDefaults' method in " + plotCompClass);
            return false;
        }
        Object[] loadDefaultsObjArgs = new Object[]{reader};
        Boolean retVal = Boolean.FALSE;
        try {
            retVal = (Boolean)m.invoke(null, loadDefaultsObjArgs);
            reader.close();
            if (retVal == null) {
                return false;
            }
            return retVal;
        }
        catch (InvocationTargetException ite) {
            System.out.println("loadDefaults:Invocation Exception " + ite);
        }
        catch (IllegalAccessException iae) {
            System.out.println("loadDefaults:IllegalAccess " + iae);
            return false;
        }
        catch (IOException ioe) {
            return retVal;
        }
        return false;
    }

    @Override
    public Map getDefaultsTable() {
        return this.m_plotDefaultsTable;
    }

    static {
        emptyObjArgs = new Object[0];
        loadDefaultsClsArgs = new Class[]{BufferedReader.class};
        emptyClsArgs = new Class[0];
        emptyObjArgs = new Object[0];
        G2dLabelDrawProp.init();
        AxisLabelDrawProp.init();
        AxisTicsDrawProp.init();
        LegendPanelProp.init();
        G2dPanelProp.init();
        TitleDrawProp.init();
        ViewportDrawProp.init();
        G2dLineProperties.init();
        G2dMarkerProperties.init();
        PROGRAM_DEFAULTS.putAll(PlotDefaultsManager.getDefaults().getDefaultsTable());
    }
}

