/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.data.Units;
import hec.geometry.Axis;
import hec.geometry.LocalPt;
import hec.gfx2d.AxisLabelDrawProp;
import hec.gfx2d.AxisTics;
import hec.gfx2d.G2dGlyph;
import hec.gfx2d.G2dLabel;
import hec.gfx2d.G2dObject;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.Gfx2dDrawUtil;
import hec.gfx2d.Viewport;
import hec.gfx2d.text.TextSubstitutionManager;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import rma.services.units.UnitsComponent;
import rma.swing.RmaJMenuLabel;
import rma.util.FillPatternFactory;

public class AxisLabel
extends G2dLabel
implements Observer,
UnitsComponent {
    Axis _axis = null;
    int _displayUnitSystem = 0;

    public AxisLabel(G2dPanel p, Axis ax, int align) {
        super(p, 1);
        this._axis = ax;
        this._axis.addObserver(this);
        this._alignment = align;
        AxisLabelDrawProp drawProp = new AxisLabelDrawProp();
        if (align == 0 || align == 1) {
            drawProp.rotation = 90;
        }
        if (drawProp.text == null || drawProp.text.length() == 0) {
            drawProp.text = this._axis.getScaledLabel();
        }
        this.setProperties(drawProp);
    }

    private AxisTics getAxisTics() {
        G2dPanel p = this.getG2dPanel();
        Viewport[] viewports = p.getViewports();
        for (int i = 0; i < viewports.length; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (p.getViewportAxis(viewports[i], j) != this._axis) continue;
                return p.getViewportAxisTics(viewports[i], j);
            }
        }
        return null;
    }

    @Override
    protected String getPopupMenuTitle() {
        return "Axis Label";
    }

    @Override
    public void setDisplayUnitsSystem(int units) {
        if (!Units.isValidUnitsSystem(units) && units != 0 && Boolean.getBoolean("DEBUG")) {
            throw new IllegalArgumentException("ERROR <AxisLabel.setDisplayUnitsSystem()> : Invalid Unit System Id " + units);
        }
        this._displayUnitSystem = units;
    }

    @Override
    public void setDisplayScaleFactor(int paramId, double scaleFactor) {
    }

    @Override
    public String getDisplayUnitsString(int v) {
        return "";
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof Axis && arg == "COMPUTED_SCALE" && this.isVisible()) {
            this.paintGfx();
        } else if (o instanceof Axis && arg == "LABEL_CHANGE") {
            this._drawProp.text = arg != null ? ((Axis)o).getLabel() : "";
        }
    }

    @Override
    public boolean objectPopupMenu(LocalPt pt, int modifiers) {
        Component comp0 = this._popupMenu.getComponent(0);
        if (comp0 instanceof RmaJMenuLabel) {
            RmaJMenuLabel label = (RmaJMenuLabel)comp0;
            label.setText("Axis Label");
        }
        return super.objectPopupMenu(pt, modifiers);
    }

    @Override
    public void editProperties() {
        AxisTics tics = this.getAxisTics();
        if (tics == null) {
            return;
        }
        tics.editProperties(1);
    }

    @Override
    public Dimension getPreferredSizeLocal() {
        if (this._drawProp.text == null || this._drawProp.text.length() == 0) {
            this._drawProp.text = this._axis.getScaledLabel();
        }
        return super.getPreferredSizeLocal();
    }

    @Override
    public void paintGfx(Graphics g) {
        if (this._axis == null) {
            return;
        }
        if (!this._drawProp.showLabel) {
            return;
        }
        String text = this._drawProp.text;
        if (text == null || text.length() == 0) {
            text = this._axis.getScaledLabel();
        }
        String oldText = text = TextSubstitutionManager.getTextSubstitutionManager().replaceTokens(text, this.getTextSubstitutionObjects());
        String units = this.replaceUnitTemplate(text);
        this.setText(units);
        this.superPaintGfx(g);
        this.setText(oldText);
    }

    private void superPaintGfx(Graphics g) {
        Dimension dim = this.getSize();
        Color oldColor = g.getColor();
        Font oldFont = g.getFont();
        g.setFont(this.getG2dFont());
        this.fitFont(g, dim);
        FontMetrics metrics = g.getFontMetrics();
        g.setColor(this.getForeground());
        if (g instanceof Graphics2D && this._drawProp.drawBackground) {
            g.setColor(this._drawProp.backgroundColor);
            Paint oldPaint = ((Graphics2D)g).getPaint();
            Composite oldAC = ((Graphics2D)g).getComposite();
            AlphaComposite ac = AlphaComposite.getInstance(3, this._drawProp.getAlphaComposite());
            ((Graphics2D)g).setComposite(ac);
            ((Graphics2D)g).setPaint(FillPatternFactory.createFillPattern(this._drawProp.fillPattern, g.getColor()));
            g.fillRect(0, 0, dim.width - 1, dim.height - 1);
            ((Graphics2D)g).setPaint(oldPaint);
            ((Graphics2D)g).setComposite(oldAC);
        }
        if (g instanceof Graphics2D && this._drawProp.drawBorder) {
            this.drawBorder((Graphics2D)g, dim);
        }
        int iconOffset = 0;
        if (this._icon != null) {
            int iconWidth = this._icon.getIconWidth();
            int iconHeight = this._icon.getIconHeight();
            if (iconHeight > 0 && iconWidth > 0) {
                iconOffset += iconHeight;
                this._icon.paintIcon(this, g, dim.width / 2 - iconWidth / 2, this.getInsets().top);
            }
        }
        int h = metrics.getHeight();
        int width = Math.abs((int)(Math.sin(Math.toRadians(this._drawProp.rotation)) * (double)dim.height + Math.cos(Math.toRadians(this._drawProp.rotation)) * (double)dim.width));
        for (int i = 0; i < this._text.length; ++i) {
            int ioff;
            String text = TextSubstitutionManager.getTextSubstitutionManager().replaceTokens(this._text[i], this.getTextSubstitutionObjects());
            if (text == null) continue;
            int iy = metrics.getMaxAscent() + i * h + this._drawProp.space + iconOffset;
            switch (this._drawProp.align) {
                case 1: {
                    ioff = (width - metrics.stringWidth(text)) / 2;
                    break;
                }
                case 2: {
                    ioff = width - metrics.stringWidth(text);
                    break;
                }
                default: {
                    ioff = (this._drawProp.space + 3) * 1;
                }
            }
            if (ioff < 0) {
                ioff = 0;
            }
            g.setColor(this._drawProp.textColor);
            Gfx2dDrawUtil.drawString(this, g, text, ioff, iy, this._drawProp.rotation);
        }
        g.setFont(oldFont);
        g.setColor(oldColor);
        if (Boolean.getBoolean("DEBUG_PLOT_BOUNDS")) {
            Color c2 = g.getColor();
            g.setColor(Color.orange);
            Dimension d = this.getSize();
            g.drawRect(0, 0, d.width - 1, d.height - 1);
            g.setColor(c2);
        }
    }

    private String replaceUnitTemplate(String val) {
        if (val == null) {
            return "";
        }
        int indexL = -1;
        int indexS = -1;
        indexL = val.indexOf("%L");
        if (indexL == -1 && (indexS = val.indexOf("%S")) == -1) {
            return val;
        }
        StringBuffer sb = new StringBuffer(val);
        String unitsLbl = this._axis.getDisplayUnitsString(this._displayUnitSystem);
        if (indexL >= 0) {
            sb.replace(indexL, indexL + 2, "");
            sb.insert(indexL, unitsLbl);
        }
        if (indexS >= 0) {
            sb.replace(indexS, indexS + 2, "");
            sb.insert(indexS, unitsLbl);
        }
        return sb.toString();
    }

    @Override
    public Object[] getTextSubstitutionObjects() {
        Viewport[] viewports = this.getG2dPanel().getViewports();
        for (int i = 0; viewports != null && i < viewports.length; ++i) {
            if (viewports[i].getAxis("x1") != this._axis && viewports[i].getAxis("y1") != this._axis && viewports[i].getAxis("x2") != this._axis && viewports[i].getAxis("y2") != this._axis) continue;
            return this.getPlotObjects(viewports[i]).toArray();
        }
        return new Object[0];
    }

    private List<G2dObject> getPlotObjects(Viewport viewport) {
        ArrayList<G2dObject> plotObjects = new ArrayList<G2dObject>();
        Vector glyphs = viewport.getGlyphVector();
        if (glyphs == null) {
            return plotObjects;
        }
        for (int j = 0; j < glyphs.size(); ++j) {
            G2dObject gobj = ((G2dGlyph)glyphs.get(j)).getG2dObject();
            if (gobj == null) continue;
            plotObjects.add(gobj);
        }
        return plotObjects;
    }
}

