/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.G2dMarkerProperties;
import hec.heclib.util.HecTime;
import hec.lang.annotation.Scriptable;
import rma.swing.RmaColor;
import rma.util.RmaDrawConst;

public class AxisMarkerDescription {
    final String defaultAxis = "Y";
    final String defaultValue = "0";
    final String defaultLabelText = "";
    final String defaultLabelColor = "black";
    final String defaultLabelPosition;
    final String defaultLabelAlignment;
    final String defaultLabelFont;
    final String defaultLineColor = "black";
    final String defaultLineStyle;
    final float defaultLineWidth = 1.0f;
    final String defaultFillColor;
    final String defaultFillStyle;
    final String defaultFillPattern;
    final boolean defaultDrawLabel = true;
    final boolean defaultDrawLine = true;
    public String axis = "Y";
    public String value = "0";
    public String labelText = "";
    public String labelColor = "black";
    public String labelPosition = this.defaultLabelPosition;
    public String labelAlignment = this.defaultLabelAlignment;
    public String labelFont = this.defaultLabelFont;
    public String lineColor = "black";
    public String lineStyle = this.defaultLineStyle;
    public float lineWidth = 1.0f;
    public String fillColor = this.defaultFillColor;
    public String fillStyle = this.defaultFillStyle;
    public String fillPattern = this.defaultFillPattern;
    public boolean drawLabel = true;
    public boolean drawLine = true;

    @Scriptable
    public AxisMarkerDescription() {
        this.defaultLabelPosition = null;
        this.defaultLabelAlignment = null;
        this.defaultLabelFont = null;
        this.defaultLineStyle = null;
        this.defaultFillColor = null;
        this.defaultFillStyle = null;
        this.defaultFillPattern = null;
    }

    @Scriptable
    public AxisMarkerDescription(AxisMarkerDescription other) {
        this.defaultLabelPosition = null;
        this.defaultLabelAlignment = null;
        this.defaultLabelFont = null;
        this.defaultLineStyle = null;
        this.defaultFillColor = null;
        this.defaultFillStyle = null;
        this.defaultFillPattern = null;
        this.axis = other.axis;
        this.value = other.value;
        this.labelText = other.labelText;
        this.labelColor = other.labelColor;
        this.labelPosition = other.labelPosition;
        this.labelAlignment = other.labelAlignment;
        this.labelFont = other.labelFont;
        this.lineColor = other.lineColor;
        this.lineStyle = other.lineStyle;
        this.lineWidth = other.lineWidth;
        this.fillColor = other.fillColor;
        this.fillStyle = other.fillStyle;
        this.fillPattern = other.fillPattern;
        this.drawLabel = other.drawLabel;
        this.drawLine = other.drawLine;
    }

    @Scriptable
    public G2dMarkerProperties toMarkerProperties() throws IllegalArgumentException {
        G2dMarkerProperties markerProp = new G2dMarkerProperties();
        if (this.axis == null) {
            markerProp.drawOnAxis = 1;
        } else {
            String str = this.axis.toLowerCase();
            if (str.startsWith("y")) {
                markerProp.drawOnAxis = 1;
            } else if (str.startsWith("x")) {
                markerProp.drawOnAxis = 0;
            } else {
                throw new IllegalArgumentException("Invalid axis field : \"" + this.axis + "\"");
            }
        }
        try {
            markerProp.markerValue = Double.parseDouble(this.value);
        }
        catch (Exception e) {
            try {
                HecTime time = new HecTime();
                time.set(this.value);
                markerProp.markerValue = time.value();
            }
            catch (Exception e2) {
                throw new IllegalArgumentException("Invalid value field : \"" + this.value + "\"");
            }
        }
        if (this.labelText != null) {
            markerProp.markerLabel = this.labelText;
        }
        if (this.labelPosition == null) {
            markerProp.labelPosition = 0;
        } else {
            markerProp.labelPosition = Integer.MIN_VALUE;
            for (int i = 0; i < G2dLineProperties.LABEL_POS_NAMES.length; ++i) {
                if (!this.labelPosition.equalsIgnoreCase(G2dLineProperties.LABEL_POS_NAMES[i])) continue;
                markerProp.labelPosition = i;
                break;
            }
            if (markerProp.labelPosition == Integer.MIN_VALUE) {
                throw new IllegalArgumentException("Invalid labelPosition field : \"" + this.labelPosition + "\"");
            }
        }
        if (this.labelAlignment == null) {
            markerProp.labelAlign = 0;
        } else {
            markerProp.labelAlign = Integer.MIN_VALUE;
            for (int i = 0; i < G2dLineProperties.LABEL_ALIGN_NAMES.length; ++i) {
                if (!this.labelAlignment.equalsIgnoreCase(G2dLineProperties.LABEL_ALIGN_NAMES[i])) continue;
                markerProp.labelAlign = i;
                break;
            }
            if (markerProp.labelAlign == Integer.MIN_VALUE) {
                throw new IllegalArgumentException("Invalid labelAlignment field : \"" + this.labelAlignment + "\"");
            }
        }
        if (this.labelColor == null) {
            markerProp.drawLabel = false;
        } else {
            markerProp.drawLabel = true;
            markerProp.labelColor = RmaColor.parseColorString(this.labelColor);
            if (markerProp.labelColor == null) {
                throw new IllegalArgumentException("Invalid labelColor field : \"" + this.labelColor + "\"");
            }
        }
        if (this.labelFont == null) {
            markerProp.labelFont = null;
        } else {
            markerProp.labelFont = G2dMarkerProperties.string2font(this.labelFont);
            if (markerProp.labelFont == null && markerProp.labelColor == null) {
                throw new IllegalArgumentException("Invalid labelFont field : \"" + this.labelFont + "\"");
            }
        }
        if (this.lineColor == null) {
            markerProp.drawLine = false;
        } else {
            markerProp.drawLine = true;
            markerProp.lineColor = RmaColor.parseColorString(this.lineColor);
            if (markerProp.lineColor == null) {
                throw new IllegalArgumentException("Invalid lineColor field : \"" + this.lineColor + "\"");
            }
        }
        markerProp.lineStylePattern = this.lineStyle == null ? G2dLineProperties.SOLID_STYLE_PATTERN : G2dLineProperties.lookupStyle(this.lineStyle);
        markerProp.lineWidth = this.lineWidth;
        if (this.fillColor == null) {
            markerProp.fillType = 0;
        } else {
            markerProp.fillColor = RmaColor.parseColorString(this.fillColor);
            if (markerProp.fillColor == null) {
                throw new IllegalArgumentException("Invalid fillColor field : \"" + this.fillColor + "\"");
            }
        }
        if (this.fillStyle == null) {
            markerProp.fillType = 0;
        } else if (this.fillColor != null) {
            markerProp.fillType = G2dLineProperties.lookupFill(this.fillStyle);
            if (markerProp.fillType == 0 && !this.fillStyle.equalsIgnoreCase("none")) {
                throw new IllegalArgumentException("Invalid fillStyle field : \"" + this.fillStyle + "\"");
            }
        }
        if (this.fillPattern == null) {
            markerProp.fillPattern = 0;
        } else {
            markerProp.fillPattern = RmaDrawConst.lookupFillPattern(this.fillPattern);
            if (markerProp.fillPattern == -1) {
                throw new IllegalArgumentException("Invalid fillPattern field : \"" + this.fillPattern + "\"");
            }
        }
        markerProp.drawLabel = this.drawLabel;
        markerProp.drawLine = this.drawLine;
        return markerProp;
    }
}

