/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.geometry.Axis;
import hec.gfx2d.G2dPanel;
import java.awt.Color;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JScrollBar;

public class AxisScrollbar
extends JScrollBar
implements Observer {
    public static final int MAX_RANGE_VALUE = 10000;
    public static final int MIN_RANGE_VALUE = 0;
    G2dPanel _g2dPanel = null;
    Axis[] _axisArray = new Axis[2];
    Color _axisScrollColor = new Color(174, 174, 174);

    public AxisScrollbar(G2dPanel p, Axis ax, int orientation) {
        super(orientation);
        this._g2dPanel = p;
        this._axisArray[0] = ax;
        this._axisArray[1] = null;
        this._axisArray[0].addObserver(this);
        this.addAdjustmentListener(this._axisArray[0]);
        this.computeScaling();
    }

    public AxisScrollbar(G2dPanel p, Axis[] ax, int orientation) {
        super(orientation);
        this._g2dPanel = p;
        for (int i = 0; i < ax.length && i < this._axisArray.length; ++i) {
            this._axisArray[i] = ax[i];
            if (this._axisArray[i] == null) continue;
            this.addAdjustmentListener(this._axisArray[i]);
            this._axisArray[i].addObserver(this);
        }
        this.computeScaling();
    }

    @Override
    protected void fireAdjustmentValueChanged(int id, int type, int value) {
        Object[] listeners = this.listenerList.getListenerList();
        AdjustmentEvent e = null;
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != AdjustmentListener.class) continue;
            if (e == null) {
                e = new AdjustmentEvent(this, id, type, value);
            }
            if (i == 2) {
                ((Axis)listeners[i + 1]).updateRatedFunctionScroll((Axis)listeners[1], e);
                continue;
            }
            ((AdjustmentListener)listeners[i + 1]).adjustmentValueChanged(e);
        }
    }

    public void addAxis(Axis ax) {
        for (int i = 0; i < this._axisArray.length; ++i) {
            if (this._axisArray[i] != null) continue;
            this._axisArray[i] = ax;
            this.addAdjustmentListener(ax);
            ax.addObserver(this);
            return;
        }
        this.computeScaling();
        System.out.println("There are no slots left in the Axis array to add a new Axis.  Remove an Axis first");
    }

    public void removeAxis(Axis ax) {
        this.removeAdjustmentListener(ax);
        for (int i = 0; i < this._axisArray.length; ++i) {
            if (this._axisArray[i] != ax) continue;
            this._axisArray[i] = null;
        }
        this.computeScaling();
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof Axis && arg == "NEW_ZOOM") {
            this.computeScaling((Axis)o);
        }
    }

    public void computeScaling() {
        for (int i = 0; i < this._axisArray.length; ++i) {
            this.computeScaling(this._axisArray[i]);
        }
        this.updateUI();
    }

    private void computeScaling(Axis axis) {
        int i;
        int lineinc;
        if (axis == null) {
            return;
        }
        int pgwidth = (int)(axis.getZoom() * 10000.0 + 0.5);
        if (pgwidth > 10000) {
            pgwidth = 10000;
        }
        if ((lineinc = pgwidth / 100) < 1) {
            lineinc = 1;
        }
        int ival = pgwidth == 10000 ? 0 : axis.computeScrollPosition();
        for (i = 0; i < this._axisArray.length; ++i) {
            if (this._axisArray[i] == null) continue;
            this.removeAdjustmentListener(this._axisArray[i]);
        }
        this.setValues(ival, pgwidth, 0, 10000);
        this.setBlockIncrement(lineinc * 10);
        this.setUnitIncrement(lineinc);
        if (this.getBlockIncrement() != 1000) {
            this.setVisible(true);
        } else {
            this.setVisible(false);
        }
        for (i = 0; i < this._axisArray.length; ++i) {
            if (this._axisArray[i] == null) continue;
            this.addAdjustmentListener(this._axisArray[i]);
        }
    }

    public void setAxisScrollColor(Color c2) {
        this._axisScrollColor = c2;
        this.setBackground(c2);
        this.setForeground(c2);
    }

    public Color getAxisScrollColor() {
        return this._axisScrollColor;
    }
}

