/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.geometry.Axis;
import hec.gfx2d.AxisTics;
import hec.gfx2d.CategoryAxisTics;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.ProbabilityAxisTics;
import hec.gfx2d.TSAxisTics;
import hec.gfx2d.Viewport;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

public class AxisTicFactory {
    private static Map<String, Object> _axisMapping = null;

    public static void addMapping(String axisClass, String axisTicsClass) {
        if (axisClass == null || axisTicsClass == null) {
            return;
        }
        _axisMapping.put(axisClass, axisTicsClass);
    }

    public static AxisTics createAxisTics(G2dPanel parent, Axis axis, Viewport view, int pos) {
        return AxisTicFactory.lookupG2dGlyphClass(parent, axis, axis.getClass(), view, pos);
    }

    private static AxisTics lookupG2dGlyphClass(G2dPanel parent, Axis axis, Class axisClass, Viewport view, int pos) {
        if (axis == null || axisClass == null) {
            return null;
        }
        AxisTics axisTics = null;
        Class<?> axisTicsClass = null;
        String strAxisClass = axisClass.getName();
        Object o = _axisMapping.get(strAxisClass);
        if (o instanceof String) {
            try {
                axisTicsClass = Thread.currentThread().getContextClassLoader().loadClass((String)o);
                _axisMapping.put(strAxisClass, axisTicsClass);
            }
            catch (Exception e) {
                System.out.println("Unable to instantiate class for Axis: " + strAxisClass + "  " + e);
                _axisMapping.put(strAxisClass, o);
            }
            catch (NoClassDefFoundError nfe) {
                System.out.println("No Glyph Class found for " + o + " for Axis " + strAxisClass + "  " + nfe);
            }
        } else if (o instanceof Class) {
            axisTicsClass = (Class<?>)o;
        }
        if (axisTicsClass == null) {
            Class<?>[] axisclassifcs = axisClass.getInterfaces();
            for (int ii = 0; ii < axisclassifcs.length; ++ii) {
                axisTics = AxisTicFactory.lookupG2dGlyphClass(parent, axis, axisclassifcs[ii], view, pos);
                if (axisTics == null) continue;
                return axisTics;
            }
            return AxisTicFactory.lookupG2dGlyphClass(parent, axis, axisClass.getSuperclass(), view, pos);
        }
        try {
            Class[] classargs;
            Constructor<?> constructor;
            if (strAxisClass.equals("hec.geometry.LogAxis")) {
                axisClass = Class.forName("hec.geometry.Axis");
            }
            if ((constructor = axisTicsClass.getConstructor(classargs = new Class[]{G2dPanel.class, axisClass, Viewport.class, Integer.TYPE})) != null) {
                Object[] objargs = new Object[]{parent, axis, view, new Integer(pos)};
                AxisTics at = (AxisTics)constructor.newInstance(objargs);
                return at;
            }
        }
        catch (InvocationTargetException ite) {
            System.out.println("AxisTicFactory: Error Creating AxisTics " + axisTicsClass.getName() + " Error:" + ite.getTargetException());
            ite.getTargetException().printStackTrace(System.out);
        }
        catch (Exception ee) {
            System.out.println("AxisTicFactory: Could not find a AxisTics matching the axis class: " + axisClass.getName());
            System.out.println("AxisTicFactory: " + ee.toString());
            ee.printStackTrace();
        }
        return null;
    }

    static {
        _axisMapping = new HashMap<String, Object>();
        _axisMapping.put("hec.geometry.TSAxis", TSAxisTics.class);
        _axisMapping.put("hec.geometry.ProbabilityAxis", ProbabilityAxisTics.class);
        _axisMapping.put("hec.geometry.LogAxis", AxisTics.class);
        _axisMapping.put("hec.geometry.Axis", AxisTics.class);
        _axisMapping.put("hec.geometry.CategoryAxis", CategoryAxisTics.class);
    }
}

