/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.data.Parameter;
import hec.data.Units;
import hec.geometry.Axis;
import hec.geometry.AxisFactory;
import hec.geometry.AxisIterator;
import hec.geometry.AxisProp;
import hec.geometry.DataObjectRating;
import hec.geometry.DefaultRatingFunction;
import hec.geometry.LocalPt;
import hec.geometry.LocalRect;
import hec.geometry.LogAxis;
import hec.geometry.ProbabilityAxis;
import hec.geometry.RatingFunction;
import hec.geometry.Scale;
import hec.geometry.ScaleProperties;
import hec.geometry.WorldRect;
import hec.gfx2d.AxisLabel;
import hec.gfx2d.AxisScrollbar;
import hec.gfx2d.AxisTicsDrawProp;
import hec.gfx2d.G2dAxisLabelPropertiesPanel;
import hec.gfx2d.G2dAxisPropertiesPanel;
import hec.gfx2d.G2dComponent;
import hec.gfx2d.G2dFont;
import hec.gfx2d.G2dGlyph;
import hec.gfx2d.G2dObject;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dPropertiesDlg;
import hec.gfx2d.G2dResolutionConst;
import hec.gfx2d.G2dScalePropertiesPanel;
import hec.gfx2d.G2dZoomComponent;
import hec.gfx2d.Gfx2dDrawUtil;
import hec.gfx2d.RatingFunctionEditor;
import hec.gfx2d.ScalePropertiesPanel;
import hec.gfx2d.Viewport;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import rma.lang.RmaMath;
import rma.swing.DefaultJPanel;
import rma.swing.RmaColor;
import rma.swing.RmaJMenuLabel;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class AxisTics
extends G2dComponent
implements Observer,
G2dZoomComponent {
    Axis _axis = null;
    Viewport _viewport = null;
    AxisTicsDrawProp _drawProp = new AxisTicsDrawProp();
    Color _ticColor = new Color(0, 0, 0);
    G2dAxisPropertiesPanel axisPanel = null;
    G2dScalePropertiesPanel scalePanel = null;
    G2dAxisLabelPropertiesPanel labelPanel = null;

    public AxisTics(G2dPanel p, Axis ax, Viewport vp, int align) {
        super(p);
        this._axis = ax;
        this._axis.addObserver(this);
        this._viewport = vp;
        this._alignment = align;
        this.setOpaque(false);
    }

    public void setAxis(Axis axis) {
        this._axis = axis;
    }

    public Viewport getViewport() {
        return this._viewport;
    }

    protected void buildMenu(Container c2) {
        JMenuItem jm = new JMenuItem("Edit Properties");
        jm.addActionListener(new G2dComponent.EditPropertyListener(this));
        c2.add(jm);
        JMenu menu = new JMenu("Set Axis Type");
        if (this._axis instanceof LogAxis) {
            jm = new JMenuItem("Linear Axis");
            jm.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AxisTics.this.setLinear();
                }
            });
        } else if (this._axis instanceof Axis) {
            if (this._axis instanceof ProbabilityAxis && Boolean.getBoolean("NoProbabilityAxisSwitch")) {
                jm = null;
            } else {
                jm = new JMenuItem("Log Axis");
                jm.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AxisTics.this.setLogarithmic();
                    }
                });
            }
        }
        if (this._alignment == 1) {
            JMenu ratingMenu = new JMenu("Rating");
            JMenuItem mi = new JMenuItem("On Left Axis");
            ratingMenu.add(mi);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AxisTics.this.computeRatingFromOppositeAxis();
                }
            });
            mi = new JMenuItem("Enter Rating Function");
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AxisTics.this.enterRatingFunctionFromTable();
                }
            });
            ratingMenu.add(mi);
            mi = new JMenuItem("Remove Rating Function");
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AxisTics.this._axis.setRatingFunction(null);
                    AxisTics.this._axis.computeNiceMinMax();
                    AxisTics.this._axis.computeScaling();
                    AxisTics.this.revalidate();
                    AxisTics.this.repaint();
                    AxisTics.this._viewport.setDirty();
                    AxisTics.this._viewport.repaint();
                }
            });
            ratingMenu.add(mi);
            c2.add(ratingMenu);
        }
        if (jm != null) {
            menu.add(jm);
        }
        if (menu.getMenuComponentCount() > 0) {
            c2.add(menu);
        }
    }

    public void setLinear() {
        this.swapInNewAxis(AxisFactory.createAxis(0, this._axis.getName()));
        this._drawProp.drawMinorTics = false;
    }

    public void setLogarithmic() {
        this.setLogarithmic(new AxisValuesGreaterThenZero());
    }

    public void setLogarithmic(AxisSwapValidator validator) {
        if (this._axis instanceof LogAxis) {
            return;
        }
        if (!validator.isValid()) {
            return;
        }
        this.swapInNewAxis(AxisFactory.createAxis(3, this._axis.getName()));
        this._drawProp.drawMinorTics = true;
    }

    @Deprecated
    public void computeRatingFromOpositeAxis() {
        this.computeRatingFromOppositeAxis();
    }

    public void computeRatingFromOppositeAxis() {
        G2dObject go1 = null;
        G2dObject go2 = null;
        Vector glyphList = this._viewport.getGlyphVector();
        if (glyphList == null || glyphList.size() <= 1) {
            return;
        }
        for (int i = 0; i < glyphList.size(); ++i) {
            G2dGlyph glyph = (G2dGlyph)glyphList.get(i);
            Axis a = glyph.getScale().getAxis(1);
            if (a == this._axis && go1 == null) {
                go1 = glyph.getG2dObject();
                continue;
            }
            if (a == this._axis || go2 != null) continue;
            go2 = glyph.getG2dObject();
        }
        if (go1 == null || go2 == null) {
            return;
        }
        DataObjectRating f = new DataObjectRating(go1, go2);
        this._axis.setRatingFunction(f, true);
        Axis masterAxis = this._viewport.getMasterAxis(1);
        if (masterAxis != null) {
            double max = f.getBaseValue(masterAxis.getMax());
            double min = f.getBaseValue(masterAxis.getMin());
            this._axis.setMinMax(min, max);
        }
        this._axis.computeScaling();
        this.revalidate();
        this.repaint();
        this._viewport.setDirty();
        this._viewport.repaint();
    }

    private void enterRatingFunctionFromTable() {
        RatingFunctionEditor rf = null;
        Window w = SwingUtilities.windowForComponent(this);
        rf = w instanceof JDialog ? new RatingFunctionEditor((JDialog)w, true, "Rating Function Editor") : new RatingFunctionEditor((JFrame)w, true, "Rating Function Editor");
        RatingFunction f = this._axis.getRatingFunction();
        if (f instanceof DefaultRatingFunction) {
            rf.fillForm((DefaultRatingFunction)f);
        }
        rf.pack();
        rf.setVisible(true);
        if (rf.isCanceled()) {
            return;
        }
        double[][] values = rf.saveForm();
        f = new DefaultRatingFunction();
        ((DefaultRatingFunction)f).setRatingFunction(values[1], values[0]);
        this._axis.setRatingFunction(f);
        Axis masterAxis = this._viewport.getMasterAxis(1);
        if (masterAxis != null) {
            double max = f.getBaseValue(masterAxis.getMax());
            double min = f.getBaseValue(masterAxis.getMin());
            this._axis.setMinMax(min, max);
        }
        this._axis.computeScaling();
        this.revalidate();
        this.repaint();
        this._viewport.setDirty();
        this._viewport.repaint();
    }

    private void swapInNewAxis(Axis newAxis) {
        int axisLocation;
        newAxis.setAxisProp(this._axis.getAxisProp());
        Scale[] sList = this._parent.getScales();
        for (int i = 0; i < sList.length; ++i) {
            Scale scl = sList[i];
            if (scl == null) continue;
            if (scl.getAxis(0) == this._axis) {
                scl.setAxis(newAxis, 0);
                continue;
            }
            if (scl.getAxis(1) != this._axis) continue;
            scl.setAxis(newAxis, 1);
        }
        Vector observers = this._axis.getObserverList();
        for (int i = 0; i < observers.size(); ++i) {
            Observer o = (Observer)observers.get(i);
            newAxis.addObserver(o);
            if (!(o instanceof AxisScrollbar)) continue;
            ((AxisScrollbar)o).removeAxis(this._axis);
            ((AxisScrollbar)o).addAxis(newAxis);
        }
        Vector glyphVector = this._viewport.getGlyphVector();
        WorldRect bounds = null;
        for (Object object : glyphVector) {
            WorldRect temp = ((G2dGlyph)object).getBounds();
            if (bounds == null) {
                bounds = temp;
                continue;
            }
            if (temp == null) continue;
            bounds.grow(temp);
        }
        if (this._alignment == 3 || this._alignment == 2) {
            if (bounds != null) {
                newAxis.setWorldExtents(bounds.w, bounds.e);
                newAxis.computeNiceMinMax();
            }
            newAxis.computeScaling(this._viewport.getWidth());
            axisLocation = this._alignment == 2 ? 0 : 1;
        } else {
            if (bounds != null) {
                newAxis.setWorldExtents(bounds.s, bounds.n);
                newAxis.computeNiceMinMax();
            }
            newAxis.computeScaling(this._viewport.getHeight());
            axisLocation = this._alignment == 0 ? 2 : 3;
        }
        this._axis.deleteObservers();
        this._axis = newAxis;
        this._parent.setViewportAxisLink(this._viewport, this._axis, axisLocation);
        if (this._alignment == 0) {
            this._viewport.setMasterAxis(1, this._axis);
        }
        if (this._alignment == 2) {
            this._viewport.setMasterAxis(0, this._axis);
        }
        this._parent.invalidate();
        this._parent.validate();
        this._parent.repaint();
    }

    @Override
    public void createPopupMenu() {
        this._popupMenu = new JPopupMenu();
        this._popupMenu = new JPopupMenu("Axis Tics Properties");
        RmaJMenuLabel label = new RmaJMenuLabel("Axis Tics");
        Font f = label.getFont();
        f = new Font(f.getName(), 2, f.getSize());
        label.setFont(f);
        this._popupMenu.add(label);
        this._popupMenu.addSeparator();
        this.buildMenu(this._popupMenu);
    }

    public JMenu createEditMenu() {
        JMenu jm = new JMenu("Axis Label");
        this.buildMenu(jm);
        return jm;
    }

    public void setProperties(AxisTicsDrawProp prop) {
        if (prop == null) {
            return;
        }
        this._drawProp = prop;
    }

    public AxisTicsDrawProp getProperties() {
        return this._drawProp;
    }

    @Override
    public void update(Observable o, Object arg) {
        boolean updateScalePanel = false;
        if (o instanceof Axis && arg == "COMPUTED_SCALE" && this.isVisible()) {
            this.paintGfx();
            updateScalePanel = true;
        }
        if (o instanceof Axis && arg == "NEW_ZOOM") {
            this.invalidate();
            updateScalePanel = true;
        }
        if (updateScalePanel && this.scalePanel != null && this.scalePanel.isVisible()) {
            this.scalePanel.refresh();
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSizeLocal() {
        Dimension defaultDim = super.getPreferredSizeLocal();
        Dimension dim = new Dimension(defaultDim);
        int sz = (int)((double)this._drawProp.getMajorTicFontSize() * this._parent.getFontScl() + 0.5);
        int g2dResolution = this._parent.getDeviceResoultion();
        double scl = g2dResolution / G2dResolutionConst.PRINTER_SCALE;
        if ((double)sz < (double)this._drawProp.getMajorTicMinFontSize() * scl) {
            sz = (int)((double)this._drawProp.getMajorTicMinFontSize() * scl);
        }
        if ((double)sz > (double)this._drawProp.getMajorTicMaxFontSize() * scl) {
            sz = (int)((double)this._drawProp.getMajorTicMaxFontSize() * scl);
        }
        String name = this._drawProp.getMajorTicFontFamily();
        String fname = name + "-PLAIN-" + Integer.toString(sz);
        Font font = G2dFont.newFont(fname, 0, sz);
        int space = 3;
        FontMetrics metrics = this.getFontMetrics(font);
        int numMajorTics = 0;
        if (this._alignment == 0 || this._alignment == 1) {
            Axis ma;
            dim.width = 0;
            if (this._drawProp.drawMajorTics) {
                ma = this._viewport.getMasterAxis(1);
                if (ma == null) {
                    ma = this._axis;
                }
                AxisIterator iter = AxisFactory.createAxisIterator(ma, ma.getMajorTic());
                while (iter.next()) {
                    ++numMajorTics;
                }
            }
            if (this._drawProp.drawMajorTics) {
                dim.width += (int)((double)(this._drawProp.majorTicLength + space * 2) * scl);
            }
            if (this._drawProp.drawMajorTicLabels) {
                ma = this._viewport.getMasterAxis(1);
                int sigFig = this._axis.getSigFig();
                if (ma == null || ma == this._axis) {
                    ma = this._axis;
                } else {
                    double max = RMAIO.parseDouble(RMAIO.setPrecision2(this._axis.getActMax(), sigFig));
                    double min = RMAIO.parseDouble(RMAIO.setPrecision2(this._axis.getActMin(), sigFig));
                    double value = (max - min) / (double)numMajorTics;
                    String strDecimal = Double.toString(value);
                    int tempSigFig = 1;
                    double logV = RmaMath.log10(value);
                    if (logV < 1.0 && (tempSigFig = (int)Math.ceil(Math.abs(logV)) + 1) > sigFig) {
                        sigFig = tempSigFig;
                    }
                }
                AxisIterator iter = AxisFactory.createAxisIterator(ma, ma.getMajorTic());
                DecimalFormat df = new DecimalFormat();
                df.setMaximumFractionDigits(sigFig);
                df.setMinimumFractionDigits(sigFig);
                while (iter.next()) {
                    double maLocalValue = ma.w2lE(iter.getValue());
                    double value = iter.getValue();
                    sigFig = value != 0.0 ? this._axis.getSigFig() : (this._axis.getSigFig() == 0 ? 0 : 1);
                    String txt = df.format(this._axis.l2wE(maLocalValue) / this._axis.getThousScale());
                    int iw = (int)Math.ceil((double)(this._drawProp.majorTicLength + space * 2) * scl) + metrics.stringWidth(txt);
                    if (dim.width >= iw) continue;
                    dim.width = iw;
                }
            }
            dim.height = 25;
        } else {
            dim.width = 25;
            dim.height = 0;
            if (this._drawProp.showMajorTics()) {
                dim.height += (int)Math.ceil((double)(this._drawProp.majorTicLength + space * 2) * scl);
            }
            if (this._drawProp.showTicLabels() && this._drawProp.showMajorTics()) {
                dim.height += metrics.getHeight();
            }
        }
        return dim;
    }

    @Override
    public void paintGfx(Graphics g) {
        int style;
        String name;
        if (this._axis == null) {
            return;
        }
        if (Boolean.getBoolean("DEBUG_PLOT_BOUNDS")) {
            Color c2 = g.getColor();
            g.setColor(Color.blue);
            Dimension d = this.getSize();
            g.drawRect(0, 0, d.width - 1, d.height - 1);
            g.setColor(c2);
        }
        Font font = g.getFont();
        int sz = (int)((double)this._drawProp.getMajorTicFontSize() * this._parent.getFontScl() + 0.5);
        int g2dResolution = this._parent.getDeviceResoultion();
        double scl = g2dResolution / G2dResolutionConst.PRINTER_SCALE;
        if ((double)sz < (double)this._drawProp.getMajorTicMinFontSize() * scl) {
            sz = (int)((double)this._drawProp.getMajorTicMinFontSize() * scl);
        }
        if ((double)sz > (double)this._drawProp.getMajorTicMaxFontSize() * scl) {
            sz = (int)((double)this._drawProp.getMajorTicMaxFontSize() * scl);
        }
        if ((font = G2dFont.newFont(name = this._drawProp.getMajorTicFontFamily(), style = this._drawProp.getMajorTicFontStyle(), sz)) != null) {
            g.setFont(font);
        }
        if (this._alignment == 0) {
            this.drawTicsLeft(g);
        } else if (this._alignment == 1) {
            this.drawTicsRight(g);
        } else if (this._alignment == 2) {
            this.drawTicsTop(g);
        } else if (this._alignment == 3) {
            this.drawTicsBottom(g);
        }
    }

    protected void drawTicsRight(Graphics g) {
        Rectangle rc = this.getBounds();
        Rectangle vprc = this._viewport.getBounds();
        int space = 2;
        FontMetrics metrics = g.getFontMetrics();
        int ioff = vprc.y - rc.y;
        int g2dResolution = this._parent.getDeviceResoultion();
        int TIC_LENGTH = this._drawProp.majorTicLength * (g2dResolution / G2dResolutionConst.PRINTER_SCALE);
        int MINOR_TIC_LENGTH = this._drawProp.minorTicLength * (g2dResolution / G2dResolutionConst.PRINTER_SCALE);
        int TIC_SPACE_LENGTH = (this._drawProp.majorTicLength + space * 2) * (g2dResolution / G2dResolutionConst.PRINTER_SCALE);
        int numMajorTics = 0;
        if (this._drawProp.drawMajorTics) {
            g.setColor(this._drawProp.axisTicColor);
            Axis ma = this._viewport.getMasterAxis(1);
            if (ma == null) {
                ma = this._axis;
            }
            AxisIterator iter = AxisFactory.createAxisIterator(ma, ma.getMajorTic());
            while (iter.next()) {
                ++numMajorTics;
                int maLocalValue = ma.w2l(iter.getValue());
                int ix = ioff + maLocalValue;
                g.drawLine(0, ix, TIC_LENGTH, ix);
            }
        }
        ArrayList<Rectangle2D> mBoundingBoxes = new ArrayList<Rectangle2D>();
        int sigFig = 0;
        if (this._drawProp.drawMajorTics && this._drawProp.drawMajorTicLabels) {
            g.setColor(this._drawProp.axisTicColor);
            Axis ma = this._viewport.getMasterAxis(1);
            sigFig = this._axis.getSigFig();
            if (ma == null) {
                ma = this._axis;
            } else {
                double max = RMAIO.parseDouble(RMAIO.setPrecision2(this._axis.getActMax(), sigFig));
                double min = RMAIO.parseDouble(RMAIO.setPrecision2(this._axis.getActMin(), sigFig));
                double value = (max - min) / (double)numMajorTics;
                String strDecimal = Double.toString(value);
                int tempSigFig = 1;
                double logV = RmaMath.log10(value);
                if (logV < 1.0 && (tempSigFig = (int)Math.ceil(Math.abs(logV)) + 1) > sigFig) {
                    sigFig = tempSigFig;
                }
            }
            double t1 = ma.w2lE(ma.getMajorTic());
            double t2 = ma.w2lE(0.0);
            double t3 = t1 - t2;
            double dely = Math.abs(t3);
            int iskip = dely != 0.0 ? (int)((double)metrics.getHeight() / dely + 1.0) : metrics.getHeight() + 1;
            AxisIterator iter = AxisFactory.createAxisIterator(ma, ma.getMajorTic() * (double)iskip);
            DecimalFormat df = new DecimalFormat();
            df.setMaximumFractionDigits(sigFig);
            df.setMinimumFractionDigits(sigFig);
            while (iter.next()) {
                String txt;
                double maLocalValue = ma.w2lE(iter.getValue());
                int iy = ioff + (int)maLocalValue;
                double value = this._axis.l2wE(maLocalValue);
                if (ma instanceof LogAxis) {
                    if (value / this._axis.getThousScale() < 1.0) {
                        txt = Double.toString(value / this._axis.getThousScale());
                    } else {
                        df.setMaximumFractionDigits(0);
                        txt = df.format(value / this._axis.getThousScale());
                    }
                } else {
                    txt = df.format(value / this._axis.getThousScale());
                }
                int ix = TIC_SPACE_LENGTH;
                if (iy - metrics.getMaxAscent() / 2 > 0 && iy + metrics.getMaxAscent() / 2 < rc.height) {
                    int y = iy + metrics.getAscent() / 2;
                    Gfx2dDrawUtil.drawString(this, g, txt, ix, y);
                    Rectangle r = new Rectangle(ix, y - metrics.getAscent(), metrics.stringWidth(txt), metrics.getAscent());
                    mBoundingBoxes.add(r);
                    continue;
                }
                if (iy - metrics.getMaxAscent() / 2 < 0) continue;
                int adjust = 0;
                while (iy + metrics.getMaxAscent() / 2 - adjust > rc.height) {
                    ++adjust;
                }
                int y = iy + metrics.getAscent() / 2 - adjust;
                Gfx2dDrawUtil.drawString(this, g, txt, ix, y);
                Rectangle r = new Rectangle(ix, y - metrics.getAscent(), metrics.stringWidth(txt), metrics.getAscent());
                mBoundingBoxes.add(r);
            }
        }
        if (this._drawProp.drawMinorTics) {
            g.setColor(this._drawProp.axisTicColor);
            Axis ma = this._viewport.getMasterAxis(1);
            if (ma == null) {
                ma = this._axis;
            }
            AxisIterator iter = AxisFactory.createAxisIterator(ma, ma.getMinorTic());
            iter.iterateMinorScale();
            FontMetrics minorTicFontMetrics = null;
            while (iter.next()) {
                int x;
                String txt;
                int maLocalValue = ma.w2l(iter.getValue());
                int iy = ioff + maLocalValue;
                if (iy > vprc.height + ioff) continue;
                g.drawLine(0, iy, MINOR_TIC_LENGTH, iy);
                if (!this._drawProp.drawMinorTicLabels) continue;
                Font f = this._drawProp.getMinorTicFont();
                if (f != null) {
                    g.setFont(f);
                }
                g.setColor(this._drawProp.minorTicLabelColor);
                if (minorTicFontMetrics == null) {
                    minorTicFontMetrics = g.getFontMetrics();
                }
                DecimalFormat df = new DecimalFormat();
                df.setMaximumFractionDigits(sigFig);
                df.setMinimumFractionDigits(sigFig);
                if (ma instanceof LogAxis) {
                    txt = Double.toString((double)maLocalValue / this._axis.getThousScale());
                } else {
                    txt = RMAIO.setPrecision2((double)maLocalValue / this._axis.getThousScale(), sigFig);
                    txt = df.format(this._axis.l2wE(maLocalValue) / this._axis.getThousScale());
                }
                if (iy - minorTicFontMetrics.getAscent() / 2 > 0 && iy + minorTicFontMetrics.getMaxAscent() / 2 < rc.height) {
                    x = MINOR_TIC_LENGTH + TIC_SPACE_LENGTH;
                    int y = iy + minorTicFontMetrics.getAscent() / 2;
                    int height = minorTicFontMetrics.getAscent();
                    Rectangle2D.Double box = new Rectangle2D.Double(x, y - height, minorTicFontMetrics.stringWidth(txt), height);
                    boolean intersects = false;
                    for (int i = 0; i < mBoundingBoxes.size(); ++i) {
                        if (!((Shape)mBoundingBoxes.get(i)).intersects(box)) continue;
                        intersects = true;
                        break;
                    }
                    if (!intersects) {
                        Gfx2dDrawUtil.drawString(this, g, txt, x, y);
                        mBoundingBoxes.add(box);
                    }
                } else {
                    x = MINOR_TIC_LENGTH + TIC_SPACE_LENGTH;
                    if (iy - minorTicFontMetrics.getAscent() / 2 >= 0) {
                        int adjust = 0;
                        while (iy + minorTicFontMetrics.getAscent() / 2 - adjust > rc.height) {
                            ++adjust;
                        }
                        int y = iy + minorTicFontMetrics.getAscent() / 2 - adjust;
                        int height = minorTicFontMetrics.getAscent();
                        Rectangle2D.Double box = new Rectangle2D.Double(x, y - height, minorTicFontMetrics.stringWidth(txt), height);
                        boolean intersects = false;
                        for (int i = 0; i < mBoundingBoxes.size(); ++i) {
                            if (!((Shape)mBoundingBoxes.get(i)).intersects(box)) continue;
                            intersects = true;
                            break;
                        }
                        if (!intersects) {
                            Gfx2dDrawUtil.drawString(this, g, txt, x, y);
                            mBoundingBoxes.add(box);
                        }
                    }
                }
                g.setColor(this._drawProp.axisTicColor);
            }
        }
    }

    protected void drawTicsLeft(Graphics g) {
        AxisIterator iter;
        Rectangle rc = this.getBounds();
        Rectangle vprc = this._viewport.getBounds();
        int space = 2;
        FontMetrics metrics = g.getFontMetrics();
        int g2dResolution = this._parent.getDeviceResoultion();
        int ioff = vprc.y - rc.y;
        int TIC_LENGTH = this._drawProp.majorTicLength * (g2dResolution / G2dResolutionConst.PRINTER_SCALE);
        int MINOR_TIC_LENGTH = this._drawProp.minorTicLength * (g2dResolution / G2dResolutionConst.PRINTER_SCALE);
        int TIC_SPACE_LENGTH = (this._drawProp.majorTicLength + space) * (g2dResolution / G2dResolutionConst.PRINTER_SCALE);
        ArrayList<Rectangle2D> mBoundingBoxes = new ArrayList<Rectangle2D>();
        if (this._drawProp.drawMajorTics) {
            g.setColor(this._drawProp.axisTicColor);
            Axis ma = this._viewport.getMasterAxis(1);
            if (ma == null) {
                ma = this._axis;
            }
            iter = AxisFactory.createAxisIterator(ma, ma.getMajorTic());
            while (iter.next()) {
                int ix = iter.getLocalValue() + ioff;
                if (ix < ioff || ix > vprc.height + ioff) continue;
                g.drawLine(rc.width, ix, rc.width - TIC_LENGTH, ix);
            }
        }
        if (this._drawProp.drawMajorTics && this._drawProp.drawMajorTicLabels) {
            g.setColor(this._drawProp.axisTicColor);
            double t1 = this._axis.w2lE(this._axis.getMajorTic());
            double t2 = this._axis.w2lE(0.0);
            double t3 = t1 - t2;
            double dely = Math.abs(t3);
            int iskip = dely != 0.0 ? (int)((double)metrics.getHeight() / dely + 1.0) : metrics.getHeight() + 1;
            Axis ma = this._viewport.getMasterAxis(1);
            if (ma == null) {
                ma = this._axis;
            }
            AxisIterator iter2 = AxisFactory.createAxisIterator(ma, ma.getMajorTic() * (double)iskip);
            int sigFig = this._axis.getSigFig();
            DecimalFormat df = new DecimalFormat();
            df.setMaximumFractionDigits(sigFig);
            df.setMinimumFractionDigits(sigFig);
            while (iter2.next()) {
                String txt;
                double maLocalValue = ma.w2lE(iter2.getValue());
                int iy = (int)maLocalValue + ioff;
                if (iy < ioff || iy > vprc.height + ioff) continue;
                double value = iter2.getValue();
                if (ma instanceof LogAxis) {
                    if (value / this._axis.getThousScale() < 1.0) {
                        txt = Double.toString(value / this._axis.getThousScale());
                    } else {
                        df.setMaximumFractionDigits(0);
                        txt = df.format(value / this._axis.getThousScale());
                    }
                } else {
                    txt = df.format(this._axis.l2wE(maLocalValue) / this._axis.getThousScale());
                }
                int ix = rc.width - TIC_SPACE_LENGTH - metrics.stringWidth(txt);
                if (iy - metrics.getMaxAscent() / 2 > 0 && iy + metrics.getMaxAscent() / 2 < rc.height) {
                    int y = iy + metrics.getAscent() / 2;
                    Gfx2dDrawUtil.drawString(this, g, txt, ix, y);
                    Rectangle r = new Rectangle(ix, y - metrics.getAscent(), metrics.stringWidth(txt), metrics.getAscent());
                    mBoundingBoxes.add(r);
                    continue;
                }
                if (iy - metrics.getMaxAscent() / 2 < 0) continue;
                int adjust = 0;
                while (iy + metrics.getMaxAscent() / 2 - adjust > rc.height) {
                    ++adjust;
                }
                int y = iy + metrics.getAscent() / 2 - adjust;
                Gfx2dDrawUtil.drawString(this, g, txt, ix, y);
                Rectangle r = new Rectangle(ix, y - metrics.getAscent(), metrics.stringWidth(txt), metrics.getAscent());
                mBoundingBoxes.add(r);
            }
        }
        if (this._drawProp.drawMinorTics) {
            g.setColor(this._drawProp.axisTicColor);
            Axis ma = this._viewport.getMasterAxis(1);
            if (ma == null) {
                ma = this._axis;
            }
            iter = AxisFactory.createAxisIterator(ma, ma.getMinorTic());
            iter.iterateMinorScale();
            int sigFig = this._axis.getSigFig();
            DecimalFormat df = new DecimalFormat();
            df.setMaximumFractionDigits(sigFig);
            df.setMinimumFractionDigits(sigFig);
            FontMetrics minorTicFontMetrics = null;
            while (iter.next()) {
                String txt;
                double value = iter.getValue();
                double maLocalValue = ma.w2lE(value);
                int iy = (int)maLocalValue + ioff;
                if (iy < ioff || iy > vprc.height + ioff) continue;
                g.drawLine(rc.width, iy, rc.width - MINOR_TIC_LENGTH, iy);
                if (!this._drawProp.drawMinorTicLabels) continue;
                Font f = this._drawProp.getMinorTicFont();
                if (f != null) {
                    g.setFont(f);
                }
                g.setColor(this._drawProp.minorTicLabelColor);
                if (minorTicFontMetrics == null) {
                    minorTicFontMetrics = g.getFontMetrics();
                }
                if (ma instanceof LogAxis) {
                    txt = Double.toString(value / this._axis.getThousScale());
                } else {
                    txt = RMAIO.setPrecision2(value / this._axis.getThousScale(), sigFig);
                    txt = df.format(this._axis.l2wE(maLocalValue) / this._axis.getThousScale());
                }
                int ix = rc.width - TIC_SPACE_LENGTH - minorTicFontMetrics.stringWidth(txt);
                if (iy - minorTicFontMetrics.getAscent() / 2 > 0 && iy + minorTicFontMetrics.getMaxAscent() / 2 < rc.height) {
                    int y = iy + minorTicFontMetrics.getAscent() / 2;
                    int height = minorTicFontMetrics.getAscent();
                    Rectangle2D.Double box = new Rectangle2D.Double(ix, y - height, minorTicFontMetrics.stringWidth(txt), height);
                    boolean intersects = false;
                    for (int i = 0; i < mBoundingBoxes.size(); ++i) {
                        if (!((Shape)mBoundingBoxes.get(i)).intersects(box)) continue;
                        intersects = true;
                        break;
                    }
                    if (!intersects) {
                        Gfx2dDrawUtil.drawString(this, g, txt, ix, y);
                        mBoundingBoxes.add(box);
                    }
                } else if (iy - minorTicFontMetrics.getAscent() / 2 >= 0) {
                    int adjust = 0;
                    while (iy + minorTicFontMetrics.getAscent() / 2 - adjust > rc.height) {
                        ++adjust;
                    }
                    int y = iy + minorTicFontMetrics.getAscent() / 2 - adjust;
                    int height = minorTicFontMetrics.getAscent();
                    Rectangle2D.Double box = new Rectangle2D.Double(ix, y - height, minorTicFontMetrics.stringWidth(txt), height);
                    boolean intersects = false;
                    for (int i = 0; i < mBoundingBoxes.size(); ++i) {
                        if (!((Shape)mBoundingBoxes.get(i)).intersects(box)) continue;
                        intersects = true;
                        break;
                    }
                    if (!intersects) {
                        Gfx2dDrawUtil.drawString(this, g, txt, ix, y);
                        mBoundingBoxes.add(box);
                    }
                }
                g.setColor(this._drawProp.axisTicColor);
            }
        }
    }

    protected void drawTicsTop(Graphics g) {
        Rectangle rc = this.getBounds();
        Rectangle vprc = this._viewport.getBounds();
        int space = 2;
        FontMetrics metrics = g.getFontMetrics();
        int ioff = vprc.x - rc.x;
        if (this._drawProp.drawMajorTics) {
            g.setColor(this._drawProp.axisTicColor);
            Axis ma = this._viewport.getMasterAxis(0);
            if (ma == null) {
                ma = this._axis;
            }
            AxisIterator iter = AxisFactory.createAxisIterator(ma, ma.getMajorTic());
            while (iter.next()) {
                int ix = ioff + iter.getLocalValue();
                if (ix < ioff || ix > ioff + this._viewport.getWidth()) continue;
                g.drawLine(ix, 0, ix, this._drawProp.majorTicLength);
            }
        }
        int lastLabelPos = this._axis.isReversed() ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        boolean lastLabelWidth = false;
        if (this._drawProp.drawMajorTics && this._drawProp.drawMajorTicLabels) {
            this.drawAxisLabelsTop(g, metrics, ioff, space, rc);
        }
        if (this._drawProp.drawMinorTics) {
            g.setColor(this._drawProp.axisTicColor);
            Axis ma = this._viewport.getMasterAxis(0);
            if (ma == null) {
                ma = this._axis;
            }
            AxisIterator iter = AxisFactory.createAxisIterator(ma, ma.getMinorTic());
            iter.iterateMinorScale();
            while (iter.next()) {
                int ix = ioff + iter.getLocalValue();
                if (ix < ioff || ix > ioff + this._viewport.getWidth() || ix > vprc.width + ioff) continue;
                g.drawLine(ix, 0, ix, this._drawProp.minorTicLength);
            }
        }
    }

    protected void drawTicsBottom(Graphics g) {
        int ix;
        AxisIterator iter;
        Axis ma;
        Rectangle rc = this.getBounds();
        Rectangle vprc = this._viewport.getBounds();
        int space = 2;
        FontMetrics metrics = g.getFontMetrics();
        int ioff = vprc.x - rc.x;
        if (this._drawProp.drawMajorTics) {
            g.setColor(this._drawProp.axisTicColor);
            ma = this._viewport.getMasterAxis(0);
            if (ma == null) {
                ma = this._axis;
            }
            iter = AxisFactory.createAxisIterator(ma, ma.getMajorTic());
            while (iter.next()) {
                ix = ioff + iter.getLocalValue();
                if (ix < ioff || ix > ioff + this._viewport.getWidth()) continue;
                g.setColor(this._axis.getTicColor());
                g.drawLine(ix, rc.height, ix, rc.height - this._drawProp.majorTicLength);
            }
        }
        if (this._drawProp.drawMajorTics && this._drawProp.drawMajorTicLabels) {
            this.drawAxisLabelsBottom(g, metrics, ioff, space, rc);
        }
        if (this._drawProp.drawMinorTics) {
            g.setColor(this._drawProp.axisTicColor);
            ma = this._viewport.getMasterAxis(0);
            if (ma == null) {
                ma = this._axis;
            }
            iter = AxisFactory.createAxisIterator(ma, ma.getMinorTic());
            iter.iterateMinorScale();
            while (iter.next()) {
                ix = ioff + iter.getLocalValue();
                if (ix < ioff || ix > ioff + this._viewport.getWidth() || ix > vprc.width + ioff) continue;
                g.drawLine(ix, rc.height, ix, rc.height - this._drawProp.minorTicLength);
            }
        }
    }

    protected void drawAxisLabelsBottom(Graphics g, FontMetrics metrics, int ioff, int space, Rectangle rc) {
        int lastLabelPos = this._axis.isReversed() ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        int lastLabelWidth = 0;
        g.setColor(this._drawProp.axisTicColor);
        double val = this._axis.getActMax() / this._axis.getThousScale();
        String xtxt = RMAIO.setPrecision2(val, this._axis.getSigFig());
        int delx = Math.abs(this._axis.w2l(this._axis.getMajorTic()) - this._axis.w2l(0.0));
        int iskip = (int)((double)metrics.stringWidth(xtxt) * 1.1 / (double)delx + 1.0);
        Axis ma = this._viewport.getMasterAxis(0);
        if (ma == null) {
            ma = this._axis;
        }
        AxisIterator iter = AxisFactory.createAxisIterator(ma, ma.getMajorTic() * (double)iskip);
        DecimalFormat df = new DecimalFormat();
        while (iter.next()) {
            double value = iter.getValue();
            double maLocalValue = ma.w2lE(value);
            int ix = ioff + (int)maLocalValue;
            if (ix < ioff) continue;
            String txt = "";
            if (ma instanceof LogAxis) {
                if (value / this._axis.getThousScale() < 1.0) {
                    txt = Double.toString(value / this._axis.getThousScale());
                } else {
                    df.setMaximumFractionDigits(0);
                    txt = df.format(value / this._axis.getThousScale());
                }
            } else {
                df.setMaximumFractionDigits(this._axis.getSigFig());
                txt = df.format(this._axis.l2wE(maLocalValue) / this._axis.getThousScale());
            }
            int iy = rc.height - this._drawProp.majorTicLength - space - metrics.getMaxDescent();
            int labelWidth = metrics.stringWidth(txt);
            if (!this._axis.isReversed()) {
                if (lastLabelPos + lastLabelWidth / 2 + 2 >= ix - labelWidth / 2) continue;
                Gfx2dDrawUtil.drawString(this, g, txt, ix - labelWidth / 2, iy);
                lastLabelPos = ix;
                lastLabelWidth = labelWidth;
                continue;
            }
            if (lastLabelPos - lastLabelWidth / 2 - 2 <= ix + labelWidth / 2) continue;
            Gfx2dDrawUtil.drawString(this, g, txt, ix - labelWidth / 2, iy);
            lastLabelPos = ix;
            lastLabelWidth = labelWidth;
        }
    }

    protected void drawAxisLabelsTop(Graphics g, FontMetrics metrics, int ioff, int space, Rectangle rc) {
        int lastLabelPos = this._axis.isReversed() ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        int lastLabelWidth = 0;
        g.setColor(this._drawProp.axisTicColor);
        double val = this._axis.getActMax() / this._axis.getThousScale();
        String xtxt = RMAIO.setPrecision2(val, this._axis.getSigFig());
        int delx = Math.abs(this._axis.w2l(this._axis.getMajorTic()) - this._axis.w2l(0.0));
        int iskip = (int)((double)metrics.stringWidth(xtxt) * 1.1 / (double)delx + 1.0);
        Axis ma = this._viewport.getMasterAxis(0);
        if (ma == null) {
            ma = this._axis;
        }
        AxisIterator iter = AxisFactory.createAxisIterator(ma, ma.getMajorTic() * (double)iskip);
        DecimalFormat df = new DecimalFormat();
        while (iter.next()) {
            double value = iter.getValue();
            double maLocalValue = ma.w2lE(value);
            int ix = ioff + (int)maLocalValue;
            if (ix < ioff) continue;
            String txt = "";
            if (ma instanceof LogAxis) {
                if (value / this._axis.getThousScale() < 1.0) {
                    txt = Double.toString(value / this._axis.getThousScale());
                } else {
                    df.setMaximumFractionDigits(0);
                    txt = df.format(value / this._axis.getThousScale());
                }
            } else {
                df.setMaximumFractionDigits(this._axis.getSigFig());
                txt = df.format(this._axis.l2wE(maLocalValue) / this._axis.getThousScale());
            }
            int iy = this._drawProp.majorTicLength + space + metrics.getMaxAscent();
            int labelWidth = metrics.stringWidth(txt);
            if (!this._axis.isReversed()) {
                if (lastLabelPos + lastLabelWidth / 2 + 2 >= ix - labelWidth / 2) continue;
                Gfx2dDrawUtil.drawString(this, g, txt, ix - labelWidth / 2, iy);
                lastLabelPos = ix;
                lastLabelWidth = labelWidth;
                continue;
            }
            if (lastLabelPos - lastLabelWidth / 2 - 2 <= ix + labelWidth / 2) continue;
            Gfx2dDrawUtil.drawString(this, g, txt, ix - labelWidth / 2, iy);
            lastLabelPos = ix;
            lastLabelWidth = labelWidth;
        }
    }

    public Axis getAxis() {
        return this._axis;
    }

    public void setFontSizes(int sz, int tiny, int min, int max) {
        this._drawProp.setMajorTicFontSize(sz);
        this._drawProp.setMajorTicTinyFontSize(tiny);
        this._drawProp.setMajorTicMinFontSize(min);
        this._drawProp.setMajorTicMaxFontSize(max);
    }

    public int[] getFontSizes() {
        int[] sizes = new int[]{this._drawProp.getMajorTicFontSize(), this._drawProp.getMajorTicTinyFontSize(), this._drawProp.getMajorTicMinFontSize(), this._drawProp.getMajorTicMaxFontSize()};
        return sizes;
    }

    @Override
    public boolean objectPopupMenu(LocalPt pt, int modifiers) {
        Rectangle rect = this.getBounds();
        if (!rect.contains(new Point(pt.x, pt.y))) {
            return false;
        }
        this.createPopupMenu();
        this._popupMenu.show(this, pt.x - rect.x, pt.y - rect.y);
        return true;
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        return "Axis Tics";
    }

    protected boolean getCanSwapAxis() {
        Vector glyphs = this._viewport.getGlyphVector();
        for (int i = 0; glyphs != null && i < glyphs.size(); ++i) {
            G2dGlyph glyph = (G2dGlyph)glyphs.get(i);
            G2dObject data = glyph.getG2dObject();
            if (data == null || data.canSwapXYValues()) continue;
            return false;
        }
        return true;
    }

    protected boolean getAxisSwapped() {
        Vector glyphs = this._viewport.getGlyphVector();
        for (int i = 0; glyphs != null && i < glyphs.size(); ++i) {
            G2dGlyph glyph = (G2dGlyph)glyphs.get(i);
            G2dObject data = glyph.getG2dObject();
            if (data == null || !data.canSwapXYValues() || !data.swapXYValues()) continue;
            return true;
        }
        return false;
    }

    protected int translateFromAlignmentToAxisPosition(int alignment) {
        switch (alignment) {
            case 3: {
                return 1;
            }
            case 2: {
                return 0;
            }
            case 0: {
                return 2;
            }
            case 1: {
                return 3;
            }
        }
        return 0;
    }

    @Override
    public void editProperties() {
        this.editProperties(0);
    }

    public void editProperties(int selectedTab) {
        Cursor oldCursor = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.axisPanel = new G2dAxisPropertiesPanel();
        this.scalePanel = new G2dScalePropertiesPanel();
        this.labelPanel = new G2dAxisLabelPropertiesPanel();
        AxisLabel label = this.getG2dPanel().getViewportAxisLabel(this._viewport, this.translateFromAlignmentToAxisPosition(this._alignment));
        if (label != null) {
            this.labelPanel.setData(label.getProperties());
            this.labelPanel.setLabelText(label.getText());
        }
        this.axisPanel.setData(this._drawProp);
        AxisProp prop = this._axis.getAxisProp();
        prop.max = this._axis.getMax();
        prop.min = this._axis.getMin();
        prop.minortic = this._axis.getMinorTic();
        prop.majortic = this._axis.getMajorTic();
        prop.actmax = this._axis.getActMax();
        prop.actmin = this._axis.getActMin();
        prop.isReversed = this._axis.isReversed();
        prop.swapAxis = this.getAxisSwapped();
        prop.canSwapAxis = this.getCanSwapAxis();
        if (this._alignment == 1 || this._alignment == 0) {
            prop.isReversed = !prop.isReversed;
        }
        prop.isDefaultLimits = false;
        this.scalePanel.setData(prop);
        this.axisPanel.setName("Tics");
        G2dPropertiesDlg dlg = null;
        Window w = SwingUtilities.windowForComponent(this);
        dlg = w instanceof Dialog ? new G2dPropertiesDlg((Dialog)w, false, "Edit Axis Properties", new DefaultJPanel[]{this.scalePanel, this.labelPanel, this.axisPanel}) : new G2dPropertiesDlg((Frame)w, false, "Edit Axis Properties", new DefaultJPanel[]{this.scalePanel, this.labelPanel, this.axisPanel});
        if (dlg == null) {
            return;
        }
        dlg.setTitle(this._viewport.getName() + " - Axis " + this._axis.getName() + " Properties");
        dlg.addOKListener(new PropertiesOKListener(this.scalePanel, this.labelPanel));
        if (label != null && selectedTab == 1) {
            dlg.setSelectedTabIndex(selectedTab);
        }
        if (label == null) {
            dlg.setTabEnabled(1, false);
        }
        this.setCursor(oldCursor);
        dlg.setVisible(true);
    }

    public PropertiesOKListener getPropertiesOKListener(ScalePropertiesPanel scalePanel, G2dAxisLabelPropertiesPanel labelPanel) {
        return new PropertiesOKListener(scalePanel, labelPanel);
    }

    @Override
    public void zoomIn(LocalRect rc) {
        boolean icnt = false;
        Rectangle lrc = this.getBounds();
        Rectangle vprc = this._viewport.getBounds();
        if (this._alignment == 3 || this._alignment == 2) {
            int ioff = vprc.x - lrc.x;
            this._axis.zoomIn(rc.l - ioff, rc.r - ioff);
            AxisTics axisTics = this._parent.getViewportAxisTics(this._viewport, 0);
            if (axisTics != null && axisTics != this) {
                Axis axis = axisTics.getAxis();
                axis.zoomIn(rc.l - ioff, rc.r - ioff);
            } else {
                axisTics = this._parent.getViewportAxisTics(this._viewport, 1);
                if (axisTics != null && axisTics != this) {
                    Axis axis = axisTics.getAxis();
                    axis.zoomIn(rc.l - ioff, rc.r - ioff);
                }
            }
        } else {
            int ioff = vprc.y - lrc.y;
            this._axis.zoomIn(rc.t - ioff, rc.b - ioff);
            AxisTics axisTics = this._parent.getViewportAxisTics(this._viewport, 2);
            if (axisTics != null && axisTics != this) {
                Axis axis = axisTics.getAxis();
                axis.zoomIn(rc.t - ioff, rc.b - ioff);
            } else {
                axisTics = this._parent.getViewportAxisTics(this._viewport, 3);
                if (axisTics != null && axisTics != this) {
                    Axis axis = axisTics.getAxis();
                    axis.zoomIn(rc.t - ioff, rc.b - ioff);
                }
            }
        }
        this._parent.invalidate();
        this._parent.validate();
        this._parent.repaint();
    }

    @Override
    public void zoomByFactor(double factor) {
        Axis oppositeAxis = null;
        if (this._alignment == 3 || this._alignment == 2) {
            AxisTics axisTics = this._parent.getViewportAxisTics(this._viewport, 0);
            if (axisTics != null && axisTics != this) {
                oppositeAxis = axisTics.getAxis();
            } else {
                axisTics = this._parent.getViewportAxisTics(this._viewport, 1);
                if (axisTics != null && axisTics != this) {
                    Axis axis = axisTics.getAxis();
                }
            }
            if (oppositeAxis != null) {
                oppositeAxis.zoomByFactor(factor);
            }
            this._axis.zoomByFactor(factor);
        } else {
            Axis y1 = this._parent.getViewportAxis(this._viewport, 2);
            Axis y2 = this._parent.getViewportAxis(this._viewport, 3);
            y1.zoomByFactor(factor);
            if (y2 != null) {
                RatingFunction f = y2.getRatingFunction();
                if (f != null) {
                    y2.zoomIn(f.getBaseValue(y1.getActMin()), f.getBaseValue(y1.getActMax()));
                } else {
                    y2.zoomByFactor(factor);
                }
            }
        }
        this._parent.invalidate();
        this._parent.validate();
        this._parent.repaint();
    }

    public void setMajorTicsVisible(boolean state) {
        this._drawProp.drawMajorTics = state;
    }

    @Deprecated
    public void setDrawMajorTicsOn() {
        this.setMajorTicsVisible(true);
    }

    @Deprecated
    public void setDrawMajorTicsOff() {
        this.setMajorTicsVisible(false);
    }

    public boolean areMajorTicsVisible() {
        return this._drawProp.drawMajorTics;
    }

    @Deprecated
    public boolean areMajorTicsDrawn() {
        return this.areMajorTicsVisible();
    }

    public void setMajorTicLabelsVisible(boolean state) {
        this._drawProp.drawMajorTicLabels = state;
    }

    @Deprecated
    public void setDrawMajorTicLabelsOn() {
        this.setMajorTicLabelsVisible(true);
    }

    @Deprecated
    public void setDrawMajorTicLabelsOff() {
        this.setMajorTicLabelsVisible(false);
    }

    public boolean areMajorTicLabelsVisible() {
        return this._drawProp.drawMajorTicLabels;
    }

    @Deprecated
    public boolean areMajorTicLabelsDrawn() {
        return this.areMajorTicLabelsVisible();
    }

    public void setMinorTicsVisible(boolean state) {
        this._drawProp.drawMinorTics = state;
    }

    @Deprecated
    public void setDrawMinorTicsOn() {
        this.setMinorTicsVisible(true);
    }

    @Deprecated
    public void setDrawMinorTicsOff() {
        this.setMinorTicsVisible(false);
    }

    public boolean areMinorTicsVisible() {
        return this._drawProp.drawMinorTics;
    }

    @Deprecated
    public boolean areMinorTicsDrawn() {
        return this.areMinorTicsVisible();
    }

    public void setMinorTicLabelsVisible(boolean state) {
        this._drawProp.drawMinorTicLabels = state;
    }

    @Deprecated
    public void setDrawMinorTicLabelsOn() {
        this.setMinorTicLabelsVisible(true);
    }

    @Deprecated
    public void setDrawMinorTicLabelsOff() {
        this.setMinorTicLabelsVisible(false);
    }

    public boolean areMinorTicLabelsVisible() {
        return this._drawProp.drawMinorTicLabels;
    }

    @Deprecated
    public boolean areMinorTicLabelsDrawn() {
        return this.areMinorTicLabelsVisible();
    }

    public void setMajorTicLength(int ticLength) {
        this._drawProp.majorTicLength = ticLength;
    }

    public int getMajorTicLength() {
        return this._drawProp.majorTicLength;
    }

    public void setMinorTicLength(int ticLength) {
        this._drawProp.minorTicLength = ticLength;
    }

    public int getMinorTicLength() {
        return this._drawProp.minorTicLength;
    }

    public void setAxisTicColor(String colorString) {
        this._drawProp.axisTicColor = RmaColor.parseColorString(colorString);
    }

    public Color getAxisTicColor() {
        return this._drawProp.axisTicColor;
    }

    public String getAxisTicColorString() {
        return RmaColor.color2String(this._drawProp.axisTicColor);
    }

    protected WorldRect getMaxBounds() {
        Vector glyphs = this._viewport.getGlyphVector();
        WorldRect rect = null;
        if (glyphs == null || glyphs.size() == 0) {
            return rect;
        }
        Scale scale = null;
        for (int i = 0; i < glyphs.size(); ++i) {
            G2dGlyph glyph = (G2dGlyph)glyphs.get(i);
            if (glyph.getScale().getAxis(0) != this._axis && glyph.getScale().getAxis(1) != this._axis) continue;
            scale = glyph.getScale();
            if (rect == null) {
                rect = glyph.getBounds();
                continue;
            }
            WorldRect r = glyph.getBounds();
            if (r == null) continue;
            rect.grow(r);
        }
        double deltax = Math.abs(rect.e - rect.w);
        double deltay = Math.abs(rect.n - rect.s);
        if (deltay != 0.0) {
            rect.n += deltay * 0.01;
            if (!(this.getAxis() instanceof LogAxis)) {
                rect.s = rect.s >= 0.0 && rect.s - deltay * 0.01 < 0.0 ? 0.0 : (rect.s -= deltay * 0.01);
            }
        } else {
            rect.n += rect.n * 0.01;
            rect.s -= rect.s * 0.01;
        }
        if (!RMAConst.isValidValue(rect.w)) {
            rect.w = 0.0;
        }
        if (!RMAConst.isValidValue(rect.e)) {
            rect.e = 10.0;
        }
        if (!RMAConst.isValidValue(rect.s)) {
            rect.s = 0.0;
        }
        if (!RMAConst.isValidValue(rect.n)) {
            rect.n = 10.0;
        }
        int dataUnitSystem = this._axis.getDataUnitSystem();
        int displayUnitSystem = this._axis.getDisplayUnitSystem();
        int parameterId = this._axis.getParameterId();
        if (parameterId == -1 || !Units.isValidUnitsSystem(displayUnitSystem) || !Units.isValidUnitsSystem(dataUnitSystem) || dataUnitSystem == displayUnitSystem) {
            return rect;
        }
        String fromUnits = Parameter.getUnitsStringForSystem(parameterId, dataUnitSystem);
        String toUnits = Parameter.getUnitsStringForSystem(parameterId, displayUnitSystem);
        WorldRect rect2 = new WorldRect();
        try {
            rect2.e = Units.convertUnits(rect.e, fromUnits, toUnits);
            rect2.n = Units.convertUnits(rect.n, fromUnits, toUnits);
            rect2.s = Units.convertUnits(rect.s, fromUnits, toUnits);
            rect2.w = Units.convertUnits(rect.w, fromUnits, toUnits);
        }
        catch (Exception e) {
            System.out.println("Exception occurred when trying to compute bounds in AxisTics");
            System.out.println(e.getMessage());
            e.printStackTrace();
            return rect;
        }
        return rect2;
    }

    private class AxisValuesGreaterThenZero
    implements AxisSwapValidator {
        private AxisValuesGreaterThenZero() {
        }

        @Override
        public boolean isValid() {
            WorldRect bounds = null;
            for (Object object : AxisTics.this._viewport.getGlyphVector()) {
                WorldRect temp = ((G2dGlyph)object).getBounds();
                if (bounds == null) {
                    bounds = temp;
                    continue;
                }
                if (temp == null) continue;
                bounds.grow(temp);
            }
            double max = 0.0;
            double min = 0.0;
            if (AxisTics.this._alignment == 3 || AxisTics.this._alignment == 2) {
                max = bounds != null ? bounds.e : 0.0;
                min = bounds != null ? bounds.w : 0.0;
            } else {
                max = bounds != null ? bounds.n : 0.0;
                double d = min = bounds != null ? bounds.s : 0.0;
            }
            if (max <= 0.0 || min <= 0.0) {
                RMAIO.postWarning(AxisTics.this, "Unable to change the axis to a log scale because some of the data values are less than or equal to 0.");
                return false;
            }
            return true;
        }
    }

    public static interface AxisSwapValidator {
        public boolean isValid();
    }

    class PropertiesOKListener
    implements ActionListener {
        private ScalePropertiesPanel _scalePanel = null;
        private G2dAxisLabelPropertiesPanel _labelPanel = null;

        private PropertiesOKListener(ScalePropertiesPanel scalePanel, G2dAxisLabelPropertiesPanel labelPanel) {
            this._scalePanel = scalePanel;
            this._labelPanel = labelPanel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ScaleProperties prop = this._scalePanel.getData();
            double max = 0.0;
            double min = 0.0;
            double vmin = 0.0;
            double vmax = 0.0;
            Vector glyphs = AxisTics.this._viewport.getGlyphVector();
            HashMap<Scale, Scale> swappedScales = new HashMap<Scale, Scale>();
            for (int i = 0; glyphs != null && i < glyphs.size(); ++i) {
                G2dGlyph glyph = (G2dGlyph)glyphs.get(i);
                G2dObject data = glyph.getG2dObject();
                if (data == null || !data.canSwapXYValues()) continue;
                data.setSwapXYValues(prop.swapXYAxis());
            }
            if (prop.canSwapXYAxis() && prop.swapXYAxis()) {
                AxisTics.this._viewport.resetAllDataLimits(false);
            }
            max = prop.getMaxScaleValue();
            min = prop.getMinScaleValue();
            if (prop.isAutomaticMax() || prop.isAutomaticMin()) {
                WorldRect b = AxisTics.this.getMaxBounds();
                if (prop.isAutomaticMin() && b != null) {
                    double d = min = AxisTics.this._alignment == 1 || AxisTics.this._alignment == 0 ? b.s : b.w;
                }
                if (prop.isAutomaticMax() && b != null) {
                    max = AxisTics.this._alignment == 1 || AxisTics.this._alignment == 0 ? b.n : b.e;
                }
            }
            vmax = prop.isAutomaticViewMax() ? max : prop.getActualMaxScaleValue();
            vmin = prop.isAutomaticViewMin() ? min : prop.getActualMinScaleValue();
            prop.setMaxScaleValue(max);
            prop.setMinScaleValue(min);
            prop.setActualMaxScaleValue(vmax);
            prop.setActualMinScaleValue(vmin);
            AxisProp aprop = new AxisProp((AxisProp)prop);
            aprop.isReversed = AxisTics.this._alignment == 1 || AxisTics.this._alignment == 0 ? !prop.isReversed() : prop.isReversed();
            aprop.label = this._labelPanel.getLabelText();
            AxisTics.this._axis.setAxisProp(aprop);
            boolean swappedValues = false;
            for (int i = 0; glyphs != null && i < glyphs.size(); ++i) {
                Scale scl;
                G2dGlyph glyph = (G2dGlyph)glyphs.get(i);
                G2dObject data = glyph.getG2dObject();
                if (data == null || !data.canSwapXYValues() || swappedScales.get(scl = glyph.getScale()) != null) continue;
                swappedScales.put(scl, scl);
                Axis x1 = scl.getAxis(0);
                Axis y1 = scl.getAxis(1);
                if (data.swapXYValues()) {
                    if (x1 != AxisTics.this.getAxis() && y1 != AxisTics.this.getAxis()) continue;
                    swappedValues = true;
                    x1.pushLabel();
                    y1.pushLabel();
                    String tempLabel = x1.getLabel();
                    x1.setLabel(y1.getLabel());
                    y1.setLabel(tempLabel);
                    tempLabel = null;
                    ((AxisProp)prop).label = AxisTics.this.getAxis().getLabel();
                    continue;
                }
                x1.popLabel();
                y1.popLabel();
            }
            AxisTics.this._parent.invalidate();
            AxisTics.this._parent.doLayout();
            AxisTics.this._parent.paintGfx();
            AxisTics.this.repaint();
            if (AxisTics.this._alignment == 1 || AxisTics.this._alignment == 0) {
                prop.setReversed(!aprop.isReversed());
            }
            this._scalePanel.refresh();
        }
    }
}

