/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.geometry.CategoryAxis;
import hec.gfx2d.AxisTics;
import hec.gfx2d.AxisTicsDrawProp;
import hec.gfx2d.G2dComponent;
import hec.gfx2d.G2dFont;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dResolutionConst;
import hec.gfx2d.Viewport;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import javax.swing.JMenuItem;

public class CategoryAxisTics
extends AxisTics {
    private static final double ROTATE_LABEL_ANGLE = Math.toRadians(-60.0);

    public CategoryAxisTics(G2dPanel p, CategoryAxis ax, Viewport vp, int align) {
        super(p, ax, vp, align);
    }

    @Override
    protected void buildMenu(Container c2) {
        JMenuItem jm = new JMenuItem("Edit Properties");
        jm.addActionListener(new G2dComponent.EditPropertyListener(this));
        c2.add(jm);
    }

    @Override
    public Dimension getPreferredSizeLocal() {
        Dimension base = super.getPreferredSizeLocal();
        Dimension preferredSize = new Dimension(base);
        AxisTicsDrawProp drawProp = this.getProperties();
        if ((this.getAlignment() == 2 || this.getAlignment() == 3) && drawProp.drawMajorTics && drawProp.drawMajorTicLabels) {
            int g2dResolution = this._parent.getDeviceResoultion();
            double scl = g2dResolution / G2dResolutionConst.PRINTER_SCALE;
            CategoryAxis axis = (CategoryAxis)this.getAxis();
            int sz = (int)((double)drawProp.getMajorTicFontSize() * this._parent.getFontScl() + 0.5);
            if ((double)sz < (double)drawProp.getMajorTicMinFontSize() * scl) {
                sz = (int)((double)drawProp.getMajorTicMinFontSize() * scl);
            }
            if ((double)sz > (double)drawProp.getMajorTicMaxFontSize() * scl) {
                sz = (int)((double)drawProp.getMajorTicMaxFontSize() * scl);
            }
            String name = drawProp.getMajorTicFontFamily();
            String fname = name + "-PLAIN-" + Integer.toString(sz);
            Font font = G2dFont.newFont(fname, 0, sz);
            FontMetrics metrics = this.getFontMetrics(font);
            int space = 2;
            preferredSize.height = 0;
            preferredSize.height += (int)Math.ceil((double)(drawProp.majorTicLength + space * 2) * scl);
            double maxOff = 0.0;
            for (int streamOrder : axis.getCategoryStreams()) {
                String categoryLabelText = axis.getCategoryName(streamOrder);
                double textWidth = metrics.stringWidth(categoryLabelText);
                double yOff = Math.sin(-ROTATE_LABEL_ANGLE) * textWidth;
                maxOff = Math.max(maxOff, yOff);
            }
            preferredSize.height += (int)(Math.ceil(maxOff + (double)(space * 2)) * scl);
        }
        return preferredSize;
    }

    @Override
    public void paintGfx(Graphics g) {
        int style;
        String name;
        Font labelFont;
        if (this.getAxis() == null) {
            return;
        }
        if (Boolean.getBoolean("DEBUG_PLOT_BOUNDS")) {
            Color c2 = g.getColor();
            g.setColor(Color.blue);
            Dimension d = this.getSize();
            g.drawRect(0, 0, d.width - 1, d.height - 1);
            g.setColor(c2);
        }
        AxisTicsDrawProp drawProp = this.getProperties();
        int fontSize = (int)((double)this.getProperties().getMajorTicFontSize() * this._parent.getFontScl() + 0.5);
        int g2dResolution = this._parent.getDeviceResoultion();
        double scl = g2dResolution / G2dResolutionConst.PRINTER_SCALE;
        if ((double)fontSize < (double)drawProp.getMajorTicMinFontSize() * scl) {
            fontSize = (int)((double)drawProp.getMajorTicMinFontSize() * scl);
        }
        if ((double)fontSize > (double)drawProp.getMajorTicMaxFontSize() * scl) {
            fontSize = (int)((double)drawProp.getMajorTicMaxFontSize() * scl);
        }
        if ((labelFont = G2dFont.newFont(name = drawProp.getMajorTicFontFamily(), style = drawProp.getMajorTicFontStyle(), fontSize)) != null) {
            g.setFont(labelFont);
        }
        switch (this.getAlignment()) {
            case 0: {
                this.drawTicsLeft(g);
                break;
            }
            case 1: {
                this.drawTicsRight(g);
                break;
            }
            case 2: {
                this.drawTicsTop(g);
                break;
            }
            case 3: {
                this.drawTicsBottom(g);
                break;
            }
        }
    }

    @Override
    protected void drawTicsRight(Graphics g) {
        int iy;
        int localValue;
        Rectangle boundRect = this.getBounds();
        Viewport viewport = this.getViewport();
        Rectangle viewportRect = viewport.getBounds();
        FontMetrics metrics = g.getFontMetrics();
        AxisTicsDrawProp drawProp = this.getProperties();
        CategoryAxis axis = (CategoryAxis)this.getAxis();
        int space = 2;
        int insetOff = viewportRect.y - boundRect.y;
        int g2dResolution = this._parent.getDeviceResoultion();
        int TIC_LENGTH = drawProp.majorTicLength * (g2dResolution / G2dResolutionConst.PRINTER_SCALE);
        int TIC_SPACE_LENGTH = (drawProp.majorTicLength + space * 2) * (g2dResolution / G2dResolutionConst.PRINTER_SCALE);
        if (drawProp.drawMajorTics) {
            g.setColor(drawProp.axisTicColor);
            for (int streamOrder : axis.getCategoryStreams()) {
                localValue = axis.w2l((double)streamOrder + 0.5);
                iy = insetOff + localValue;
                g.drawLine(boundRect.width, iy, boundRect.width - TIC_LENGTH, iy);
            }
        }
        if (drawProp.drawMajorTics && drawProp.drawMajorTicLabels) {
            g.setColor(drawProp.axisTicColor);
            for (int streamOrder : axis.getCategoryStreams()) {
                localValue = axis.w2l((double)streamOrder + 0.5);
                iy = insetOff + localValue;
                int ix = boundRect.width;
                String categoryLabelText = axis.getCategoryName(streamOrder);
                Rectangle2D rc2d = metrics.getStringBounds(categoryLabelText, g);
                iy = (int)((double)iy - rc2d.getHeight() / 2.0);
                ix = (int)((double)ix - ((double)TIC_SPACE_LENGTH + rc2d.getWidth()));
                g.drawString(categoryLabelText, ix, iy);
            }
        }
    }

    @Override
    protected void drawTicsLeft(Graphics g) {
        int iy;
        int localValue;
        Rectangle boundRect = this.getBounds();
        Viewport viewport = this.getViewport();
        Rectangle viewportRect = viewport.getBounds();
        FontMetrics metrics = g.getFontMetrics();
        AxisTicsDrawProp drawProp = this.getProperties();
        CategoryAxis axis = (CategoryAxis)this.getAxis();
        int space = 2;
        int insetOff = viewportRect.y - boundRect.y;
        int g2dResolution = this._parent.getDeviceResoultion();
        int TIC_LENGTH = drawProp.majorTicLength * (g2dResolution / G2dResolutionConst.PRINTER_SCALE);
        int TIC_SPACE_LENGTH = (drawProp.majorTicLength + space * 2) * (g2dResolution / G2dResolutionConst.PRINTER_SCALE);
        if (drawProp.drawMajorTics) {
            g.setColor(drawProp.axisTicColor);
            for (int streamOrder : axis.getCategoryStreams()) {
                localValue = axis.w2l((double)streamOrder + 0.5);
                iy = insetOff + localValue;
                g.drawLine(0, iy, TIC_LENGTH, iy);
            }
        }
        if (drawProp.drawMajorTics && drawProp.drawMajorTicLabels) {
            g.setColor(drawProp.axisTicColor);
            for (int streamOrder : axis.getCategoryStreams()) {
                localValue = axis.w2l((double)streamOrder + 0.5);
                iy = insetOff + localValue;
                int ix = 0;
                String categoryLabelText = axis.getCategoryName(streamOrder);
                Rectangle2D rc2d = metrics.getStringBounds(categoryLabelText, g);
                iy = (int)((double)iy - rc2d.getHeight() / 2.0);
                ix = (int)((double)ix + ((double)TIC_SPACE_LENGTH + rc2d.getWidth()));
                g.drawString(categoryLabelText, ix, iy);
            }
        }
    }

    @Override
    protected void drawTicsTop(Graphics g) {
        int ix;
        int localValue;
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Dimension d = new Dimension(this.getSize());
        d.setSize(d.getWidth(), d.getHeight() * 2.0);
        this.setMinimumSize(d);
        this.setPreferredSize(d);
        Rectangle boundRect = this.getBounds();
        Viewport viewport = this.getViewport();
        Rectangle viewportRect = viewport.getBounds();
        FontMetrics metrics = g2d.getFontMetrics();
        AxisTicsDrawProp drawProp = this.getProperties();
        CategoryAxis axis = (CategoryAxis)this.getAxis();
        int space = 2;
        int insetOff = viewportRect.x - boundRect.x;
        int g2dResolution = this._parent.getDeviceResoultion();
        int TIC_LENGTH = drawProp.majorTicLength * (g2dResolution / G2dResolutionConst.PRINTER_SCALE);
        int TIC_SPACE_LENGTH = (drawProp.majorTicLength + space * 2) * (g2dResolution / G2dResolutionConst.PRINTER_SCALE);
        if (drawProp.drawMajorTics) {
            g2d.setColor(drawProp.axisTicColor);
            for (int streamOrder : axis.getCategoryStreams()) {
                localValue = axis.w2l((double)streamOrder + 0.5);
                ix = insetOff + localValue;
                if (ix <= insetOff || ix >= insetOff + viewportRect.width) continue;
                g2d.drawLine(ix, 0, ix, TIC_LENGTH);
            }
        }
        if (drawProp.drawMajorTics && drawProp.drawMajorTicLabels) {
            g2d.setColor(drawProp.axisTicColor);
            for (int streamOrder : axis.getCategoryStreams()) {
                localValue = axis.w2l((double)streamOrder + 0.5);
                ix = insetOff + localValue;
                int iy = TIC_SPACE_LENGTH;
                String categoryLabelText = axis.getCategoryName(streamOrder);
                Rectangle2D rc2d = metrics.getStringBounds(categoryLabelText, g2d);
                double yOff = Math.sin(-ROTATE_LABEL_ANGLE) * rc2d.getWidth();
                double xOff = Math.cos(-ROTATE_LABEL_ANGLE) * rc2d.getWidth() / 2.0;
                ix = (int)((double)ix - (xOff + (double)(space * 2)));
                iy = (int)((double)iy + (yOff + (double)(space * 2)));
                g2d.translate(ix, iy);
                g2d.rotate(ROTATE_LABEL_ANGLE);
                g2d.drawString(categoryLabelText, 0, 0);
                g2d.rotate(-ROTATE_LABEL_ANGLE);
                g2d.translate(-ix, -iy);
            }
        }
    }

    @Override
    protected void drawTicsBottom(Graphics g) {
        int ix;
        int localValue;
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Rectangle boundRect = this.getBounds();
        Viewport viewport = this.getViewport();
        Rectangle viewportRect = viewport.getBounds();
        FontMetrics metrics = g2d.getFontMetrics();
        AxisTicsDrawProp drawProp = this.getProperties();
        CategoryAxis axis = (CategoryAxis)this.getAxis();
        int space = 2;
        int insetOff = viewportRect.x - boundRect.x;
        int g2dResolution = this._parent.getDeviceResoultion();
        int TIC_LENGTH = drawProp.majorTicLength * (g2dResolution / G2dResolutionConst.PRINTER_SCALE);
        int TIC_SPACE_LENGTH = (drawProp.majorTicLength + space * 2) * (g2dResolution / G2dResolutionConst.PRINTER_SCALE);
        if (drawProp.drawMajorTics) {
            g2d.setColor(drawProp.axisTicColor);
            for (int streamOrder : axis.getCategoryStreams()) {
                localValue = axis.w2l((double)streamOrder + 0.5);
                ix = insetOff + localValue;
                g2d.drawLine(ix, boundRect.height, ix, boundRect.height - TIC_LENGTH);
            }
        }
        if (drawProp.drawMajorTics && drawProp.drawMajorTicLabels) {
            g2d.setColor(drawProp.axisTicColor);
            for (int streamOrder : axis.getCategoryStreams()) {
                localValue = axis.w2l((double)streamOrder + 0.5);
                ix = insetOff + localValue;
                int iy = boundRect.height + TIC_SPACE_LENGTH;
                String categoryLabelText = axis.getCategoryName(streamOrder);
                Rectangle2D rc2d = metrics.getStringBounds(categoryLabelText, g2d);
                iy = (int)((double)iy - rc2d.getHeight() / 2.0);
                g2d.translate(ix, iy);
                g2d.rotate(ROTATE_LABEL_ANGLE);
                g2d.drawString(categoryLabelText, 0, 0);
                g2d.rotate(-ROTATE_LABEL_ANGLE);
                g2d.translate(-ix, -iy);
            }
        }
    }
}

