/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.gfx2d.PlotIconBase;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Line2D;

public class ColorBarIcon
extends PlotIconBase {
    Color[] _colors = null;
    int[] _intColorValues = null;
    int[] _intValues = null;
    double[] _doubColorValues = null;
    double[] _doubValues = null;
    int[] _times = null;
    Line2D[] _line2D = null;
    int[] _lineColors = null;
    double _totalHeight = 1.0;
    boolean _forceRecompute = false;

    public void setData(int[] times, int[] values) {
        this._intValues = values;
        this._times = times;
        this._doubValues = null;
        this._line2D = null;
        this._size = 0;
    }

    public void setData(int[] times, double[] values) {
        this._doubValues = this._cumulativeInterval == -1 ? values : this.accumulate(times, values);
        this._times = times;
        this._intValues = null;
        this._line2D = null;
        this._size = 0;
    }

    @Override
    public void clearData() {
        this._doubValues = null;
        this._intValues = null;
        this._times = null;
        this._line2D = null;
    }

    public void setColorValues(int[] colorValues, Color[] colors) {
        if (colorValues.length != colors.length) {
            return;
        }
        this._intColorValues = colorValues;
        this._colors = colors;
        this._size = 0;
    }

    public void setColorValues(double[] colorValues, Color[] colors) {
        if (colorValues.length != colors.length) {
            return;
        }
        this._doubColorValues = colorValues;
        this._colors = colors;
    }

    protected int determineColorPosition(int loc) {
        int position = 0;
        if (this._doubValues != null) {
            if (loc >= this._doubValues.length) {
                return -1;
            }
            int i = 0;
            while (i < this._doubColorValues.length && this._doubValues[loc] > this._doubColorValues[i]) {
                position = i++;
            }
            return position;
        }
        if (this._intValues != null) {
            if (loc >= this._intValues.length) {
                return -1;
            }
            for (int i = 0; i < this._intColorValues.length; ++i) {
                if (this._intColorValues[i] != this._intValues[loc]) continue;
                return i;
            }
        }
        return position;
    }

    protected int arrayLength() {
        if (this._doubValues != null) {
            return this._doubValues.length;
        }
        if (this._intValues != null) {
            return this._intValues.length;
        }
        return 0;
    }

    public void recompute() {
        this._forceRecompute = true;
    }

    @Override
    public void paintIcon(Component c2, Graphics g, int x, int y) {
        Graphics2D g2 = (Graphics2D)g;
        if (this._colors == null) {
            g2.setBackground(this._noDataColor);
            if (this._dimension.height > 0) {
                g2.clearRect(x, y, this._dimension.width, this._dimension.height);
            }
            return;
        }
        Dimension dim = this._fixedDimension != null ? this._fixedDimension : c2.size();
        if (this._size == 0 || dim.height != this._dimension.height || dim.width != this._dimension.width || x != this._xLoc || y != this._yLoc || this._forceRecompute) {
            this._forceRecompute = false;
            this._dimension = dim;
            this._xLoc = x;
            this._yLoc = y;
            if (this._times != null) {
                this.computeLine();
            }
        }
        Stroke originalStroke = g2.getStroke();
        if (this._line2D != null) {
            g2.setBackground(this._backgroundColor);
            if (this._dimension.height > 0) {
                g2.clearRect(x, y, this._dimension.width, this._dimension.height);
            }
            this.paintColorBar(g2);
        } else {
            g2.setBackground(this._noDataColor);
            if (this._dimension.height > 0) {
                g2.clearRect(x, y, this._dimension.width, this._dimension.height);
            }
        }
        g2.setStroke(originalStroke);
    }

    protected void paintColorBar(Graphics2D g2) {
        BasicStroke s = new BasicStroke((float)this._totalHeight, 0, 2);
        g2.setStroke(s);
        int size = this._size;
        if (size > this._lineColors.length) {
            size = this._lineColors.length;
        }
        if (size > this._line2D.length) {
            size = this._line2D.length;
        }
        for (int i = 0; i < this._size; ++i) {
            int icolor = this._lineColors[i];
            if (icolor < this._colors.length) {
                g2.setColor(this._colors[icolor]);
            }
            g2.draw(this._line2D[i]);
        }
    }

    protected void computeLine() {
        int i;
        int previousColor;
        if (this.arrayLength() == 0 || this._times.length == 0) {
            return;
        }
        int startTime = this._times.length > 1 ? this._times[0] - (this._times[this._times.length - 1] - this._times[0]) / (this._times.length - 1) : (this._minXSet != -3.4028234663852886E38 ? (int)this._minXSet : this._times[0]);
        double minX = startTime;
        double maxX = this._times[this._times.length - 1];
        if (this._minXSet != -3.4028234663852886E38 && this._minXSet < minX) {
            minX = this._minXSet;
        }
        if (this._maxXSet != -3.4028234663852886E38 && this._maxXSet > maxX) {
            maxX = this._maxXSet;
        }
        double diffX = maxX - minX;
        double totalWidth = this._dimension.width;
        this._totalHeight = this._dimension.height;
        double yPosition = (double)this._yLoc + (double)this._dimension.height / 2.0;
        Line2D[] tempLine2D = new Line2D[this.arrayLength() + 1];
        int[] tempColor = new int[this.arrayLength() + 1];
        double startPosition = ((double)startTime - minX) / diffX * totalWidth + (double)this._xLoc;
        double endPosition = totalWidth + (double)this._xLoc;
        int currentColor = previousColor = this.determineColorPosition(0);
        this._size = 0;
        for (i = 0; i < this.arrayLength(); ++i) {
            if (i < this._times.length - 1) {
                currentColor = this.determineColorPosition(i + 1);
            }
            if (currentColor == previousColor && i != this._times.length - 1) continue;
            endPosition = ((double)this._times[i] - minX) / diffX * totalWidth + (double)this._xLoc;
            tempLine2D[this._size] = new Line2D.Double(startPosition, yPosition, endPosition, yPosition);
            tempColor[this._size] = previousColor;
            ++this._size;
            startPosition = endPosition;
            previousColor = currentColor;
        }
        if (this._size > 1) {
            int i2;
            int max = tempColor[0];
            for (i2 = 0; i2 < this._size; ++i2) {
                if (tempColor[i2] <= max) continue;
                max = tempColor[i2];
            }
            for (i2 = 0; i2 < this._size; ++i2) {
                double prevx1;
                double x1;
                double x2;
                double diff;
                if (tempColor[i2] != max || !((diff = tempLine2D[i2].getX2() - tempLine2D[i2].getX1()) < 2.0)) continue;
                double aver = (tempLine2D[i2].getX2() + tempLine2D[i2].getX1()) / 2.0;
                if (i2 == 0) {
                    double nextx2;
                    x2 = tempLine2D[i2].getX2() + 2.0;
                    if (x2 > (nextx2 = tempLine2D[i2 + 1].getX2())) {
                        tempColor[i2 + 1] = max;
                        continue;
                    }
                    tempLine2D[i2] = ColorBarIcon.modLine2D(tempLine2D[i2], x2, 1);
                    tempLine2D[i2 + 1] = ColorBarIcon.modLine2D(tempLine2D[i2 + 1], x2, 0);
                    continue;
                }
                if (i2 == this._size - 1) {
                    x1 = tempLine2D[i2].getX1() - 2.0;
                    if (x1 < (prevx1 = tempLine2D[i2 - 1].getX1())) {
                        tempColor[i2 - 1] = max;
                        continue;
                    }
                    tempLine2D[i2] = ColorBarIcon.modLine2D(tempLine2D[i2], x1, 0);
                    tempLine2D[i2 - 1] = ColorBarIcon.modLine2D(tempLine2D[i2 - 1], x1, 1);
                    continue;
                }
                x1 = aver - 1.0;
                x2 = aver + 1.0;
                prevx1 = tempLine2D[i2 - 1].getX1();
                if (x1 < prevx1) {
                    tempColor[i2 - 1] = max;
                } else {
                    tempLine2D[i2] = ColorBarIcon.modLine2D(tempLine2D[i2], x1, 0);
                    tempLine2D[i2 - 1] = ColorBarIcon.modLine2D(tempLine2D[i2 - 1], x1, 1);
                }
                double nextx2 = tempLine2D[i2 + 1].getX2();
                if (x2 > nextx2) {
                    tempColor[i2 + 1] = max;
                    continue;
                }
                tempLine2D[i2] = ColorBarIcon.modLine2D(tempLine2D[i2], x2, 1);
                tempLine2D[i2 + 1] = ColorBarIcon.modLine2D(tempLine2D[i2 + 1], x2, 0);
            }
        }
        this._line2D = new Line2D[this._size];
        this._lineColors = new int[this._size];
        for (i = 0; i < this._size; ++i) {
            this._line2D[i] = tempLine2D[i];
            this._lineColors[i] = tempColor[i];
        }
        tempLine2D = null;
        tempColor = null;
    }

    public static Line2D modLine2D(Line2D oldLine2D, double point, int pointLocation) {
        double x1 = oldLine2D.getX1();
        double x2 = oldLine2D.getX2();
        double y1 = oldLine2D.getY1();
        double y2 = oldLine2D.getY2();
        if (pointLocation == 0) {
            x1 = point;
        } else if (pointLocation == 1) {
            x2 = point;
        } else if (pointLocation == 2) {
            y1 = point;
        } else if (pointLocation == 3) {
            y2 = point;
        }
        return new Line2D.Double(x1, y1, x2, y2);
    }
}

