/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.gfx2d.ColorSquare;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import javax.swing.JToolTip;

public class ColorChooser {
    ColorSquare[] _colorSquares;
    Color[] _color = new Color[this._numColors];
    int _numColors = 42;
    int _highLighted = -1;

    ColorChooser() {
        this.setColors();
        this._colorSquares = new ColorSquare[this._numColors];
        for (int i = 0; i < this._numColors; ++i) {
            this._colorSquares[i] = new ColorSquare(this._color[i]);
        }
        this.setPositions();
    }

    public void setColors() {
        this._color[0] = new Color(0, 0, 10);
        this._color[1] = new Color(128, 128, 128);
        this._color[2] = new Color(192, 192, 192);
        this._color[3] = new Color(255, 255, 255);
        this._color[4] = new Color(255, 224, 192);
        this._color[5] = new Color(224, 176, 144);
        this._color[6] = new Color(176, 112, 80);
        this._color[7] = new Color(0, 0, 80);
        this._color[8] = new Color(0, 0, 128);
        this._color[9] = new Color(0, 0, 255);
        this._color[10] = new Color(176, 176, 255);
        this._color[11] = new Color(200, 144, 255);
        this._color[12] = new Color(160, 64, 255);
        this._color[13] = new Color(96, 0, 192);
        this._color[14] = new Color(0, 90, 80);
        this._color[15] = new Color(0, 128, 128);
        this._color[16] = new Color(0, 128, 255);
        this._color[17] = new Color(160, 208, 255);
        this._color[18] = new Color(176, 255, 255);
        this._color[19] = new Color(112, 255, 255);
        this._color[20] = new Color(0, 255, 255);
        this._color[21] = new Color(0, 80, 0);
        this._color[22] = new Color(0, 128, 0);
        this._color[23] = new Color(0, 255, 0);
        this._color[24] = new Color(176, 255, 176);
        this._color[25] = new Color(255, 255, 144);
        this._color[26] = new Color(255, 255, 0);
        this._color[27] = new Color(255, 204, 0);
        this._color[28] = new Color(80, 0, 0);
        this._color[29] = new Color(128, 0, 0);
        this._color[30] = new Color(255, 0, 0);
        this._color[31] = new Color(255, 176, 176);
        this._color[32] = new Color(255, 184, 112);
        this._color[33] = new Color(255, 128, 0);
        this._color[34] = new Color(255, 96, 0);
        this._color[35] = new Color(80, 0, 80);
        this._color[36] = new Color(128, 0, 126);
        this._color[37] = new Color(255, 0, 255);
        this._color[38] = new Color(255, 176, 255);
        this._color[39] = new Color(255, 160, 208);
        this._color[40] = new Color(255, 128, 192);
        this._color[41] = new Color(255, 0, 128);
    }

    public void setPositions() {
        int count = 0;
        Point p = new Point(15, 30);
        for (int i = 0; i < this._numColors; ++i) {
            this._colorSquares[i].setPosition(p);
            p.x += 23;
            if (++count % 7 != 0) continue;
            p.x = 15;
            p.y += 23;
        }
    }

    public void paint(Graphics g) {
        this.draw(g);
    }

    public void draw(Graphics g) {
        for (int i = 0; i < this._numColors; ++i) {
            this._colorSquares[i].draw(g);
        }
    }

    public Color getColor(Point p, Graphics g) {
        boolean found = false;
        for (int i = 0; i < this._numColors; ++i) {
            found = this._colorSquares[i].withInBounds(p);
            if (!found) continue;
            this._colorSquares[i].pressed(g);
            return this._colorSquares[i].getColor();
        }
        return null;
    }

    public void highLight(Point p, Graphics g) {
        if (this._highLighted != -1) {
            this._colorSquares[this._highLighted].unHighLight(g);
            this._highLighted = -1;
        }
        boolean found = false;
        for (int i = 0; i < this._numColors; ++i) {
            found = this._colorSquares[i].withInBounds(p);
            if (!found) continue;
            this._highLighted = i;
            this._colorSquares[i].drawHighLight(g);
            JToolTip tool = new JToolTip();
            tool.setTipText("Fuck YOu");
        }
    }
}

