/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;

public class ColorSquare {
    Color _color;
    int _size = 15;
    Point _position = new Point(0, 0);

    public ColorSquare(Color color) {
        this._color = color;
        this._position = new Point(0, 0);
    }

    public ColorSquare(Color color, Point point, int size) {
        this._color = color;
        this._position = new Point(point);
        this._size = size;
    }

    public ColorSquare() {
    }

    public void setPosition(Point point) {
        this._position.x = point.x;
        this._position.y = point.y;
    }

    public void setColor(Color color) {
        this._color = color;
    }

    public void setSize(int size) {
        this._size = size;
    }

    public int getSize() {
        return this._size;
    }

    public Color getColor() {
        return this._color;
    }

    public Point getPosition() {
        return this._position;
    }

    public void paint(Graphics g) {
        this.draw(g);
    }

    public void draw(Graphics g) {
        g.setColor(this._color);
        for (int i = 0; i < this._size; ++i) {
            g.drawLine(this._position.x, this._position.y + i, this._position.x + this._size, this._position.y + i);
        }
    }

    public void drawHighLight(Graphics g) {
        g.setColor(Color.white);
        g.drawLine(this._position.x - 3, this._position.y - 3, this._position.x + this._size, this._position.y - 3);
        g.drawLine(this._position.x - 3, this._position.y - 3, this._position.x - 3, this._position.y + this._size);
        g.setColor(Color.lightGray);
        g.drawLine(this._position.x - 2, this._position.y - 2, this._position.x + this._size, this._position.y - 2);
        g.drawLine(this._position.x - 2, this._position.y - 2, this._position.x - 2, this._position.y + this._size);
        g.drawLine(this._position.x - 1, this._position.y - 1, this._position.x + this._size, this._position.y - 1);
        g.drawLine(this._position.x - 1, this._position.y - 1, this._position.x - 1, this._position.y + this._size);
        g.setColor(Color.darkGray);
        g.drawLine(this._position.x + this._size + 3, this._position.y - 3, this._position.x + this._size + 3, this._position.y + this._size + 3);
        g.drawLine(this._position.x - 3, this._position.y + this._size + 3, this._position.x + this._size + 3, this._position.y + this._size + 3);
    }

    public void pressed(Graphics g) {
        g.setColor(Color.darkGray);
        g.drawLine(this._position.x - 3, this._position.y - 3, this._position.x + this._size, this._position.y - 3);
        g.drawLine(this._position.x - 3, this._position.y - 3, this._position.x - 3, this._position.y + this._size);
        g.setColor(Color.lightGray);
        g.drawLine(this._position.x - 2, this._position.y - 2, this._position.x + this._size, this._position.y - 2);
        g.drawLine(this._position.x - 2, this._position.y - 2, this._position.x - 2, this._position.y + this._size);
        g.drawLine(this._position.x - 1, this._position.y - 1, this._position.x + this._size, this._position.y - 1);
        g.drawLine(this._position.x - 1, this._position.y - 1, this._position.x - 1, this._position.y + this._size);
        g.setColor(Color.white);
        g.drawLine(this._position.x + this._size + 3, this._position.y - 3, this._position.x + this._size + 3, this._position.y + this._size + 3);
        g.drawLine(this._position.x - 3, this._position.y + this._size + 3, this._position.x + this._size + 3, this._position.y + this._size + 3);
    }

    public void unHighLight(Graphics g) {
        g.setColor(Color.lightGray);
        g.drawLine(this._position.x - 3, this._position.y - 3, this._position.x + this._size, this._position.y - 3);
        g.drawLine(this._position.x - 3, this._position.y - 3, this._position.x - 3, this._position.y + this._size);
        g.drawLine(this._position.x - 2, this._position.y - 2, this._position.x + this._size, this._position.y - 2);
        g.drawLine(this._position.x - 2, this._position.y - 2, this._position.x - 2, this._position.y + this._size);
        g.drawLine(this._position.x - 1, this._position.y - 1, this._position.x + this._size, this._position.y - 1);
        g.drawLine(this._position.x - 1, this._position.y - 1, this._position.x - 1, this._position.y + this._size);
        g.drawLine(this._position.x + this._size + 3, this._position.y - 3, this._position.x + this._size + 3, this._position.y + this._size + 3);
        g.drawLine(this._position.x - 3, this._position.y + this._size + 3, this._position.x + this._size + 3, this._position.y + this._size + 3);
    }

    public boolean withInBounds(Point p) {
        return p.x >= this._position.x && p.y >= this._position.y && p.x <= this._position.x + this._size && p.y <= this._position.y + this._size;
    }
}

