/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.geometry.WorldPt;
import hec.geometry.WorldRect;
import hec.gfx2d.ComplexSeasonalDataGlyph;
import hec.gfx2d.G2dData;
import hec.gfx2d.G2dGlyphFactory;
import hec.gfx2d.G2dObject;
import hec.gfx2d.SimpleSeasonalData;
import java.util.Hashtable;
import java.util.Vector;
import rma.util.RMAConst;
import rma.util.RMAIO;
import rma.util.RMASort;

public class ComplexSeasonalData
extends G2dData
implements G2dObject {
    public int[] _tdata;
    public double[] _ydata;
    public int[] _tdataOrg;
    public double[] _ydataOrg;
    public String _xtype;
    public String _ytype;
    protected Vector _srVector;
    protected String _interpolationType = "linear";
    protected int _nyears = 1;
    boolean _loaded = false;

    public ComplexSeasonalData() {
        this.name = "Seasonal Data";
        this.xunits = "Minutes";
        this.yunits = "yunits";
        this._tdata = new int[100];
        this._ydata = new double[100];
        for (int i = 0; i < 100; ++i) {
            this._tdata[i] = i;
            this._ydata[i] = 5.0 * Math.sin(Math.PI * (double)i / 20.0);
        }
        this._srVector = new Vector();
    }

    public void setData(Vector seasonalData) {
        if (seasonalData == null) {
            return;
        }
        this._srVector = seasonalData;
    }

    public void addData(SimpleSeasonalData ssd) {
        if (ssd == null) {
            return;
        }
        this._srVector.addElement(ssd);
    }

    public boolean calcPlotArrays() {
        int i;
        boolean maxSize = false;
        if (this._srVector.size() == 0) {
            return true;
        }
        for (i = 0; i < this._srVector.size(); ++i) {
            if (((SimpleSeasonalData)this._srVector.elementAt(i)).calcPlotArrays()) continue;
        }
        Hashtable<Integer, Integer> dTable = new Hashtable<Integer, Integer>();
        for (i = 0; i < this._srVector.size(); ++i) {
            SimpleSeasonalData ssd = (SimpleSeasonalData)this._srVector.elementAt(i);
            if (!ssd.calculationsSuccessful()) continue;
            for (int j = 0; j < ssd.tdata.length; ++j) {
                dTable.put(new Integer(ssd.tdata[j]), new Integer(ssd.tdata[j]));
            }
        }
        Vector dateList = new Vector();
        RMAIO.copyHashToVector(dTable, dateList);
        RMASort.quickSort(dateList);
        int[] tarray = new int[dateList.size()];
        double[] darray = new double[dateList.size()];
        for (i = 0; i < tarray.length; ++i) {
            tarray[i] = (Integer)dateList.elementAt(i);
        }
        int endtime = this._nyears * 365 * 1440;
        boolean t0 = false;
        if (this._interpolationType.equalsIgnoreCase("linear")) {
            for (i = 0; i < tarray.length; ++i) {
                for (int j = 0; j < this._srVector.size(); ++j) {
                    SimpleSeasonalData ssd = (SimpleSeasonalData)this._srVector.elementAt(j);
                    if (!ssd.calculationsSuccessful()) continue;
                    int n = i;
                    darray[n] = darray[n] + ssd.interpolateValue(tarray[i]);
                }
            }
        }
        this._tdataOrg = this._tdata;
        this._ydataOrg = this._ydata;
        this._tdata = tarray;
        this._ydata = darray;
        return true;
    }

    public void setInterpolationType(String interpType) {
        if (interpType.equalsIgnoreCase("linear") || interpType.equalsIgnoreCase("step") || interpType.equalsIgnoreCase("cubic")) {
            this._interpolationType = interpType;
        }
    }

    @Override
    public WorldRect getBounds() {
        if (this._tdata == null || this._tdata.length == 0 || this._ydata == null || this._ydata.length == 0) {
            return new WorldRect(0.0, 0.0, 0.0, 0.0);
        }
        if (this.bounds == null) {
            this.bounds = new WorldRect(this._tdata[0], this._ydata[0], this._tdata[0], this._ydata[0]);
            for (int i = 1; i < this._tdata.length; ++i) {
                if (RMAConst.isValidValue(this._tdata[i])) {
                    if (this.bounds.w > (double)this._tdata[i]) {
                        this.bounds.w = this._tdata[i];
                    } else if (this.bounds.e < (double)this._tdata[i]) {
                        this.bounds.e = this._tdata[i];
                    }
                }
                if (!RMAConst.isValidValue(this._ydata[i])) continue;
                if (this.bounds.s > this._ydata[i]) {
                    this.bounds.s = this._ydata[i];
                    continue;
                }
                if (!(this.bounds.n < this._ydata[i])) continue;
                this.bounds.n = this._ydata[i];
            }
        }
        int nyears = (int)(this.bounds.w / 525600.0);
        this.bounds.w = 525600 * nyears;
        nyears = (int)(this.bounds.e / 525600.0);
        if (this.bounds.e % 525600.0 > 0.0) {
            ++nyears;
        }
        this.bounds.e = 525600 * nyears;
        return this.bounds;
    }

    @Override
    public String getXAxisName() {
        return "Minutes";
    }

    @Override
    public String getYAxisName() {
        return this.yunits;
    }

    public void setYAxisName(String name) {
        if (name != null) {
            this.yunits = name;
        }
    }

    @Override
    public int getXAxisType() {
        return 2;
    }

    @Override
    public int getYAxisType() {
        return 0;
    }

    @Override
    public void load() {
    }

    @Override
    public void unload() {
    }

    public WorldPt getNearestDataPt(WorldPt pt) {
        if (this._tdata == null || this._tdata.length == 0) {
            return null;
        }
        double y2 = -1.0;
        double y1 = -1.0;
        double x2 = -1.0;
        double x1 = -1.0;
        double dist = Double.POSITIVE_INFINITY;
        WorldPt closestPt = null;
        for (int z = 0; z < this._tdata.length; ++z) {
            if (closestPt == null) {
                closestPt = new WorldPt(this._tdata[0], this._ydata[0]);
            }
            x1 = this._tdata[z];
            y1 = this._ydata[z];
            double dx = pt.e - x1;
            double dy = pt.n - y1;
            if (dx == 0.0 && dy == 0.0) {
                return pt;
            }
            double tmp = Math.sqrt(dx * dx + dy * dy);
            if (!(tmp < dist)) continue;
            dist = tmp;
            closestPt.init(x1, y1);
        }
        return closestPt;
    }

    static {
        G2dGlyphFactory.addMapping(ComplexSeasonalData.class, ComplexSeasonalDataGlyph.class);
    }
}

