/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.data.DataSetException;
import hec.data.Units;
import hec.geometry.LocalPt;
import hec.geometry.Scale;
import hec.geometry.WorldPt;
import hec.gfx2d.ComplexSeasonalData;
import hec.gfx2d.G2dGlyph;
import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.Viewport;
import hec.heclib.util.HecTime;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class ComplexSeasonalDataGlyph
extends G2dGlyph {
    ComplexSeasonalData _obj;

    public ComplexSeasonalDataGlyph(Viewport view, ComplexSeasonalData map, Scale scl) {
        super(view, map, scl);
        this._obj = map;
        G2dLineProperties prop = this._line.getProperties();
        prop._drawPoints = true;
        prop._symbolSize = 3.0f;
        this._line.setProperties(prop);
    }

    @Override
    public void draw(Graphics g) {
        int i;
        this._obj.calcPlotArrays();
        int xmin = Math.min(this._scale.getAxis(0).w2l(this._scale.getAxis(0).getActMin()), this._scale.getAxis(0).w2l(this._scale.getAxis(0).getActMax()));
        int ymax = Math.max(this._scale.getAxis(1).w2l(this._scale.getAxis(1).getActMax()), this._scale.getAxis(1).w2l(this._scale.getAxis(1).getActMin()));
        int xmax = Math.max(this._scale.getAxis(0).w2l(this._scale.getAxis(0).getActMin()), this._scale.getAxis(0).w2l(this._scale.getAxis(0).getActMax()));
        int ymin = Math.min(this._scale.getAxis(1).w2l(this._scale.getAxis(1).getActMax()), this._scale.getAxis(1).w2l(this._scale.getAxis(1).getActMin()));
        Rectangle rect = new Rectangle(xmin, ymin, xmax - xmin, ymax - ymin);
        int ilen = this._obj._tdata.length;
        double[] xarray = new double[10000];
        double[] yarray = new double[10000];
        for (int ioff = 0; ioff < ilen; ioff += i) {
            int imax;
            if (ioff > 0) {
                --ioff;
            }
            if ((imax = 10000) > ilen - ioff) {
                imax = ilen - ioff;
            }
            for (i = 0; i < imax; ++i) {
                double dx = this._obj._tdata[i + ioff];
                double dy = this._obj._ydata[i + ioff];
                if (!RMAConst.isValidValue(dx) || !RMAConst.isValidValue(dy)) {
                    ++i;
                    break;
                }
                xarray[i] = dx;
                yarray[i] = dy;
            }
            this._line.setLineData(xarray, yarray, imax);
            this._line.drawLine(g, rect);
        }
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        LocalPt rpt;
        if (e == null) {
            return null;
        }
        LocalPt pt = new LocalPt(e.getX(), e.getY());
        if (this._line.contains(pt) && (rpt = this._line.getNearestDataPt(pt)) != null) {
            double xval = this._scale.getAxis(0).l2w(rpt.x);
            double yval = this._scale.getAxis(1).l2w(rpt.y);
            WorldPt wp = new WorldPt(xval, yval);
            if ((wp = this._obj.getNearestDataPt(wp)) == null) {
                return null;
            }
            HecTime hTime = new HecTime();
            hTime.setMinutes(wp.e);
            Object date = hTime.date(4);
            date = ((String)date).substring(0, ((String)date).length() - 4) + " " + hTime.time();
            try {
                double yVal = Units.convertUnits(wp.n, this._obj.getXParameterId(), this._obj.getUnitSystem(), this._scale.getDisplayUnitSystem());
                return new String("[" + (String)date + " ," + RMAIO.setPrecision2(yVal, 2) + "]");
            }
            catch (DataSetException exp) {
                return new String("[" + (String)date + " ," + RMAIO.setPrecision2(wp.n, 2) + "]");
            }
        }
        return null;
    }
}

