/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.data.DataSetIllegalArgumentException;
import hec.data.Parameter;
import hec.gfx2d.DataTypeProperties;
import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.LineProperties;
import hec.gfx2d.PlotProperties;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.util.List;
import java.util.Vector;

public class DataType {
    public static final int SYSTEM_FILE_LOCATION = 0;
    public static final int USER_FILE_LOCATION = 1;
    public static final String UNDEFINED = "UNDEFINED";
    private static final Vector<LineProperties> UNDEFINED_LINES = new Vector(7);
    private Vector<PlotProperties> _lineProps = new Vector();
    private int _parameterId = -1;
    private DataTypeProperties _properties = this.createProperties();
    private int _fileLocation;
    private boolean _modified;

    public DataType() {
    }

    protected DataTypeProperties createProperties() {
        return new DataTypeProperties();
    }

    public DataType(String name) {
        this();
        this.setName(name);
    }

    public void addG2dLineProperties(G2dLineProperties props) {
        if (props == null) {
            return;
        }
        this.addPlotProperties(props);
    }

    protected void addPlotProperties(PlotProperties props) {
        this._lineProps.add(props);
    }

    public List<PlotProperties> getPlotProperties() {
        return this._lineProps;
    }

    public void setName(String name) {
        if (UNDEFINED.equals(this.getName())) {
            return;
        }
        this._properties.setName(name);
    }

    public String getName() {
        return this._properties.getName();
    }

    public void setParameter(String param) {
        if (UNDEFINED.equals(this.getName())) {
            return;
        }
        this._properties.setParameter(param);
        Parameter parameter = new Parameter();
        if (this.getParameter() != null) {
            if (Parameter.isValid(this.getParameter())) {
                try {
                    parameter.setParameter(this.getParameter());
                    this._parameterId = parameter.getParameterId();
                    return;
                }
                catch (DataSetIllegalArgumentException dataSetIllegalArgumentException) {
                    // empty catch block
                }
            }
        }
        this._parameterId = -1;
    }

    public Vector<LineProperties> getG2dLinesList() {
        Vector<LineProperties> lineProps = new Vector<LineProperties>();
        for (int i = 0; i < this._lineProps.size(); ++i) {
            if (!(this._lineProps.get(i) instanceof LineProperties)) continue;
            lineProps.add((LineProperties)((Object)this._lineProps.get(i)));
        }
        if (lineProps.size() == 0) {
            return UNDEFINED_LINES;
        }
        return lineProps;
    }

    public String getYAxisName() {
        return this.getYAxisName(null);
    }

    public String getYAxisName(String units) {
        StringBuffer buffer = new StringBuffer();
        String param = this.getParameter();
        buffer.append(this.getParameter());
        String dssType = this.getDSSType();
        if (dssType != null) {
            dssType = dssType.toUpperCase();
        }
        if (!("INST-VAL".equalsIgnoreCase(dssType) || "ALL".equalsIgnoreCase(dssType) || "".equals(dssType))) {
            buffer.append(" ");
            buffer.append(this.getDSSType());
        }
        if (units != null) {
            buffer.append(" (");
            buffer.append(units.trim());
            buffer.append(")");
        } else if (this._parameterId != -1) {
            buffer.append(" (%S)");
        }
        return buffer.toString();
    }

    public void setYAxisReversed(boolean reversed) {
        if (UNDEFINED.equals(this.getName())) {
            return;
        }
        this._properties.setYAxisReversed(reversed);
    }

    public boolean isYAxisReversed() {
        return this._properties.isYAxisReversed();
    }

    public int getParameterId() {
        return this._parameterId;
    }

    public String getParameter() {
        return this._properties.getParameter();
    }

    public void writeProperties(BufferedWriter writer, String endTag) {
    }

    public void readProperties(BufferedReader in, String endTag) {
    }

    public String getDSSType() {
        return this._properties.getDssType();
    }

    public void setDSSType(String type) {
        this._properties.setDssType(type);
    }

    public String toString() {
        return this.getName();
    }

    public boolean hasDefaultMaxAxisValue() {
        return this._properties.hasDefaultMaxAxisValue();
    }

    public boolean hasDefaultMinAxisValue() {
        return this._properties.hasDefaultMinAxisValue();
    }

    public double getDefaultMinAxisValue() {
        return this._properties.getDefaultMinAxisValue();
    }

    public double getDefaultMaxAxisValue() {
        return this._properties.getDefaultMaxAxisValue();
    }

    public void setDefaultMaxAxisValue(double value) {
        this._properties.setDefaultMaxAxisValue(value);
    }

    public void setDefaultMinAxisValue(double value) {
        this._properties.setDefaultMinAxisValue(value);
    }

    public void setHasDefaultMaxAxisValue(boolean useDefault) {
        this._properties.setHasDefaultMaxAxisValue(useDefault);
    }

    public void setHasDefaultMinAxisValue(boolean useDefault) {
        this._properties.setHasDefaultMinAxisValue(useDefault);
    }

    public DataTypeProperties getProperties() {
        return this._properties;
    }

    public boolean hasViewportWeight() {
        return this._properties.hasViewportWeight();
    }

    public void setHasViewportWeight(boolean hasWeight) {
        this._properties.setHasViewportWeight(hasWeight);
    }

    public void setViewportWeight(double val) {
        this._properties.setViewportWeight(val);
    }

    public double getViewportWeight() {
        return this._properties.getViewportWeight();
    }

    public void setProperties(DataTypeProperties newProps) {
        if (newProps == null) {
            return;
        }
        this._properties = newProps;
    }

    public void setFileLocation(int loc) {
        this._fileLocation = loc;
    }

    public int getFileLocation() {
        return this._fileLocation;
    }

    public boolean isModified() {
        return this._modified;
    }

    public void setModified(boolean modified) {
        this._modified = modified;
    }

    public String getKey() {
        String type = this.getDSSType();
        if (type == null || type.length() == 0) {
            type = "INST-VAL";
        }
        return (this.getName() + type).toUpperCase();
    }

    static {
        G2dLineProperties props = new G2dLineProperties();
        props.setLineColor(Color.blue);
        UNDEFINED_LINES.add(props);
        props = new G2dLineProperties();
        props.setLineColor(Color.red);
        UNDEFINED_LINES.add(props);
        props = new G2dLineProperties();
        props.setLineColor(Color.green.darker());
        UNDEFINED_LINES.add(props);
        props = new G2dLineProperties();
        props.setLineColor(Color.darkGray);
        UNDEFINED_LINES.add(props);
        props = new G2dLineProperties();
        props.setLineColor(Color.magenta);
        UNDEFINED_LINES.add(props);
        props = new G2dLineProperties();
        props.setLineColor(Color.orange);
        UNDEFINED_LINES.add(props);
        props = new G2dLineProperties();
        props.setLineColor(Color.black);
        UNDEFINED_LINES.add(props);
    }
}

