/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.data.Parameter;
import hec.gfx2d.DataType;
import hec.gfx2d.DataTypeFactory;
import hec.gfx2d.DataTypePanel;
import hec.gfx2d.G2dLineLabelPropertiesPanel;
import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.G2dLinePropertiesPanel;
import hec.gfx2d.Gfx2dDrawUtil;
import hec.gfx2d.LineProperties;
import hec.gfx2d.Symbol;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import rma.lang.Modifiable;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.InsertDlg;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDialog;
import rma.swing.RmaJFrame;
import rma.swing.RmaJIntegerField;
import rma.swing.RmaJPopupMenu;
import rma.swing.RmaJRadioButton;
import rma.swing.RmaJTable;
import rma.swing.RmaJTextField;
import rma.swing.event.ReflectMultiListener;
import rma.swing.table.ColumnGroup;
import rma.swing.table.GroupableTableHeader;
import rma.swing.table.MleHeadRenderer;
import rma.swing.table.RmaTableModel;
import rma.swing.wheel.WheelTool;
import rma.util.FillPatternFactory;
import rma.util.RMAIO;
import rma.util.RMASort;
import rma.util.RMAUtil;

public class DataTypeEditor
extends RmaJFrame {
    private static final String DEFAULT_TITLE = "Default Line Style Options";
    private static final int DATA_TYPE_COL = 0;
    private static final int PARAMETER_COL = 1;
    private static final int DSS_TYPE_COL = 2;
    private static final int LINE_NUM_COL = 3;
    private static final int LINE_COL = 4;
    private RmaJTable _dataTypeTable;
    private ModifiableTabbedPane _tabbedPane;
    private RmaJRadioButton _currentPlotRB;
    private RmaJRadioButton _defaultLineStyles;
    private RmaJComboBox _dssTypeCombo;
    private G2dLinePropertiesPanel _linePanel;
    private G2dLineLabelPropertiesPanel _lineLabelPanel;
    private DataTypePanel _dataTypePanel;
    private ReflectMultiListener _listener;
    private boolean _startedFromMain = false;
    private RmaJTextField _statusLineTxt;
    private RmaJTextField _modifiedLineTxt;
    private DataType _selectedDataType = null;
    private JMenuItem _addRowMenuItem;
    private JMenuItem _deleteRowMenuItem;
    private JMenuItem _copyRowMenuItem;

    public DataTypeEditor() {
        this.setTitle(DEFAULT_TITLE);
        this.buildControls();
    }

    protected void buildControls() {
        this._listener = new ReflectMultiListener();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(0);
        this.buildMenus();
        this._currentPlotRB = new RmaJRadioButton("Current Plot Line Styles");
        this._currentPlotRB.setMnemonic('C');
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this._currentPlotRB, gbc);
        this._defaultLineStyles = new RmaJRadioButton("Default Line Styles");
        this._defaultLineStyles.setMnemonic('D');
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this._defaultLineStyles, gbc);
        RmaJPopupMenu popup = new RmaJPopupMenu();
        JMenuItem menuItem = new JMenuItem("Copy");
        popup.add(menuItem);
        menuItem.addActionListener(this._listener.add(this, menuItem, "copyLine"));
        RmaTableModel rtm = new RmaTableModel(new String[]{" \nName", " \nParameter", " \nType", "Line\nNumber", " \nLine/Fill"}, new Object[0][0], new boolean[0]){

            @Override
            public Object getValueAt(int row, int col) {
                DataType dataType = (DataType)super.getValueAt(row, 0);
                if (dataType == null) {
                    return "";
                }
                switch (col) {
                    case 0: {
                        return dataType;
                    }
                    case 1: {
                        return dataType.getParameter();
                    }
                    case 2: {
                        return dataType.getDSSType();
                    }
                    case 3: 
                    case 4: {
                        return super.getValueAt(row, col);
                    }
                }
                return "";
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return col == 0 || col == 1 || col == 2;
            }

            @Override
            public void setValueAt(Object obj, int row, int col) {
                if (obj == null) {
                    return;
                }
                switch (col) {
                    case 0: {
                        DataType dataType = (DataType)super.getValueAt(row, 0);
                        dataType.setName(obj.toString());
                        break;
                    }
                    case 1: {
                        DataType dataType = (DataType)super.getValueAt(row, 0);
                        dataType.setParameter(obj.toString());
                        break;
                    }
                    case 2: {
                        DataType dataType = (DataType)super.getValueAt(row, 0);
                        dataType.setDSSType(obj.toString());
                    }
                }
            }
        };
        this._dataTypeTable = new RmaJTable(this, (Object[])new String[]{"Name", "Parameter", "Type", "Line Name", "Line/Fill"}){

            @Override
            public String getToolTipText(MouseEvent e) {
                int col = DataTypeEditor.this._dataTypeTable.columnAtPoint(e.getPoint());
                if (col == 0) {
                    int row = DataTypeEditor.this._dataTypeTable.rowAtPoint(e.getPoint());
                    DataType dt = (DataType)this.getValueAt(row, col);
                    if (dt == null) {
                        return null;
                    }
                    switch (dt.getFileLocation()) {
                        case 3: {
                            return "<html>Name:" + dt.getName() + "<BR>Location:CWMS ALL</html>";
                        }
                        case 2: {
                            return "<html>Name:" + dt.getName() + "<BR>Location:CWMS WATERSHED</html>";
                        }
                        case 1: {
                            return "<html>Name:" + dt.getName() + "<BR>Location:USER ALL</html>";
                        }
                    }
                }
                return super.getToolTipText(e);
            }
        };
        this._dataTypeTable.setTableHeader(new GroupableTableHeader(this._dataTypeTable.getColumnModel()));
        this._dataTypeTable.setModel(rtm);
        this._dataTypeTable.setColumnWidths(240, 61, 35, 10, 65);
        this._dataTypeTable.setCellSelectionEnabled(false);
        this._dataTypeTable.setColumnSelectionAllowed(false);
        this._dataTypeTable.setRowSelectionAllowed(true);
        this._dataTypeTable.setHorizontalAlignment(4, 3);
        this._dataTypeTable.setEditable(false);
        this._dataTypeTable.setPopupMenu(popup);
        this._dataTypeTable.setRowHeight(24);
        this._dataTypeTable.setComboBoxEditor(2, DataTypeFactory.DSS_TYPES);
        this._dataTypeTable.setSelectionMode(0);
        TableColumnModel cm = this._dataTypeTable.getColumnModel();
        TableColumn tc = cm.getColumn(4);
        if (tc != null) {
            tc.setCellRenderer(new LinePropertiesRenderer());
        }
        ColumnGroup cgLines = new ColumnGroup(new MleHeadRenderer(), "Line Styles");
        cgLines.add(cm.getColumn(0));
        cgLines.add(cm.getColumn(1));
        cgLines.add(cm.getColumn(2));
        cgLines.add(cm.getColumn(3));
        cgLines.add(cm.getColumn(4));
        GroupableTableHeader header = (GroupableTableHeader)this._dataTypeTable.getTableHeader();
        header.addColumnGroup(cgLines);
        this._dataTypeTable.setMlHeaderRenderer();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this._dataTypeTable.getScrollPane(), gbc);
        this._dataTypeTable.getScrollPane().setHorizontalScrollBarPolicy(30);
        this._tabbedPane = new ModifiableTabbedPane();
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this._tabbedPane, gbc);
        JPanel statusPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 3;
        gbc.anchor = 16;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        this.getContentPane().add((Component)statusPanel, gbc);
        this._statusLineTxt = new RmaJTextField();
        this._statusLineTxt.setEditable(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.gridwidth = 1;
        gbc.anchor = 16;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 5, 0, 1);
        statusPanel.add((Component)this._statusLineTxt, gbc);
        this._modifiedLineTxt = new RmaJTextField("             ");
        this._modifiedLineTxt.setColumns(10);
        this._modifiedLineTxt.setEditable(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.anchor = 14;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(5, 1, 0, 5);
        statusPanel.add((Component)this._modifiedLineTxt, gbc);
        this._linePanel = new G2dLinePropertiesPanel();
        this._lineLabelPanel = new G2dLineLabelPropertiesPanel();
        this._dataTypePanel = new DataTypePanel();
        this._tabbedPane.addTab("Line", this._linePanel);
        this._tabbedPane.addTab("Label", this._lineLabelPanel);
        this._tabbedPane.addTab("Defaults", this._dataTypePanel);
        this.setTabsEnabled(false);
        this._tabbedPane.setEnabledAt(0, false);
        this._tabbedPane.setEnabledAt(1, false);
        this._dataTypeTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int row = DataTypeEditor.this._dataTypeTable.getSelectedRow();
                if (row == -1) {
                    DataTypeEditor.this._selectedDataType = null;
                    DataTypeEditor.this.setTabsEnabled(false);
                    return;
                }
                DataTypeEditor.this.setTabsEnabled(true);
                if (DataTypeEditor.this._selectedDataType != null && DataTypeEditor.this._tabbedPane.isModified()) {
                    DataTypeEditor.this._linePanel.savePanel();
                    DataTypeEditor.this._lineLabelPanel.savePanel();
                    DataTypeEditor.this._dataTypePanel.savePanel();
                    DataTypeEditor.this._selectedDataType.setProperties(DataTypeEditor.this._dataTypePanel.getData());
                    DataTypeEditor.this._selectedDataType.setFileLocation(1);
                    DataTypeEditor.this._selectedDataType.setModified(true);
                }
                DataTypeEditor.this.setIgnoreModifiedEvents(true);
                DataTypeEditor.this._selectedDataType = (DataType)DataTypeEditor.this._dataTypeTable.getValueAt(row, 0);
                G2dLineProperties lineProps = (G2dLineProperties)DataTypeEditor.this._dataTypeTable.getValueAt(row, 4);
                DataTypeEditor.this._linePanel.setData(lineProps);
                DataTypeEditor.this._lineLabelPanel.setData(lineProps);
                DataTypeEditor.this._dataTypePanel.setData(DataTypeEditor.this._selectedDataType.getProperties());
                DataTypeEditor.this._linePanel.fillPanel();
                DataTypeEditor.this._lineLabelPanel.fillPanel();
                DataTypeEditor.this._dataTypePanel.fillPanel();
                DataTypeEditor.this.setIgnoreModifiedEvents(false);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DataTypeEditor.this.closeWindow();
            }
        });
    }

    protected void setTabsEnabled(boolean enabled) {
        this._linePanel.setEnabled(enabled);
        this._lineLabelPanel.setEnabled(enabled);
        this._dataTypePanel.setEnabled(enabled);
        this._tabbedPane.setEnabledAt(0, enabled);
        this._tabbedPane.setEnabledAt(1, enabled);
        this._tabbedPane.setEnabledAt(2, enabled);
        this._addRowMenuItem.setEnabled(enabled);
        this._copyRowMenuItem.setEnabled(enabled);
        this._deleteRowMenuItem.setEnabled(enabled);
    }

    protected void buildMenus() {
        JMenuBar mbar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic('F');
        JMenuItem menuItem = new JMenuItem("New Parameter...", 78);
        menuItem.addActionListener(this._listener.add(this, menuItem, "newDataType"));
        fileMenu.add(menuItem);
        fileMenu.addSeparator();
        this._addRowMenuItem = new JMenuItem("Add Row(s)", 65);
        this._addRowMenuItem.setEnabled(false);
        this._addRowMenuItem.addActionListener(this._listener.add(this, this._addRowMenuItem, "addLines"));
        fileMenu.add(this._addRowMenuItem);
        this._copyRowMenuItem = new JMenuItem("Copy Row", 67);
        this._copyRowMenuItem.setEnabled(false);
        this._copyRowMenuItem.addActionListener(this._listener.add(this, this._copyRowMenuItem, "copyLine"));
        fileMenu.add(this._copyRowMenuItem);
        this._deleteRowMenuItem = new JMenuItem("Delete Row(s)", 68);
        this._deleteRowMenuItem.setEnabled(false);
        this._deleteRowMenuItem.addActionListener(this._listener.add(this, this._deleteRowMenuItem, "deleteLines"));
        fileMenu.addSeparator();
        menuItem = new JMenuItem("Save", 83);
        menuItem.addActionListener(this._listener.add(this, menuItem, "saveDataTypes"));
        fileMenu.add(menuItem);
        fileMenu.addSeparator();
        menuItem = new JMenuItem("Close", 67);
        menuItem.addActionListener(this._listener.add(this, menuItem, "closeWindow"));
        fileMenu.add(menuItem);
        mbar.add(fileMenu);
        this.setJMenuBar(mbar);
    }

    public void fillForm() {
        this._defaultLineStyles.doClick();
        this._currentPlotRB.setVisible(false);
        this._defaultLineStyles.setVisible(false);
        this._dataTypeTable.deleteCells();
        Vector v = DataTypeFactory.getFactory().getDataTypes();
        this._statusLineTxt.setText("Opened " + DataTypeFactory.getFactory().getFileName());
        this.fillForm(v);
        this.pack();
        this.setLocation();
    }

    private void fillForm(Vector v) {
        RMASort.quickSort(v);
        for (int i = 0; i < v.size(); ++i) {
            DataType dataType = (DataType)v.get(i);
            Vector<LineProperties> lineProps = dataType.getG2dLinesList();
            for (int j = 0; j < lineProps.size(); ++j) {
                Vector<Object> row = new Vector<Object>(4);
                row.add(dataType);
                row.add(dataType.getParameter());
                row.add(dataType.getDSSType());
                G2dLineProperties props = (G2dLineProperties)lineProps.get(j);
                row.add(String.valueOf(j + 1));
                row.add(props);
                this._dataTypeTable.appendRow(row);
            }
        }
        this.setModified(false);
    }

    protected void saveDataTypes() {
        this._dataTypeTable.commitEdit(true);
        if (this._selectedDataType != null && this._tabbedPane.isModified()) {
            this._linePanel.savePanel();
            this._lineLabelPanel.savePanel();
            this._dataTypePanel.savePanel();
            this._selectedDataType.setProperties(this._dataTypePanel.getData());
            this._selectedDataType.setFileLocation(1);
            this._selectedDataType.setModified(true);
        }
        if (DataTypeFactory.getFactory().writeFile()) {
            this._statusLineTxt.setText("Data Saved.");
            this.setModified(false);
        } else {
            this._statusLineTxt.setText("Error saving data.");
        }
    }

    protected void addLines() {
        int row = this._dataTypeTable.getSelectedRow();
        if (row == -1) {
            JOptionPane.showMessageDialog(this, "No row selected");
            return;
        }
        this._dataTypeTable.commitEdit(true);
        InsertDlg dialog = new InsertDlg((Frame)this, true);
        dialog.setLabelText("Enter number of lines to add");
        dialog.setVisible(true);
        if (dialog.isCanceled()) {
            return;
        }
        int numRows = dialog.getRowsToInsert();
        if (numRows < 1) {
            return;
        }
        DataType dataType = (DataType)this._dataTypeTable.getValueAt(row, 0);
        G2dLineProperties props = (G2dLineProperties)this._dataTypeTable.getValueAt(row, 4);
        int j = 0;
        for (int i = 0; i < numRows; ++i) {
            G2dLineProperties newProps = props.clone();
            dataType.addG2dLineProperties(newProps);
            Vector<Object> rowData = new Vector<Object>(4);
            rowData.add(dataType);
            rowData.add(dataType.getParameter());
            rowData.add(dataType.getDSSType());
            rowData.add(String.valueOf(dataType.getG2dLinesList().size()));
            rowData.add(newProps);
            int rowCount = this._dataTypeTable.getRowCount();
            for (j = row; j < rowCount && this._dataTypeTable.getValueAt(j, 0) == dataType; ++j) {
            }
            ((RmaTableModel)this._dataTypeTable.getModel()).insertRow(j, rowData);
        }
        this._dataTypeTable.updateSelection(j, 0, false, false);
    }

    protected void deleteLines() {
    }

    protected void copyLine() {
        int row = this._dataTypeTable.getSelectedRow();
        if (row == -1) {
            JOptionPane.showMessageDialog(this, "No row selected");
            return;
        }
        this._dataTypeTable.commitEdit(true);
        this._dataTypeTable.clearSelection();
        DataType dataType = (DataType)this._dataTypeTable.getValueAt(row, 0);
        G2dLineProperties props = (G2dLineProperties)this._dataTypeTable.getValueAt(row, 4);
        G2dLineProperties newProps = props.clone();
        dataType.addG2dLineProperties(newProps);
        Vector<Object> rowData = new Vector<Object>(4);
        rowData.add(dataType);
        rowData.add(dataType.getParameter());
        rowData.add(dataType.getDSSType());
        rowData.add(String.valueOf(dataType.getG2dLinesList().size()));
        rowData.add(newProps);
        int rowCount = this._dataTypeTable.getRowCount();
        int i = 0;
        for (i = row; i < rowCount && this._dataTypeTable.getValueAt(i, 0) == dataType; ++i) {
        }
        ((RmaTableModel)this._dataTypeTable.getModel()).insertRow(i, rowData);
        this._dataTypeTable.updateSelection(i, 0, false, false);
    }

    protected void newDataType() {
        NewDataTypeDialog dialog = new NewDataTypeDialog();
        dialog.setVisible(true);
        if (dialog.isCanceled()) {
            return;
        }
        String parameter = dialog.getParameter();
        String dssType = dialog.getDSSType();
        String name = dialog.getDataTypeName();
        boolean yAxisReversed = dialog.isYAxisReversed();
        int numLines = dialog.getNumberOfLines();
        try {
            DataTypeFactory.getFactory().addDataType(parameter, name, dssType, yAxisReversed, numLines);
        }
        catch (Exception e) {
            System.out.println("Error adding new DataType " + e);
            JOptionPane.showMessageDialog(this, "Error:" + e, "Error Adding", 0);
            return;
        }
        this.fillForm();
    }

    protected void closeWindow() {
        if (this.isModified()) {
            int opt = JOptionPane.showConfirmDialog(this, "Line Styles have change.\nSave Changes?", "Save Changes?", 1);
            if (opt == 0) {
                this.saveDataTypes();
            } else if (opt == 2) {
                return;
            }
        }
        this.setVisible(false);
        if (this._startedFromMain) {
            System.exit(0);
        }
    }

    public void setStartedFromMain(boolean b) {
        this._startedFromMain = b;
        if (this._startedFromMain) {
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    DataTypeEditor.this.closeWindow();
                }
            });
        }
    }

    @Override
    public void setModified(boolean b) {
        if (this.isIgnoringModifiedEvents()) {
            return;
        }
        super.setModified(b);
        this._modifiedLineTxt.setText(b ? "Modified" : "        ");
    }

    public static void main(String[] args) {
        try {
            int osType = RMAIO.getOSType();
            if (osType == 0 || osType == 1) {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                WheelTool.initWheelTool();
            } else if (osType == 2) {
                UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
            }
        }
        catch (Exception e) {
            System.out.println("Failed to set look and feel");
        }
        DataTypeEditor dataTypeEditor = new DataTypeEditor();
        dataTypeEditor.setStartedFromMain(true);
        dataTypeEditor.fillForm();
        dataTypeEditor.setVisible(true);
    }

    class LinePropertiesRenderer
    extends JPanel
    implements TableCellRenderer {
        String _sampleText;
        boolean _drawLine;
        int strLen;
        G2dLineProperties props;

        LinePropertiesRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setBorder(BorderFactory.createLineBorder(table.getSelectionBackground()));
            } else {
                this.setBorder(null);
            }
            this.props = (G2dLineProperties)table.getValueAt(row, column);
            Rectangle r = table.getCellRect(row, column, false);
            this.setSize(r.width, r.height);
            this.setBackground(((RmaJTable)table).getCellBackground(row, column));
            if (this.props == null) {
                return new JLabel();
            }
            return this;
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Color oldColor = g.getColor();
            this._drawLine = this.props.drawLine();
            Dimension d = this.getSize();
            if (this.props.getFillType() != 0) {
                g.setColor(this.props.getFillColor());
                Paint oldPaint = ((Graphics2D)g).getPaint();
                ((Graphics2D)g).setPaint(FillPatternFactory.createFillPattern(this.props.getFillType(), this.props.getFillColor()));
                g.fillRect(15, 20, d.width - 30, d.height - 30);
                ((Graphics2D)g).setPaint(oldPaint);
            } else {
                g.setColor(Color.white);
                g.fillRect(15, 20, d.width - 30, d.height - 30);
            }
            g.setColor(this.props.getLineColor());
            if (this.props.hasLabel()) {
                this._sampleText = this.props.getLabel();
                this.strLen = g.getFontMetrics().stringWidth(this._sampleText);
            } else {
                this._sampleText = null;
                this.strLen = 0;
            }
            if (this.props.getLabelPosition() == 0 && this.props.getLabelAlignment() == 0) {
                this.drawAboveLeft(g);
            } else if (this.props.getLabelPosition() == 0 && this.props.getLabelAlignment() == 2) {
                this.drawAboveCenter(g);
            } else if (this.props.getLabelPosition() == 0 && this.props.getLabelAlignment() == 1) {
                this.drawAboveRight(g);
            } else if (this.props.getLabelPosition() == 1 && this.props.getLabelAlignment() == 0) {
                this.drawBelowLeft(g);
            } else if (this.props.getLabelPosition() == 1 && this.props.getLabelAlignment() == 2) {
                this.drawBelowCenter(g);
            } else if (this.props.getLabelPosition() == 1 && this.props.getLabelAlignment() == 1) {
                this.drawBelowRight(g);
            } else if (this.props.getLabelPosition() == 2 && this.props.getLabelAlignment() == 2) {
                this.drawCenterCenter(g);
            } else if (this.props.getLabelPosition() == 2 && this.props.getLabelAlignment() == 1) {
                this.drawCenterRight(g);
            } else if (this.props.getLabelPosition() == 2 && this.props.getLabelAlignment() == 0) {
                this.drawCenterLeft(g);
            }
            g.setColor(oldColor);
        }

        private void drawAboveLeft(Graphics g) {
            int offset = 15;
            Dimension d = this.getSize();
            if (this._drawLine) {
                this.drawLine(g, 5, d.height / 2 + 2, d.width - 5, d.height / 2 + 2);
            }
            if (this._sampleText != null) {
                g.setColor(Color.black);
                Gfx2dDrawUtil.drawString(this, g, this._sampleText, offset, d.height / 2 + 2 - g.getFontMetrics().getDescent());
            }
        }

        private void drawAboveCenter(Graphics g) {
            Dimension d = this.getSize();
            if (this._drawLine) {
                this.drawLine(g, 5, d.height / 2 + 2, d.width - 5, d.height / 2 + 2);
            }
            if (this._sampleText != null) {
                g.setColor(Color.black);
                Gfx2dDrawUtil.drawString(this, g, this._sampleText, d.width / 2 - this.strLen / 2, d.height / 2 + 2 - g.getFontMetrics().getDescent());
            }
        }

        private void drawAboveRight(Graphics g) {
            int offset = 15;
            Dimension d = this.getSize();
            if (this._drawLine) {
                this.drawLine(g, 5, d.height / 2 + 2, d.width - 5, d.height / 2 + 2);
            }
            if (this._sampleText != null) {
                g.setColor(Color.black);
                Gfx2dDrawUtil.drawString(this, g, this._sampleText, d.width - offset - this.strLen, d.height / 2 + 2 - g.getFontMetrics().getDescent());
            }
        }

        private void drawBelowLeft(Graphics g) {
            Dimension d = this.getSize();
            if (this._drawLine) {
                this.drawLine(g, 5, d.height / 2 + 2, d.width - 5, d.height / 2 + 2);
            }
            if (this._sampleText != null) {
                g.setColor(Color.black);
                Gfx2dDrawUtil.drawString(this, g, this._sampleText, 10, d.height / 2 + 2 + g.getFontMetrics().getAscent());
            }
        }

        private void drawBelowCenter(Graphics g) {
            Dimension d = this.getSize();
            if (this._drawLine) {
                this.drawLine(g, 5, d.height / 2 + 2, d.width - 5, d.height / 2 + 2);
            }
            if (this._sampleText != null) {
                g.setColor(Color.black);
                Gfx2dDrawUtil.drawString(this, g, this._sampleText, d.width / 2 - this.strLen / 2, d.height / 2 + 2 + g.getFontMetrics().getAscent());
            }
        }

        private void drawBelowRight(Graphics g) {
            Dimension d = this.getSize();
            if (this._drawLine) {
                this.drawLine(g, 5, d.height / 2 + 2, d.width - 5, d.height / 2 + 2);
            }
            if (this._sampleText != null) {
                g.setColor(Color.black);
                Gfx2dDrawUtil.drawString(this, g, this._sampleText, d.width - 10 - this.strLen, d.height / 2 + 2 + g.getFontMetrics().getAscent());
            }
        }

        private void drawCenterRight(Graphics g) {
            int offset = 15;
            Dimension d = this.getSize();
            if (this._drawLine) {
                this.drawLine(g, 5, d.height / 2 + 2, d.width - 12 - this.strLen, d.height / 2 + 2);
                this.drawLine(g, d.width - 10 + 2, d.height / 2 + 2, d.width - 5, d.height / 2 + 2);
            }
            if (this._sampleText != null) {
                g.setColor(Color.black);
                Gfx2dDrawUtil.drawString(this, g, this._sampleText, d.width - offset - this.strLen, d.height / 2 + 2 + g.getFontMetrics().getAscent() / 2 - 1);
            }
        }

        private void drawCenterCenter(Graphics g) {
            Dimension d = this.getSize();
            if (this._drawLine) {
                this.drawLine(g, 5, d.height / 2 + 2, d.width / 2 - this.strLen / 2 - 2, d.height / 2 + 2);
                this.drawLine(g, d.width / 2 + this.strLen / 2 + 2, d.height / 2 + 2, d.width - 5, d.height / 2 + 2);
            }
            if (this._sampleText != null) {
                g.setColor(Color.black);
                Gfx2dDrawUtil.drawString(this, g, this._sampleText, d.width / 2 - this.strLen / 2, d.height / 2 + 2 + g.getFontMetrics().getAscent() / 2 - 1);
            }
        }

        private void drawCenterLeft(Graphics g) {
            int offset = 15;
            Dimension d = this.getSize();
            if (this._drawLine) {
                this.drawLine(g, 5, d.height / 2 + 2, 8, d.height / 2 + 2);
                this.drawLine(g, 10 + this.strLen + 2, d.height / 2 + 2, d.width - 5, d.height / 2 + 2);
            }
            if (this._sampleText != null) {
                g.setColor(Color.black);
                Gfx2dDrawUtil.drawString(this, g, this._sampleText, offset, d.height / 2 + 2 + g.getFontMetrics().getAscent() / 2 - 1);
            }
        }

        private void drawLine(Graphics g, int x1, int y1, int x2, int y2) {
            int fillType = this.props.getFillType();
            Color oldColor = g.getColor();
            Dimension d = this.getSize();
            Graphics2D g2d = (Graphics2D)g;
            if (fillType != 0) {
                Color lineFColor = this.props.getFillColor();
                if (this.props.getFillPattern() == 0) {
                    g2d.setColor(lineFColor);
                    if (fillType == 1) {
                        g2d.fillRect(5, 2, d.width - 9, d.height / 2);
                    } else if (fillType == 2) {
                        g2d.fillRect(5, d.height / 2 + 2, d.width - 9, d.height / 2 - 2);
                    }
                } else {
                    Composite oldac = ((Graphics2D)g).getComposite();
                    AlphaComposite ac = AlphaComposite.getInstance(3, 0.5f);
                    Paint op = g2d.getPaint();
                    int pattern = this.props.getFillPattern();
                    Paint tp = FillPatternFactory.createFillPattern(pattern, lineFColor);
                    g2d.setPaint(tp);
                    ((Graphics2D)g).setComposite(ac);
                    if (fillType == 1) {
                        g2d.fillRect(5, 2, d.width - 9, d.height / 2);
                    } else if (fillType == 2) {
                        g2d.fillRect(5, d.height / 2 + 2, d.width - 9, d.height / 2 - 2);
                    }
                    g2d.setComposite(oldac);
                    g2d.setPaint(op);
                }
            }
            float lineThickness = this.props.getLineWidth();
            float[] linePattern = this.props.getLinePattern();
            g.setColor(this.props.getLineColor());
            Stroke oldStroke = g2d.getStroke();
            BasicStroke bs = new BasicStroke(lineThickness, 0, 0, 10.0f, linePattern, 0.0f);
            g2d.setStroke(bs);
            g.drawLine(x1, y1, x2, y2);
            g2d.setStroke(oldStroke);
            if (this.props.drawPoints()) {
                Symbol.draw(g, d.width / 2, d.height / 2 + 2, this.props.getSymbolType(), this.props.getPointLineColor(), this.props.getPointFillColor(), this.props.getSymbolSize());
            }
            g.setColor(oldColor);
        }
    }

    class ModifiableTabbedPane
    extends JTabbedPane
    implements Modifiable {
        private boolean _modified;

        @Override
        public void setModified(boolean modified) {
            this._modified = modified;
            if (modified) {
                RMAUtil.setParentModified(this);
            } else {
                RMAUtil.setChildrenUnmodified(this);
            }
        }

        @Override
        public boolean isModified() {
            return this._modified;
        }
    }

    class NewDataTypeDialog
    extends RmaJDialog {
        private RmaJComboBox _parameterCombo;
        private RmaJTextField _nameTxt;
        private RmaJCheckBox _yAxisReversed;
        private ButtonCmdPanel _cmdPanel;
        private RmaJIntegerField _numLinesFld;
        private boolean _canceled;

        NewDataTypeDialog() {
            super(DataTypeEditor.this, "New Data Type", true);
            this.buildControls();
        }

        void buildControls() {
            this.getContentPane().setLayout(new GridBagLayout());
            JLabel label = new JLabel("Parameter:");
            label.setDisplayedMnemonic('P');
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets(5, 5, 0, 5);
            this.getContentPane().add((Component)label, gbc);
            this._parameterCombo = new RmaJComboBox<String>(Parameter.getAvailableParameters());
            label.setLabelFor(this._parameterCombo);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = RmaInsets.insets(5, 5, 0, 5);
            this.getContentPane().add((Component)this._parameterCombo, gbc);
            label = new JLabel("Name:");
            label.setDisplayedMnemonic('N');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets(5, 5, 0, 5);
            this.getContentPane().add((Component)label, gbc);
            this._nameTxt = new RmaJTextField();
            label.setLabelFor(this._nameTxt);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = RmaInsets.insets(5, 5, 0, 5);
            this.getContentPane().add((Component)this._nameTxt, gbc);
            label = new JLabel("Type:");
            label.setDisplayedMnemonic('T');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets(5, 5, 0, 5);
            this.getContentPane().add((Component)label, gbc);
            DataTypeEditor.this._dssTypeCombo = new RmaJComboBox<String>(DataTypeFactory.DSS_TYPES);
            label.setLabelFor(DataTypeEditor.this._dssTypeCombo);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 2;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = RmaInsets.insets(5, 5, 0, 5);
            this.getContentPane().add((Component)DataTypeEditor.this._dssTypeCombo, gbc);
            label = new JLabel("Number of Lines:");
            label.setDisplayedMnemonic('N');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 3;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets(5, 5, 0, 5);
            this.getContentPane().add((Component)label, gbc);
            this._numLinesFld = new RmaJIntegerField();
            this._numLinesFld.setMinValue(0);
            label.setLabelFor(this._numLinesFld);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 3;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = RmaInsets.insets(5, 5, 0, 5);
            this.getContentPane().add((Component)this._numLinesFld, gbc);
            this._yAxisReversed = new RmaJCheckBox("Y Axis Reversed");
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 4;
            gbc.gridwidth = 2;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = RmaInsets.insets(5, 5, 0, 5);
            this.getContentPane().add((Component)this._yAxisReversed, gbc);
            this._cmdPanel = new ButtonCmdPanel(12);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 5;
            gbc.gridwidth = 2;
            gbc.weighty = 1.0;
            gbc.anchor = 16;
            gbc.fill = 2;
            gbc.insets = RmaInsets.insets(5, 5, 0, 5);
            this.getContentPane().add((Component)this._cmdPanel, gbc);
            this._cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

                @Override
                public void buttonCmdActionPerformed(ActionEvent e) {
                    switch (e.getID()) {
                        case 8: {
                            if (!NewDataTypeDialog.this.saveForm()) break;
                            NewDataTypeDialog.this._canceled = false;
                            NewDataTypeDialog.this.setVisible(false);
                            break;
                        }
                        case 4: {
                            NewDataTypeDialog.this._canceled = true;
                            NewDataTypeDialog.this.setVisible(false);
                        }
                    }
                }
            });
            this.pack();
            this.setLocation();
        }

        private boolean saveForm() {
            if (this._parameterCombo.getSelectedIndex() == -1) {
                JOptionPane.showMessageDialog(this, "No Parameter Selected");
                return false;
            }
            if (this._nameTxt.getText().length() == 0) {
                JOptionPane.showMessageDialog(this, "No Name Entered");
                return false;
            }
            if (DataTypeEditor.this._dssTypeCombo.getSelectedIndex() == -1) {
                JOptionPane.showMessageDialog(this, "No Type Selected");
                return false;
            }
            return true;
        }

        boolean isCanceled() {
            return this._canceled;
        }

        String getParameter() {
            return (String)this._parameterCombo.getSelectedItem();
        }

        String getDSSType() {
            return (String)DataTypeEditor.this._dssTypeCombo.getSelectedItem();
        }

        String getDataTypeName() {
            return this._nameTxt.getText();
        }

        boolean isYAxisReversed() {
            return this._yAxisReversed.isSelected();
        }

        int getNumberOfLines() {
            return this._numLinesFld.getValue();
        }
    }
}

