/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.data.Parameter;
import hec.gfx2d.DataType;
import hec.gfx2d.DataTypeProperties;
import hec.gfx2d.G2dLine;
import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.G2dObject;
import hec.gfx2d.LineProperties;
import hec.gfx2d.LocationIndex;
import hec.gfx2d.PairedDataSet;
import hec.gfx2d.PropertiesSerializer;
import hec.gfx2d.TimeSeriesDataSet;
import hec.gfx2d.dss.G2dDssObject;
import hec.gfx2d.dss.G2dDssTimeSeries;
import hec.gfx2d.dss.G2dDssTimeSeriesCollection;
import hec.heclib.dss.DSSPathname;
import hec.io.DSSIdentifier;
import hec.io.DataContainer;
import hec.io.PairedDataContainer;
import hec.io.TimeSeriesContainer;
import hec.lang.Logger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import rma.util.RMAConst;
import rma.util.RMAIO;
import rma.util.RMASort;

public class DataTypeFactory {
    public static final DataType UNDEFINED_DATA_TYPE = new DataType("UNDEFINED");
    public static final String PLOT_LINES_FILE = "defaultLineStyles.config";
    protected static String DEFAULT_PACKAGE = "hec/gfx2d/";
    static final String SEPARATOR = "-";
    static final String UNDEFINED_LINES = "UNDEFINED";
    static final String UNDEFINED_PARAMETER = "UNDEFINED";
    static final String BEGIN_DEF = "Type Begin";
    static final String END_DEF = "Type End";
    static final String BEGIN_LINE = "Line Begin";
    static final String END_LINE = "Line End";
    static final String PARAMETER = "parameter";
    static final String NAME = "name";
    static final String DSS_TYPE = "type";
    static final String YAXIS_REVERSED = "Y Axis Reversed";
    static final String USE_DEFAULT_MAX = "Default Max";
    static final String USE_DEFAULT_MIN = "Default Min";
    static final String USE_VIEWPORT_WEIGHT = "Viewport Weight";
    public static String INST_VAL = "INST-VAL";
    public static String INST_CUM = "INST-CUM";
    public static String PER_AVER = "PER-AVER";
    public static String PER_CUM = "PER-CUM";
    public static final String[] DSS_TYPES = new String[]{"All", INST_VAL, INST_CUM, PER_AVER, PER_CUM};
    private static Hashtable _dataTypeTable = new Hashtable();
    private static Hashtable _paramCntTable = new Hashtable();
    private static Hashtable _paramTable = new Hashtable();
    private Vector _paramList = new Vector();
    private Vector _locationList = new Vector();
    protected static boolean _debug = false;
    private static DataTypeFactory m_factory = null;
    private static String _overrideFile;

    protected List getLocationList() {
        return this._locationList;
    }

    protected DataTypeFactory() {
        _debug = Logger.canDebug("dataTypeFactory");
        this.readFile();
        this.fillParamList();
    }

    public static void setFactory(DataTypeFactory factory) {
        m_factory = factory;
    }

    public static DataTypeFactory getFactory() {
        if (m_factory == null) {
            m_factory = new DataTypeFactory();
        }
        return m_factory;
    }

    private static boolean init() {
        return true;
    }

    public void reset() {
        this._locationList.clear();
        _debug = Logger.canDebug("dataTypeFactory");
    }

    public List<LineProperties> getLineProperties(List<? extends G2dObject> dataContainers) {
        return this.getLineProperties(dataContainers, null, true);
    }

    public List<LineProperties> getLineProperties(List<? extends G2dObject> dataContainers, boolean useDataTypeStyles) {
        return this.getLineProperties(dataContainers, null, useDataTypeStyles);
    }

    public List<LineProperties> getLineProperties(List<? extends G2dObject> dataContainers, String paramOverride) {
        return this.getLineProperties(dataContainers, paramOverride, true);
    }

    public List<LineProperties> getLineProperties(List<? extends G2dObject> dataContainers, String param, boolean useDataTypeStyles) {
        if (dataContainers == null) {
            return null;
        }
        if (_debug) {
            System.out.println("getLineProperties: looking for " + dataContainers.size() + " lines paramOverride " + param);
        }
        Vector<LineProperties> retVec = new Vector<LineProperties>();
        G2dLineProperties props = null;
        this.orderLines(dataContainers);
        for (int i = 0; i < dataContainers.size(); ++i) {
            int j;
            DataContainer dc;
            int curveCount;
            Object obj = dataContainers.get(i);
            if (!(obj instanceof G2dObject)) {
                Vector<LineProperties> lines = this.getUndefinedDataType().getG2dLinesList();
                int idx = i % lines.size();
                retVec.add(lines.get(idx));
                return retVec;
            }
            if (obj instanceof G2dDssTimeSeriesCollection) {
                curveCount = obj.getCurveCount();
                if (curveCount > 0) {
                    dc = ((G2dDssTimeSeriesCollection)obj).getTimeSeriesContainer().get(0);
                    props = this.getLineProperties(dc, param, useDataTypeStyles);
                }
                if (curveCount > 1) {
                    int transperency;
                    int tMax = 90;
                    int tMin = 10;
                    int ii = (tMax - tMin) / curveCount;
                    props._lineTransparency = transperency = tMax - ii;
                }
                for (j = 0; j < curveCount; ++j) {
                    retVec.add(props);
                }
                continue;
            }
            curveCount = obj.getCurveCount();
            for (j = 0; j < curveCount; ++j) {
                if (obj instanceof TimeSeriesDataSet) {
                    obj = ((TimeSeriesDataSet)obj)._timeSeries;
                }
                if (obj instanceof PairedDataSet) {
                    obj = ((PairedDataSet)obj)._pairedData;
                }
                if (obj instanceof DataContainer) {
                    dc = (DataContainer)obj;
                    props = this.getLineProperties(dc, param, useDataTypeStyles);
                    retVec.add(props);
                    continue;
                }
                if (obj instanceof G2dDssObject) {
                    G2dDssObject data = (G2dDssObject)obj;
                    props = this.getLineProperties(data, param, useDataTypeStyles);
                    retVec.add(props);
                    continue;
                }
                if (obj instanceof G2dObject && useDataTypeStyles) {
                    props = this.getLineProperties((G2dObject)obj, param, useDataTypeStyles);
                    retVec.add(props);
                    continue;
                }
                Vector<LineProperties> lines = this.getUndefinedDataType().getG2dLinesList();
                int idx = i % lines.size();
                retVec.add(lines.get(idx));
            }
        }
        return retVec;
    }

    public G2dLineProperties getLineProperties(G2dDssObject data) {
        return this.getLineProperties(data, true);
    }

    public G2dLineProperties getLineProperties(G2dDssObject data, boolean useDataTypeStyles) {
        return this.getLineProperties(data, null, useDataTypeStyles);
    }

    public G2dLineProperties getLineProperties(G2dDssObject data, String paramOverride, boolean useDataTypeStyles) {
        String param;
        Object lineProps = null;
        DSSIdentifier dssId = data.getDSSIdentifer();
        if (_debug && paramOverride != null) {
            System.out.println("getLineProperties: param override=" + paramOverride);
        }
        if (dssId == null) {
            if (paramOverride != null && paramOverride.length() > 0) {
                param = paramOverride.toUpperCase();
            } else {
                int parameterId = data.getYParameterId();
                param = Parameter.getParamString(parameterId);
            }
        } else {
            String dssPath = dssId.getDSSPath();
            Vector<String> dssPaths = DSSPathname.parseDssPath(dssPath);
            param = paramOverride != null && paramOverride.length() > 0 ? paramOverride : dssPaths.get(2);
        }
        param = param.toUpperCase();
        String parameter = this.getParameter(param);
        String leftOverParameter = this.getExcessParameter(param);
        String dssPath = dssId.getDSSPath();
        String type = null;
        if (data instanceof G2dDssTimeSeries) {
            type = ((G2dDssTimeSeries)data).getYType();
        }
        if (type == null || type.length() == 0) {
            type = INST_VAL;
        }
        type = type.toUpperCase();
        Vector<String> dssPathParts = DSSPathname.parseDssPath(dssPath);
        String location = dssPathParts.get(1) + SEPARATOR + dssPathParts.get(5) + (String)(leftOverParameter != null ? SEPARATOR + leftOverParameter : "");
        return this.getLineProperties(parameter, location, type, DataTypeFactory.isInstanteous(type), useDataTypeStyles);
    }

    public G2dLineProperties getLineProperties(G2dObject data, String paramOverride, boolean useDataTypeStyles) {
        Object lineProps = null;
        String lineStyleName = "";
        if (_debug && paramOverride != null) {
            System.out.println("getLineProperties: param override=" + paramOverride);
        }
        if (paramOverride != null && paramOverride.length() > 0) {
            lineStyleName = paramOverride.toUpperCase();
        } else {
            lineStyleName = data.getLineStyleName();
            if ((lineStyleName = this.getParameter(lineStyleName)) == null || lineStyleName.length() < 1) {
                int parameterId = data.getYParameterId();
                lineStyleName = Parameter.getParamString(parameterId);
            }
        }
        String param = lineStyleName.toUpperCase();
        String leftOverParameter = this.getExcessParameter(param);
        DataType dt = this.getDataType(data);
        String type = dt.getDSSType();
        String location = data.getName();
        return this.getLineProperties(param, location, type, DataTypeFactory.isInstanteous(type), useDataTypeStyles);
    }

    private void orderLines(List dataContainers) {
    }

    public G2dLineProperties getLineProperties(DataContainer dc) {
        return this.getLineProperties(dc, true);
    }

    public G2dLineProperties getLineProperties(DataContainer dc, boolean useDataTypeStyles) {
        return this.getLineProperties(dc, null, useDataTypeStyles);
    }

    public G2dLineProperties getLineProperties(DataContainer dc, String paramOverride, boolean useDataTypeStyles) {
        boolean isInstanteous;
        String type;
        String param;
        String leftOverParameter = null;
        if (_debug && paramOverride != null) {
            System.out.println("getLineProperties: param override=" + paramOverride);
        }
        if (dc instanceof TimeSeriesContainer) {
            TimeSeriesContainer tsc = (TimeSeriesContainer)dc;
            param = paramOverride != null && paramOverride.length() > 0 ? paramOverride.toUpperCase() : tsc.parameter.toUpperCase();
            type = tsc.type.toUpperCase();
            isInstanteous = type != null ? type.startsWith("INST-") || type.length() == 0 : true;
        } else if (dc instanceof PairedDataContainer) {
            PairedDataContainer pdc = (PairedDataContainer)dc;
            param = paramOverride != null && paramOverride.length() > 0 ? paramOverride : pdc.yparameter.toUpperCase();
            type = pdc.ytype;
            isInstanteous = true;
        } else {
            return null;
        }
        String parameter = this.getParameter(param);
        leftOverParameter = this.getExcessParameter(param);
        String location = dc.location + SEPARATOR + dc.version + (String)(leftOverParameter != null ? SEPARATOR + leftOverParameter : "");
        return this.getLineProperties(parameter, location, type, isInstanteous, useDataTypeStyles);
    }

    private G2dLineProperties getLineProperties(String parameter, String location, String type, boolean isInstanteous, boolean useDataTypeStyles) {
        DataType dt;
        G2dLineProperties lineProps = null;
        type = type == null || type.length() == 0 ? INST_VAL : type.toUpperCase();
        if (_debug) {
            System.out.println("getLineProperties: param=" + parameter + " type=" + type + " loc=" + location);
        }
        int index = -1;
        int maxIndex = -1;
        String key = parameter + this.getType(type);
        if (!useDataTypeStyles) {
            if (_debug) {
                System.out.println("getLineProperties: not using line styles for " + parameter);
            }
            dt = this.getUndefinedDataType();
            parameter = "UNDEFINED";
        } else {
            if (_debug) {
                System.out.println("getLineProperties: checking " + key);
            }
            if ((dt = (DataType)_dataTypeTable.get(key)) == null) {
                String allKey = parameter + DSS_TYPES[0].toUpperCase();
                if (_debug) {
                    System.out.println("getLineProperties: checking all " + allKey);
                }
                if ((dt = (DataType)_dataTypeTable.get(allKey)) == null) {
                    if (_debug) {
                        System.out.println("getLineProperties: no datatype found for " + key + " using defaults");
                    }
                    dt = this.getUndefinedDataType();
                    parameter = "UNDEFINED";
                }
                key = allKey;
            }
        }
        if (_debug) {
            System.out.println("getLineProperties: matched (param=" + parameter + " type=" + type + " loc=" + location + ") to key=" + key);
        }
        for (int i = 0; i < this._locationList.size(); ++i) {
            LocationIndex li = (LocationIndex)this._locationList.get(i);
            if (!li.parameter.equals(parameter)) continue;
            ++maxIndex;
            index = li.index;
        }
        Vector<LineProperties> v = dt.getG2dLinesList();
        index = ++maxIndex % v.size();
        if (_debug) {
            System.out.println("index=" + index);
        }
        this._locationList.add(new LocationIndex(location, parameter, index));
        int value = index % v.size();
        if (_debug) {
            System.out.println("value=" + value);
        }
        lineProps = (G2dLineProperties)v.get(value);
        lineProps = lineProps.clone();
        if (!isInstanteous) {
            lineProps.setLineStepStyle(1);
        }
        return lineProps;
    }

    public G2dLineProperties getAlwaysFirstLineProperty(String parameter, String location, String type, boolean isInstanteous, boolean useDataTypeStyles, boolean override) {
        DataType dt;
        G2dLineProperties lineProps = null;
        type = type == null || type.length() == 0 ? INST_VAL : type.toUpperCase();
        if (_debug) {
            System.out.println("getLineProperties: param=" + parameter + " type=" + type + " loc=" + location);
        }
        int index = 0;
        String key = parameter + this.getType(type);
        if (!useDataTypeStyles) {
            if (_debug) {
                System.out.println("getLineProperties: not using line styles for " + parameter);
            }
            dt = this.getUndefinedDataType();
            parameter = "UNDEFINED";
        } else {
            if (_debug) {
                System.out.println("getLineProperties: checking " + key);
            }
            if ((dt = (DataType)_dataTypeTable.get(key)) == null) {
                String allKey = parameter + DSS_TYPES[0].toUpperCase();
                dt = (DataType)_dataTypeTable.get(allKey);
                if (dt == null) {
                    if (_debug) {
                        System.out.println("getLineProperties: checking all " + allKey);
                    }
                    dt = this.getUndefinedDataType();
                    parameter = "UNDEFINED";
                }
                key = allKey;
            }
        }
        if (_debug) {
            System.out.println("getLineProperties: matched (param=" + parameter + " type=" + type + " loc=" + location + ") to key=" + key);
        }
        Vector<LineProperties> v = dt.getG2dLinesList();
        int value = index % v.size();
        if (_debug) {
            System.out.println("value=" + value);
        }
        lineProps = (G2dLineProperties)v.get(value);
        lineProps = lineProps.clone();
        if (!isInstanteous) {
            lineProps.setLineStepStyle(1);
        }
        return lineProps;
    }

    public Vector getDataTypes() {
        Vector v = new Vector(_dataTypeTable.size());
        Enumeration e = _dataTypeTable.elements();
        while (e.hasMoreElements()) {
            v.add(e.nextElement());
        }
        return v;
    }

    public Vector getDataTypes(Vector dcList) {
        if (dcList == null) {
            return null;
        }
        Vector<DataType> v = new Vector<DataType>(dcList.size());
        for (int i = 0; i < dcList.size(); ++i) {
            Object obj = dcList.get(i);
            if (!(obj instanceof DataContainer)) continue;
            v.add(this.getDataType((DataContainer)obj));
        }
        return v;
    }

    public DataType getDataType(G2dObject obj) {
        if (obj instanceof TimeSeriesDataSet) {
            return this.getDataType(((TimeSeriesDataSet)obj)._timeSeries);
        }
        if (obj instanceof G2dDssObject) {
            G2dDssObject data = (G2dDssObject)obj;
            return this.getDataType(data);
        }
        return this.getUndefinedDataType();
    }

    public DataType getDataType(G2dDssObject data) {
        String type;
        String parameter;
        DSSIdentifier dssId = data.getDSSIdentifer();
        if (dssId == null) {
            int parameterId = data.getYParameterId();
            parameter = Parameter.getParamString(parameterId);
            type = INST_VAL;
        } else {
            String dssPath = dssId.getDSSPath();
            Vector<String> dssPaths = DSSPathname.parseDssPath(dssPath);
            parameter = dssPaths.get(2);
            type = dssId.getType();
            if (type == null) {
                type = INST_VAL;
            }
        }
        parameter = parameter.toUpperCase();
        parameter = this.getParameter(parameter);
        String key = parameter + this.getType(type);
        DataType dt = (DataType)_dataTypeTable.get(key);
        if (dt == null && (dt = (DataType)_dataTypeTable.get(key = parameter + DSS_TYPES[0].toUpperCase())) == null) {
            if (_debug) {
                System.out.println("getDataType: no DataType found for " + key + " using defaults");
            }
            return this.getUndefinedDataType();
        }
        return dt;
    }

    public DataType getDataType(DataContainer dc) {
        String type;
        String parameter;
        if (dc instanceof TimeSeriesContainer) {
            TimeSeriesContainer tsc = (TimeSeriesContainer)dc;
            parameter = tsc.parameter.toUpperCase();
            type = this.getType(tsc.type);
        } else if (dc instanceof PairedDataContainer) {
            PairedDataContainer pdc = (PairedDataContainer)dc;
            parameter = pdc.yparameter.toUpperCase();
            type = this.getType(pdc.ytype);
        } else {
            return this.getUndefinedDataType();
        }
        parameter = this.getParameter(parameter);
        if (parameter == null || parameter.length() < 1) {
            return null;
        }
        String key = parameter + type;
        DataType dt = (DataType)_dataTypeTable.get(key);
        if (dt == null && (dt = (DataType)_dataTypeTable.get(key = parameter + DSS_TYPES[0].toUpperCase())) == null) {
            if (_debug) {
                System.out.println("getDataType: no DataType found for " + key + " using defaults");
            }
            return this.getUndefinedDataType();
        }
        return dt;
    }

    private DataType getUndefinedDataType() {
        DataType dt = (DataType)_dataTypeTable.get("UNDEFINED");
        if (dt == null) {
            return UNDEFINED_DATA_TYPE;
        }
        return dt;
    }

    public G2dLine getLine(DataContainer dc) {
        G2dLineProperties lineProps = this.getLineProperties(dc);
        if (lineProps != null) {
            return new G2dLine(lineProps);
        }
        return new G2dLine();
    }

    public String getParameter(String parameter) {
        if (parameter == null) {
            return null;
        }
        parameter = parameter.toUpperCase();
        for (int i = 0; i < this._paramList.size(); ++i) {
            String param = (String)this._paramList.get(i);
            if (!parameter.startsWith(param)) continue;
            if (_debug) {
                System.out.println("getParameter:matched " + parameter + " with " + param);
            }
            return param;
        }
        if (_debug) {
            System.out.println("getParameter:no match for " + parameter);
        }
        return parameter;
    }

    protected String getType(String type) {
        if (type == null || type.length() == 0) {
            return INST_VAL;
        }
        return type.toUpperCase();
    }

    public String getExcessParameter(String parameter) {
        if (parameter == null) {
            return null;
        }
        String param = this.getParameter(parameter);
        if (param.length() != parameter.length()) {
            return parameter.substring(param.length());
        }
        return null;
    }

    protected BufferedReader getFileReader() {
        String plotLinesFile = this.getFileName();
        BufferedReader reader = null;
        if (_debug) {
            System.out.println("readFile:plotLinesFile is " + plotLinesFile);
        }
        try {
            reader = new BufferedReader(new FileReader(plotLinesFile));
        }
        catch (FileNotFoundException nfe) {
            if (_debug) {
                System.out.println("readFile: File Not Found:" + plotLinesFile);
            }
            reader = null;
        }
        return reader;
    }

    protected BufferedWriter getFileWriter() {
        String plotLinesFile = this.getFileName();
        BufferedWriter writer = null;
        if (_debug) {
            System.out.println("writeFile:plotLinesFile is " + plotLinesFile);
        }
        try {
            writer = new BufferedWriter(new FileWriter(plotLinesFile));
        }
        catch (IOException ioe) {
            System.out.println("writeLine: File Not Found:" + plotLinesFile);
            return null;
        }
        return writer;
    }

    public boolean writeFile() {
        BufferedWriter writer = this.getFileWriter();
        boolean error = false;
        Enumeration e = _dataTypeTable.elements();
        while (e.hasMoreElements()) {
            try {
                DataType dataType = (DataType)e.nextElement();
                if (dataType == null || dataType.getFileLocation() != 1) continue;
                if (_debug) {
                    System.out.println("writeFile:writing " + dataType.getName());
                }
                writer.write(BEGIN_DEF);
                writer.newLine();
                DataTypeProperties dataTypeProps = dataType.getProperties();
                dataTypeProps.writeProperties(writer);
                Vector<LineProperties> lineProps = dataType.getG2dLinesList();
                String indent = PropertiesSerializer.getIndent();
                for (int i = 0; i < lineProps.size(); ++i) {
                    G2dLineProperties props = (G2dLineProperties)lineProps.get(i);
                    writer.write(indent + BEGIN_LINE);
                    writer.newLine();
                    props.writeProperties(writer, END_LINE);
                }
                PropertiesSerializer.decrementRecursion();
                writer.write(END_DEF);
                writer.newLine();
                dataType.setModified(false);
            }
            catch (IOException ioe) {
                System.out.println("writeFile:Error Writing " + this.getFileName() + " " + ioe);
                error = true;
                break;
            }
        }
        try {
            if (writer != null) {
                writer.flush();
                writer.close();
            }
        }
        catch (IOException ioe) {
            System.out.println("writeFile:Error Closing " + this.getFileName() + " " + ioe);
        }
        return !error;
    }

    public String getFileName() {
        if (_overrideFile != null) {
            return _overrideFile;
        }
        String dir = System.getProperty("user.home");
        return dir.concat(File.separator).concat(PLOT_LINES_FILE);
    }

    protected boolean readFile() {
        BufferedReader reader = null;
        String jarFile = DEFAULT_PACKAGE + PLOT_LINES_FILE;
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(jarFile);
        if (is != null) {
            try {
                reader = new BufferedReader(new InputStreamReader(is));
                this.readFile(reader, 3);
            }
            catch (Exception e) {
                System.out.println("readFile: Error reading File in Jars:" + jarFile + " " + e);
            }
        } else {
            System.out.println("readFile: File Not Found in Jars:" + jarFile);
        }
        reader = this.getFileReader();
        if (reader == null) {
            return false;
        }
        return this.readFile(reader, 1);
    }

    protected boolean readFile(BufferedReader reader, int loc) {
        try {
            String line;
            if (reader == null) {
                return false;
            }
            G2dLineProperties props = null;
            Object parameter = null;
            DataType dataType = null;
            while ((line = reader.readLine()) != null) {
                double val;
                String param;
                line = line.trim();
                String type = RMAIO.getType(line, "=");
                if (BEGIN_DEF.equalsIgnoreCase(line)) {
                    dataType = new DataType();
                    dataType.setFileLocation(loc);
                    continue;
                }
                if (BEGIN_LINE.equalsIgnoreCase(type)) {
                    if (dataType == null) continue;
                    param = RMAIO.getParam(line, "=");
                    if (param != null && param.length() > 0) {
                        param = param.toUpperCase();
                        Vector<LineProperties> v = dataType.getG2dLinesList();
                        for (int i = 0; i < v.size(); ++i) {
                            G2dLineProperties p = (G2dLineProperties)v.get(i);
                            if (!p.getName().equals(param)) continue;
                            props = p;
                            break;
                        }
                    } else {
                        props = null;
                    }
                    props = this.readLineDef(reader, props);
                    dataType.addG2dLineProperties(props);
                    continue;
                }
                if (END_DEF.equalsIgnoreCase(line)) {
                    if (dataType != null) {
                        DataType dt = (DataType)_dataTypeTable.get(dataType.getKey());
                        if (_debug) {
                            System.out.println("readFile:" + loc + " adding " + dataType.getKey());
                        }
                        if (dt != null) {
                            if (_debug) {
                                System.out.println("readFile:" + loc + " found override for " + dataType.getKey());
                            }
                            _dataTypeTable.remove(dataType.getKey());
                        }
                        if (_debug) {
                            System.out.println("readFile: adding key=" + dataType.getKey() + " Value=" + dataType);
                        }
                        _dataTypeTable.put(dataType.getKey(), dataType);
                    }
                    dataType = null;
                    continue;
                }
                if (dataType == null) continue;
                param = RMAIO.getParam(line, "=");
                if (PARAMETER.equalsIgnoreCase(type)) {
                    dataType.setParameter(param);
                    continue;
                }
                if (NAME.equalsIgnoreCase(type)) {
                    dataType.setName(param);
                    continue;
                }
                if (YAXIS_REVERSED.equalsIgnoreCase(type)) {
                    dataType.setYAxisReversed("true".equalsIgnoreCase(param));
                    continue;
                }
                if (DSS_TYPE.equals(type)) {
                    dataType.setDSSType(param.toUpperCase());
                    continue;
                }
                if (USE_DEFAULT_MAX.equals(type)) {
                    double val2 = RMAIO.parseDouble(param);
                    if (val2 == Double.NEGATIVE_INFINITY) continue;
                    dataType.setHasDefaultMaxAxisValue(true);
                    dataType.setDefaultMaxAxisValue(val2);
                    continue;
                }
                if (USE_DEFAULT_MIN.equals(type)) {
                    double val3 = RMAIO.parseDouble(param);
                    if (val3 == Double.NEGATIVE_INFINITY) continue;
                    dataType.setHasDefaultMinAxisValue(true);
                    dataType.setDefaultMinAxisValue(val3);
                    continue;
                }
                if (!USE_VIEWPORT_WEIGHT.equalsIgnoreCase(type) || !((val = RMAIO.parseDouble(param)) > 0.0) || !RMAConst.isValidValue(val)) continue;
                dataType.setHasViewportWeight(true);
                dataType.setViewportWeight(val);
            }
            reader.close();
        }
        catch (IOException ioe) {
            System.out.println("readLines; IOException " + ioe);
            return false;
        }
        return true;
    }

    private G2dLineProperties readLineDef(BufferedReader reader, G2dLineProperties lp) throws IOException {
        G2dLineProperties props = lp != null ? new G2dLineProperties(lp) : new G2dLineProperties();
        props.readProperties(reader, END_LINE);
        return props;
    }

    private void fillParamList() {
        this._paramList.clear();
        Enumeration e = _dataTypeTable.keys();
        Object[] keys = new Object[_dataTypeTable.size()];
        int[] lens = new int[_dataTypeTable.size()];
        int i = 0;
        while (e.hasMoreElements()) {
            String key = ((String)e.nextElement()).toUpperCase();
            keys[i] = this.fixParam(key);
            lens[i] = ((String)keys[i]).length();
            ++i;
        }
        RMASort.quickSort(lens, keys, false);
        for (i = 0; i < keys.length; ++i) {
            this._paramList.add(keys[i]);
        }
        if (_debug) {
            System.out.println("fillParamList:ParamList is now:");
            for (i = 0; i < this._paramList.size(); ++i) {
                System.out.println(this._paramList.get(i));
            }
        }
    }

    private String fixParam(String param) {
        for (int i = 0; i < DSS_TYPES.length; ++i) {
            if (!param.endsWith(DSS_TYPES[i].toUpperCase())) continue;
            return param.substring(0, param.length() - DSS_TYPES[i].length());
        }
        return param;
    }

    public void addDataType(String parameter, String name, String dssType, boolean yAxisReversed, int numLines) {
        String type;
        if (parameter == null) {
            throw new NullPointerException("Parameter is null");
        }
        if (name == null) {
            throw new NullPointerException("Name is null");
        }
        if (numLines < 0) {
            numLines = 1;
        }
        parameter = parameter.toUpperCase();
        String key = (name = name.toUpperCase()) + (type = this.getType(dssType));
        DataType dataType = (DataType)_dataTypeTable.get(key);
        if (dataType == null) {
            boolean lineIdx = true;
            dataType = new DataType(name);
            dataType.setFileLocation(1);
            dataType.setParameter(parameter);
            dataType.setDSSType(dssType);
            dataType.setYAxisReversed(yAxisReversed);
            for (int i = 0; i < numLines; ++i) {
                G2dLineProperties props = new G2dLineProperties();
                props.setName(String.valueOf(i + 1));
                dataType.addG2dLineProperties(props);
            }
            if (_debug) {
                System.out.println("addDataType: adding key=" + dataType.getKey() + " Value=" + dataType);
            }
            _dataTypeTable.put(dataType.getKey(), dataType);
            this.fillParamList();
            return;
        }
        Vector<LineProperties> lineProps = dataType.getG2dLinesList();
        dataType.setFileLocation(1);
        for (int i = 0; i < numLines; ++i) {
            G2dLineProperties props = new G2dLineProperties();
            props.setName(String.valueOf(lineProps.size() + 1));
            dataType.addG2dLineProperties(props);
        }
    }

    protected static boolean isInstanteous(String type) {
        if (type != null) {
            type.toUpperCase();
            return type.startsWith(INST_VAL.substring(0, 5)) || type.length() == 0;
        }
        return false;
    }

    public static void setDefaultPackage(String newPackage) {
        DEFAULT_PACKAGE = newPackage;
    }

    public static void setOverrideFile(String file) {
        _overrideFile = file;
    }

    static {
        DataTypeFactory.init();
    }
}

