/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.data.Parameter;
import hec.geometry.LocalPt;
import hec.geometry.Scale;
import hec.gfx2d.G2dGlyph;
import hec.gfx2d.G2dLine;
import hec.gfx2d.G2dObject;
import hec.gfx2d.Viewport;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Observable;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class DefaultG2dGlyph
extends G2dGlyph {
    private boolean mFirstPaint = true;

    public DefaultG2dGlyph(Viewport view, G2dObject map, Scale scl) {
        super(view, map, scl);
    }

    @Override
    public void draw(Graphics g) {
        G2dObject obj = this.getG2dObject();
        Rectangle rect = this.getVisibleRect();
        for (int i = 0; i < this._lineArray.length; ++i) {
            this._lineArray[i].clearLineData();
        }
        double[] xarray = new double[10000];
        double[] yarray = new double[10000];
        for (int yIdx = 0; yIdx < obj.getCurveCount(); ++yIdx) {
            int icnt = 0;
            double[] dataXArray = obj.getXValues();
            double[] dataYArray = obj.getYValues(yIdx);
            for (int xIdx = 0; xIdx < dataXArray.length; ++xIdx) {
                if (!RMAConst.isValidValue(dataXArray[xIdx]) || !RMAConst.isValidValue(dataYArray[xIdx]) || obj.getXAxisType() == 3 && dataXArray[xIdx] <= 0.0 || obj.getYAxisType() == 3 && dataYArray[xIdx] <= 0.0) {
                    if (icnt <= 0) continue;
                    this._lineArray[yIdx].addLineData(xarray, yarray, icnt);
                    icnt = 0;
                    continue;
                }
                int xdivisor = 1;
                int ydivisor = 1;
                if (obj.getXParameterId() == Parameter.PARAMID_PERCENT && obj.getXAxisType() == 4) {
                    xdivisor = 100;
                }
                if (obj.getYParameterId() == Parameter.PARAMID_PERCENT && obj.getYAxisType() == 4) {
                    ydivisor = 100;
                }
                if (obj.swapXYValues()) {
                    yarray[icnt] = dataXArray[xIdx] / (double)xdivisor;
                    xarray[icnt] = dataYArray[xIdx] / (double)ydivisor;
                } else {
                    xarray[icnt] = dataXArray[xIdx] / (double)xdivisor;
                    yarray[icnt] = dataYArray[xIdx] / (double)ydivisor;
                }
                if (++icnt < 10000) continue;
                this._lineArray[yIdx].addLineData(xarray, yarray, icnt);
                icnt = 0;
            }
            this._lineArray[yIdx].addLineData(xarray, yarray, icnt);
        }
        for (int i = 0; i < this._lineArray.length; ++i) {
            G2dLine line = this._lineArray[i];
            this._lineArray[i].drawLine(g, rect);
        }
        this.mFirstPaint = false;
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        if (e == null) {
            return null;
        }
        LocalPt pt = new LocalPt(e.getX(), e.getY());
        for (int i = 0; i < this._lineArray.length; ++i) {
            LocalPt rpt;
            if (!this._lineArray[i].contains(pt) || (rpt = this._lineArray[i].getNearestDataPt(pt)) == null) continue;
            String xval = RMAIO.setPrecision2(this._scale.getAxis(0).l2w(rpt.x), 2);
            String yval = RMAIO.setPrecision2(this._scale.getAxis(1).l2w(rpt.y), 2);
            return new String("[" + xval + "," + yval + "]");
        }
        return null;
    }

    @Override
    public void update(Observable o, Object arg) {
        G2dObject obj = this.getG2dObject();
        if ("reset data".equals(arg) && this._lineArray.length != obj.getCurveCount()) {
            this._lineArray = new G2dLine[obj.getCurveCount()];
            this.buildLineArray();
        }
        super.update(o, arg);
    }

    @Override
    public boolean isCurveDrawn(int curveNumber) {
        return true;
    }
}

