/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.gfx2d.AbstractPlotDefaults;
import hec.gfx2d.AxisLabelDrawProp;
import hec.gfx2d.AxisTicsDrawProp;
import hec.gfx2d.G2dLabelDrawProp;
import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.G2dMarkerProperties;
import hec.gfx2d.G2dPanelProp;
import hec.gfx2d.LegendPanelProp;
import hec.gfx2d.PlotDefaults;
import hec.gfx2d.PlotDefaultsManager;
import hec.gfx2d.TitleDrawProp;
import hec.gfx2d.ViewportDrawProp;
import hec.lang.Logger;
import hec.lang.PreferencesConstants;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class DefaultPlotDefaults
extends AbstractPlotDefaults
implements PreferencesConstants {
    private static final String DEFAULTS_DIRECTORY_KEY = "plot.defaults.home";
    static Map STATIC_DEFAULTS;

    public DefaultPlotDefaults() {
        if (STATIC_DEFAULTS == null) {
            STATIC_DEFAULTS = new HashMap();
        }
        this.m_plotDefaultsTable = STATIC_DEFAULTS;
    }

    @Override
    public boolean loadPlotComponentDefaults(Class plotCompClass) {
        if (plotCompClass == null) {
            return false;
        }
        String fileName = PlotDefaultsManager.getFileName(plotCompClass);
        if (fileName == null || fileName.length() == 0) {
            if (Logger.canDebug("plotDefaults")) {
                System.out.println("loadPlotComponentDefaults:No default properties file returned for " + plotCompClass);
            }
            return false;
        }
        try {
            String dir = System.getProperty(DEFAULTS_DIRECTORY_KEY);
            dir = dir.concat(File.separator).concat(fileName);
            File file = new File(dir);
            if (Logger.canDebug("plotDefaults")) {
                System.out.println("loadPlotComponentDefaults:File " + dir);
            }
            if (!file.exists()) {
                return false;
            }
            BufferedReader reader = new BufferedReader(new FileReader(dir));
            if (reader == null) {
                System.out.println("loadPlotComponentDefaults:Failed to get Reader for " + dir);
                return false;
            }
            return DefaultPlotDefaults.loadDefaults(reader, plotCompClass);
        }
        catch (FileNotFoundException nfe) {
            return false;
        }
    }

    @Override
    public BufferedWriter getBufferedWriter(Class plotCompClass) {
        String fileName = PlotDefaultsManager.getFileName(plotCompClass);
        BufferedWriter writer = null;
        String dir = System.getProperty(DEFAULTS_DIRECTORY_KEY);
        File f_dir = new File(dir);
        if (!f_dir.exists()) {
            f_dir.mkdirs();
        }
        dir = dir.concat(File.separator).concat(fileName);
        if (Logger.canDebug("plotDefaults")) {
            System.out.println("getBufferedWriter:File " + dir);
        }
        try {
            writer = new BufferedWriter(new FileWriter(dir));
        }
        catch (IOException ioe) {
            System.out.println("getBufferedWriter:IOException " + ioe);
            return null;
        }
        if (writer == null) {
            System.out.println("getBufferedWriter:Failed to get Writer for " + fileName);
            return null;
        }
        return writer;
    }

    static {
        if (STATIC_DEFAULTS == null) {
            STATIC_DEFAULTS = new HashMap();
        }
        if (System.getProperty(DEFAULTS_DIRECTORY_KEY) == null) {
            String user_dir = System.getProperty("user.home");
            System.setProperty(DEFAULTS_DIRECTORY_KEY, user_dir + File.separator + ".gfx2d");
        }
        PlotDefaults oldDefaults = PlotDefaultsManager.getDefaults();
        STATIC_DEFAULTS.putAll(PROGRAM_DEFAULTS);
        DefaultPlotDefaults defaults = new DefaultPlotDefaults();
        PlotDefaultsManager.setDefaults(defaults);
        defaults.loadPlotComponentDefaults(G2dLabelDrawProp.class);
        defaults.loadPlotComponentDefaults(G2dLabelDrawProp.class);
        defaults.loadPlotComponentDefaults(AxisLabelDrawProp.class);
        defaults.loadPlotComponentDefaults(AxisTicsDrawProp.class);
        defaults.loadPlotComponentDefaults(LegendPanelProp.class);
        defaults.loadPlotComponentDefaults(G2dPanelProp.class);
        defaults.loadPlotComponentDefaults(TitleDrawProp.class);
        defaults.loadPlotComponentDefaults(ViewportDrawProp.class);
        defaults.loadPlotComponentDefaults(G2dLineProperties.class);
        defaults.loadPlotComponentDefaults(G2dMarkerProperties.class);
        STATIC_DEFAULTS.putAll(PlotDefaultsManager.getDefaults().getDefaultsTable());
        PlotDefaultsManager.setDefaults(oldDefaults);
    }
}

