/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.gfx2d.AxisLabel;
import hec.gfx2d.AxisLabelDrawProp;
import hec.gfx2d.AxisTics;
import hec.gfx2d.AxisTicsDrawProp;
import hec.gfx2d.G2dAxisLabelPropertiesPanel;
import hec.gfx2d.G2dAxisPropertiesPanel;
import hec.gfx2d.G2dDefaultLinesPropPanel;
import hec.gfx2d.G2dLabelDrawProp;
import hec.gfx2d.G2dLineMarkerPropertiesPanel;
import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.G2dMarkerProperties;
import hec.gfx2d.G2dMiscPropertiesPanel;
import hec.gfx2d.G2dPanelProp;
import hec.gfx2d.G2dPatternPropertiesPanel;
import hec.gfx2d.G2dTitlePropertiesPanel;
import hec.gfx2d.G2dViewportPropertiesPanel;
import hec.gfx2d.LegendPanelProp;
import hec.gfx2d.LegendPropertiesPanel;
import hec.gfx2d.TitleDrawProp;
import hec.gfx2d.ViewportDrawProp;
import hec.gfx2d.action.ExportPlotDefaults;
import hec.gfx2d.action.ImportPlotDefaults;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.DefaultJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDialog;
import rma.swing.list.RmaListModel;

public class DefaultPlotPropertiesDialog
extends RmaJDialog {
    private G2dLineProperties _lineProps = new G2dLineProperties();
    private ViewportDrawProp _viewportProps = new ViewportDrawProp();
    private TitleDrawProp _titleProps = new TitleDrawProp();
    private AxisLabelDrawProp _axisLabelProps = new AxisLabelDrawProp();
    private AxisTicsDrawProp _axisTicsProps = new AxisTicsDrawProp();
    private G2dPanelProp _panelProps = new G2dPanelProp();
    private G2dLabelDrawProp _labelProps = new G2dLabelDrawProp();
    private G2dMarkerProperties _markerProps = new G2dMarkerProperties();
    private LegendPanelProp _legendProps = new LegendPanelProp();
    private boolean _canceled;
    private JTabbedPane _tabbedPane;
    private ButtonCmdPanel _cmdPanel;
    private G2dDefaultLinesPropPanel _linesPanel;
    private G2dViewportPropertiesPanel _viewPortPanel;
    private G2dTitlePropertiesPanel _titlePanel;
    private PropPanel _axisPanel;
    private PropPanel _markerPanel;
    private G2dMiscPropertiesPanel _miscPanel;
    private G2dAxisLabelPropertiesPanel _axisLabelPanel;
    private G2dAxisPropertiesPanel _axisTicsPanel;
    private G2dPatternPropertiesPanel _labelPanel;
    private G2dLineMarkerPropertiesPanel _markerLinePanel;
    private LegendPropertiesPanel _legendPanel;

    public DefaultPlotPropertiesDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.buildControls();
        this.fillForm();
    }

    protected void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Default Plot Properties");
        this._tabbedPane = new JTabbedPane();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this._tabbedPane, gbc);
        this._axisLabelPanel = new G2dAxisLabelPropertiesPanel();
        this._axisTicsPanel = new G2dAxisPropertiesPanel();
        DefaultJPanel[] axisPanels = new DefaultJPanel[]{this._axisLabelPanel, this._axisTicsPanel};
        this._axisPanel = new PropPanel(axisPanels, false, "Axis:");
        this._axisPanel.setName("Axis");
        this._axisPanel.setTabEnabled(this._axisLabelPanel, true);
        this._axisPanel.setTabEnabled(this._axisTicsPanel, true);
        this._markerLinePanel = new G2dLineMarkerPropertiesPanel();
        this._markerLinePanel.setLabelTextVisible(false);
        this._markerLinePanel.setMarkerValuePanelVisible(false);
        DefaultJPanel[] markerPanels = new DefaultJPanel[]{this._markerLinePanel};
        this._markerPanel = new PropPanel(markerPanels, false, "Marker Lines:");
        this._markerPanel.setTabEnabled(this._markerLinePanel, true);
        this._linesPanel = new G2dDefaultLinesPropPanel();
        this._viewPortPanel = new G2dViewportPropertiesPanel();
        this._titlePanel = new G2dTitlePropertiesPanel();
        this._miscPanel = new G2dMiscPropertiesPanel();
        this._miscPanel.setSetToCurrentButtonVisible(true);
        this._labelPanel = new G2dPatternPropertiesPanel();
        this._legendPanel = new LegendPropertiesPanel();
        this._tabbedPane.addTab("Curves", this._linesPanel);
        this._tabbedPane.addTab("Viewport", this._viewPortPanel);
        this._tabbedPane.addTab("Title", this._titlePanel);
        this._tabbedPane.addTab(this._axisPanel.getName(), this._axisPanel);
        this._tabbedPane.addTab("Legend", this._legendPanel);
        this._tabbedPane.addTab("Marker Lines", this._markerPanel);
        this._tabbedPane.addTab("Layout", this._miscPanel);
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.anchor = 16;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        this.getContentPane().add((Component)buttonPanel, gbc);
        this._cmdPanel = new ButtonCmdPanel(14);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 16;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this._cmdPanel, gbc);
        JButton _exportButton = new JButton("Export...");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.anchor = 13;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(5, 5, 5, 5);
        buttonPanel.add((Component)_exportButton, gbc);
        _exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    new ExportPlotDefaults().run();
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(DefaultPlotPropertiesDialog.this, ex.getMessage(), "Error", 0);
                }
            }
        });
        JButton _importButton = new JButton("Import...");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.anchor = 13;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(5, 5, 5, 5);
        buttonPanel.add((Component)_importButton, gbc);
        _importButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int results = new ImportPlotDefaults().run();
                    if (results != 0) {
                        return;
                    }
                    DefaultPlotPropertiesDialog.this._lineProps = new G2dLineProperties();
                    DefaultPlotPropertiesDialog.this._viewportProps = new ViewportDrawProp();
                    DefaultPlotPropertiesDialog.this._titleProps = new TitleDrawProp();
                    DefaultPlotPropertiesDialog.this._axisLabelProps = new AxisLabelDrawProp();
                    DefaultPlotPropertiesDialog.this._axisTicsProps = new AxisTicsDrawProp();
                    DefaultPlotPropertiesDialog.this._panelProps = new G2dPanelProp();
                    DefaultPlotPropertiesDialog.this._labelProps = new G2dLabelDrawProp();
                    DefaultPlotPropertiesDialog.this._markerProps = new G2dMarkerProperties();
                    DefaultPlotPropertiesDialog.this._legendProps = new LegendPanelProp();
                    DefaultPlotPropertiesDialog.this.fillForm();
                    DefaultPlotPropertiesDialog.this.repaint();
                    JOptionPane.showMessageDialog(DefaultPlotPropertiesDialog.this, "Defaults Imported Successfully.", "Message", 1);
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(DefaultPlotPropertiesDialog.this, ex.getMessage(), "Error", 0);
                }
            }
        });
        this._cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            @Override
            public void buttonCmdActionPerformed(ActionEvent e) {
                switch (e.getID()) {
                    case 8: {
                        if (!DefaultPlotPropertiesDialog.this.saveForm()) break;
                        DefaultPlotPropertiesDialog.this._canceled = false;
                        DefaultPlotPropertiesDialog.this.setVisible(false);
                        break;
                    }
                    case 2: {
                        DefaultPlotPropertiesDialog.this.saveForm();
                        DefaultPlotPropertiesDialog.this.setModified(false);
                        break;
                    }
                    case 4: {
                        DefaultPlotPropertiesDialog.this._canceled = true;
                        DefaultPlotPropertiesDialog.this.setVisible(false);
                    }
                }
            }
        });
        this.pack();
        this.setLocation();
    }

    protected boolean saveForm() {
        if (this._linesPanel.isModified()) {
            this._linesPanel.savePanel();
            G2dLineProperties.setDefaults(this._lineProps);
            this._linesPanel.setModified(false);
            G2dLineProperties.writeDefaults();
            LegendPanelProp.writeDefaults();
        }
        if (this._axisLabelPanel.isModified()) {
            this._axisLabelPanel.savePanel();
            AxisLabelDrawProp.setDefaults(this._axisLabelProps);
            AxisLabelDrawProp.writeDefaults();
            this._axisLabelPanel.setModified(false);
        }
        if (this._axisTicsPanel.isModified()) {
            this._axisTicsPanel.savePanel();
            AxisTicsDrawProp.setDefaults(this._axisTicsProps);
            AxisTicsDrawProp.writeDefaults();
            this._axisTicsPanel.setModified(false);
        }
        if (this._viewPortPanel.isModified()) {
            this._viewPortPanel.savePanel();
            ViewportDrawProp.setDefaults(this._viewportProps);
            ViewportDrawProp.writeDefaults();
            this._viewPortPanel.setModified(false);
        }
        if (this._titlePanel.isModified()) {
            this._titlePanel.savePanel();
            TitleDrawProp.setDefaults(this._titleProps);
            DefaultPlotPropertiesDialog defaultPlotPropertiesDialog = this;
            defaultPlotPropertiesDialog._titleProps.writeDefaults();
            this._titlePanel.setModified(false);
        }
        if (this._miscPanel.isModified()) {
            this._miscPanel.savePanel();
            G2dPanelProp.setDefaults(this._panelProps);
            G2dPanelProp.writeDefaults();
            this._miscPanel.setModified(false);
        }
        if (this._labelPanel.isModified()) {
            this._labelPanel.savePanel();
            G2dLabelDrawProp.setDefaults(this._labelProps);
            G2dLabelDrawProp.writeDefaults();
            this._labelPanel.setModified(false);
        }
        if (this._markerLinePanel.isModified()) {
            this._markerLinePanel.savePanel();
            G2dMarkerProperties.setDefaults(this._markerProps);
            G2dMarkerProperties.writeDefaults();
            this._markerLinePanel.setModified(false);
        }
        if (this._legendPanel.isModified()) {
            this._legendPanel.savePanel();
            LegendPanelProp.setDefaults(this._legendProps);
            LegendPanelProp.writeDefaults();
            this._legendPanel.setModified(false);
        }
        return true;
    }

    protected void fillForm() {
        this._linesPanel.setData(this._lineProps, this._legendProps);
        this._viewPortPanel.setData(this._viewportProps);
        this._titlePanel.setData(this._titleProps);
        this._axisLabelPanel.setData(this._axisLabelProps);
        this._axisTicsPanel.setData(this._axisTicsProps);
        this._labelPanel.setData(this._labelProps);
        this._miscPanel.setData(this._panelProps);
        this._markerLinePanel.setData(this._markerProps, TimeZone.getDefault());
        this._legendPanel.setData(this._legendProps);
        this._linesPanel.fillPanel();
        this._viewPortPanel.fillPanel();
        this._axisLabelPanel.fillPanel();
        this._axisTicsPanel.fillPanel();
        this._titlePanel.fillPanel();
        this._miscPanel.fillPanel();
        this._labelPanel.fillPanel();
        this._markerLinePanel.fillPanel();
        this._legendPanel.fillPanel();
        this._linesPanel.setModified(false);
        this._viewPortPanel.setModified(false);
        this._axisLabelPanel.setModified(false);
        this._axisTicsPanel.setModified(false);
        this._titlePanel.setModified(false);
        this._miscPanel.setModified(false);
        this._labelPanel.setModified(false);
        this._markerLinePanel.setModified(false);
        this._legendPanel.setModified(false);
        this.setModified(false);
    }

    public static void main(String[] args) {
        DefaultPlotPropertiesDialog defaultPlotPropertiesDialog1 = new DefaultPlotPropertiesDialog(new Frame(), true);
        defaultPlotPropertiesDialog1.setVisible(true);
    }

    private class PropPanel
    extends DefaultJPanel
    implements ItemListener {
        private JTabbedPane _tabPane;
        protected RmaJComboBox _selecter;
        private DefaultJPanel _panel;

        PropPanel(DefaultJPanel[] panels, boolean hasSelecter, String selecterLabel) {
            this.buildControls(panels, hasSelecter, selecterLabel);
        }

        protected void buildControls(DefaultJPanel[] panels, boolean hasSelecter, String selecterLabel) {
            GridBagConstraints gbc;
            this.setLayout(new GridBagLayout());
            int gridY = 0;
            if (hasSelecter) {
                JLabel label = new JLabel(selecterLabel);
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = gridY;
                gbc.gridwidth = 1;
                gbc.anchor = 18;
                gbc.fill = 0;
                gbc.insets = RmaInsets.insets(5, 5, 0, 5);
                this.add((Component)label, gbc);
                this._selecter = new RmaJComboBox(new RmaListModel(false));
                gbc = new GridBagConstraints();
                gbc.gridx = 1;
                gbc.gridy = gridY++;
                gbc.gridwidth = 1;
                gbc.weightx = 1.0;
                gbc.anchor = 18;
                gbc.fill = 2;
                gbc.insets = RmaInsets.insets(5, 5, 0, 5);
                this.add((Component)this._selecter, gbc);
                this._selecter.addItemListener(this);
            }
            if (panels.length > 1) {
                this._tabPane = new JTabbedPane();
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = gridY;
                gbc.gridwidth = gridY + 1;
                gbc.weightx = 1.0;
                gbc.weighty = 1.0;
                gbc.anchor = 18;
                gbc.fill = 2;
                gbc.insets = RmaInsets.insets(5, 5, 0, 5);
                this.add((Component)this._tabPane, gbc);
                for (int i = 0; i < panels.length; ++i) {
                    this._tabPane.addTab(panels[i].getName(), panels[i]);
                    panels[i].setEnabled(false);
                }
            } else {
                this._panel = panels[0];
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = gridY;
                gbc.gridwidth = gridY + 1;
                gbc.weightx = 1.0;
                gbc.weighty = 1.0;
                gbc.anchor = 18;
                gbc.fill = 2;
                gbc.insets = RmaInsets.insets(5, 5, 0, 5);
                this.add((Component)panels[0], gbc);
            }
        }

        void setTabEnabled(Component c2, boolean enabled) {
            if (this._tabPane != null) {
                for (int i = 0; i < this._tabPane.getTabCount(); ++i) {
                    Component tab = this._tabPane.getComponentAt(i);
                    if (tab != c2) continue;
                    this._tabPane.setEnabledAt(i, enabled);
                    c2.setEnabled(enabled);
                    if (this._tabPane.getSelectedIndex() != i) continue;
                    if (enabled) {
                        return;
                    }
                    while (!this._tabPane.isEnabledAt(i)) {
                        i = (i + 1) % this._tabPane.getTabCount();
                    }
                    this._tabPane.setSelectedIndex(i);
                    break;
                }
            } else if (c2 == this._panel) {
                this._panel.setEnabled(enabled);
            }
        }

        void setData(Vector items) {
            if (this._selecter == null) {
                return;
            }
            ((RmaListModel)this._selecter.getModel()).clear();
            ((RmaListModel)this._selecter.getModel()).addAll(items);
        }

        public int getSelecterItemCount() {
            return this._selecter.getModel().getSize();
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (this._selecter == null) {
                return;
            }
            if (e.getStateChange() == 2) {
                this.selecterComboDeselected();
            } else {
                this.setIgnoreModifiedEvents(true);
                if (this._selecter != null) {
                    boolean enabled;
                    boolean bl = enabled = this._selecter.getSelectedItem() != null;
                    if (this._tabPane != null) {
                        for (int i = 0; i < this._tabPane.getTabCount(); ++i) {
                            this._tabPane.getComponentAt(i).setEnabled(enabled);
                        }
                    }
                }
                this.selecterComboSelected();
                this.setIgnoreModifiedEvents(false);
            }
        }

        protected void selecterComboSelected() {
        }

        protected void selecterComboDeselected() {
        }
    }

    class AxisContainer {
        private String[] axisToString = new String[]{"X1", "X2", "Y1", "Y2"};
        AxisLabel label;
        AxisTics tics;
        int axis;

        AxisContainer(int axis) {
            this.axis = axis;
        }

        public String toString() {
            return this.axisToString[this.axis];
        }
    }
}

