/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.gfx2d.G2dDialog;
import hec.gfx2d.G2dGlyph;
import hec.gfx2d.G2dGlyphDrawProp;
import hec.gfx2d.G2dObject;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dPanelProp;
import hec.gfx2d.PlotLayout;
import hec.gfx2d.PopupPlotCreator;
import hec.gfx2d.Viewport;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class DefaultPopupPlotCreator
implements PopupPlotCreator {
    public boolean isValidDataToPlot(G2dPanel plotPanel) {
        Vector plotObjects = plotPanel.getPlotObjects();
        return plotObjects != null && plotObjects.size() > 0;
    }

    @Override
    public G2dDialog createPopupPlot(G2dPanel plotPanel) {
        Window w = SwingUtilities.windowForComponent(plotPanel);
        if (w instanceof G2dDialog) {
            return (G2dDialog)w;
        }
        if (!this.isValidDataToPlot(plotPanel)) {
            Container parent = w == null ? plotPanel : w;
            JOptionPane.showMessageDialog(parent, "There are no data to plot.", "Message", 2);
            return null;
        }
        G2dDialog dialog = null;
        PlotLayout pl = plotPanel.getPlotLayout();
        if (pl != null) {
            dialog = this.createG2dDialog(null, "", false, pl);
        } else {
            Vector<G2dObject> plotObjects;
            Vector colorVec = this.getLineStyles();
            G2dPanelProp prop = (G2dPanelProp)plotPanel.getProperties().getClone();
            if (colorVec != null) {
                plotObjects = this.getPlotObjects(plotPanel);
                dialog = this.createG2dDialog(null, "", false, plotObjects, colorVec);
                dialog.initDialog(plotObjects, colorVec, prop);
            } else {
                Viewport[] viewports;
                plotObjects = new Vector<G2dObject>();
                Vector lineStyles = new Vector();
                for (Viewport viewport : viewports = plotPanel.getViewports()) {
                    Vector glyphs = viewport.getGlyphVector();
                    for (Object glyph : glyphs) {
                        G2dGlyph g2dGlyph = (G2dGlyph)glyph;
                        G2dObject g2dObject = g2dGlyph.getG2dObject();
                        if (g2dObject == null) continue;
                        plotObjects.add(g2dObject);
                        ArrayList tempLineStyle = new ArrayList();
                        G2dGlyphDrawProp properties = g2dGlyph.getProperties();
                        tempLineStyle.addAll(properties.lineProperties);
                        while (tempLineStyle.size() < g2dObject.getCurveCount()) {
                            tempLineStyle.add(null);
                        }
                        lineStyles.addAll(tempLineStyle);
                    }
                }
                prop.toolbarProp = G2dPanel.createDefaultToolbarProperties();
                prop.hasToolbar = true;
                prop.hasLegend = true;
                dialog = this.createG2dDialog(null, "", false);
                dialog.initialize(plotObjects, lineStyles, prop);
            }
        }
        Viewport[] thumbViewports = plotPanel.getViewports();
        Viewport[] popupViewports = dialog.getPlotpanel().getViewports();
        block3: for (int i = 0; thumbViewports != null && i < thumbViewports.length; ++i) {
            for (int z = 0; popupViewports != null && z < popupViewports.length; ++z) {
                String popupScaleName = popupViewports[z].getScale().getName();
                if (!thumbViewports[i].getScale().getName().equalsIgnoreCase(popupScaleName)) continue;
                popupViewports[z].setAxisMarkers(thumbViewports[i].getAxisMarkers());
                continue block3;
            }
        }
        dialog.setLocationRelativeTo(w);
        String title = plotPanel.getTitle();
        if (title != null) {
            dialog.setTitle(title);
        }
        return dialog;
    }

    protected G2dDialog createG2dDialog(Frame frame, String title, boolean modal) {
        return new G2dDialog(frame, title, modal);
    }

    protected G2dDialog createG2dDialog(Frame frame, String title, boolean modal, Vector plotObjects, Vector colorVec) {
        return new G2dDialog(frame, title, modal, plotObjects, colorVec);
    }

    protected G2dDialog createG2dDialog(Frame frame, String title, boolean modal, PlotLayout pl) {
        return new G2dDialog(frame, title, modal, pl);
    }

    protected Vector getPlotObjects(G2dPanel plotPanel) {
        return plotPanel.getPlotObjects();
    }

    protected Vector getLineStyles() {
        return null;
    }
}

