/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.gfx2d.G2dGlyph;
import hec.gfx2d.G2dObject;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dResolutionConst;
import hec.gfx2d.LegendItem;
import hec.gfx2d.Viewport;
import hec.gfx2d.ViewportDrawProp;
import hec.gfx2d.ViewportLegendRenderer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Vector;

public class DefaultVeiwportLegendRenderer
implements ViewportLegendRenderer {
    @Override
    public void drawLegend(Graphics2D g, G2dPanel g2dPanel, Viewport viewport) {
        G2dGlyph glyph;
        int i;
        int g2dResolution = viewport.getG2dPanel().getDeviceResoultion();
        int scl = g2dResolution / G2dResolutionConst.PRINTER_SCALE;
        Graphics2D g2 = (Graphics2D)g.create();
        Dimension dim1 = new Dimension(25 * scl, 20 * scl);
        Rectangle rect = viewport.getBounds();
        Vector glyphList = viewport.getGlyphVector();
        int xoffset = 0;
        int idir = 1;
        int maxLIwidth = 0;
        int maxHeight = 0;
        if (glyphList == null || glyphList.size() == 0) {
            return;
        }
        ViewportDrawProp drawProperties = viewport._drawProp;
        for (i = 0; i < glyphList.size(); ++i) {
            glyph = (G2dGlyph)glyphList.get(i);
            G2dObject g2dObject = glyph.getG2dObject();
            LegendItem li = null;
            if (g2dPanel.getLegendPanel() != null) {
                li = g2dPanel.getLegendPanel().getLegendItem(g2dObject);
            }
            if (li == null) {
                li = new LegendItem((G2dPanel)viewport.getParent(), glyph, 0);
            }
            Dimension dim2 = li.label.getPreferredSize();
            if (maxLIwidth < dim2.width) {
                maxLIwidth = dim2.width;
            }
            maxHeight += dim2.height;
        }
        maxLIwidth += dim1.width;
        maxLIwidth += 10;
        maxHeight += 10;
        if (drawProperties.drawViewportLegendAlign != null && drawProperties.drawViewportLegendAlign.equalsIgnoreCase("RIGHT")) {
            xoffset = rect.width - maxLIwidth;
            g2.translate(xoffset, 0);
            idir = -1;
        }
        g2.translate(15 * scl * idir, 12 * scl);
        g2.setColor(Color.white);
        g2.fillRect(0, 0, maxLIwidth, maxHeight);
        g2.setColor(Color.black);
        g2.drawRect(0, 0, maxLIwidth, maxHeight);
        g2.drawRect(1, 1, maxLIwidth - 2, maxHeight - 2);
        g2.translate(5 * scl, 5 * scl);
        for (i = 0; i < glyphList.size(); ++i) {
            glyph = (G2dGlyph)glyphList.get(i);
            LegendItem li = null;
            if (g2dPanel.getLegendPanel() != null) {
                li = g2dPanel.getLegendPanel().getLegendItem(glyph.getG2dObject());
            }
            if (li == null) {
                li = new LegendItem((G2dPanel)viewport.getParent(), glyph, 0);
            }
            li.pict.setBackground(Color.WHITE);
            li.pict.setSize(dim1);
            li.pict.setBounds(0, 0, dim1.width, dim1.height);
            Dimension dim2 = li.label.getPreferredSize();
            li.label.setSize(dim2);
            li.label.setBounds(dim1.width, 0, dim2.width, dim2.height);
            li.pict.print(g2);
            g2.translate(dim1.width, 0);
            li.label.setBackground(Color.WHITE);
            li.label.paintGfx(g2);
            g2.translate(-dim1.width, 0);
            g2.translate(0, li.label.getPreferredSize().height);
        }
        g2.dispose();
    }
}

