/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.data.DataSetIllegalArgumentException;
import hec.data.Parameter;
import hec.data.Units;
import hec.gfx2d.dss.LocalDSSTimeSeriesCollection;
import hec.heclib.util.Unit;
import hec.io.DSSIdentifier;
import hec.io.TimeSeriesCollectionContainer;
import hec.io.TimeSeriesContainer;
import java.util.ArrayList;

public class DssVueSimpleDSSTimeSeriesCollection
extends LocalDSSTimeSeriesCollection {
    public DssVueSimpleDSSTimeSeriesCollection(TimeSeriesCollectionContainer colCont) {
        super(new DSSIdentifier(colCont.fileName, colCont.fullName), new ArrayList<String>());
        if (!DssVueSimpleDSSTimeSeriesCollection.collectionHasSomeData(colCont)) {
            throw new IllegalArgumentException("The TimeSeriesCollectionContainer is empty");
        }
        this._dssCollectionArray = colCont;
        this.load();
    }

    private static boolean collectionHasSomeData(TimeSeriesCollectionContainer collection) {
        for (int i = 0; i < collection.size(); ++i) {
            TimeSeriesContainer tsc = collection.get(i);
            if (tsc.numberValues <= 0 || tsc.values == null || tsc.values.length <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public void load() {
        double dy;
        if (this._dssCollectionArray == null) {
            return;
        }
        String[] sequences = this._dssCollectionArray.getSequences();
        this._max = this.getMax();
        this._min = this.getMin();
        this._median = this.getMedian();
        this._p25 = this.getP25();
        this._p75 = this.getP75();
        this._dssCollectionArray.add(this._max);
        this._dssCollectionArray.add(this._min);
        this._dssCollectionArray.add(this._median);
        this._dssCollectionArray.add(this._p25);
        this._dssCollectionArray.add(this._p75);
        TimeSeriesContainer[] tsContainers = this._dssCollectionArray.get();
        this.ydata = new double[tsContainers.length][tsContainers[0].values.length];
        for (int i = 0; i < tsContainers.length; ++i) {
            TimeSeriesContainer tsc = tsContainers[i];
            if (i == 0) {
                this._timeArray.array = tsc.times;
                this.tdata = tsc.times;
            }
            this.ydata[i] = tsc.values;
        }
        this.ytype = this._dssCollectionArray.get()[0].type;
        this.numberValues = this._dssCollectionArray.get()[0].numberValues;
        this.startIdx = 0;
        this.endIdx = this.tdata.length - 1;
        for (int ii = 0; ii < this.tdata.length; ++ii) {
            dy = this.ydata[0][ii];
            if (dy == -3.4028234663852886E38 || dy == -4.9E-324 || dy == Double.NEGATIVE_INFINITY) continue;
            this.startIdx = ii;
            break;
        }
        for (int r = this.tdata.length - 1; r >= 0; --r) {
            dy = this.ydata[0][r];
            if (dy == -3.4028234663852886E38 || dy == -4.9E-324 || dy == Double.NEGATIVE_INFINITY) continue;
            this.endIdx = r;
            break;
        }
        this.yunits = this._dssCollectionArray.get((int)0).units;
        this.ytype = this._dssCollectionArray.get((int)0).type;
        if (this.yunits.equalsIgnoreCase("FEET")) {
            this.yunits = "ft";
        }
        if (Units.getUnitsForAlias(this.yunits) != null) {
            this.yunits = Units.getUnitsForAlias(this.yunits);
        }
        if (this._dssCollectionArray.get((int)0).timeZoneID != null && !this._dssCollectionArray.get((int)0).timeZoneID.equals("")) {
            super.setGmtOffset(this._dssCollectionArray.get((int)0).timeZoneRawOffset / 3600000);
        }
        try {
            Parameter param = new Parameter(this._dssCollectionArray.get((int)0).parameter);
            int paramId = param.getParameterId();
            if (paramId != -1) {
                this.setYParameterId(paramId);
            }
        }
        catch (DataSetIllegalArgumentException e) {
            System.out.println("--------------------------------------------------------------------------");
            System.out.println("Invalid Parameter in SimpleDSSTimeSeries.load() " + e.getMessage());
            System.out.println("Will continue using UNDEFINED parameter");
            System.out.println("--------------------------------------------------------------------------");
        }
        String units = Units.getUnitsForAlias(this._dssCollectionArray.get((int)0).units);
        if (units != null) {
            int i;
            String[] unitsList = Unit.getUnitsForSystem("English");
            boolean foundInEnglish = false;
            for (i = 0; unitsList != null && i < unitsList.length; ++i) {
                if (!unitsList[i].equalsIgnoreCase(units)) continue;
                this.setUnitSystem(1);
                foundInEnglish = true;
                break;
            }
            if (!foundInEnglish) {
                unitsList = Unit.getUnitsForSystem("SI");
                for (i = 0; unitsList != null && i < unitsList.length; ++i) {
                    if (!unitsList[i].equalsIgnoreCase(units)) continue;
                    this.setUnitSystem(2);
                    break;
                }
            }
        }
        this.setLoaded(true);
    }

    @Override
    public String getYAxisName() {
        if (this.getUnitSystem() == 0 || this.getYParameterId() == -1) {
            if ((this.yunits == null || this.yunits.length() < 1 || this.yunits.equalsIgnoreCase("undef")) && this._dssCollectionArray.get(0) != null) {
                return this._dssCollectionArray.get((int)0).parameter;
            }
            return this.yunits;
        }
        Object parameterdString = Parameter.getParamString(this.getYParameterId());
        if (DssVueSimpleDSSTimeSeriesCollection.useDisplayUnits()) {
            parameterdString = (String)parameterdString + " (%S) ";
        } else {
            String units = null;
            units = Units.getUnitsForAlias(this._dssCollectionArray.get((int)0).units);
            if (units == null) {
                units = this._dssCollectionArray.get((int)0).units;
            }
            parameterdString = (String)parameterdString + " (" + units + ")";
        }
        return parameterdString;
    }
}

