/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.gfx2d.LabelLayoutConstants;
import hec.gfx2d.LabelPropertiesPanel;
import hec.gfx2d.components.CheckBoxPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import rma.swing.EnabledJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;

public class G2dAxisLabelPropertiesPanel
extends LabelPropertiesPanel
implements LabelLayoutConstants {
    private CheckBoxPanel _showLabelPanel;
    private JSeparator _topSep;
    private JLabel _paramLabel;
    private JPanel _parameterPanel;
    private RmaJComboBox _alignCombo;
    private EnabledJPanel _alignPanel;

    @Override
    protected void buildControls() {
        super.buildControls();
        this.setName("Axis Label");
        this._showLabelPanel = new CheckBoxPanel("Show Axis Label");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this._showLabelPanel, gbc);
        this._topSep = new JSeparator();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this._topSep, gbc);
        this._parameterPanel = new EnabledJPanel(new GridBagLayout());
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this._parameterPanel, gbc);
        JLabel label = new JLabel("Parameter:");
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this._parameterPanel.add((Component)label, gbc);
        this._paramLabel = new JLabel("");
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this._parameterPanel.add((Component)this._paramLabel, gbc);
        this._alignPanel = new EnabledJPanel(new GridBagLayout());
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.weightx = 0.5;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this._alignPanel, gbc);
        label = new JLabel("Alignment:");
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this._alignPanel.add((Component)label, gbc);
        this._alignCombo = new RmaJComboBox<String>(LabelLayoutConstants.LABEL_ALIGN_NAMES);
        this._alignCombo.setModifiable(true);
        label.setLabelFor(this._alignCombo);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this._alignPanel.add((Component)this._alignCombo, gbc);
        this.setAllLabelsCheckVisible(false);
    }

    @Override
    protected void addListeners() {
        super.addListeners();
        this._showLabelPanel.addComponentPanel(this);
    }

    @Override
    public void setComponentsEnabled(boolean enabled) {
        super.setComponentsEnabled(enabled);
        this._parameterPanel.setEnabled(enabled);
        this._alignPanel.setEnabled(enabled);
    }

    @Override
    public void fillPanel() {
        if (this._properties == null) {
            return;
        }
        super.fillPanel();
        if (this._properties.align == 1) {
            this._alignCombo.setSelectedItem("Center");
        } else if (this._properties.align == 0) {
            this._alignCombo.setSelectedItem("Left");
        } else if (this._properties.align == 2) {
            this._alignCombo.setSelectedItem("Right");
        }
        this._showLabelPanel.setSelected(this._properties.showLabel);
    }

    @Override
    public boolean savePanel() {
        if (this._properties == null) {
            return true;
        }
        super.savePanel();
        this._properties.showLabel = this._showLabelPanel.isSelected();
        Object selectedItem = this._alignCombo.getSelectedItem();
        if ("Center".equals(selectedItem)) {
            this._properties.setAlign(1);
        } else if ("Right".equals(selectedItem)) {
            this._properties.setAlign(2);
        } else if ("Left".equals(selectedItem)) {
            this._properties.setAlign(0);
        }
        return true;
    }

    public void setLabelText(String text) {
        if (text == null) {
            this.setText("");
            this.setSampleText("Sample Text");
            return;
        }
        this.setText(text);
        this.setSampleText(text);
    }

    public String getLabelText() {
        return this.getText();
    }

    public void setParameterText(String text) {
        if (text == null) {
            this._paramLabel.setText("");
            return;
        }
        this._paramLabel.setText(text);
    }
}

