/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.gfx2d.AxisProperties;
import hec.gfx2d.AxisTicsDrawProp;
import hec.gfx2d.SamplePanel;
import hec.gfx2d.components.CheckBoxPanel;
import hec.gfx2d.components.ComponentPanel;
import hec.gfx2d.components.FontPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;
import rma.swing.DefaultJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJColorComboBox;

public class G2dAxisPropertiesPanel
extends DefaultJPanel {
    Object[] _customColor = new Object[]{Color.white, "custom"};
    JColorChooser _colorChooser;
    JPanel jTickMarkPanel = new JPanel(new GridBagLayout());
    RmaJCheckBox jMajorTicMarkCheckBox = new RmaJCheckBox("Use major tick marks");
    RmaJCheckBox jMinorTicMarkCheckBox = new RmaJCheckBox("Use minor tick marks");
    RmaJColorComboBox jColorCombo = new RmaJColorComboBox();
    JLabel jColorLabel = new JLabel("Tic Color");
    private AxisProperties _properties = null;
    private CheckBoxPanel _showMajorTicLabelsCheck;
    private FontPanel _majorTicLabelFontPanel;
    private SamplePanel _majorTicLabelSamplePanel;
    private TicLabelsPanel _majorTicLabelsPanel;
    private TicLabelsPanel _minorTicLabelsPanel;
    private CheckBoxPanel _showMinorTicLabelsCheck;
    private FontPanel _minorTicLabelFontPanel;
    private SamplePanel _minorTicLabelSamplePanel;

    public G2dAxisPropertiesPanel() {
        super(new GridBagLayout());
        this.setName("Tics");
        this.add((Component)this.jTickMarkPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jTickMarkPanel.add((Component)this.jMajorTicMarkCheckBox, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 0, RmaInsets.insets(5, 5, 0, 5), 0, 0));
        this.jTickMarkPanel.add((Component)this.jMinorTicMarkCheckBox, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 18, 0, RmaInsets.insets(5, 5, 0, 5), 0, 0));
        this.jTickMarkPanel.add((Component)this.jColorLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 1.0, 18, 0, RmaInsets.insets(5, 5, 5, 0), 0, 0));
        this.jTickMarkPanel.add((Component)this.jColorCombo, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 18, 0, RmaInsets.insets(5, 5, 5, 5), 0, 0));
        this.jMajorTicMarkCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.jMinorTicMarkCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.jTickMarkPanel.setBorder(new TitledBorder("Tick Marks"));
        this.jColorCombo.setModifiable(true);
        JTabbedPane ticsTabbedPane = new JTabbedPane();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)ticsTabbedPane, gbc);
        this._majorTicLabelsPanel = new TicLabelsPanel();
        ticsTabbedPane.add("Major Tics", this._majorTicLabelsPanel);
        this._showMajorTicLabelsCheck = new CheckBoxPanel("Show Tic Labels");
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this._majorTicLabelsPanel.add((Component)this._showMajorTicLabelsCheck, gbc);
        this._majorTicLabelFontPanel = new FontPanel(null);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.01;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS5505;
        this._majorTicLabelsPanel.add((Component)this._majorTicLabelFontPanel, gbc);
        this._majorTicLabelSamplePanel = new SamplePanel();
        this._majorTicLabelSamplePanel.setSampleText("1000");
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS5505;
        this._majorTicLabelsPanel.add((Component)this._majorTicLabelSamplePanel, gbc);
        this._majorTicLabelFontPanel.setSamplePanel(this._majorTicLabelSamplePanel);
        this._showMajorTicLabelsCheck.addComponentPanel(this._majorTicLabelsPanel);
        this._showMajorTicLabelsCheck.setSelected(false);
        this.jMajorTicMarkCheckBox.addActionListener(this);
        this._majorTicLabelsPanel.setComponentsEnabled(this._showMajorTicLabelsCheck.isSelected());
        this._minorTicLabelsPanel = new TicLabelsPanel();
        ticsTabbedPane.add("Minor Tics", this._minorTicLabelsPanel);
        this._showMinorTicLabelsCheck = new CheckBoxPanel("Show Tic Labels");
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this._minorTicLabelsPanel.add((Component)this._showMinorTicLabelsCheck, gbc);
        this._minorTicLabelFontPanel = new FontPanel(null);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.01;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS5505;
        this._minorTicLabelsPanel.add((Component)this._minorTicLabelFontPanel, gbc);
        this._minorTicLabelSamplePanel = new SamplePanel();
        this._minorTicLabelSamplePanel.setSampleText("1000");
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS5505;
        this._minorTicLabelsPanel.add((Component)this._minorTicLabelSamplePanel, gbc);
        this._minorTicLabelFontPanel.setSamplePanel(this._minorTicLabelSamplePanel);
        this._showMinorTicLabelsCheck.addComponentPanel(this._minorTicLabelsPanel);
        this._showMinorTicLabelsCheck.setSelected(false);
        this.jMinorTicMarkCheckBox.addActionListener(this);
        this._minorTicLabelsPanel.setComponentsEnabled(this._showMinorTicLabelsCheck.isSelected());
        Dimension d = this.getPreferredSize();
        this.setSize(d);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
    }

    public void setData(AxisProperties ap) {
        this._properties = ap;
    }

    @Override
    public void fillPanel() {
        if (this._properties == null) {
            return;
        }
        this.jColorCombo.removeActionListener(this);
        this.jMajorTicMarkCheckBox.setSelected(this._properties.showMajorTics());
        this.jMinorTicMarkCheckBox.setSelected(this._properties.showMinorTics());
        if (this._properties instanceof AxisTicsDrawProp) {
            AxisTicsDrawProp props = (AxisTicsDrawProp)this._properties;
            this._majorTicLabelFontPanel.setSelectedFont(props.getMajorTicFont());
            this._majorTicLabelFontPanel.setFontColor(props.axisTicColor);
            this._majorTicLabelFontPanel.setUseFontScaling(props.useMajorTicFontScaling());
            this._majorTicLabelFontPanel.setMinScalingSize(props.getMajorTicMinFontSize());
            this._majorTicLabelFontPanel.setMaxScalingSize(props.getMajorTicMaxFontSize());
            this._showMajorTicLabelsCheck.setSelected(this._properties.showMajorTicLabels());
            this._majorTicLabelsPanel.setVisible(true);
            this.jColorCombo.setVisible(false);
            this.jColorLabel.setVisible(false);
            GridBagLayout layout = (GridBagLayout)this.jTickMarkPanel.getLayout();
            GridBagConstraints gbc = layout.getConstraints(this.jMinorTicMarkCheckBox);
            gbc.weighty = 1.0;
            layout.setConstraints(this.jMinorTicMarkCheckBox, gbc);
            this._showMinorTicLabelsCheck.setSelected(props.showMinorTicLabels());
            this._minorTicLabelFontPanel.setSelectedFont(props.getMinorTicFont());
            this._minorTicLabelFontPanel.setFontColor(props.axisTicColor);
            this._minorTicLabelFontPanel.setUseFontScaling(props.useMinorTicFontScaling());
            this._minorTicLabelFontPanel.setMinScalingSize(props.getMinorTicMinFontSize());
            this._minorTicLabelFontPanel.setMaxScalingSize(props.getMinorTicMaxFontSize());
        } else {
            this._majorTicLabelsPanel.setVisible(false);
            this._minorTicLabelsPanel.setVisible(false);
        }
        Color c2 = this._properties.getAxisTicColor();
        this.jColorCombo.setSelectedColor(c2);
        this._majorTicLabelsPanel.setComponentsEnabled(this._showMajorTicLabelsCheck.isSelected());
    }

    public void refresh() {
    }

    @Override
    public boolean savePanel() {
        if (this._properties == null) {
            return true;
        }
        this._properties.setShowMajorTics(this.jMajorTicMarkCheckBox.isSelected());
        this._properties.setShowMinorTics(this.jMinorTicMarkCheckBox.isSelected());
        this._properties.setAxisTicColor(this.jColorCombo.getSelectedColor());
        if (this._properties instanceof AxisTicsDrawProp) {
            AxisTicsDrawProp props = (AxisTicsDrawProp)this._properties;
            props.setMajorTicFont(this._majorTicLabelFontPanel.getSelectedFont());
            props.axisTicColor = this._majorTicLabelFontPanel.getFontColor();
            props.setUseMajorTicFontScaling(this._majorTicLabelFontPanel.useFontScaling());
            props.setMajorTicMinFontSize(this._majorTicLabelFontPanel.getMinScalingSize());
            props.setMajorTicMaxFontSize(this._majorTicLabelFontPanel.getMaxScalingSize());
            this._properties.setShowMajorTicLabels(this._showMajorTicLabelsCheck.isSelected());
            this._properties.setShowMinorTicLabels(this._showMinorTicLabelsCheck.isSelected());
            props.setUseMinorTicFontScaling(this._minorTicLabelFontPanel.useFontScaling());
            props.setMinorTicFont(this._minorTicLabelFontPanel.getSelectedFont());
            props.minorTicLabelColor = this._minorTicLabelFontPanel.getFontColor();
            props.setMinorTicMinFontSize(this._minorTicLabelFontPanel.getMinScalingSize());
            props.setMinorTicMaxFontSize(this._minorTicLabelFontPanel.getMaxScalingSize());
        }
        return true;
    }

    private class TicLabelsPanel
    extends JPanel
    implements ComponentPanel {
        public TicLabelsPanel() {
            super(new GridBagLayout());
            this.setBorder(BorderFactory.createTitledBorder("Tic Labels"));
        }

        @Override
        public void setComponentsEnabled(boolean enabled) {
            G2dAxisPropertiesPanel.this._majorTicLabelFontPanel.setEnabled(enabled);
            G2dAxisPropertiesPanel.this._majorTicLabelSamplePanel.setEnabled(enabled);
        }
    }
}

