/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.gfx2d.G2dFillPatternRenderer;
import hec.gfx2d.components.CheckBoxPanel;
import hec.gfx2d.components.ComponentPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import rma.swing.DefaultJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJColorComboBox;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJSpinner;

public class G2dBackgroundPropertiesPanel
extends DefaultJPanel
implements ChangeListener,
ComponentPanel {
    private static final int MAX_ALPHA_RANGE = 100;
    Object[] customColor = new Object[]{Color.white, "Custom"};
    JColorChooser _colorChooser;
    JPanel _samplePanel = null;
    CheckBoxPanel checkBoxPanel = new CheckBoxPanel("Draw Background");
    RmaJColorComboBox jColorCombo = new RmaJColorComboBox();
    RmaJComboBox fillPatternCombo = new RmaJComboBox();
    JLabel jColorLabel = new JLabel("Color:");
    JLabel jFillPatternLabel = new JLabel("Pattern:");
    JButton jFillButton = new JButton("Fill Effects ...");
    JLabel jAlphaLabel = new JLabel("Transparency:");
    RmaJSpinner jTransparencySpinner = new RmaJSpinner(new SpinnerNumberModel(50, 0, 100, 1));

    public G2dBackgroundPropertiesPanel() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.checkBoxPanel, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 18, 2, RmaInsets.insets(0, 5, 0, 5), 0, 0));
        this.add((Component)this.jColorLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 2, RmaInsets.insets(5, 15, 0, 0), 0, 0));
        this.add((Component)this.jColorCombo, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 18, 2, RmaInsets.insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.fillPatternCombo, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 18, 2, RmaInsets.insets(5, 5, 0, 5), 0, 2));
        this.add((Component)this.jFillPatternLabel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 2, RmaInsets.insets(5, 15, 0, 5), 0, 0));
        this.add((Component)this.jAlphaLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 2, RmaInsets.insets(5, 15, 5, 5), 0, 0));
        this.add((Component)this.jTransparencySpinner, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 18, 2, RmaInsets.insets(5, 5, 5, 0), 0, 0));
        this.jColorCombo.setSelectedColor(Color.blue);
        this.jFillButton.setEnabled(false);
        this.jAlphaLabel.setEnabled(false);
        this.fillPatternCombo.setEnabled(false);
        DefaultComboBoxModel<Object> comboModel = new DefaultComboBoxModel<Object>(new Object[]{new Integer(0), new Integer(1), new Integer(2), new Integer(4), new Integer(3), new Integer(5), new Integer(6)});
        this.fillPatternCombo.setModel(comboModel);
        this.fillPatternCombo.setRenderer(new G2dFillPatternRenderer());
        this.checkBoxPanel.addComponentPanel(this);
        this.fillPatternCombo.addActionListener(this);
        this.jColorCombo.addActionListener(this);
        this.jTransparencySpinner.addChangeListener(this);
        Dimension d = this.getPreferredSize();
        this.setSize(d);
        this.jColorCombo.setModifiable(true);
        this.fillPatternCombo.setModifiable(true);
        this.setComponentsEnabled(this.checkBoxPanel.isSelected());
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object obj = e.getSource();
        if (obj == this.jTransparencySpinner) {
            this.updateSamplePanel();
        }
    }

    private void updateSamplePanel() {
        if (this._samplePanel != null) {
            this._samplePanel.repaint();
        }
        this.setModified(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj == this.jColorCombo) {
            this.colorCombo_ActionPerfomred();
        } else if (obj == this.fillPatternCombo) {
            this.fillPatternCombo_ActionPerformed();
        }
    }

    private void fillPatternCombo_ActionPerformed() {
        if (this._samplePanel != null) {
            this._samplePanel.repaint();
        }
    }

    private void colorCombo_ActionPerfomred() {
        Object[] item = (Object[])this.jColorCombo.getSelectedItem();
        if (item == null) {
            return;
        }
        if (item == this.customColor) {
            JDialog dlg = JColorChooser.createDialog(this, "Choose A Color", true, this.getColorChooser(), new customColorOKListener(), null);
            dlg.setVisible(true);
        }
        ((G2dFillPatternRenderer)this.fillPatternCombo.getRenderer()).setColor((Color)item[0]);
        this.fillPatternCombo.repaint();
        if (this._samplePanel != null) {
            this._samplePanel.repaint();
        }
    }

    @Override
    public void setComponentsEnabled(boolean enabled) {
        this.jColorLabel.setEnabled(enabled);
        this.jColorCombo.setEnabled(enabled);
        this.fillPatternCombo.setEnabled(enabled);
        this.jFillPatternLabel.setEnabled(enabled);
        this.jAlphaLabel.setEnabled(enabled);
        this.jTransparencySpinner.setEnabled(enabled);
        if (this._samplePanel != null) {
            this._samplePanel.repaint();
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.checkBoxPanel.setEnabled(enabled);
        if (!enabled) {
            this.setComponentsEnabled(enabled);
        } else {
            this.setComponentsEnabled(this.checkBoxPanel.isSelected());
        }
    }

    public Color getBackgroundColor() {
        Object[] item = (Object[])this.jColorCombo.getSelectedItem();
        return (Color)item[0];
    }

    public void setBackgroundColor(Color c2) {
        if (c2 == null) {
            return;
        }
        this.jColorCombo.removeActionListener(this);
        boolean found = false;
        Object[] colorObj = null;
        DefaultComboBoxModel cm = (DefaultComboBoxModel)this.jColorCombo.getModel();
        for (int i = 0; i < this.jColorCombo.getItemCount(); ++i) {
            colorObj = (Object[])cm.getElementAt(i);
            if (!((Color)colorObj[0]).equals(c2)) continue;
            found = true;
            break;
        }
        if (!found) {
            colorObj[0] = c2;
        }
        this.jColorCombo.setSelectedItem(colorObj);
        ((G2dFillPatternRenderer)this.fillPatternCombo.getRenderer()).setColor((Color)colorObj[0]);
        if (this._samplePanel != null) {
            this._samplePanel.repaint();
        }
        this.jColorCombo.addActionListener(this);
    }

    public void setBackgroundFill(int i) {
        this.fillPatternCombo.setSelectedItem(new Integer(i));
    }

    public float getAlpha() {
        return 1.0f - (float)((Integer)this.jTransparencySpinner.getValue()).intValue() / 100.0f;
    }

    public void setAlpha(float alpha) {
        int value = (int)((1.0f - alpha) * 100.0f);
        this.jTransparencySpinner.setValue(value);
    }

    public int getBackgroundFill() {
        return (Integer)this.fillPatternCombo.getSelectedItem();
    }

    public void setCustomEnabled(boolean enabled) {
        this.checkBoxPanel.setSelected(enabled);
    }

    public boolean isCustomEnabled() {
        return this.checkBoxPanel.isSelected();
    }

    @Override
    public void fillPanel() {
    }

    public void refresh() {
    }

    @Override
    public boolean savePanel() {
        return false;
    }

    public void setSamplePanel(JPanel s) {
        this._samplePanel = s;
    }

    private JColorChooser getColorChooser() {
        if (this._colorChooser == null) {
            this._colorChooser = new JColorChooser();
        }
        return this._colorChooser;
    }

    class customColorOKListener
    implements ActionListener {
        customColorOKListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            G2dBackgroundPropertiesPanel.this.customColor[0] = G2dBackgroundPropertiesPanel.this.getColorChooser().getColor();
            G2dBackgroundPropertiesPanel.this.jColorCombo.repaint();
            G2dBackgroundPropertiesPanel.this.repaint();
        }
    }
}

