/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.beans.ConstructorProperties;
import javax.swing.border.AbstractBorder;
import rma.util.RmaDrawConst;

public class G2dBorder
extends AbstractBorder {
    protected int thickness;
    protected Color lineColor;
    protected boolean roundedCorners;
    protected float[] borderStyle;

    public G2dBorder(Color color) {
        this(color, 1, RmaDrawConst.SOLID_STYLE_PATTERN);
    }

    public G2dBorder(Color color, int thickness) {
        this(color, thickness, RmaDrawConst.SOLID_STYLE_PATTERN);
    }

    @ConstructorProperties(value={"lineColor", "thickness", "borderStyle"})
    public G2dBorder(Color color, int thickness, float[] borderStyle) {
        this.lineColor = color;
        this.thickness = thickness;
        this.borderStyle = borderStyle;
    }

    @Override
    public void paintBorder(Component c2, Graphics g, int x, int y, int width, int height) {
        if (this.thickness > 0 && g instanceof Graphics2D) {
            RectangularShape outer;
            Graphics2D g2d = (Graphics2D)g;
            Color oldColor = g2d.getColor();
            g2d.setColor(this.lineColor);
            int offs = this.thickness;
            int size = offs + offs;
            if (this.roundedCorners) {
                float arc = 0.2f * (float)offs;
                outer = new RoundRectangle2D.Float(x, y, width, height, offs, offs);
            } else {
                outer = new Rectangle2D.Float(x + offs / 2, y + offs / 2, width - offs, height - offs);
            }
            BasicStroke bs = new BasicStroke(this.thickness, 0, 0, 10.0f, this.borderStyle, 0.0f);
            g2d.setStroke(bs);
            Path2D.Float path = new Path2D.Float(0);
            path.append(outer, false);
            g2d.draw(path);
            g2d.setColor(oldColor);
        }
    }

    @Override
    public Insets getBorderInsets(Component c2, Insets insets) {
        insets.set(this.thickness, this.thickness, this.thickness, this.thickness);
        return insets;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public int getThickness() {
        return this.thickness;
    }

    public boolean getRoundedCorners() {
        return this.roundedCorners;
    }

    @Override
    public boolean isBorderOpaque() {
        return !this.roundedCorners;
    }

    public float[] getBorderStyle() {
        return this.borderStyle;
    }

    public void setBorderStyle(float[] borderStyle) {
        this.borderStyle = borderStyle;
    }
}

