/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.geometry.LocalPt;
import hec.gfx2d.G2dMouseAdapter;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dToolbarListener;
import hec.gfx2d.PreferredSizeProvider;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class G2dComponent
extends JPanel
implements G2dToolbarListener {
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int TOP = 2;
    public static final int BOTTOM = 3;
    protected G2dPanel _parent = null;
    int _alignment = 0;
    protected JPopupMenu _popupMenu;
    G2dMouseAdapter _mouseAdapter = null;
    PreferredSizeProvider _preferredSizeProvider = new DefaultPreferredSizeProvider();

    public G2dComponent() {
        this.createPopupMenu();
    }

    public G2dComponent(G2dPanel p) {
        this();
        this._parent = p;
    }

    public void setG2dPanel(G2dPanel p) {
        this._parent = p;
    }

    public void createPopupMenu() {
    }

    public G2dPanel getG2dPanel() {
        return this._parent;
    }

    public void setPreferredSizeProvider(PreferredSizeProvider preferredSizeProvider) {
        this._preferredSizeProvider = preferredSizeProvider;
    }

    public Dimension getPreferredSizeLocal() {
        return super.getPreferredSize();
    }

    @Override
    public final Dimension getPreferredSize() {
        return this._preferredSizeProvider.getPreferredSize();
    }

    @Override
    public void paint(Graphics g) {
        if (this._parent != null && !this._parent.isPaintEnabled()) {
            return;
        }
        super.paint(g);
    }

    @Override
    protected void paintComponent(Graphics arg0) {
        super.paintComponent(arg0);
        this.paintGfx(arg0);
    }

    public void paintGfx() {
        Dimension dim = this.getSize();
        this.paintImmediately(0, 0, dim.width, dim.height);
    }

    public void paintGfx(Graphics g) {
    }

    public boolean objectPopupMenu(LocalPt pt, int modifiers) {
        return false;
    }

    public void pointerOver(LocalPt pt) {
    }

    public void editProperties() {
        System.out.println("G2dComponent EditProperties()");
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        return null;
    }

    @Override
    public void setMouseAdapter(String className) {
        if (className == null) {
            this.setMouseAdapter((G2dMouseAdapter)null);
            this.setCursor(Cursor.getDefaultCursor());
            return;
        }
        G2dMouseAdapter adapter = null;
        try {
            Class<?> adapterClass = Thread.currentThread().getContextClassLoader().loadClass(className);
            Constructor<?> constructor = null;
            Constructor<?>[] cparamConstructor = adapterClass.getDeclaredConstructors();
            boolean tf = true;
            for (int i = 0; cparamConstructor != null && i < cparamConstructor.length; ++i) {
                constructor = cparamConstructor[i];
                Class<?>[] cparamClasses = cparamConstructor[i].getParameterTypes();
                for (int j = 0; cparamClasses != null && j < cparamClasses.length; ++j) {
                    if (cparamClasses[j].isAssignableFrom(this.getClass())) continue;
                    tf = false;
                    break;
                }
                if (tf) break;
            }
            if (!tf) {
                this.setMouseAdapter((G2dMouseAdapter)null);
                this.setCursor(Cursor.getDefaultCursor());
                return;
            }
            Object[] cparam = new Object[]{this, this};
            if (constructor != null) {
                adapter = (G2dMouseAdapter)constructor.newInstance(cparam);
            }
        }
        catch (InvocationTargetException e) {
            boolean expected = false;
            Throwable cause = e.getCause();
            if (cause instanceof HeadlessException) {
                expected = GraphicsEnvironment.isHeadless();
            }
            if (!expected) {
                Logger.getLogger(G2dComponent.class.getName()).log(Level.WARNING, "Unable to load Mouse Adapter: " + className, e);
            }
        }
        catch (Exception e) {
            Logger.getLogger(G2dComponent.class.getName()).log(Level.WARNING, "Unable to load Mouse Adapter: " + className, e);
        }
        if (adapter != null) {
            this.setMouseAdapter(adapter);
        }
    }

    @Override
    public G2dMouseAdapter setMouseAdapter(G2dMouseAdapter adapter) {
        if (this._mouseAdapter != null) {
            this._mouseAdapter.abort();
            this.removeMouseListener(this._mouseAdapter);
            this.removeMouseMotionListener(this._mouseAdapter);
            this.removeMouseWheelListener(this._mouseAdapter);
        }
        if (adapter != null) {
            adapter.init();
            this.addMouseListener(adapter);
            this.addMouseMotionListener(adapter);
            this.addMouseWheelListener(adapter);
            this.setCursor(adapter.getCursor());
        }
        G2dMouseAdapter oldadapter = this._mouseAdapter;
        this._mouseAdapter = adapter;
        return oldadapter;
    }

    @Override
    public G2dMouseAdapter getMouseAdapter() {
        return this._mouseAdapter;
    }

    public int getAlignment() {
        return this._alignment;
    }

    protected class DefaultPreferredSizeProvider
    implements PreferredSizeProvider {
        protected DefaultPreferredSizeProvider() {
        }

        @Override
        public Dimension getPreferredSize() {
            return G2dComponent.this.getPreferredSizeLocal();
        }
    }

    public class EditPropertyListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            G2dComponent.this.editProperties();
        }
    }
}

