/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.dataTable.HecDataTableFrame;
import hec.gfx2d.DataTypeEditor;
import hec.gfx2d.DataTypeFactory;
import hec.gfx2d.DefaultPlotPropertiesDialog;
import hec.gfx2d.EditTabFrame;
import hec.gfx2d.G2dData;
import hec.gfx2d.G2dGlyph;
import hec.gfx2d.G2dGlyphDrawProp;
import hec.gfx2d.G2dLabel;
import hec.gfx2d.G2dLine;
import hec.gfx2d.G2dObject;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dPanelProp;
import hec.gfx2d.G2dPlotProp;
import hec.gfx2d.G2dTitle;
import hec.gfx2d.G2dWMFGraphics2D;
import hec.gfx2d.GhostGlassPane;
import hec.gfx2d.LayoutPlotDialog;
import hec.gfx2d.LegendPanel;
import hec.gfx2d.LegendPanelViewMenuFactory;
import hec.gfx2d.LineProperties;
import hec.gfx2d.Margin;
import hec.gfx2d.PageSetupJDialog;
import hec.gfx2d.PairedDataSet;
import hec.gfx2d.PlotLayout;
import hec.gfx2d.PlotPropertiesDialog;
import hec.gfx2d.PlotSpecification;
import hec.gfx2d.PrintMultipleJDialog;
import hec.gfx2d.PrintProperties;
import hec.gfx2d.SavePlotSpecificationDialog;
import hec.gfx2d.SimpleJTableData;
import hec.gfx2d.TabulateObjectProvider;
import hec.gfx2d.TimeSeriesDataSet;
import hec.gfx2d.TimeWindowPlotData;
import hec.gfx2d.Viewport;
import hec.gfx2d.ViewportDrawProp;
import hec.gfx2d.autoload.AutoLoadManager;
import hec.gfx2d.autoload.RefreshCookie;
import hec.gfx2d.dss.G2dDssObject;
import hec.gfx2d.dss.G2dDssPairedData;
import hec.gfx2d.dss.G2dDssTimeSeries;
import hec.gfx2d.dss.G2dDssTimeSeriesCollection;
import hec.heclib.dss.HecDataConversion;
import hec.heclib.util.stringContainer;
import hec.hecmath.HecMath;
import hec.io.DataContainer;
import hec.io.PairedDataContainer;
import hec.io.TimeSeriesCollectionContainer;
import hec.io.TimeSeriesContainer;
import hec.lang.ClientAppCheck;
import hec.model.RunTimeWindow;
import hec.refresh.RefreshEvent;
import hec.refresh.RefreshListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.SimpleDoc;
import javax.print.StreamPrintService;
import javax.print.StreamPrintServiceFactory;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PrintQuality;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import rma.services.ServiceLookup;
import rma.swing.PrintPreview;
import rma.swing.RmaColor;
import rma.swing.RmaJFrame;
import rma.util.RMAConst;
import rma.util.RMAFilenameFilter;
import rma.util.RMAIO;
import rma.util.RMAUtil;
import rma.util.wmf.WMF;
import rma.util.wmf.WMFUtil;

public class G2dDialog
extends RmaJFrame
implements ActionListener,
Pageable,
Printable,
RefreshListener {
    static DataTypeEditor _dataTypeEditor;
    public static final int XSIZE = 600;
    public static final int YSIZE = 500;
    boolean _noInitialize = false;
    private static final int TITLE_OFFSET = 50;
    private static List<WindowListener> _dialogListenerList;
    private static WindowListener _windowListener;
    private static Vector _openDialogs;
    private static PrintMultipleJDialog _printMultipleDlg;
    private static SavePlotSpecificationDialog _saveSpecDlg;
    protected G2dPanel _gfxPanel;
    protected JMenuBar jmb = new JMenuBar();
    Color _xAxisColor = null;
    Color _yAxisColor = null;
    G2dPanel _panel = null;
    Frame _owner = null;
    Point _screenLocPt = null;
    JMenuItem _jmi_Tab;
    JMenuItem _jmi_UseLineStyles;
    protected static boolean _useLineStyles;
    PrintProperties _printProperties = new PrintProperties();
    PageFormat _pageFormat;
    boolean _useLocalPageFormat = true;
    protected TransferHandler _transferHandler = null;
    protected JMenu _fileMenu;
    protected JMenu _editMenu;
    protected JMenu _viewMenu;
    protected JMenuItem jConfigurePlotLayout;
    JCheckBoxMenuItem _alwaysOnTopMenu;
    protected String _timewindow;
    protected PlotPropertiesDialog _plotPropsDlg;
    private List _dssVec = null;
    JMenuItem _visibleLegendMenuItem = null;
    private int WMF_SCALE = RMAIO.parseInt(System.getProperty("CLIPBOARD_SCALE"), 4);

    public G2dDialog() {
        this.initDialog();
        this.setGlassPane(new GhostGlassPane());
    }

    public G2dDialog(Frame owner) {
        this();
        this.setFrame(owner);
        this.setGlassPane(new GhostGlassPane());
    }

    public G2dDialog(Frame owner, String title) {
        this(owner);
        this.setTitle(title);
        this.setGlassPane(new GhostGlassPane());
    }

    public G2dDialog(Frame owner, boolean modal) {
        this(owner);
        this.setFrame(owner);
        this.setGlassPane(new GhostGlassPane());
    }

    public G2dDialog(Frame owner, String title, boolean modal) {
        this(owner);
        this.setTitle(title);
        this.setGlassPane(new GhostGlassPane());
    }

    public G2dDialog(Frame owner, String title, boolean modal, Vector datavec, Vector colorvec) {
        super(title);
        this.setFrame(owner);
        if (datavec.size() == 0) {
            return;
        }
        Object obj = datavec.elementAt(0);
        if (obj instanceof G2dObject) {
            this.initDialog(datavec, colorvec, null);
        } else {
            this.initialize(datavec, colorvec, null);
        }
        this.setGlassPane(new GhostGlassPane());
    }

    public G2dDialog(Frame owner, String title, boolean modal, Vector containers, G2dPanelProp prop) {
        super(title);
        this.setFrame(owner);
        this.initialize(containers, null, prop);
        this.setGlassPane(new GhostGlassPane());
    }

    public G2dDialog(Frame owner, String title, boolean modal, PlotLayout plotLayout) {
        super(title);
        this.setFrame(owner);
        this.initialize(plotLayout);
        this.setGlassPane(new GhostGlassPane());
    }

    public G2dDialog(Frame owner, String title, boolean modal, Vector containers) {
        super(title);
        this.setFrame(owner);
        this.initialize(containers, null, null);
        this.setGlassPane(new GhostGlassPane());
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            Dimension d;
            if (this._screenLocPt != null) {
                super.setLocation(this._screenLocPt);
            } else {
                Frame parent = this.getFrame();
                if (parent != null) {
                    Rectangle bounds = parent.getBounds();
                    Rectangle abounds = this.getBounds();
                    int x = bounds.x + (bounds.width - abounds.width) / 2;
                    int y = bounds.y + (bounds.height - abounds.height) / 2;
                    x = x < 0 ? 0 : x;
                    y = y < 0 ? 0 : y;
                    super.setLocation(x, y);
                } else {
                    d = Toolkit.getDefaultToolkit().getScreenSize();
                    Dimension dd = this.getSize();
                    super.setLocation((d.width - dd.width) / 2, (d.height - dd.height) / 2);
                }
            }
            G2dDialog.addVisibleDialog(this);
            G2dPanelProp properties = new G2dPanelProp();
            d = this.getSize();
            if (RMAConst.isValidValue(properties.dialogWidth)) {
                d.width = properties.dialogWidth;
            }
            if (RMAConst.isValidValue(properties.dialogHeight)) {
                d.height = properties.dialogHeight;
            }
            this.setSize(d);
        } else {
            G2dDialog.removeVisibleDialog(this);
        }
        super.setVisible(b);
    }

    @Override
    public void setTransferHandler(TransferHandler transferHandler) {
        this._transferHandler = transferHandler;
        if (this._gfxPanel != null) {
            this._gfxPanel.setTransferHandler(this._transferHandler);
        }
    }

    public static void addG2dDialogWindowListener(WindowListener wl) {
        if (wl == null || _dialogListenerList.contains(wl)) {
            return;
        }
        _dialogListenerList.add(wl);
    }

    public static void removeG2dDialogWindowListener(WindowListener wl) {
        if (wl == null || !_dialogListenerList.contains(wl)) {
            return;
        }
        _dialogListenerList.remove(wl);
    }

    private static void addVisibleDialog(G2dDialog dlg) {
        if (!_openDialogs.contains(dlg)) {
            _openDialogs.addElement(dlg);
            dlg.addWindowListener(_windowListener);
            for (int i = 0; i < _dialogListenerList.size(); ++i) {
                WindowListener wl = _dialogListenerList.get(i);
                wl.windowOpened(new WindowEvent(dlg, 200));
            }
        }
    }

    private static void removeVisibleDialog(G2dDialog dlg) {
        _openDialogs.removeElement(dlg);
        if (dlg != null) {
            dlg.removeWindowListener(_windowListener);
        }
        for (int i = 0; i < _dialogListenerList.size(); ++i) {
            WindowListener wl = _dialogListenerList.get(i);
            wl.windowClosed(new WindowEvent(dlg, 202));
        }
    }

    public static Vector getVisibleDialogs() {
        return (Vector)_openDialogs.clone();
    }

    @Override
    public void setLocation(int x, int y) {
        if (this._screenLocPt == null) {
            this._screenLocPt = new Point(x, y);
        } else {
            this._screenLocPt.x = x;
            this._screenLocPt.y = y;
        }
        super.setLocation(this._screenLocPt.x, this._screenLocPt.y);
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.invalidate();
        this.validate();
        this.repaint();
    }

    void initialize(List containers, List colorVec, G2dPanelProp prop) {
        this.setSize(600, 500);
        this.getContentPane().setLayout(new BorderLayout());
        this._gfxPanel = this.createDefaultG2dPanel();
        Vector<G2dData> dssvec = new Vector<G2dData>();
        DataTypeFactory.getFactory().reset();
        for (int i = 0; i < containers.size(); ++i) {
            Object cont = containers.get(i);
            if (cont instanceof TimeSeriesContainer) {
                TimeSeriesDataSet ts = new TimeSeriesDataSet((TimeSeriesContainer)cont);
                if (((TimeSeriesContainer)cont).timeZoneID != null) {
                    ts.setGmtOffset(((TimeSeriesContainer)cont).timeZoneRawOffset / 3600000);
                }
                dssvec.addElement(ts);
                continue;
            }
            if (cont instanceof PairedDataContainer) {
                PairedDataSet pd = new PairedDataSet((PairedDataContainer)cont);
                dssvec.addElement(pd);
                continue;
            }
            dssvec.addElement((G2dData)cont);
        }
        if (prop != null) {
            for (Object object : prop.plotPropVector) {
                G2dPlotProp plotProp = (G2dPlotProp)object;
                ViewportDrawProp viewportDrawProp = plotProp.viewportDrawProp;
                Vector glyphProperties = viewportDrawProp.glyphProperties;
                for (Object glyphProperty : glyphProperties) {
                    G2dGlyphDrawProp glyphDrawProperties = (G2dGlyphDrawProp)glyphProperty;
                    List lineProperties = glyphDrawProperties.lineProperties;
                    if (colorVec == null) {
                        colorVec = new ArrayList<LineProperties>();
                    }
                    colorVec.addAll(lineProperties);
                }
            }
        }
        if (colorVec == null) {
            colorVec = DataTypeFactory.getFactory().getLineProperties(dssvec);
            if (prop != null && prop.getPlotCount() > 0) {
                this._gfxPanel.configurePanel(prop);
                this._gfxPanel.setPlotObjects(dssvec, colorVec);
            } else {
                this._gfxPanel.buildComponents(dssvec, colorVec);
            }
            _useLineStyles = true;
        } else {
            if (prop != null && prop.getPlotCount() > 0) {
                this._gfxPanel.configurePanel(prop);
                this._gfxPanel.setPlotObjects(dssvec, colorVec);
            } else {
                this._gfxPanel.buildComponents(dssvec, colorVec);
            }
            _useLineStyles = false;
        }
        this.getContentPane().add((Component)this._gfxPanel, "Center");
        this.makeMenus();
    }

    void initialize(PlotLayout pl) {
        this.setSize(600, 500);
        this.getContentPane().setLayout(new BorderLayout());
        this._gfxPanel = this.createDefaultG2dPanel();
        this._gfxPanel.buildComponents(pl);
        _useLineStyles = false;
        this.getContentPane().add((Component)this._gfxPanel, "Center");
        this.makeMenus();
    }

    protected void initDialog() {
        this.setSize(600, 500);
        this.getContentPane().setLayout(new BorderLayout());
        this._gfxPanel = this.createDefaultG2dPanel();
        this._gfxPanel.buildDefaultComponents();
        this.getContentPane().add((Component)this._gfxPanel, "Center");
        this.makeMenus();
    }

    protected void initDialog(Vector objvec) {
        this.setSize(600, 500);
        if (objvec.size() <= 0) {
            return;
        }
        this.getContentPane().setLayout(new BorderLayout());
        this._gfxPanel = this.createDefaultG2dPanel();
        this._gfxPanel.buildComponents(objvec);
        this.getContentPane().add((Component)this._gfxPanel, "Center");
        this.makeMenus();
    }

    protected void initDialog(Vector objvec, Vector colorvec, G2dPanelProp prop) {
        this.setSize(600, 500);
        if (objvec.size() <= 0) {
            return;
        }
        this.getContentPane().setLayout(new BorderLayout());
        this._gfxPanel = this.createDefaultG2dPanel();
        boolean plotPropertiesHasLineStyles = false;
        if (prop != null) {
            for (Object object : prop.plotPropVector) {
                G2dPlotProp plotProp = (G2dPlotProp)object;
                ViewportDrawProp viewportDrawProp = plotProp.viewportDrawProp;
                Vector glyphProperties = viewportDrawProp.glyphProperties;
                for (Object glyphProperty : glyphProperties) {
                    G2dGlyphDrawProp glyphDrawProperties = (G2dGlyphDrawProp)glyphProperty;
                    List lineProperties = glyphDrawProperties.lineProperties;
                    plotPropertiesHasLineStyles |= !lineProperties.isEmpty();
                }
            }
            this._gfxPanel.configurePanel(prop);
        }
        _useLineStyles = !plotPropertiesHasLineStyles && (colorvec == null || colorvec.isEmpty());
        this._gfxPanel.buildComponents(objvec, colorvec);
        this.getContentPane().add((Component)this._gfxPanel, "Center");
        this.makeMenus();
    }

    public void makeMenus() {
        this.setDefaultCloseOperation(2);
        if (this.getJMenuBar() != null) {
            return;
        }
        this._fileMenu = new JMenu("File");
        this._fileMenu.setMnemonic('F');
        this._jmi_Tab = new JMenuItem("Tabulate", 84);
        this._jmi_Tab.addActionListener(this);
        this._fileMenu.add(this._jmi_Tab);
        this._fileMenu.addSeparator();
        JMenuItem jmi = new JMenuItem("Save As ...");
        jmi.addActionListener(this);
        this._fileMenu.add(jmi);
        jmi = new JMenuItem("Save Template ...");
        jmi.addActionListener(this);
        this._fileMenu.add(jmi);
        jmi = new JMenuItem("Apply Template ...");
        jmi.addActionListener(this);
        this._fileMenu.add(jmi);
        jmi = new JMenuItem("Save Specification ...");
        jmi.addActionListener(this);
        this._fileMenu.add(jmi);
        this._fileMenu.addSeparator();
        String dataModel = System.getProperty("sun.arch.data.model");
        if ("32".equals(dataModel) && (RMAIO.getOSType() == 1 || RMAIO.getOSType() == 0)) {
            jmi = new JMenuItem("Copy to Clipboard", 111);
            jmi.addActionListener(this);
            this._fileMenu.add(jmi);
            this._fileMenu.addSeparator();
        }
        jmi = new JMenuItem("Print", 80);
        jmi.setAccelerator(KeyStroke.getKeyStroke(80, 2, false));
        jmi.addActionListener(this);
        this._fileMenu.add(jmi);
        jmi = new JMenuItem("Page Setup", 83);
        jmi.addActionListener(this);
        this._fileMenu.add(jmi);
        jmi = new JMenuItem("Print Preview");
        jmi.addActionListener(this);
        this._fileMenu.add(jmi);
        jmi = new JMenuItem("Print Multiple");
        jmi.addActionListener(this);
        this._fileMenu.add(jmi);
        this._fileMenu.addSeparator();
        jmi = new JMenuItem("Close", 67);
        jmi.setAccelerator(KeyStroke.getKeyStroke(87, 2, false));
        jmi.addActionListener(this);
        this._fileMenu.add(jmi);
        this.jmb.add(this._fileMenu);
        this._editMenu = new JMenu("Edit");
        this._editMenu.setMnemonic('E');
        jmi = new JMenuItem("Plot Properties ...", 80);
        jmi.addActionListener(this);
        this._editMenu.add(jmi);
        this.jConfigurePlotLayout = new JMenuItem("Configure Plot Layout...", 67);
        this.jConfigurePlotLayout.addActionListener(this);
        this._editMenu.add(this.jConfigurePlotLayout);
        this._editMenu.addSeparator();
        jmi = new JMenuItem("Default Line Styles...", 76);
        this._editMenu.add(jmi);
        jmi.addActionListener(this);
        jmi = new JMenuItem("Default Plot Properties...", 68);
        this._editMenu.add(jmi);
        jmi.addActionListener(this);
        this.jmb.add(this._editMenu);
        this._viewMenu = new JMenu("View");
        this._viewMenu.setMnemonic('V');
        this.jmb.add(this._viewMenu);
        if (RMAIO.getOSType() != 2) {
            this._alwaysOnTopMenu = new JCheckBoxMenuItem("Always On Top");
            this._alwaysOnTopMenu.setMnemonic('A');
            this._alwaysOnTopMenu.addActionListener(this);
            this._viewMenu.add(this._alwaysOnTopMenu);
        }
        this._jmi_UseLineStyles = new JCheckBoxMenuItem("Use Line Styles", _useLineStyles);
        this._jmi_UseLineStyles.setMnemonic('U');
        this._jmi_UseLineStyles.addActionListener(this);
        this._viewMenu.add(this._jmi_UseLineStyles);
        this._viewMenu.add(new AbstractAction("Zoom to all"){

            @Override
            public void actionPerformed(ActionEvent e) {
                G2dDialog.this._gfxPanel.zoomToAll();
            }
        });
        JMenu m = new LegendPanelViewMenuFactory().createLegendViewMenu(this._gfxPanel);
        this._viewMenu.add(m);
        this._visibleLegendMenuItem = new JMenuItem("Hide Legend");
        this._visibleLegendMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                G2dDialog.this._gfxPanel.setLegendVisible(!G2dDialog.this._gfxPanel.isLegendVisible());
            }
        });
        this._viewMenu.add(this._visibleLegendMenuItem);
        this._viewMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                String text = (G2dDialog.this._gfxPanel.isLegendVisible() ? "Hide" : "Show") + " Legend";
                G2dDialog.this._visibleLegendMenuItem.setText(text);
                G2dDialog.this._visibleLegendMenuItem.repaint();
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        this.setJMenuBar(this.jmb);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JMenuItem c2 = (JMenuItem)e.getSource();
        String arg = c2.getText();
        if (c2 == this._alwaysOnTopMenu) {
            RMAUtil.setWindowAlwaysOnTop(this, this._alwaysOnTopMenu.isSelected());
        }
        if (arg.equals("Close")) {
            this.close();
        } else if (arg.equals("Print")) {
            this.print();
        } else if (arg.equals("Print Preview")) {
            this.printPreview();
        } else if (arg.equals("Print Multiple")) {
            this.printMultiple();
        } else if (arg.equals("Page Setup")) {
            this.pageSetup();
        } else if (arg.equals("Tabulate")) {
            this.tabulate(true);
        } else if (arg.equals("Edit")) {
            this.Edit();
        } else if (arg.equals("Open")) {
            this.Open();
        } else if (arg.equals("Save As ...")) {
            this.saveAs();
        } else if (arg.equals("Test Save As ...")) {
            this.testSaveAs();
        } else if (arg.equals("Copy to Clipboard")) {
            this.copyToClipboard();
        } else if (arg.equals("Apply Template ...")) {
            this.importProperties();
        } else if (arg.equals("Save Template ...")) {
            this.exportProperties();
        } else if (arg.equals("Save Specification ...")) {
            this.savePlotSpecification();
        } else if (arg.equals("Plot Properties ...")) {
            this.plotProperties();
        } else if (arg.equals("Default Line Styles...")) {
            this.configurePlotTypes();
        } else if (arg.equals("Default Plot Properties...")) {
            this.defaultPlotProperties();
        } else if (arg.equals("Use Line Styles")) {
            _useLineStyles = this._jmi_UseLineStyles.isSelected();
            this._gfxPanel.useLineStyles(_useLineStyles);
        } else if (arg.equals("Live Display...")) {
            this.configureLiveDisplay();
        } else if (arg.equals("Configure Plot Layout...")) {
            this.configurePlotLayout();
        }
    }

    public void setUseLineStylesOn() {
        if (this._jmi_UseLineStyles.isSelected()) {
            return;
        }
        this._jmi_UseLineStyles.doClick();
    }

    public JMenu getFileMenu() {
        return this._fileMenu;
    }

    public JMenu getEditMenu() {
        return this._editMenu;
    }

    public JMenu getViewMenu() {
        return this._viewMenu;
    }

    public void setUseLineStylesOff() {
        if (!this._jmi_UseLineStyles.isSelected()) {
            return;
        }
        this._jmi_UseLineStyles.doClick();
    }

    public void applyTemplate(G2dPanelProp properties) {
        if (properties == null) {
            return;
        }
        this._gfxPanel.resetProperties(properties);
        this.updateUnitSystem(this);
    }

    public void applyTemplate(String templateFile) {
        if (templateFile == null) {
            return;
        }
        G2dPanelProp prop = null;
        prop = this.importPropertiesLocal(templateFile = RMAIO.parsePathName(templateFile));
        if (prop != null) {
            this._gfxPanel.resetProperties(prop);
            this.updateUnitSystem(this._gfxPanel);
        }
    }

    public void importProperties() {
        G2dPanelProp prop = this.importPropertiesLocal();
        if (prop != null) {
            this._gfxPanel.resetProperties(prop);
            this.updateUnitSystem(this._gfxPanel);
        }
    }

    private G2dPanelProp importPropertiesLocal() {
        RMAFilenameFilter propFileFilter = new RMAFilenameFilter("template", "Template Properties (*.template)");
        JFileChooser chooser = new JFileChooser();
        chooser.addChoosableFileFilter(propFileFilter);
        int state = chooser.showOpenDialog(this);
        File file = chooser.getSelectedFile();
        if (state == 1 || state == -1) {
            return null;
        }
        if (file == null && state == 0) {
            JOptionPane.showMessageDialog(this, "Please select a file!", "File Error", 0);
            return null;
        }
        String path = "";
        path = file.getPath();
        return this.importPropertiesLocal(path);
    }

    private G2dPanelProp importPropertiesLocal(String path) {
        G2dPanelProp panelProp = new G2dPanelProp();
        try {
            if (!path.endsWith(".template")) {
                path = path.concat(".template");
            }
            BufferedReader buffR = new BufferedReader(new FileReader(path));
            panelProp.readProperties(buffR);
            buffR.close();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            JOptionPane.showMessageDialog(this, e.getMessage(), "Error Opening Properites File", 0);
        }
        Window[] ownedWindows = this.getOwnedWindows();
        if (ownedWindows != null) {
            for (int i = 0; i < ownedWindows.length; ++i) {
                ownedWindows[i].setVisible(false);
                ownedWindows[i].dispose();
            }
        }
        return panelProp;
    }

    private void writeLocal() {
        int reply;
        RMAFilenameFilter plotPropFileFilter = new RMAFilenameFilter("template", "Template Properties (*.template)");
        JFileChooser chooser = new JFileChooser();
        chooser.addChoosableFileFilter(plotPropFileFilter);
        int state = chooser.showSaveDialog(this);
        File file = chooser.getSelectedFile();
        if (state == 1) {
            return;
        }
        if (file == null && state == 0) {
            JOptionPane.showMessageDialog(this, "Please select a file!", "File Error", 0);
            return;
        }
        if (file.exists() && (reply = RMAIO.postYesNoWarning(this, file.getName() + " already exists!\n Do you want to replace it?")) == 1) {
            return;
        }
        String path = file.getPath();
        this.writeLocal(path);
    }

    public void writeLocal(String path) {
        if (!path.endsWith(".template")) {
            path = path.concat(".template");
        }
        G2dPanelProp panelProp = this._gfxPanel.getProperties();
        try {
            BufferedWriter buffW = new BufferedWriter(new FileWriter(path));
            panelProp.writeProperties(buffW);
            buffW.flush();
            buffW.close();
        }
        catch (Exception e) {
            System.out.println("writeLocal: error writing template " + e.getMessage());
        }
    }

    public void exportProperties() {
        this.writeLocal();
    }

    public void exportProperties(String templateName) {
        if (templateName == null || templateName.length() == 0) {
            this.exportProperties();
            return;
        }
        this.writeLocal(templateName);
    }

    public static void setUseLineStyles(boolean useLineStyles) {
        _useLineStyles = useLineStyles;
    }

    public static boolean getUseLineStyles() {
        return _useLineStyles;
    }

    public void close() {
        if (!ClientAppCheck.haveClientApp()) {
            this.setDefaultCloseOperation(3);
        }
        this.setVisible(false);
        this.dispose();
    }

    public void printPreview() {
        if (this._pageFormat == null) {
            this._pageFormat = new PageFormat();
        }
        Thread runner = new Thread(){

            @Override
            public void run() {
                G2dDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                Window window = SwingUtilities.windowForComponent(G2dDialog.this);
                Frame frame = null;
                if (window instanceof Frame) {
                    frame = (Frame)window;
                }
                new PrintPreview(frame, (Printable)G2dDialog.this, G2dDialog.this.getTitle() + " preview");
                G2dDialog.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        };
        runner.start();
    }

    @Override
    public PageFormat getPageFormat(int pageNum) {
        this._pageFormat.setOrientation(this._printProperties.getLayout());
        Margin margin = this._printProperties.getMargins();
        Paper paper = new Paper();
        double imageableX = margin.getLeftMargin() * 72.0;
        double imageableY = margin.getTopMargin() * 72.0;
        double imageableW = paper.getWidth() - (margin.getLeftMargin() + margin.getRightMargin()) * 72.0;
        double imageableH = paper.getHeight() - (margin.getTopMargin() + margin.getBottomMargin()) * 72.0;
        paper.setImageableArea(imageableX, imageableY, imageableW, imageableH);
        this._pageFormat.setPaper(paper);
        return this._pageFormat;
    }

    @Override
    public Printable getPrintable(int pageNum) {
        return this;
    }

    @Override
    public int getNumberOfPages() {
        return 1;
    }

    public void printToDefault() {
        try {
            System.out.println("printer job=" + System.getProperty("java.awt.printerjob"));
            PrinterJob prnJob = PrinterJob.getPrinterJob();
            prnJob.setPageable(this);
            this._pageFormat = prnJob.defaultPage();
            prnJob.print();
        }
        catch (PrinterException e) {
            e.printStackTrace();
            System.err.println("Printing error: " + e.toString());
            RMAIO.postError(this, e.toString());
        }
    }

    public void print() {
        try {
            System.out.println("printer job=" + System.getProperty("java.awt.printerjob"));
            PrinterJob prnJob = PrinterJob.getPrinterJob();
            prnJob.setPageable(this);
            if (!prnJob.printDialog()) {
                return;
            }
            this._pageFormat = prnJob.defaultPage();
            prnJob.print();
        }
        catch (PrinterException e) {
            e.printStackTrace();
            System.err.println("Printing error: " + e.toString());
            RMAIO.postError(this, e.toString());
        }
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        return this._gfxPanel.print(g, pageFormat, pageIndex, this._useLocalPageFormat, this._printProperties);
    }

    public void useLocalPageSettings(boolean set) {
        this._useLocalPageFormat = set;
    }

    public PrintProperties getPrintProperties() {
        return this._printProperties;
    }

    public void pageSetup() {
        PageSetupJDialog dlg = new PageSetupJDialog((Frame)this, true);
        dlg.setPrintProperties(this._printProperties);
        dlg.setVisible(true);
        if (dlg.isCanceled()) {
            return;
        }
        this._printProperties = dlg.getPrintProperties();
    }

    public void printMultiple() {
        G2dDialog.openMultiplePrintDlg();
    }

    private static void openMultiplePrintDlg() {
        if (_printMultipleDlg == null) {
            _printMultipleDlg = new PrintMultipleJDialog();
        }
        if (_printMultipleDlg.isVisible()) {
            _printMultipleDlg.toFront();
            return;
        }
        _printMultipleDlg.setVisible(true);
    }

    public HecDataTableFrame tabulate() {
        return this.tabulate(false);
    }

    public HecDataTableFrame tabulate(boolean showTable) {
        Vector tempG2dObjects = this._gfxPanel.getPlotObjects();
        List g2dObjects = new ArrayList();
        if (tempG2dObjects != null && tempG2dObjects.size() > 0) {
            g2dObjects.addAll(tempG2dObjects);
        }
        System.out.println("Plot objects vector length = " + g2dObjects.size());
        g2dObjects = this.getTabulateObjects(g2dObjects);
        System.out.println("Plot objects vector length AFTER getTabulateObjects = " + g2dObjects.size());
        if (g2dObjects.isEmpty()) {
            return null;
        }
        int status = -1;
        HecDataTableFrame table = new HecDataTableFrame((Object)this);
        status = table.setData(g2dObjects);
        System.out.println("Tabulate Status = " + status);
        if (status == 0) {
            table.allowEditing(false);
            if (showTable) {
                table.show();
            }
        }
        return table;
    }

    protected List getTabulateObjects(List v) {
        List<Object> returnVec = new ArrayList<Object>(v.size());
        G2dObject firstObj = (G2dObject)v.get(0);
        Class<?> c2 = firstObj.getClass();
        for (int i = 0; i < v.size(); ++i) {
            Object obj = this.getTabulateObject(v.get(i), c2);
            if (obj == null) continue;
            returnVec.add(obj);
        }
        int displayUnitsSystem = ServiceLookup.getUnitsDisplayService().getDisplayUnitsSystem();
        if (firstObj instanceof G2dDssTimeSeriesCollection) {
            returnVec = this.convertTimeSeriesCollectionContainers(returnVec, firstObj.getUnitSystem(), displayUnitsSystem);
        } else if (firstObj instanceof TimeSeriesDataSet || firstObj instanceof G2dDssTimeSeries) {
            returnVec = this.convertTimeSeriesContainers(returnVec, firstObj.getUnitSystem(), displayUnitsSystem);
        } else if (firstObj instanceof PairedDataSet || firstObj instanceof G2dDssPairedData || firstObj instanceof SimpleJTableData) {
            returnVec = this.convertPairedDataContainer(returnVec, firstObj.getUnitSystem(), displayUnitsSystem);
        }
        return returnVec;
    }

    private List convertPairedDataContainer(List pdContainers, int fromUS, int toUS) {
        if (toUS == 0 || toUS == fromUS) {
            return pdContainers;
        }
        for (int i = 0; i < pdContainers.size(); ++i) {
            PairedDataContainer pdcBase = (PairedDataContainer)pdContainers.get(i);
            if (pdcBase == null) continue;
            PairedDataContainer pdc = new PairedDataContainer();
            pdcBase.clone(pdc);
            stringContainer sc = new stringContainer();
            try {
                sc.string = pdc.xunits;
                HecDataConversion.convertUnits(pdc.xOrdinates, pdc.xOrdinates.length, fromUS, toUS, sc);
                pdc.xunits = sc.string;
                for (int j = 0; j < pdc.numberCurves; ++j) {
                    sc.string = pdc.yunits;
                    HecDataConversion.convertUnits(pdc.yOrdinates[j], pdc.yOrdinates[j].length, fromUS, toUS, sc);
                }
                pdc.yunits = sc.string;
                pdContainers.set(i, pdc);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return pdContainers;
    }

    private List convertTimeSeriesContainers(List tsContainers, int fromUS, int toUS) {
        if (toUS == 0 || toUS == fromUS) {
            return tsContainers;
        }
        for (int i = 0; i < tsContainers.size(); ++i) {
            if (tsContainers.get(i) instanceof TimeSeriesCollectionContainer) {
                TimeSeriesCollectionContainer tscc = (TimeSeriesCollectionContainer)tsContainers.get(i);
                TimeSeriesContainer[] tsArray = tscc.get();
                for (int c2 = 0; c2 < tsArray.length; ++c2) {
                    TimeSeriesContainer tsc = tsArray[c2];
                    if (tsc == null) continue;
                    tsc = (TimeSeriesContainer)tsc.clone();
                    stringContainer sc = new stringContainer();
                    try {
                        sc.string = tsc.units;
                        HecDataConversion.convertUnits(tsc.values, tsc.values.length, fromUS, toUS, sc);
                        System.out.println(tsc.toString());
                        tsc.units = sc.string;
                        tsArray[c2] = tsc;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ((TimeSeriesCollectionContainer)tsContainers.get(i)).set(tsArray);
                }
                continue;
            }
            TimeSeriesContainer tsc = (TimeSeriesContainer)tsContainers.get(i);
            if (tsc == null) continue;
            tsc = (TimeSeriesContainer)tsc.clone();
            stringContainer sc = new stringContainer();
            try {
                sc.string = tsc.units;
                HecDataConversion.convertUnits(tsc.values, tsc.values.length, fromUS, toUS, sc);
                System.out.println(tsc.toString());
                tsc.units = sc.string;
                tsContainers.set(i, tsc);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return tsContainers;
    }

    private List convertTimeSeriesCollectionContainers(List tsContainers, int fromUS, int toUS) {
        ArrayList<TimeSeriesContainer> tsArray = new ArrayList<TimeSeriesContainer>();
        if (toUS == 0 || toUS == fromUS) {
            return tsContainers;
        }
        for (int i = 0; i < tsContainers.size(); ++i) {
            Object tsContainer = tsContainers.get(i);
            if (!(tsContainer instanceof G2dDssTimeSeriesCollection)) continue;
            TimeSeriesContainer[] tsArray2 = ((G2dDssTimeSeriesCollection)tsContainers.get(i)).getTimeSeriesContainer().get();
            for (int j = 0; j < tsArray2.length; ++j) {
                TimeSeriesContainer tsc = tsArray2[j];
                if (tsc == null) continue;
                tsc = (TimeSeriesContainer)tsc.clone();
                stringContainer sc = new stringContainer();
                try {
                    sc.string = tsc.units;
                    HecDataConversion.convertUnits(tsc.values, tsc.values.length, fromUS, toUS, sc);
                    System.out.println(tsc.toString());
                    tsc.units = sc.string;
                    tsArray.add(tsc);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return tsArray;
    }

    public void Edit() {
        EditTabFrame e = new EditTabFrame(this);
    }

    public void Open() {
    }

    public void saveAs() {
        int reply;
        RMAFilenameFilter wmfFileFilter = new RMAFilenameFilter("wmf", "Windows Metafile (*.wmf)");
        RMAFilenameFilter psFileFilter = new RMAFilenameFilter("ps", "Postscript (*.ps)");
        RMAFilenameFilter jpegFileFilter = new RMAFilenameFilter(new String[]{"jpg", "jpeg"}, "JPEG (*.jpg, *.jpeg)");
        RMAFilenameFilter pngFileFilter = new RMAFilenameFilter(new String[]{"png"}, "Portable Network Graphics (*.png)");
        JFileChooser chooser = new JFileChooser();
        chooser.setAcceptAllFileFilterUsed(false);
        if (RMAIO.getOSType() == 1 || RMAIO.getOSType() == 0) {
            chooser.addChoosableFileFilter(wmfFileFilter);
        }
        chooser.addChoosableFileFilter(psFileFilter);
        chooser.addChoosableFileFilter(jpegFileFilter);
        chooser.addChoosableFileFilter(pngFileFilter);
        int state = chooser.showSaveDialog(this);
        File file = chooser.getSelectedFile();
        if (state == 1 || state == -1) {
            return;
        }
        if (file == null && state == 0) {
            JOptionPane.showMessageDialog(this, "Please select a file!", "File Error", 0);
            return;
        }
        if (file.exists() && (reply = RMAIO.postYesNoWarning(this, file.getName() + " already exists!\n Do you want to replace it?")) == 1) {
            return;
        }
        RMAFilenameFilter ff = (RMAFilenameFilter)chooser.getFileFilter();
        if (ff.equals(psFileFilter)) {
            this.saveToPostscript(file);
        } else if (ff.equals(wmfFileFilter)) {
            this.saveToMetafile(file);
        } else if (ff.equals(jpegFileFilter)) {
            this.saveToJpeg(file);
        } else if (ff.equals(pngFileFilter)) {
            this.saveToPng(file);
        }
    }

    private void testSaveAs() {
        this.saveToPng(new File("J:\\temp\\TestPlotScripts\\test.png"));
    }

    public void saveToPng(String fileName) {
        this.saveToPng(new File(fileName));
    }

    public void saveToPng(File file) {
        String path = file.getPath();
        if (!path.contains(".png") && !path.contains(".jpeg")) {
            path = path.concat(".png");
            file = new File(path);
        }
        this.saveToImage(file, "png", 1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToImage(File file, String imageType, float compression) {
        this.invalidate();
        this.validate();
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName(imageType);
        if (!iter.hasNext()) {
            Logger logger = Logger.getLogger(this.getClass().getName());
            logger.log(Level.WARNING, "No Image writers exist for Image Type = {0}", imageType);
            return;
        }
        ImageWriter next = iter.next();
        ImageWriteParam defaultWriteParam = next.getDefaultWriteParam();
        Dimension d = this._gfxPanel.getSize();
        BufferedImage bImage = new BufferedImage(d.width + 1, d.height + 1, 1);
        Graphics2D g = bImage.createGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, d.width + 1, d.height + 1);
        Color oldColor = this._gfxPanel.getBackground();
        this._gfxPanel.setBackground(new Color(0, 0, 0, 0));
        ((Graphics)g).translate(1, 1);
        this._gfxPanel.paintGfx(g);
        g.dispose();
        this._gfxPanel.setBackground(oldColor);
        if (defaultWriteParam.canWriteCompressed() && compression != -2.1474836E9f) {
            defaultWriteParam.setCompressionMode(2);
            defaultWriteParam.setCompressionQuality(compression / 100.0f);
        }
        FileOutputStream fs = null;
        ImageInputStream createImageOutputStream = null;
        try {
            boolean success;
            File parentFile = file.getParentFile();
            if (parentFile != null && !parentFile.exists() && !(success = parentFile.mkdirs())) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Unable to create directory: " + parentFile.getAbsolutePath());
            }
            fs = new FileOutputStream(file);
            createImageOutputStream = ImageIO.createImageOutputStream(fs);
            next.setOutput(createImageOutputStream);
            IIOImage iioImage = new IIOImage(bImage, null, null);
            next.write(null, iioImage, defaultWriteParam);
        }
        catch (IOException e) {
            Logger.getLogger(G2dDialog.class.getName()).log(Level.SEVERE, "Error exporting plot to image file", e);
        }
        finally {
            next.dispose();
            if (createImageOutputStream != null) {
                try {
                    createImageOutputStream.flush();
                }
                catch (IOException e) {
                    Logger.getLogger(G2dDialog.class.getName()).log(Level.SEVERE, "Error flushing Image Output Stream", e);
                }
                try {
                    createImageOutputStream.close();
                }
                catch (IOException e) {
                    Logger.getLogger(G2dDialog.class.getName()).log(Level.SEVERE, "Error closing Image Output Stream", e);
                }
            }
            if (fs != null) {
                try {
                    fs.flush();
                }
                catch (IOException e) {
                    Logger.getLogger(G2dDialog.class.getName()).log(Level.SEVERE, "Error flushing File Output Stream", e);
                }
                try {
                    fs.close();
                }
                catch (IOException e) {
                    Logger.getLogger(G2dDialog.class.getName()).log(Level.SEVERE, "Error closing File Output Stream", e);
                }
            }
        }
    }

    public void saveToJpeg(String fileName) {
        this.saveToJpeg(new File(fileName), Integer.MIN_VALUE);
    }

    public void saveToJpeg(String fileName, int quality) {
        this.saveToJpeg(new File(fileName), quality);
    }

    public void saveToJpeg(File file) {
        this.saveToJpeg(file, Integer.MIN_VALUE);
    }

    public void saveToJpeg(File file, int quality) {
        String path = file.getPath();
        if (!path.contains(".jpg") && !path.contains(".jpeg")) {
            path = path.concat(".jpg");
            file = new File(path);
        }
        this.saveToImage(file, "jpg", quality);
    }

    public void saveToPostscript(String fileName) {
        this.saveToPostscript(new File(fileName));
    }

    public void saveToPostscript(File file) {
        if (file == null || file.getPath() == null) {
            return;
        }
        Object path = file.getPath();
        if (!((String)path).endsWith(".ps")) {
            path = (String)path + ".ps";
        }
        this.invalidate();
        this.validate();
        DocFlavor.SERVICE_FORMATTED flavor = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
        String psMimeType = DocFlavor.BYTE_ARRAY.POSTSCRIPT.getMimeType();
        StreamPrintServiceFactory[] factories = StreamPrintServiceFactory.lookupStreamPrintServiceFactories(flavor, psMimeType);
        if (factories.length == 0) {
            RMAIO.postError(this, "No Postscript Drivers Found.");
            return;
        }
        try {
            FileOutputStream fos = new FileOutputStream((String)path);
            StreamPrintService sps = factories[0].getPrintService(fos);
            DocPrintJob pj = sps.createPrintJob();
            HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
            aset.add(PrintQuality.HIGH);
            if (this._printProperties.getLayout() == 0) {
                aset.add(OrientationRequested.LANDSCAPE);
            }
            SimpleDoc doc = new SimpleDoc(this._gfxPanel, flavor, null);
            pj.print(doc, aset);
            fos.close();
        }
        catch (PrintException pe) {
            System.err.println(pe);
        }
        catch (IOException ie) {
            System.err.println(ie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WMF createWMF(int scaleFactor) {
        WMF wmf = new WMF();
        System.out.println("WMF_SCALE=" + scaleFactor);
        Dimension dp = this._gfxPanel.getSize();
        Rectangle rp = this._gfxPanel.getBounds();
        int sclfac = scaleFactor;
        int oldResolution = this._gfxPanel.getDeviceResoultion();
        this._gfxPanel.setDeviceResolution(sclfac * oldResolution);
        Dimension d = new Dimension(dp.width * sclfac, dp.height * sclfac);
        this._gfxPanel.setBounds(rp.x + 1, rp.y + 1, rp.width * sclfac, rp.height * sclfac);
        G2dWMFGraphics2D g = new G2dWMFGraphics2D(this._gfxPanel, wmf, d.width, d.height, this._gfxPanel.getForeground(), this._gfxPanel.getBackground());
        AffineTransform af = ((Graphics2D)g).getTransform();
        double afscl = sclfac;
        af.scale(afscl, afscl);
        Viewport[] viewports = this._gfxPanel.getViewports();
        try {
            this._gfxPanel.invalidate();
            try {
                this._gfxPanel.validate();
            }
            catch (Error e) {
                Logger.getLogger(G2dDialog.class.getName()).log(Level.WARNING, "Error Validating G2dPanel", e);
                WMF wMF = wmf;
                g.dispose();
                this._gfxPanel.setDeviceResolution(oldResolution);
                this._gfxPanel.setBounds(rp);
                for (int i = 0; viewports != null && i < viewports.length; ++i) {
                    viewports[i].setDoubleBuffered(true);
                }
                this._gfxPanel.setSize(dp);
                this._gfxPanel.invalidate();
                try {
                    this._gfxPanel.validate();
                }
                catch (Error e2) {
                    e2.printStackTrace();
                    System.out.println(e2.getMessage());
                    return wmf;
                }
                return wMF;
            }
            for (int i = 0; viewports != null && i < viewports.length; ++i) {
                viewports[i].setDoubleBuffered(true);
            }
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Color oldColor = this._gfxPanel.getBackground();
            this._gfxPanel.paintGfx(g);
            WMF wMF = wmf;
            return wMF;
        }
        finally {
            g.dispose();
            this._gfxPanel.setDeviceResolution(oldResolution);
            this._gfxPanel.setBounds(rp);
            for (int i = 0; viewports != null && i < viewports.length; ++i) {
                viewports[i].setDoubleBuffered(true);
            }
            this._gfxPanel.setSize(dp);
            this._gfxPanel.invalidate();
            try {
                this._gfxPanel.validate();
            }
            catch (Error e) {
                e.printStackTrace();
                System.out.println(e.getMessage());
                return wmf;
            }
        }
    }

    public void saveToMetafile(String fileName) {
        this.saveToMetafile(new File(fileName));
    }

    public void saveToMetafile(File file) {
        this.invalidate();
        this.validate();
        Dimension d = this._gfxPanel.getSize();
        WMF wmf = this.createWMF(this.WMF_SCALE);
        try {
            String path = file.getPath();
            if (!path.contains(".wmf")) {
                path = path.concat(".wmf");
            }
            FileOutputStream out = new FileOutputStream(path);
            wmf.writePlaceableWMF(out, 0, 0, d.width * this.WMF_SCALE, d.height * this.WMF_SCALE, Toolkit.getDefaultToolkit().getScreenResolution() * this.WMF_SCALE);
            out.close();
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    public void savePlotSpecification() {
        int reply;
        if (_saveSpecDlg == null) {
            _saveSpecDlg = new SavePlotSpecificationDialog(this);
        }
        _saveSpecDlg.setLocationRelativeTo(this);
        _saveSpecDlg.setVisible(true);
        if (_saveSpecDlg.isCanceled()) {
            return;
        }
        RMAFilenameFilter xmlFileFilter = new RMAFilenameFilter("xml", "XML Files (*.xml)");
        RMAFilenameFilter txtFileFilter = new RMAFilenameFilter("txt", "Text Files (*.txt)");
        RMAFilenameFilter allFileFilter = new RMAFilenameFilter("*", "All Files (*.*)");
        JFileChooser chooser = new JFileChooser();
        chooser.setAcceptAllFileFilterUsed(false);
        if (_saveSpecDlg.isXml()) {
            chooser.addChoosableFileFilter(xmlFileFilter);
        } else {
            chooser.addChoosableFileFilter(txtFileFilter);
        }
        chooser.addChoosableFileFilter(allFileFilter);
        int state = chooser.showSaveDialog(this);
        File file = chooser.getSelectedFile();
        if (state == 1 || state == -1) {
            return;
        }
        if (file == null && state == 0) {
            JOptionPane.showMessageDialog(this, "Please select a file!", "File Error", 0);
            return;
        }
        if (file.exists() && (reply = RMAIO.postYesNoWarning(this, file.getName() + " already exists!\n Do you want to replace it?")) == 1) {
            return;
        }
        PlotSpecification plotSpec = new PlotSpecification();
        plotSpec.setIncludeDefaults(_saveSpecDlg.includeDefaults());
        plotSpec.setIncludeData(_saveSpecDlg.includeData());
        plotSpec.setUseCompactForm(_saveSpecDlg.isCompact());
        String plotSpecString = null;
        try {
            plotSpecString = _saveSpecDlg.isXml() ? plotSpec.getPlotSpecXml(this) : plotSpec.getPlotSpecText(this);
            FileWriter w = new FileWriter(file);
            w.write(plotSpecString);
            w.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Eror Saving Plot Specification", 0);
        }
    }

    public void copyToClipboard() {
        if (RMAIO.getOSType() != 1 && RMAIO.getOSType() != 0) {
            throw new RuntimeException("Cannot copy metafile to clipboard on any OS other than WINDOWS!!");
        }
        WMF wmf = this.createWMF(this.WMF_SCALE);
        Dimension d = this._gfxPanel.getSize();
        try {
            WMFUtil.writePlaceableWMFToClipboard(wmf, 0, 0, d.width * this.WMF_SCALE, d.height * this.WMF_SCALE, Toolkit.getDefaultToolkit().getScreenResolution() * this.WMF_SCALE);
        }
        catch (IOException ex) {
            String messge = "The following error occured while writing wmf File to Clipboard:\n" + ex.getMessage();
            RMAIO.postError(this, messge);
            Logger.getLogger(G2dDialog.class.getName()).log(Level.SEVERE, "Error writing WMF File to Clipboard.", ex);
        }
    }

    public void setXAxisColor(Color x) {
        this._xAxisColor = x;
    }

    public void setYAxisColor(Color y) {
        this._yAxisColor = y;
    }

    public Color getXAxisColor() {
        return this._xAxisColor;
    }

    public Color getYAxisColor() {
        return this._yAxisColor;
    }

    public void setPanel(G2dPanel panel) {
        this._panel = panel;
    }

    public G2dPanel getPlotpanel() {
        return this._gfxPanel;
    }

    public void setPlotpanel(G2dPanel panel) {
        if (panel == null) {
            return;
        }
        this._gfxPanel = panel;
    }

    public void setFrame(Frame owner) {
        this._owner = owner;
    }

    public Frame getFrame() {
        return this._owner;
    }

    public LegendPanel getLegend() {
        return this._gfxPanel.getLegendPanel();
    }

    public void setLegendBackground(String colorString) {
        Color c2 = RmaColor.parseColorString(colorString);
        this.setLegendBackground(c2);
    }

    public void setLegendBackground(Color c2) {
        this.getLegend().setBackground(c2);
    }

    public void setLegendLocation(String location) {
        int position = 0;
        if ("bottom".equalsIgnoreCase(location)) {
            position = 0;
        } else if ("right".equalsIgnoreCase(location)) {
            position = 1;
        } else if ("viewport top left".equalsIgnoreCase(location)) {
            position = 6;
        } else if ("viewport top right".equalsIgnoreCase(location)) {
            position = 7;
        } else if ("separate window".equalsIgnoreCase(location)) {
            position = 5;
        } else {
            JOptionPane.showMessageDialog(this, "Invalid legend location : \"" + location + "\".\nValid locations are \"Right\",\"Bottom\",\"Viewport Top Left\",\"Viewport Top Right\", and\"Separate Window\".", "Legend Location Error", 0);
            return;
        }
        this._gfxPanel.moveLegendToPosition(position);
    }

    public G2dLabel getLegendLabel(DataContainer dc) {
        LegendPanel legend = this.getLegend();
        if (legend == null) {
            return null;
        }
        G2dData dataSet = null;
        if (dc instanceof TimeSeriesContainer) {
            dataSet = new TimeSeriesDataSet((TimeSeriesContainer)dc);
        } else if (dc instanceof PairedDataContainer) {
            dataSet = new PairedDataSet((PairedDataContainer)dc);
        }
        if (dataSet == null) {
            return null;
        }
        return legend.getLegendLabel(dataSet.getName());
    }

    public G2dLabel getLegendLabel(DataContainer dc, int curveNumber) {
        LegendPanel legend = this.getLegend();
        if (legend == null) {
            return null;
        }
        G2dData dataSet = null;
        if (dc instanceof PairedDataContainer) {
            dataSet = new PairedDataSet((PairedDataContainer)dc);
        }
        if (dataSet == null) {
            return null;
        }
        return legend.getLegendLabel(dataSet.getName(), curveNumber);
    }

    public void setLegendItemVisible(HecMath dataSet, boolean isVisible) {
        if (dataSet != null) {
            String path = dataSet.getPath();
            this.setLegendItemVisible(path, isVisible);
        }
    }

    public void setLegendItemVisible(DataContainer dataContainer, boolean isVisible) {
        if (dataContainer == null) {
            String path = dataContainer.fullName;
            this.setLegendItemVisible(path, isVisible);
        }
    }

    public void setLegendItemVisible(String dataName, boolean isVisible) {
        if (dataName == null) {
            System.out.println("setLegendItemVisible: no data name!");
            return;
        }
        G2dGlyph glyph = this.getGlyph(dataName);
        if (glyph == null) {
            System.out.println("setLegendItemVisible: failed to find curve for " + dataName);
            return;
        }
        glyph.setLegendItemsVisible(isVisible);
    }

    public void setLegendLabelText(DataContainer dc, String text) {
        try {
            this.getLegendLabel(dc).setText(text);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setLegendLabelText(DataContainer dc, int curveNumber, String text) {
        try {
            this.getLegendLabel(dc, curveNumber).setText(text);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setLegendLabelTextFontSize(DataContainer dc, int size) {
        try {
            this.getLegendLabel(dc).setFontSize(size);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setTabulate(boolean enable) {
        this._jmi_Tab.setEnabled(enable);
    }

    @Override
    public String toString() {
        return this.getTitle();
    }

    public void setTimeWindow(String timewindow) {
        this._timewindow = timewindow;
    }

    public void plotTimeWindow(RunTimeWindow window, int offset, String windowName) {
        if (window == null) {
            throw new IllegalArgumentException("NULL Time window in G2dDialog.plotTimeWindow()");
        }
        TimeWindowPlotData data = new TimeWindowPlotData(window, offset);
        data.name = windowName;
        this._gfxPanel.addPlotObject(data);
    }

    public void plotProperties() {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this._plotPropsDlg = new PlotPropertiesDialog((Frame)this, true);
            this._plotPropsDlg.setTitle(this.getTitle() + " Properties");
            this._plotPropsDlg.setG2dPanel(this._gfxPanel);
            this._plotPropsDlg.pack();
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
        this._plotPropsDlg.setVisible(true);
    }

    public void defaultPlotProperties() {
        DefaultPlotPropertiesDialog dppd;
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            dppd = new DefaultPlotPropertiesDialog((Frame)this, true);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
        dppd.setVisible(true);
    }

    public void configurePlotTypes() {
        if (_dataTypeEditor == null) {
            _dataTypeEditor = new DataTypeEditor();
        }
        if (_dataTypeEditor.isVisible()) {
            _dataTypeEditor.toFront();
        } else {
            _dataTypeEditor.fillForm();
        }
        _dataTypeEditor.setVisible(true);
    }

    public void configureLiveDisplay() {
        AutoLoadManager.getDefault().editRefreshProperties(this);
    }

    public void configurePlotLayout() {
        LayoutPlotDialog dialog = new LayoutPlotDialog(this, true);
        dialog.setVisible(true);
    }

    public void configurePlotLayout(PlotLayout plotLayout) {
        if (plotLayout == null) {
            return;
        }
        if (this._gfxPanel == null) {
            this._gfxPanel = this.createDefaultG2dPanel();
            this.getContentPane().add((Component)this._gfxPanel, "Center");
        }
        this._gfxPanel.buildComponents(plotLayout);
        this._noInitialize = true;
    }

    public void addDataSet(G2dObject object) {
        if (object == null) {
            return;
        }
        if (this._dssVec == null) {
            this._dssVec = new Vector();
        }
        this._dssVec.add(object);
    }

    @Deprecated
    public void addDisplayObject(DataContainer dc) {
        this.addData(dc);
    }

    public void addData(DataContainer dc) {
        G2dData g2dObj = null;
        if (dc instanceof TimeSeriesContainer) {
            TimeSeriesDataSet ts = new TimeSeriesDataSet((TimeSeriesContainer)dc);
            if (((TimeSeriesContainer)dc).timeZoneID != null) {
                ts.setGmtOffset(((TimeSeriesContainer)dc).timeZoneRawOffset / 3600000);
            }
            g2dObj = ts;
        } else if (dc instanceof PairedDataContainer) {
            PairedDataSet pd;
            g2dObj = pd = new PairedDataSet((PairedDataContainer)dc);
        }
        if (g2dObj == null) {
            return;
        }
        if (this._dssVec == null) {
            this._dssVec = new Vector();
        }
        this._dssVec.add(g2dObj);
    }

    public Viewport getViewport(int viewportIndex) {
        if (viewportIndex < 0 || viewportIndex >= this._gfxPanel._viewportVector.size()) {
            System.out.println("getViewport: invalid viewport number " + viewportIndex);
        }
        return (Viewport)this._gfxPanel._viewportVector.get(viewportIndex);
    }

    public Vector getViewports() {
        return this._gfxPanel.getViewportVector();
    }

    public void initPlot() {
        if (this._dssVec != null) {
            this.initialize(this._dssVec, null, null);
        }
    }

    public void showPlot() {
        if (this._dssVec != null) {
            this.initialize(this._dssVec, null, null);
        }
        this.setVisible(true);
    }

    public G2dTitle getPlotTitle() {
        return this._gfxPanel._title;
    }

    public void setPlotTitleVisible(boolean visible) {
        if (visible) {
            this.getPlotTitle().setDrawTitleOn();
        } else {
            this.getPlotTitle().setDrawTitleOff();
        }
    }

    public boolean isPlotTitleVisible() {
        return this.getPlotTitle().isTitleDrawn();
    }

    public void setPlotTitleText(String text) {
        this.getPlotTitle().setText(text);
    }

    public String getPlotTitleText() {
        return this.getPlotTitle().getText();
    }

    public void setBackground(String colorString) {
        this.setBackground(RmaColor.parseColorString(colorString));
    }

    public G2dGlyph getGlyph(HecMath dataSet) {
        if (dataSet == null) {
            return null;
        }
        String path = dataSet.getPath();
        return this.getGlyph(path);
    }

    public G2dGlyph getGlyph(DataContainer dataContainer) {
        if (dataContainer == null) {
            return null;
        }
        String path = dataContainer.fullName;
        return this.getGlyph(path);
    }

    public G2dGlyph getGlyph(String dataName) {
        if (dataName == null) {
            System.out.println("getGlyph: no data name!");
            return null;
        }
        Vector viewPorts = this._gfxPanel._viewportVector;
        for (int i = 0; i < viewPorts.size(); ++i) {
            Viewport v = (Viewport)viewPorts.get(i);
            Vector glyphVector = v.getGlyphVector();
            for (int j = 0; j < glyphVector.size(); ++j) {
                G2dGlyph glyph = (G2dGlyph)glyphVector.get(j);
                G2dObject obj = glyph.getG2dObject();
                if (obj instanceof G2dDssObject) {
                    G2dDssObject dssObj = (G2dDssObject)obj;
                    if (!dssObj.getDSSIdentifer().getDSSPath().equals(dataName)) continue;
                    return glyph;
                }
                if (obj instanceof TimeSeriesDataSet) {
                    TimeSeriesDataSet tsds = (TimeSeriesDataSet)obj;
                    if (!dataName.equals(tsds._timeSeries.fullName)) continue;
                    return glyph;
                }
                if (!(obj instanceof PairedDataSet)) continue;
                PairedDataSet pds = (PairedDataSet)obj;
                if (!dataName.equals(pds._pairedData.fullName)) continue;
                return glyph;
            }
        }
        return null;
    }

    public G2dLine getCurve(HecMath dataSet) {
        if (dataSet == null) {
            return null;
        }
        String path = dataSet.getPath();
        return this.getCurve(path);
    }

    public G2dLine getCurve(HecMath dataSet, int curveNumber) {
        if (dataSet == null) {
            return null;
        }
        String path = dataSet.getPath();
        return this.getCurve(path, curveNumber);
    }

    public G2dLine getCurve(DataContainer dataContainer) {
        if (dataContainer == null) {
            return null;
        }
        String path = dataContainer.fullName;
        return this.getCurve(path);
    }

    public G2dLine getCurve(DataContainer dataContainer, int curveNumber) {
        if (dataContainer == null) {
            return null;
        }
        String path = dataContainer.fullName;
        return this.getCurve(path, curveNumber);
    }

    public G2dLine getCurve(String dssPath) {
        if (dssPath == null) {
            System.out.println("getCurve: no DSS path!");
            return null;
        }
        G2dGlyph glyph = this.getGlyph(dssPath);
        if (glyph == null) {
            System.out.println("getCurve: failed to find curve for " + dssPath);
            return null;
        }
        return glyph.getLine();
    }

    public G2dLine getCurve(String dssPath, int curveNumber) {
        if (dssPath == null) {
            System.out.println("getCurve: no DSS path!");
            return null;
        }
        G2dGlyph glyph = this.getGlyph(dssPath);
        if (glyph == null) {
            System.out.println("getCurve: failed to find curve for " + dssPath);
            return null;
        }
        return glyph.getLine(curveNumber);
    }

    public Viewport getViewport(String dataSetPath) {
        if (dataSetPath == null) {
            System.out.println("getViewport: no dataSetPath!");
            return null;
        }
        Vector viewPorts = this._gfxPanel._viewportVector;
        for (int i = 0; i < viewPorts.size(); ++i) {
            Viewport v = (Viewport)viewPorts.get(i);
            Vector glyphVector = v.getGlyphVector();
            for (int j = 0; j < glyphVector.size(); ++j) {
                G2dGlyph glyph = (G2dGlyph)glyphVector.get(j);
                G2dObject obj = glyph.getG2dObject();
                if (obj instanceof G2dDssObject) {
                    G2dDssObject dssObj = (G2dDssObject)obj;
                    if (!dssObj.getDSSIdentifer().getDSSPath().equals(dataSetPath)) continue;
                    return v;
                }
                if (obj instanceof TimeSeriesDataSet) {
                    TimeSeriesDataSet tsds = (TimeSeriesDataSet)obj;
                    if (!dataSetPath.equals(tsds._timeSeries.fullName)) continue;
                    return v;
                }
                if (!(obj instanceof PairedDataSet)) continue;
                PairedDataSet pds = (PairedDataSet)obj;
                if (!dataSetPath.equals(pds._pairedData.fullName)) continue;
                return v;
            }
        }
        System.out.println("getViewport: failed to find Viewport for curve " + dataSetPath);
        return null;
    }

    public Viewport getViewport(DataContainer dc) {
        return this.getViewport(dc.fullName);
    }

    public Viewport getViewport(HecMath dataSet) {
        if (dataSet == null) {
            return null;
        }
        return this.getViewport(dataSet.getPath());
    }

    public void maximize() {
        this.setExtendedState(6);
    }

    public void minimize() {
        this.iconify();
    }

    public void iconify() {
        this.setExtendedState(1);
    }

    public void restore() {
        this.setExtendedState(0);
    }

    public Object getTabulateObject(Object obj, Class firstObjClass) {
        if (obj instanceof TabulateObjectProvider) {
            return ((TabulateObjectProvider)obj).getTabulateObject();
        }
        if (obj instanceof TimeSeriesDataSet) {
            return ((TimeSeriesDataSet)obj)._timeSeries;
        }
        if (obj instanceof G2dDssTimeSeriesCollection) {
            return ((G2dDssTimeSeriesCollection)obj).getTimeSeriesContainer();
        }
        if (obj instanceof PairedDataSet) {
            return ((PairedDataSet)obj)._pairedData;
        }
        if (obj instanceof G2dDssTimeSeries) {
            return ((G2dDssTimeSeries)obj).getTimeSeriesContainer();
        }
        if (obj instanceof G2dDssPairedData) {
            return ((G2dDssPairedData)obj).getPairedDataContainer();
        }
        if (obj instanceof SimpleJTableData) {
            return ((SimpleJTableData)obj).getPairedDataContainer();
        }
        System.out.println("tablulate: Unrecognized data set " + obj.getClass());
        return null;
    }

    @Override
    public void refresh(RefreshEvent event) {
        Vector plotObjects = this.getPlotpanel().getPlotObjects();
        for (int z = 0; z < plotObjects.size(); ++z) {
            G2dObject g2dObject = (G2dObject)plotObjects.get(z);
            RefreshCookie rc = (RefreshCookie)g2dObject.getLookup().lookup(RefreshCookie.class);
            if (rc == null) continue;
            rc.refresh(event.getMessage());
        }
    }

    protected G2dPanel createDefaultG2dPanel() {
        return new G2dPanel();
    }

    static {
        _dialogListenerList = new ArrayList<WindowListener>();
        _openDialogs = new Vector();
        _printMultipleDlg = null;
        _saveSpecDlg = null;
        _useLineStyles = true;
        _windowListener = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (e.getWindow() instanceof G2dDialog) {
                    G2dDialog.removeVisibleDialog((G2dDialog)e.getWindow());
                }
            }
        };
    }
}

