/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.gfx2d.DataTypeFactory;
import hec.gfx2d.G2dData;
import hec.gfx2d.G2dDialog;
import hec.gfx2d.G2dObject;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.GhostGlassPane;
import hec.gfx2d.LineProperties;
import hec.gfx2d.PairedDataSet;
import hec.gfx2d.TimeSeriesDataSet;
import hec.gfx2d.TimeSeriesDataSetBase;
import hec.io.DataContainer;
import hec.io.PairedDataContainer;
import hec.io.TimeSeriesContainer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaNavigationPanel;

public class G2dDialogIndividualSelect
extends G2dDialog
implements ItemListener {
    Vector _dataSets;
    RmaJComboBox jComboDataSource = new RmaJComboBox();
    JPanel comboPanel;

    public G2dDialogIndividualSelect(Frame owner, String title, Vector dataSets) {
        super(owner);
        this._dataSets = dataSets;
        this.setTitle(title);
        this.initialize();
        this.fillDataSetCombo();
        this.setGlassPane(new GhostGlassPane());
    }

    void initialize() {
        this.setSize(600, 600);
        this.getContentPane().setLayout(new BorderLayout());
        this.comboPanel = new JPanel(new GridBagLayout());
        this.getContentPane().add((Component)this.comboPanel, "North");
        JLabel jl = new JLabel("Selected Data Set:");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.anchor = 18;
        gbc.insets = RmaInsets.insets(12, 5, 5, 5);
        this.comboPanel.add((Component)jl, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.insets = RmaInsets.insets(10, 5, 5, 10);
        this.comboPanel.add((Component)this.jComboDataSource, gbc);
        JPanel comboBtnsPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.insets = RmaInsets.insets(0, 0, 0, 0);
        this.comboPanel.add((Component)comboBtnsPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 11;
        comboBtnsPanel.add((Component)new JPanel(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 0;
        gbc.anchor = 11;
        gbc.insets = RmaInsets.insets(2, 25, 2, 5);
        RmaNavigationPanel navigationPanel = new RmaNavigationPanel();
        navigationPanel.fillForm(this.jComboDataSource);
        comboBtnsPanel.add((Component)navigationPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 11;
        comboBtnsPanel.add((Component)new JPanel(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.insets = RmaInsets.insets(5, 0, 5, 0);
        this.comboPanel.add((Component)new JSeparator(), gbc);
        this.makeMenus();
    }

    private void fillDataSetCombo() {
        if (this._dataSets == null) {
            return;
        }
        this.jComboDataSource.removeItemListener(this);
        this.jComboDataSource.removeAllItems();
        int ncnt = this._dataSets.size();
        String dsName = "";
        for (int i = 0; i < ncnt; ++i) {
            DataContainer dc;
            Object ds = this._dataSets.get(i);
            if (ds == null) {
                System.out.println(" Data Source is null for item = " + i);
                continue;
            }
            if (ds instanceof DataContainer) {
                dsName = ((DataContainer)ds).fullName;
                this.jComboDataSource.addItem(dsName);
                continue;
            }
            if (ds instanceof TimeSeriesDataSetBase) {
                dc = ((TimeSeriesDataSetBase)ds).getData();
                dsName = dc.fullName;
                this.jComboDataSource.addItem(dsName);
                continue;
            }
            if (ds instanceof PairedDataSet) {
                dc = ((PairedDataSet)ds).getData();
                dsName = dc.fullName;
                this.jComboDataSource.addItem(dsName);
                continue;
            }
            if (!(ds instanceof G2dData)) continue;
            dsName = ((G2dObject)ds).getName();
            this.jComboDataSource.addItem(dsName);
        }
        if (ncnt > 0) {
            this.jComboDataSource.setSelectedIndex(0);
            this.selectDataSet();
            this.jComboDataSource.addItemListener(this);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        Object object = event.getSource();
        if (event.getStateChange() != 1) {
            return;
        }
        if (object == this.jComboDataSource) {
            this.selectDataSet();
        }
    }

    protected void selectDataSet() {
        int indx = this.jComboDataSource.getSelectedIndex();
        if (indx > -1) {
            this.setData(this._dataSets.elementAt(indx));
        }
    }

    public void setData(Object ds) {
        if (this._gfxPanel != null) {
            this.getContentPane().remove(this._gfxPanel);
        }
        this._gfxPanel = new G2dPanel();
        Vector<Object> dssvec = new Vector<Object>();
        DataTypeFactory.getFactory().reset();
        if (ds instanceof TimeSeriesContainer) {
            TimeSeriesDataSet ts = new TimeSeriesDataSet((TimeSeriesContainer)ds);
            if (((TimeSeriesContainer)ds).timeZoneID != null) {
                ts.setGmtOffset(((TimeSeriesContainer)ds).timeZoneRawOffset / 3600000);
            }
            dssvec.addElement(ts);
        } else if (ds instanceof TimeSeriesDataSet) {
            dssvec.addElement(ds);
        } else if (ds instanceof PairedDataContainer) {
            PairedDataSet pd = new PairedDataSet((PairedDataContainer)ds);
            dssvec.addElement(pd);
        } else if (ds instanceof PairedDataSet) {
            dssvec.addElement(ds);
        }
        List<LineProperties> colorVec = DataTypeFactory.getFactory().getLineProperties(dssvec);
        this._gfxPanel.buildComponents(dssvec, colorVec);
        this._gfxPanel.useLineStyles(_useLineStyles);
        this.getContentPane().add((Component)this._gfxPanel, "Center");
        this._gfxPanel.revalidate();
        this.repaint();
    }
}

