/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.geometry.LocalPt;
import hec.gfx2d.G2dEditComponent;
import hec.gfx2d.G2dEditGlyph;
import hec.gfx2d.G2dGlyph;
import hec.gfx2d.G2dMouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JPanel;

public class G2dEditAdapter
extends G2dMouseAdapter {
    G2dEditComponent eComp = null;
    G2dEditGlyph _glyph = null;
    Vector _editableGlyphs = new Vector();

    public G2dEditAdapter(G2dEditComponent c2, JPanel comp) {
        this.eComp = c2;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (G2dEditAdapter.pressedButton1(e)) {
            LocalPt pt = new LocalPt(e.getX(), e.getY());
            if (!this.findGlyph(pt) || this._glyph == null) {
                return;
            }
            int modifiers = e.getModifiers();
            this._glyph.selectPt(pt, modifiers);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger() || G2dEditAdapter.pressedButton3(e)) {
            LocalPt pt = new LocalPt(e.getX(), e.getY());
            if (!this.findGlyph(pt) || this._glyph == null) {
                return;
            }
            this._glyph.objectEditPopupMenu(pt, e.getModifiers());
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (G2dEditAdapter.pressedButton1(e)) {
            LocalPt pt = new LocalPt(e.getX(), e.getY());
            if (this.eComp != null) {
                int modifiers = e.getModifiers();
                Vector glyphVec = this.eComp.getGlyphVector();
                int nglyphs = glyphVec.size();
                for (int i = 0; i < nglyphs; ++i) {
                    G2dGlyph g = (G2dGlyph)glyphVec.elementAt(i);
                    if (!(g instanceof G2dEditGlyph)) continue;
                    ((G2dEditGlyph)g).mousePressed(pt, modifiers);
                }
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this._glyph == null) {
            return;
        }
        if (G2dEditAdapter.pressedButton1(e)) {
            LocalPt pt = new LocalPt(e.getX(), e.getY());
            if (this.eComp != null) {
                this._glyph.movePt(pt);
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    boolean findGlyph(LocalPt pt) {
        G2dGlyph g;
        int i;
        if (this.eComp == null) {
            return false;
        }
        Vector glyphVec = this.eComp.getGlyphVector();
        int nglyphs = glyphVec.size();
        this._editableGlyphs.removeAllElements();
        for (i = 0; i < nglyphs; ++i) {
            g = (G2dGlyph)glyphVec.elementAt(i);
            if (!(g instanceof G2dEditGlyph)) continue;
            this._editableGlyphs.add(g);
        }
        if (this._editableGlyphs == null || this._editableGlyphs.size() < 1) {
            return false;
        }
        nglyphs = this._editableGlyphs.size();
        this._glyph = null;
        for (i = 0; i < nglyphs; ++i) {
            g = (G2dEditGlyph)this._editableGlyphs.elementAt(i);
            if (!g.pointerOver(pt)) continue;
            this._glyph = g;
            return true;
        }
        this._glyph = null;
        return false;
    }
}

