/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import rma.util.FillPatternFactory;

public class G2dFillPatternRenderer
extends JLabel
implements ListCellRenderer {
    protected Color _color = Color.blue;
    private FillIcon _icon = new FillIcon();
    private int _filltype = 0;

    public G2dFillPatternRenderer() {
        this.setOpaque(true);
        this.setIcon(this._icon);
    }

    public G2dFillPatternRenderer(int fillType, Color c2) {
        this();
        this.setColor(c2);
        this._filltype = fillType;
    }

    public void setColor(Color c2) {
        if (c2 == null) {
            return;
        }
        this._color = c2;
    }

    public void setFillIcon(FillIcon icon) {
        if (icon != null) {
            this._icon = icon;
        }
    }

    public void setFillPattern(int filltype) {
        this._filltype = filltype;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this._icon.setFillPattern((Integer)value);
        this._icon.setColor(this._color);
        if (isSelected) {
            this.setForeground(list.getSelectionForeground());
            this.setBackground(list.getSelectionBackground());
        } else {
            this.setForeground(list.getForeground());
            this.setBackground(list.getBackground());
        }
        return this;
    }

    protected class FillIcon
    implements Icon {
        private Color _color;
        private int _fillType = 0;
        private int _w;
        private int _h;

        public FillIcon() {
            this(Color.blue, 50, 13);
        }

        public FillIcon(Color color) {
            this(color, 50, 13);
        }

        public FillIcon(Color color, int w, int h) {
            this._color = color;
            this._w = w;
            this._h = h;
        }

        @Override
        public void paintIcon(Component c2, Graphics g, int x, int y) {
            Color oldColor = g.getColor();
            Graphics2D g2d = (Graphics2D)g;
            g2d.setColor(Color.black);
            g2d.drawRect(x, y, c2.getSize().width - 1, c2.getSize().height - 1);
            g2d.setColor(this._color);
            g2d.setPaint(FillPatternFactory.createFillPattern(this._fillType, this._color));
            g2d.fillRect(x + 1, y + 1, c2.getSize().width - 2, c2.getSize().height - 2);
        }

        public Color getColor() {
            return this._color;
        }

        public void setColor(Color color) {
            this._color = color;
        }

        public void setFillPattern(int fillType) {
            this._fillType = fillType;
        }

        @Override
        public int getIconWidth() {
            return this._w;
        }

        @Override
        public int getIconHeight() {
            return this._h;
        }
    }
}

