/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.gfx2d.FontProperties;
import hec.gfx2d.components.FontPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import rma.swing.DefaultJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJIntegerField;
import rma.util.RMAConst;
import rma.util.RMAUtil;

public class G2dFontPropertiesPanel
extends DefaultJPanel {
    FontProperties _fontProperties = null;
    Map _styles = new HashMap();
    Object[] customColor = new Object[]{Color.white, "Custom"};
    JColorChooser _colorChooser = new JColorChooser();
    FontPanel mFontPanel;
    JSlider minSizeSB = null;
    JSlider maxSizeSB = null;

    public G2dFontPropertiesPanel() {
        this.setName("Font");
        this.setLayout(new BorderLayout());
        this.mFontPanel = new FontPanel(null);
        this.add((Component)this.mFontPanel, "Center");
        JPanel sizePanel = new JPanel(new GridBagLayout());
        sizePanel.setBorder(BorderFactory.createTitledBorder("Font Size Bounds"));
        this.add((Component)sizePanel, "South");
        JPanel minSizePanel = new JPanel();
        minSizePanel.setBorder(new TitledBorder("Min Size"));
        minSizePanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.insets = RmaInsets.INSETS0000;
        gbc.anchor = 18;
        gbc.fill = 2;
        sizePanel.add((Component)minSizePanel, gbc);
        final RmaJIntegerField minSizeTxt = new RmaJIntegerField();
        minSizeTxt.setEditable(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.ipadx = 20;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.anchor = 18;
        gbc.fill = 2;
        minSizePanel.add((Component)minSizeTxt, gbc);
        this.minSizeSB = new JSlider(0, 5, 40, 10);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.insets = new Insets(0, 0, 0, 5);
        gbc.anchor = 18;
        gbc.fill = 2;
        minSizePanel.add((Component)this.minSizeSB, gbc);
        this.minSizeSB.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RMAUtil.setParentModified(G2dFontPropertiesPanel.this.minSizeSB);
                minSizeTxt.setValue(G2dFontPropertiesPanel.this.minSizeSB.getValue());
                G2dFontPropertiesPanel.this.mFontPanel.setMinimumFontSize(G2dFontPropertiesPanel.this.minSizeSB.getValue());
                G2dFontPropertiesPanel.this.maxSizeSB.setMinimum(G2dFontPropertiesPanel.this.minSizeSB.getValue());
            }
        });
        JPanel maxSizePanel = new JPanel();
        maxSizePanel.setBorder(new TitledBorder("Max Size"));
        maxSizePanel.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.insets = RmaInsets.INSETS0000;
        gbc.anchor = 18;
        gbc.fill = 2;
        sizePanel.add((Component)maxSizePanel, gbc);
        final RmaJIntegerField maxSizeTxt = new RmaJIntegerField();
        maxSizeTxt.setEditable(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.ipadx = 20;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.anchor = 18;
        gbc.fill = 2;
        maxSizePanel.add((Component)maxSizeTxt, gbc);
        this.maxSizeSB = new JSlider(0, 5, 40, 10);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.insets = new Insets(0, 0, 0, 5);
        gbc.anchor = 18;
        gbc.fill = 2;
        maxSizePanel.add((Component)this.maxSizeSB, gbc);
        this.maxSizeSB.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RMAUtil.setParentModified(G2dFontPropertiesPanel.this.maxSizeSB);
                maxSizeTxt.setValue(G2dFontPropertiesPanel.this.maxSizeSB.getValue());
                G2dFontPropertiesPanel.this.mFontPanel.setMaximumFontSize(G2dFontPropertiesPanel.this.maxSizeSB.getValue());
                G2dFontPropertiesPanel.this.minSizeSB.setMaximum(G2dFontPropertiesPanel.this.maxSizeSB.getValue());
            }
        });
    }

    @Override
    public void fillPanel() {
        if (this._fontProperties == null) {
            return;
        }
        this.mFontPanel.setSelectedFont(this._fontProperties.getFont());
        this.mFontPanel.setFontColor(this._fontProperties.getTextColor());
    }

    public void refresh() {
    }

    @Override
    public boolean savePanel() {
        if (this._fontProperties == null) {
            return true;
        }
        this._fontProperties.setFont(this.mFontPanel.getSelectedFont());
        int maxValue = this.maxSizeSB.getValue();
        this._fontProperties.setMaxFontSize(maxValue);
        int minValue = this.minSizeSB.getValue();
        this._fontProperties.setMinFontSize(minValue);
        Color c2 = this.mFontPanel.getFontColor();
        this._fontProperties.setTextColor(c2 != null ? c2 : Color.black);
        return true;
    }

    public void setData(FontProperties fp) {
        this._fontProperties = fp;
        Color c2 = this._fontProperties.getTextColor();
        this.mFontPanel.setFontColor(c2 != null ? c2 : Color.black);
        int minValue = this._fontProperties.getMinFontSize();
        minValue = RMAConst.isValidValue(minValue) ? minValue : 2;
        this.minSizeSB.setValue(minValue);
        int maxValue = this._fontProperties.getMaxFontSize();
        maxValue = RMAConst.isValidValue(maxValue) ? maxValue : this.maxSizeSB.getMaximum();
        this.maxSizeSB.setValue(maxValue);
    }

    protected boolean canDisplayRange(Font font, int rangeBase) {
        for (int i = rangeBase; i < rangeBase + 256; ++i) {
            if (!font.canDisplay((char)i)) continue;
            return true;
        }
        return false;
    }
}

