/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.data.Units;
import hec.geometry.LocalPt;
import hec.geometry.Scale;
import hec.geometry.WorldRect;
import hec.gfx2d.G2dGlyphDrawProp;
import hec.gfx2d.G2dLine;
import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.G2dLinesPropPanel;
import hec.gfx2d.G2dObject;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dPolygon;
import hec.gfx2d.G2dPolygonProperties;
import hec.gfx2d.G2dPropertiesDlg;
import hec.gfx2d.Gfx2dDrawUtil;
import hec.gfx2d.LegendItemDrawUtilities;
import hec.gfx2d.LegendPanel;
import hec.gfx2d.Viewport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import rma.swing.DefaultJPanel;
import rma.swing.RmaJMenuLabel;
import rma.util.RMAIO;
import rma.util.WeakObserver;

public abstract class G2dGlyph
implements Observer,
Serializable {
    protected transient Viewport _viewport = null;
    protected G2dObject _g2dObject = null;
    protected transient Scale _scale = null;
    protected G2dGlyphDrawProp _drawProp = new G2dGlyphDrawProp();
    protected G2dLine _line = null;
    protected G2dLine[] _lineArray = null;
    protected G2dPolygon _polygon = null;
    protected WorldRect _bounds = new WorldRect();
    protected static final int maxPtArraySz = 10000;
    protected static final int[] xarray = new int[10000];
    protected static final int[] yarray = new int[10000];
    transient JPopupMenu _popupMenu = null;
    RmaJMenuLabel _nameMenuItem = null;
    transient G2dPropertiesDlg m_propertiesDialog = null;
    boolean _isVisible = true;
    G2dLine m_popupLine = null;
    LocalPt m_lPoint = null;
    private Cursor m_oldCursor = null;
    G2dLinesPropPanel m_linePropertiesPanel;

    public G2dGlyph(Viewport view, G2dObject map, Scale scl) {
        this._viewport = view;
        this._g2dObject = map;
        if (this._g2dObject instanceof Observable) {
            WeakObserver weakObs = new WeakObserver(this);
            ((Observable)((Object)this._g2dObject)).addObserver(weakObs);
        }
        this._scale = scl;
        int resolution = this.getDeviceResolution();
        this._line = this.createG2dLine();
        this._line.setGlyph(this);
        this._polygon = new G2dPolygon();
        this._polygon.setGlyph(this);
        this._polygon.setScale(this._scale);
        this._lineArray = new G2dLine[this._g2dObject.getCurveCount()];
        this.buildLineArray();
        this._scale.setGmtOffset(map.getGmtOffset());
        map.getDataZoneId().ifPresent(this._scale::setDataZoneId);
        if (map.getXParameterId() != -1) {
            this._scale.setParameterId(map.getXParameterId(), 0);
        }
        if (map.getYParameterId() != -1) {
            this._scale.setParameterId(map.getYParameterId(), 1);
        }
        if (Units.isValidUnitsSystem(map.getUnitSystem())) {
            this._scale.setDataUnitSystem(map.getUnitSystem());
        }
    }

    protected G2dLine createG2dLine() {
        return new G2dLine();
    }

    protected void buildLineArray() {
        int i;
        this._lineArray = new G2dLine[this._g2dObject.getCurveCount()];
        for (i = 0; i < this._lineArray.length; ++i) {
            this._lineArray[i] = i == 0 ? this._line : this.createG2dLine();
            this._lineArray[i].setGlyph(this);
            this._lineArray[i].setScale(this._scale);
            this._lineArray[i].setName(this._g2dObject.getName());
        }
        if (this._lineArray.length > 0) {
            this._line = this._lineArray[0];
        }
        for (i = 0; this._drawProp != null && i < this._drawProp.lineProperties.size(); ++i) {
            if (i >= this._lineArray.length) continue;
            this._lineArray[i].setProperties((G2dLineProperties)this._drawProp.lineProperties.get(i));
        }
        int numLineProperties = this._drawProp.lineProperties.size();
        if (numLineProperties < this._lineArray.length) {
            for (int i2 = numLineProperties; i2 < this._lineArray.length && i2 < this._drawProp.lineProperties.size(); ++i2) {
                this._lineArray[i2].setProperties((G2dLineProperties)this._drawProp.lineProperties.get(numLineProperties - 1));
            }
        }
    }

    protected void finalize() throws Throwable {
        if (this._g2dObject != null && this._g2dObject instanceof Observable) {
            ((Observable)((Object)this._g2dObject)).deleteObserver(this);
        }
    }

    public boolean isVisible() {
        return this._isVisible;
    }

    public void setVisible(boolean visible) {
        this._isVisible = visible;
    }

    public Rectangle getVisibleRect() {
        if (this._scale == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        int xmin = Math.min(this._scale.getAxis(0).w2l(this._scale.getAxis(0).getActMin()), this._scale.getAxis(0).w2l(this._scale.getAxis(0).getActMax()));
        int ymax = Math.max(this._scale.getAxis(1).w2l(this._scale.getAxis(1).getActMax()), this._scale.getAxis(1).w2l(this._scale.getAxis(1).getActMin()));
        int xmax = Math.max(this._scale.getAxis(0).w2l(this._scale.getAxis(0).getActMin()), this._scale.getAxis(0).w2l(this._scale.getAxis(0).getActMax()));
        int ymin = Math.min(this._scale.getAxis(1).w2l(this._scale.getAxis(1).getActMax()), this._scale.getAxis(1).w2l(this._scale.getAxis(1).getActMin()));
        Rectangle rect = new Rectangle(xmin, ymin, xmax - xmin, ymax - ymin);
        return rect;
    }

    public Viewport getViewport() {
        return this._viewport;
    }

    public Scale getScale() {
        return this._scale;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof G2dObject && arg != null && arg.equals("reset data")) {
            Container c2 = this._viewport.getParent();
            if (c2 != null) {
                c2.setVisible(false);
            }
            this._scale.setParameterId(((G2dObject)((Object)o)).getXParameterId(), 0);
            this._scale.setParameterId(((G2dObject)((Object)o)).getYParameterId(), 1);
            this._scale.setDataUnitSystem(((G2dObject)((Object)o)).getUnitSystem());
            this._scale.invalidateRegionExtents();
            this._viewport.resetDataLimits(this._scale);
            if (c2 != null) {
                c2.setVisible(true);
            }
            this._viewport.setDirty();
            this._viewport.repaint();
        } else if (o instanceof G2dObject && arg != null && arg.equals("update data")) {
            this._viewport.setDirty();
            this._viewport.repaint();
        }
    }

    public String getName() {
        return this._g2dObject.getName();
    }

    public WorldRect getBounds() {
        this._bounds = null;
        WorldRect tempBounds = null;
        if (this._g2dObject != null && (tempBounds = this._g2dObject.getBounds()) != null) {
            this._bounds = new WorldRect();
            this._bounds.init(tempBounds);
        }
        if (this._bounds == null) {
            this._bounds = new WorldRect();
        }
        return this._bounds;
    }

    public boolean dataAtPoint(LocalPt pt) {
        for (int i = 0; i < this._lineArray.length; ++i) {
            if (this._lineArray[i] == null || !this._lineArray[i].contains(pt)) continue;
            return true;
        }
        return false;
    }

    public boolean objectPopupMenu(LocalPt pt, int modifiers) {
        for (int i = 0; i < this._lineArray.length; ++i) {
            if (this._lineArray[i] == null || !this._lineArray[i].contains(pt)) continue;
            this.m_popupLine = this._lineArray[i];
            if (this._lineArray.length > 1) {
                this.showPopup(this._viewport, pt.x, pt.y);
            } else {
                this._line.showPopup(this._viewport, pt.x, pt.y);
            }
            return true;
        }
        if (this._polygon != null && this._polygon.contains(pt)) {
            this._polygon.showPopup(this._viewport, pt.x, pt.y);
            return true;
        }
        return false;
    }

    public boolean pointerOver(LocalPt pt) {
        return false;
    }

    public boolean objectSelect(LocalPt pt, int modifiers) {
        return false;
    }

    public boolean objectDoubleClick(LocalPt pt, int modifiers) {
        return false;
    }

    public boolean mouseDragged(LocalPt pt) {
        return false;
    }

    public void clearSelection() {
    }

    public String getToolTipText(MouseEvent e) {
        LocalPt rpt;
        if (e == null) {
            return null;
        }
        LocalPt pt = new LocalPt(e.getX(), e.getY());
        if (this._line.contains(pt) && (rpt = this._line.getNearestDataPt(pt)) != null) {
            String xval = RMAIO.setPrecision2(this._scale.getAxis(0).l2w(rpt.x), this._scale.getAxis(0).getSigFig());
            String yval = RMAIO.setPrecision2(this._scale.getAxis(1).l2w(rpt.y), this._scale.getAxis(0).getSigFig());
            return new String("[" + xval + "," + yval + "]");
        }
        return null;
    }

    public int getDeviceResolution() {
        if (this._viewport == null || this._viewport.getParent() == null) {
            return Gfx2dDrawUtil.DEVICE_RESOLUTION;
        }
        return ((G2dPanel)this._viewport.getParent()).getDeviceResoultion();
    }

    public abstract void draw(Graphics var1);

    public void showPopup(Component c2, int x, int y) {
        this.createPopupMenu();
        this._nameMenuItem.setText(this.m_popupLine.getName());
        this.m_lPoint = new LocalPt(x, y);
        this._popupMenu.show(c2, x, y);
    }

    protected Dimension getLegendPictSize(G2dLineProperties prop) {
        if (prop == null) {
            return new Dimension(36, 10);
        }
        float h = 10.0f;
        float w = 36.0f;
        if (prop.drawPoints()) {
            float symsize = prop.getSymbolSize();
            if (h < symsize + 4.0f) {
                h = symsize + 4.0f;
            }
            if (w < symsize + 24.0f) {
                w = symsize + 24.0f;
            }
        }
        return new Dimension((int)w, (int)h);
    }

    public boolean showAllCurvesOnLegend() {
        return this._drawProp.showAllCurvesOnLegend();
    }

    public void setShowAllCurvesOnLegend(boolean b) {
        this._drawProp.setShowAllCurvesOnLegend(b);
    }

    public boolean isLegendItemsVisible() {
        return this._drawProp.showLegendItems();
    }

    public void setLegendItemsVisible(boolean b) {
        this._drawProp.setShowLegendItems(b);
    }

    public boolean isLineVisible() {
        return this._line.isVisible();
    }

    public void setLineVisible(boolean visible) {
        for (int i = 0; i < this._lineArray.length; ++i) {
            this._lineArray[i].setVisible(visible);
        }
    }

    public void setLineColor(Color c2) {
        G2dLineProperties p = this._line.getProperties();
        p.setLineColor(c2);
        this._line.setProperties(p);
    }

    public void setFillColor(Color c2) {
        G2dLineProperties p = this._line.getProperties();
        p.setSymbolFillColor(c2);
        p.setSymbolLineColor(c2);
        this._line.setProperties(p);
    }

    public void setColor(Color c2) {
        G2dLineProperties p = this._line.getProperties();
        p.setSymbolFillColor(c2);
        p.setLineColor(c2);
        p.setSymbolLineColor(c2);
        p.setFillColor(c2);
        this._line.setProperties(p);
        G2dPolygonProperties pp = this._polygon.getProperties();
        p.setLineColor(c2);
        p.setFillColor(c2);
    }

    public void setProperties(G2dGlyphDrawProp prop) {
        if (prop == null) {
            return;
        }
        this._drawProp = prop;
        for (int i = 0; this._drawProp != null && i < this._drawProp.lineProperties.size(); ++i) {
            if (i >= this._lineArray.length) continue;
            this._lineArray[i].setProperties((G2dLineProperties)this._drawProp.lineProperties.get(i));
        }
        int numLineProperties = this._drawProp.lineProperties.size();
        if (numLineProperties < this._lineArray.length) {
            for (int i = numLineProperties; i < this._lineArray.length; ++i) {
                if (this._lineArray[i] == null) continue;
                this._lineArray[i].setProperties((G2dLineProperties)this._drawProp.lineProperties.get(numLineProperties - 1));
            }
        }
        if (this._drawProp.polygonProperties != null) {
            this._polygon.setProperties(this._drawProp.polygonProperties);
        }
    }

    public G2dGlyphDrawProp getProperties() {
        this._drawProp.lineProperties = new Vector();
        for (int i = 0; i < this._lineArray.length; ++i) {
            if (this._lineArray[i] == null) continue;
            this._drawProp.lineProperties.add(this._lineArray[i].getProperties());
        }
        this._drawProp.polygonProperties = this._polygon.getProperties();
        return this._drawProp;
    }

    public G2dObject getG2dObject() {
        return this._g2dObject;
    }

    public G2dLine getLine() {
        return this._line;
    }

    public String toString() {
        return this._g2dObject.getName();
    }

    private DefaultJPanel[] buildPropertiesPanel(int curveNum) {
        DefaultJPanel[] propertiesPanels = new DefaultJPanel[1];
        this.m_linePropertiesPanel = new G2dLinesPropPanel();
        LegendPanel lp = this._viewport._parent._legend;
        this.m_linePropertiesPanel.setLegendPanel(lp);
        if (this.getCurveCount() == 1) {
            this.m_linePropertiesPanel.setLineSelectorVisible(false);
        }
        Vector<G2dGlyph> v = new Vector<G2dGlyph>(1);
        v.add(this);
        this.m_linePropertiesPanel.setGlyphVector(v);
        this.m_linePropertiesPanel.setSelectedLineIndex(curveNum);
        propertiesPanels[0] = this.m_linePropertiesPanel;
        return propertiesPanels;
    }

    public void editLineProperties() {
        this.editLineProperties(0);
    }

    public void editLineProperties(int curveNum) {
        if (this.getCurveCount() == 1) {
            this.m_propertiesDialog = this._line.editLineProperties();
            this.m_linePropertiesPanel = this._line._linePropPanel;
            return;
        }
        DefaultJPanel[] propertiesPanels = this.buildPropertiesPanel(curveNum);
        Window w = null;
        if (this.getViewport() != null) {
            w = SwingUtilities.windowForComponent(this.getViewport());
        }
        this.m_propertiesDialog = null;
        this.m_linePropertiesPanel = this._line._linePropPanel;
        this.m_propertiesDialog = w instanceof Frame ? new G2dPropertiesDlg((Frame)w, false, this.getName() + " Properties", propertiesPanels) : new G2dPropertiesDlg((Dialog)w, false, this.getName() + " Properties", propertiesPanels);
        List listeners = this.getOKListeners();
        for (int i = 0; i < listeners.size(); ++i) {
            this.m_propertiesDialog.addOKListener((ActionListener)listeners.get(i));
        }
        this.m_propertiesDialog.setVisible(true);
    }

    protected List getOKListeners() {
        ArrayList<PropertiesOKListener> l = new ArrayList<PropertiesOKListener>();
        l.add(new PropertiesOKListener());
        return l;
    }

    protected void createPopupMenu() {
        this._popupMenu = new JPopupMenu("Line Properties");
        this._nameMenuItem = new RmaJMenuLabel("Line Properties");
        Font f = this._nameMenuItem.getFont();
        f = new Font(f.getName(), 2, f.getSize());
        this._nameMenuItem.setFont(f);
        this._popupMenu.add(this._nameMenuItem);
        this._popupMenu.addSeparator();
        JMenuItem jm = new JMenuItem("Edit Properties");
        jm.setName("EDIT_PROPERTIES");
        jm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int idx = 0;
                for (int i = 0; i < G2dGlyph.this._lineArray.length; ++i) {
                    if (G2dGlyph.this._lineArray[i] != G2dGlyph.this.m_popupLine) continue;
                    idx = i;
                    break;
                }
                G2dGlyph.this.editLineProperties(idx);
            }
        });
        this._popupMenu.add(jm);
        this._popupMenu.addSeparator();
        int lineIdx = -1;
        for (int i = 0; i < this._lineArray.length; ++i) {
            if (this._lineArray[i] != this.m_popupLine) continue;
            lineIdx = i;
            break;
        }
        if (lineIdx > -1) {
            jm = new JMenuItem(this.isCurveDrawn(lineIdx) ? "Hide Curve" : "Show Curve");
            jm.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int idx = 0;
                    for (int i = 0; i < G2dGlyph.this._lineArray.length; ++i) {
                        if (G2dGlyph.this._lineArray[i] != G2dGlyph.this.m_popupLine) continue;
                        idx = i;
                        break;
                    }
                    G2dGlyph.this.setCurveDrawn(idx, !G2dGlyph.this.isCurveDrawn(idx));
                    G2dGlyph.this.getViewport().setDirty();
                    SwingUtilities.windowForComponent(G2dGlyph.this.getViewport()).repaint();
                }
            });
            this._popupMenu.add(jm);
            this._popupMenu.addSeparator();
        }
        jm = new JMenuItem("Add Callout");
        jm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                G2dGlyph.this.m_popupLine.addCallout(G2dGlyph.this.m_lPoint);
            }
        });
        this._popupMenu.add(jm);
        if (this.m_popupLine.m_calloutTable.size() > 0) {
            jm = new JMenuItem(this.m_popupLine.isCalloutsVisible() ? "Hide Callouts" : "Show Callouts");
            jm.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    G2dGlyph.this.m_popupLine.setCalloutsVisible(!G2dGlyph.this.m_popupLine.isCalloutsVisible());
                    G2dGlyph.this.getViewport().setDirty();
                    SwingUtilities.windowForComponent(G2dGlyph.this.getViewport()).repaint();
                }
            });
            this._popupMenu.add(jm);
            jm = new JMenuItem("Clear Callouts");
            jm.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    G2dGlyph.this.m_popupLine.clearCallouts();
                    G2dGlyph.this.getViewport().setDirty();
                    SwingUtilities.windowForComponent(G2dGlyph.this.getViewport()).repaint();
                }
            });
        }
        this._popupMenu.add(jm);
    }

    private void setLineProperties(G2dLine line, G2dLineProperties properties) {
        G2dLineProperties lineProperties = line.getProperties();
        line.setProperties(lineProperties);
    }

    public G2dLine getLine(int index) {
        if (index < 0 || index >= this.getCurveCount()) {
            return null;
        }
        return this._lineArray[index];
    }

    public int getCurveCount() {
        return this._lineArray.length;
    }

    public String getCurveName(int curveIndex) {
        if (curveIndex < 0 || curveIndex >= this._lineArray.length) {
            return "";
        }
        if (this._lineArray[curveIndex] == null) {
            return "";
        }
        return this._lineArray[curveIndex].getName();
    }

    public void drawLegendPict(Graphics g, int curveIndex, Dimension dim) {
        if (curveIndex < 0 || curveIndex >= this._lineArray.length) {
            return;
        }
        G2dLineProperties prop = this._lineArray[curveIndex].getProperties();
        int resolution = ((G2dPanel)this._viewport.getParent()).getDeviceResoultion();
        LegendItemDrawUtilities.drawLegendPict(g, prop, dim, resolution);
    }

    public Dimension getLegendPictSize(int curveIndex) {
        if (curveIndex < 0 || curveIndex >= this._lineArray.length) {
            return new Dimension(0, 0);
        }
        return this.getLegendPictSize(this._lineArray[curveIndex].getProperties());
    }

    public boolean isCurveDrawn(int curveNumber) {
        return true;
    }

    public void setCurveDrawn(int curveNumber, boolean drawn) {
    }

    public class PropertiesOKListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }
}

