/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import rma.util.RMAIO;

public abstract class G2dGlyphDataRecord
implements Cloneable,
Serializable {
    protected Hashtable _listeners = new Hashtable();

    public Object clone() {
        Object clone = null;
        try {
            clone = super.clone();
            G2dGlyphDataRecord d = (G2dGlyphDataRecord)clone;
            Enumeration enumeration = this._listeners.elements();
            while (enumeration.hasMoreElements()) {
                ActionListener al = (ActionListener)enumeration.nextElement();
                d.addModifiedListener(al);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return clone;
    }

    public void fireModified() {
        Enumeration enumeration = this._listeners.elements();
        while (enumeration.hasMoreElements()) {
            ActionListener al = (ActionListener)enumeration.nextElement();
            ActionEvent ae = new ActionEvent(this, 0, "modified");
            al.actionPerformed(ae);
        }
    }

    public void addModifiedListener(ActionListener al) {
        this._listeners.put(al, al);
    }

    public void removeModifiedListener(ActionListener al) {
        this._listeners.remove(al);
    }

    public void read(BufferedReader input) throws IOException {
        String line = input.readLine();
        while (line.indexOf("GlyphDataRecordEnd") < 0) {
            String type = RMAIO.getType(line, "=");
            String param = RMAIO.getParam(line, "=");
            this.read0(type, param);
            line = input.readLine();
            System.out.println(line);
        }
    }

    public void write(BufferedWriter output) throws IOException {
        String stringClass = this.getClass().getName();
        output.write("Class=" + stringClass);
        output.newLine();
        this.write0(output);
    }

    protected abstract void read0(String var1, String var2) throws IOException;

    protected abstract void write0(BufferedWriter var1) throws IOException;
}

