/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.G2dPolygonProperties;
import hec.gfx2d.PropertiesSerializer;
import hec.io.AsciiSerializable;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Vector;
import rma.util.RMAIO;

public class G2dGlyphDrawProp
implements AsciiSerializable {
    public static final int PLOT_USING_DEFAULT_LINE_STYLES = 0;
    public static final int PLOT_USING_MAJOR_MINOR_STYLES = 1;
    public static final int PLOT_USING_LABEL_INTERVALS = 2;
    private static final int DEFAULT_FONT_SIZE = 10;
    private static final int DEFAULT_TINY_FONT_SIZE = 6;
    private static final int DEFAULT_MIN_FONT_SIZE = 8;
    private static final int DEFAULT_MAX_FONT_SIZE = 16;
    private static final int DEFAULT_FONT_STYLE = 0;
    private static final int DEFAULT_SPACE = 2;
    private static final int DEFAULT_MAJOR_INTERVAL = 1;
    private static final int DEFAULT_LABEL_INTERVAL = 1;
    private static final String DEFAULT_FFAMILY_STYLE = null;
    private static final boolean DEFAULT_SHOW_ALL_LEGEND_ITEMS = true;
    private static final boolean DEFAULT_DRAW_LEGEND_ITEMS = true;
    private static final int DEFAULT_DRAW_MODE = 0;
    public int fontSize = 10;
    public int tinyFontSize = 6;
    public int minFontSize = 8;
    public int maxFontSize = 16;
    public int fontStyle = 0;
    public String fontFamily = DEFAULT_FFAMILY_STYLE;
    public int space = 2;
    public List lineProperties = new Vector();
    public G2dPolygonProperties polygonProperties = new G2dPolygonProperties();
    boolean _drawLegendItems = true;
    boolean _showAllCurvesOnLegend = true;
    int _drawingMode = 0;
    int _majorMinorInterval = 1;
    int _labelInterval = 1;

    public G2dGlyphDrawProp() {
    }

    public G2dGlyphDrawProp(G2dGlyphDrawProp dp) {
        this.set(dp);
    }

    public void setDrawingMode(int mode) {
        if (mode != 0 && mode != 1 && mode != 2) {
            return;
        }
        this._drawingMode = mode;
    }

    public int getDrawingMode() {
        return this._drawingMode;
    }

    public boolean showLegendItems() {
        return this._drawLegendItems;
    }

    public void setShowLegendItems(boolean b) {
        this._drawLegendItems = b;
    }

    public boolean showAllCurvesOnLegend() {
        return this._showAllCurvesOnLegend;
    }

    public void setShowAllCurvesOnLegend(boolean b) {
        this._showAllCurvesOnLegend = b;
    }

    public int getMajorMinorInterval() {
        return this._majorMinorInterval;
    }

    public int getLabelInterval() {
        return this._labelInterval;
    }

    public void setMajorMinorInterval(int interval) {
        this._majorMinorInterval = interval;
    }

    public void setLabelInterval(int interval) {
        this._labelInterval = interval;
    }

    public void writeProperties(BufferedWriter writer, String endTag) {
        if (writer == null) {
            return;
        }
        PropertiesSerializer.incrementRecursion();
        String indent = PropertiesSerializer.getIndent();
        if (this.fontSize != 10) {
            RMAIO.fout(writer, indent + "fontSize=" + this.fontSize);
        }
        if (this.tinyFontSize != 6) {
            RMAIO.fout(writer, indent + "tinyFontSize=" + this.tinyFontSize);
        }
        if (this.minFontSize != 8) {
            RMAIO.fout(writer, indent + "minFontSize=" + this.minFontSize);
        }
        if (this.maxFontSize != 16) {
            RMAIO.fout(writer, indent + "maxFontSize=" + this.maxFontSize);
        }
        if (this.fontStyle != 0) {
            RMAIO.fout(writer, indent + "fontStyle=" + this.fontStyle);
        }
        if (this.fontFamily != DEFAULT_FFAMILY_STYLE) {
            RMAIO.fout(writer, indent + "fontFamily=" + this.fontFamily);
        }
        if (this.space != 2) {
            RMAIO.fout(writer, indent + "space=" + this.space);
        }
        if (this._drawingMode != 0) {
            RMAIO.fout(writer, indent + "drawMode=" + this._drawingMode);
        }
        if (!this._showAllCurvesOnLegend) {
            RMAIO.fout(writer, indent + "showAllLegendItems=" + this._showAllCurvesOnLegend);
        }
        if (!this._drawLegendItems) {
            RMAIO.fout(writer, indent + "drawLegendItems=" + this._drawLegendItems);
        }
        if (this._majorMinorInterval != 1) {
            RMAIO.fout(writer, indent + "majorInterval=" + this._majorMinorInterval);
        }
        if (this._labelInterval != 1) {
            RMAIO.fout(writer, indent + "labelInterval=" + this._labelInterval);
        }
        for (int i = 0; i < this.lineProperties.size(); ++i) {
            G2dLineProperties lp = (G2dLineProperties)this.lineProperties.get(i);
            if (lp == null) continue;
            RMAIO.fout(writer, indent + "Line Begin");
            lp.writeProperties(writer, "Line End");
        }
        RMAIO.fout(writer, indent + "Polygon Begin");
        this.polygonProperties.writeProperties(writer, "Polygon End");
        PropertiesSerializer.decrementRecursion();
        indent = PropertiesSerializer.getIndent();
        RMAIO.fout(writer, indent + endTag);
    }

    public void readProperties(BufferedReader in, String endTag) {
        if (in == null) {
            return;
        }
        String line = "";
        String param = "";
        String type = "";
        try {
            while ((line = in.readLine()) != null) {
                line.trim();
                param = RMAIO.getParam(line, "=");
                type = RMAIO.getType(line, "=");
                if (!type.equalsIgnoreCase(endTag)) {
                    if (type.equalsIgnoreCase("fontSize")) {
                        this.fontSize = Integer.valueOf(param);
                    }
                    if (type.equalsIgnoreCase("tinyFontSize")) {
                        this.tinyFontSize = Integer.valueOf(param);
                    }
                    if (type.equalsIgnoreCase("minFontSize")) {
                        this.minFontSize = Integer.valueOf(param);
                    }
                    if (type.equalsIgnoreCase("maxFontSize")) {
                        this.maxFontSize = Integer.valueOf(param);
                    }
                    if (type.equalsIgnoreCase("fontStyle")) {
                        this.fontStyle = Integer.valueOf(param);
                    }
                    if (type.equalsIgnoreCase("fontFamily")) {
                        this.fontFamily = param;
                    }
                    if (type.equalsIgnoreCase("space")) {
                        this.space = Integer.valueOf(param);
                    }
                    if (type.equalsIgnoreCase("drawMode")) {
                        this._drawingMode = Integer.valueOf(param);
                    }
                    if (type.equalsIgnoreCase("majorInterval")) {
                        this._majorMinorInterval = Integer.valueOf(param);
                    }
                    if (type.equalsIgnoreCase("labelInterval")) {
                        this._labelInterval = Integer.valueOf(param);
                    }
                    if (type.equalsIgnoreCase("showAllLegendItems")) {
                        this._showAllCurvesOnLegend = Boolean.valueOf(param);
                    }
                    if (type.equalsIgnoreCase("drawLegendItems")) {
                        this._drawLegendItems = Boolean.valueOf(param);
                    }
                    if (type.equalsIgnoreCase("Line Begin")) {
                        G2dLineProperties lp = new G2dLineProperties();
                        lp.readProperties(in, "Line End");
                        this.lineProperties.add(lp);
                    }
                    if (!type.equalsIgnoreCase("Polygon Begin")) continue;
                    this.polygonProperties.readProperties(in, "Polygon End");
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            System.out.println("Error in readProperties(BufferedReader)");
            return;
        }
    }

    public Object clone() {
        return new G2dGlyphDrawProp(this);
    }

    public void set(G2dGlyphDrawProp dp) {
        this.fontSize = dp.fontSize;
        this.tinyFontSize = dp.tinyFontSize;
        this.minFontSize = dp.minFontSize;
        this.maxFontSize = dp.maxFontSize;
        this.fontStyle = dp.fontStyle;
        this.fontFamily = dp.fontFamily;
        this.space = dp.space;
        this.polygonProperties = dp.polygonProperties;
        this.lineProperties = dp.lineProperties;
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

