/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.data.DataSet;
import hec.geometry.Scale;
import hec.gfx2d.DataSetGlyph;
import hec.gfx2d.DefaultG2dGlyph;
import hec.gfx2d.G2dGlyph;
import hec.gfx2d.G2dObject;
import hec.gfx2d.Viewport;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class G2dGlyphFactory {
    public static Map g2dGlyphMapping;
    private static final Map<String, Object> _g2dGlyphMapping;

    @Deprecated
    public static void addMapping(String g2dGlyphDataClass, String g2dGlyphClass) {
        if (g2dGlyphDataClass == null || g2dGlyphClass == null) {
            return;
        }
        _g2dGlyphMapping.put(g2dGlyphDataClass, g2dGlyphClass);
        g2dGlyphMapping = Collections.unmodifiableMap(_g2dGlyphMapping);
    }

    public static void addMapping(Class<?> g2dGlyphDataClass, Class<? extends G2dGlyph> g2dGlyphClass) {
        if (g2dGlyphDataClass == null || g2dGlyphClass == null) {
            return;
        }
        _g2dGlyphMapping.put(g2dGlyphDataClass.getName(), g2dGlyphClass);
        g2dGlyphMapping = Collections.unmodifiableMap(_g2dGlyphMapping);
    }

    public static G2dGlyph newG2dGlyph(Viewport view, G2dObject obj, Scale scl) {
        Class<?> g2dclass = obj.getClass();
        return G2dGlyphFactory.lookupG2dGlyphClass(view, obj, g2dclass, scl);
    }

    private static G2dGlyph lookupG2dGlyphClass(Viewport view, G2dObject obj, Class cls, Scale scl) {
        if (cls == null) {
            return null;
        }
        Class<?> glyphClass = null;
        String strG2dClass = cls.getName();
        Object o = _g2dGlyphMapping.get(strG2dClass);
        if (o instanceof String) {
            try {
                glyphClass = Thread.currentThread().getContextClassLoader().loadClass((String)o);
                _g2dGlyphMapping.put(strG2dClass, glyphClass);
            }
            catch (Exception e) {
                System.out.println("Unable to instantiate class for G2dObject: " + strG2dClass + "  " + e);
                _g2dGlyphMapping.put(strG2dClass, o);
            }
            catch (NoClassDefFoundError nfe) {
                System.out.println("No Glyph Class found for " + o + " for G2dObject " + strG2dClass + "  " + nfe);
            }
        } else if (o instanceof Class) {
            glyphClass = (Class<?>)o;
        }
        if (glyphClass == null) {
            Class<?>[] g2dclassifcs;
            for (Class<?> ifcs : g2dclassifcs = cls.getInterfaces()) {
                G2dGlyph glyph = G2dGlyphFactory.lookupG2dGlyphClass(view, obj, ifcs, scl);
                if (glyph == null) continue;
                return glyph;
            }
            return G2dGlyphFactory.lookupG2dGlyphClass(view, obj, cls.getSuperclass(), scl);
        }
        try {
            Class[] classargs = new Class[]{Viewport.class, cls, Scale.class};
            Constructor<?> constructor = glyphClass.getConstructor(classargs);
            if (constructor != null) {
                Object[] objargs = new Object[]{view, obj, scl};
                return (G2dGlyph)constructor.newInstance(objargs);
            }
        }
        catch (InvocationTargetException ite) {
            System.out.println("G2dGlyphFactory: Error Creating glyph " + glyphClass.getName() + " Error:" + ite.getTargetException());
            ite.getTargetException().printStackTrace(System.out);
            _g2dGlyphMapping.put(strG2dClass, o);
        }
        catch (Exception ee) {
            System.out.println("G2dGlyphFactory: Could not find a G2dGlyph matching the g2d class: " + cls.getName());
            System.out.println("G2dGlyphFactory: " + ee.toString());
            ee.printStackTrace();
            _g2dGlyphMapping.put(strG2dClass, o);
        }
        return null;
    }

    static {
        _g2dGlyphMapping = new HashMap<String, Object>();
        G2dGlyphFactory.addMapping(G2dObject.class, DefaultG2dGlyph.class);
        G2dGlyphFactory.addMapping(DataSet.class, DataSetGlyph.class);
        g2dGlyphMapping = Collections.unmodifiableMap(_g2dGlyphMapping);
    }
}

