/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.geometry.LocalRect;
import hec.gfx2d.G2dComponent;
import hec.gfx2d.G2dGraphicPosition;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Enumeration;
import java.util.Vector;

public class G2dGraphicComponent {
    G2dGraphicComponent _parent = null;
    G2dComponent _parentComponent = null;
    LocalRect _bounds = new LocalRect(5, 5, 50, 50);
    G2dGraphicPosition _position = new G2dGraphicPosition();
    Vector _graphicVector = new Vector();
    Dimension _preferredSize = new Dimension(25, 25);
    int _layoutNumRows = 0;
    float[] _layoutRowWgts = null;
    int _layoutNumCols = 0;
    float[] _layoutColWgts = null;

    public G2dGraphicComponent() {
    }

    public G2dGraphicComponent(G2dGraphicComponent g, G2dComponent c2) {
        this._parent = g;
        this._parentComponent = c2;
    }

    public void setPosition(G2dGraphicPosition pos) {
        this._position = pos;
    }

    public G2dGraphicPosition getPosition() {
        return this._position;
    }

    public void paint(Graphics g) {
        if (this._graphicVector.isEmpty()) {
            g.setColor(Color.black);
            g.drawRect(this._bounds.l, this._bounds.t, this._bounds.width() - 1, this._bounds.height() - 1);
            g.drawLine(this._bounds.l, this._bounds.t, this._bounds.r, this._bounds.b);
            g.drawLine(this._bounds.r, this._bounds.t, this._bounds.l, this._bounds.b);
        }
        Enumeration e = this._graphicVector.elements();
        while (e.hasMoreElements()) {
            ((G2dGraphicComponent)e.nextElement()).paint(g);
        }
    }

    void addGraphic(G2dGraphicComponent graphic) {
        this._graphicVector.addElement(graphic);
        this.sizeChildren();
    }

    public Dimension getPreferredSize() {
        return this._preferredSize;
    }

    public Dimension getPreferredSize(Graphics g) {
        int i;
        Dimension pt = new Dimension();
        if (this._graphicVector.size() == 0) {
            return this._preferredSize;
        }
        float[] colsz = new float[this._layoutNumCols];
        float[] rowsz = new float[this._layoutNumRows];
        for (i = 0; i < this._layoutNumCols; ++i) {
            colsz[i] = this._preferredSize.width;
        }
        for (i = 0; i < this._layoutNumRows; ++i) {
            rowsz[i] = this._preferredSize.height;
        }
        Enumeration e = this._graphicVector.elements();
        while (e.hasMoreElements()) {
            G2dGraphicComponent elem = (G2dGraphicComponent)e.nextElement();
            G2dGraphicPosition pos = elem.getPosition();
            if (!(pos.colWgt < 0.0f) && !(pos.rowWgt < 0.0f)) continue;
            pt = elem.getPreferredSize(g);
            for (i = pos.row; i < pos.row + pos.numRows; ++i) {
                if (!(rowsz[i] < (float)pt.height)) continue;
                rowsz[i] = pt.height;
            }
            for (i = pos.col; i < pos.col + pos.numCols; ++i) {
                if (!(colsz[i] < (float)pt.width)) continue;
                colsz[i] = pt.width;
            }
        }
        pt.width = 0;
        pt.height = 0;
        for (i = 0; i < this._layoutNumCols; ++i) {
            pt.width = (int)((float)pt.width + colsz[i]);
        }
        for (i = 0; i < this._layoutNumRows; ++i) {
            pt.height = (int)((float)pt.height + rowsz[i]);
        }
        return pt;
    }

    public void clear() {
        this._graphicVector.removeAllElements();
    }

    public boolean setBounds(Graphics zd, LocalRect rc) {
        int inc;
        this._bounds.init(rc);
        float[] rowpos = new float[this._layoutNumRows + 1];
        float[] colpos = new float[this._layoutNumCols + 1];
        Dimension[] prefsz = new Dimension[this._graphicVector.size()];
        int i = 0;
        Enumeration e = this._graphicVector.elements();
        while (e.hasMoreElements()) {
            G2dGraphicComponent elem = (G2dGraphicComponent)e.nextElement();
            G2dGraphicPosition pos = elem.getPosition();
            if (pos.colWgt < 0.0f || pos.rowWgt < 0.0f) {
                prefsz[i] = elem.getPreferredSize(zd);
                prefsz[i].width /= pos.numCols;
                prefsz[i].height /= pos.numRows;
            }
            ++i;
        }
        float sumwgt = 0.0f;
        float fixed = 0.0f;
        for (i = 0; i < this._layoutNumRows; ++i) {
            if (this._layoutRowWgts[i] > 0.0f) {
                sumwgt += this._layoutRowWgts[i];
                continue;
            }
            if (!(this._layoutRowWgts[i] < 0.0f)) continue;
            fixed += (float)prefsz[(int)Math.abs((float)this._layoutRowWgts[i]) - 1].height;
        }
        rowpos[0] = rc.t;
        for (i = 0; i < this._layoutNumRows; ++i) {
            if (this._layoutRowWgts[i] > 0.0f) {
                inc = (int)(this._layoutRowWgts[i] / sumwgt * ((float)rc.height() - fixed));
                if (inc < 0) {
                    inc = 0;
                }
                rowpos[i + 1] = rowpos[i] + (float)inc;
                continue;
            }
            if (!(this._layoutRowWgts[i] < 0.0f)) continue;
            rowpos[i + 1] = rowpos[i] + (float)prefsz[(int)Math.abs((float)this._layoutRowWgts[i]) - 1].height;
        }
        rowpos[this._layoutNumRows] = rc.b;
        sumwgt = 0.0f;
        fixed = 0.0f;
        for (i = 0; i < this._layoutNumCols; ++i) {
            if (this._layoutColWgts[i] > 0.0f) {
                sumwgt += this._layoutColWgts[i];
                continue;
            }
            if (!(this._layoutColWgts[i] < 0.0f)) continue;
            fixed += (float)prefsz[(int)Math.abs((float)this._layoutColWgts[i]) - 1].width;
        }
        colpos[0] = rc.l;
        for (i = 0; i < this._layoutNumCols; ++i) {
            if (this._layoutColWgts[i] > 0.0f) {
                inc = (int)(this._layoutColWgts[i] / sumwgt * ((float)rc.width() - fixed));
                if (inc < 0) {
                    inc = 0;
                }
                colpos[i + 1] = colpos[i] + (float)inc;
                continue;
            }
            if (!(this._layoutColWgts[i] < 0.0f)) continue;
            colpos[i + 1] = colpos[i] + (float)prefsz[(int)Math.abs((float)this._layoutColWgts[i]) - 1].width;
        }
        colpos[this._layoutNumCols] = rc.r;
        LocalRect bound = new LocalRect();
        Enumeration e2 = this._graphicVector.elements();
        while (e2.hasMoreElements()) {
            G2dGraphicComponent elem = (G2dGraphicComponent)e2.nextElement();
            G2dGraphicPosition pos = elem.getPosition();
            bound.l = (int)colpos[pos.col];
            bound.r = (int)colpos[pos.col + pos.numCols];
            bound.t = (int)rowpos[pos.row];
            bound.b = (int)rowpos[pos.row + pos.numRows];
            elem.setBounds(zd, bound);
        }
        return true;
    }

    public LocalRect getBounds() {
        return this._bounds;
    }

    public void sizeChildren() {
        int i;
        this._layoutNumCols = 0;
        this._layoutNumRows = 0;
        Enumeration e = this._graphicVector.elements();
        while (e.hasMoreElements()) {
            G2dGraphicComponent elem = (G2dGraphicComponent)e.nextElement();
            G2dGraphicPosition pos = elem.getPosition();
            if (this._layoutNumRows < pos.row + pos.numRows) {
                this._layoutNumRows = pos.row + pos.numRows;
            }
            if (this._layoutNumCols >= pos.col + pos.numCols) continue;
            this._layoutNumCols = pos.col + pos.numCols;
        }
        this._layoutRowWgts = new float[this._layoutNumRows];
        this._layoutColWgts = new float[this._layoutNumCols];
        Dimension sz = new Dimension();
        for (i = 0; i < this._layoutNumRows; ++i) {
            this._layoutRowWgts[i] = 1.0f;
        }
        for (i = 0; i < this._layoutNumCols; ++i) {
            this._layoutColWgts[i] = 1.0f;
        }
        int icnt = 1;
        Enumeration e2 = this._graphicVector.elements();
        while (e2.hasMoreElements()) {
            G2dGraphicComponent elem = (G2dGraphicComponent)e2.nextElement();
            G2dGraphicPosition pos = elem.getPosition();
            if (pos.rowWgt > 0.0f) {
                for (i = pos.row; i < pos.row + pos.numRows; ++i) {
                    this._layoutRowWgts[i] = pos.rowWgt;
                }
            } else if (pos.rowWgt < 0.0f) {
                for (i = pos.row; i < pos.row + pos.numRows; ++i) {
                    this._layoutRowWgts[i] = -icnt;
                }
            }
            if (pos.colWgt > 0.0f) {
                for (i = pos.col; i < pos.col + pos.numCols; ++i) {
                    this._layoutColWgts[i] = pos.colWgt;
                }
            } else if (pos.colWgt < 0.0f) {
                for (i = pos.col; i < pos.col + pos.numCols; ++i) {
                    this._layoutColWgts[i] = -icnt;
                }
            }
            ++icnt;
        }
    }
}

