/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.gfx2d.GridProperties;
import hec.gfx2d.SimpleLinePropertiesPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.border.TitledBorder;
import rma.swing.DefaultJPanel;
import rma.swing.RmaInsets;

public class G2dGridPropertiesPanel
extends DefaultJPanel {
    GridProperties _gridProperties = null;
    SimpleLinePropertiesPanel majorXPanel = new SimpleLinePropertiesPanel("Draw Major X Grid");
    SimpleLinePropertiesPanel minorXPanel = new SimpleLinePropertiesPanel("Draw Minor X Grid");
    SimpleLinePropertiesPanel majorYPanel = new SimpleLinePropertiesPanel("Draw Major Y Grid");
    SimpleLinePropertiesPanel minorYPanel = new SimpleLinePropertiesPanel("Draw Minor Y Grid");

    public G2dGridPropertiesPanel() {
        this.setLayout(new GridBagLayout());
        Insets ins = this.getInsets();
        this.setName("Gridlines");
        this.add((Component)this.majorXPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, RmaInsets.insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.minorXPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 16, 1, RmaInsets.insets(5, 5, 5, 0), 0, 0));
        this.add((Component)this.majorYPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 12, 1, RmaInsets.insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.minorYPanel, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 14, 1, RmaInsets.insets(5, 5, 5, 5), 0, 0));
        this.majorXPanel.setBorder(new TitledBorder("Major X Grid"));
        this.minorXPanel.setBorder(new TitledBorder("Minor X Grid"));
        this.majorYPanel.setBorder(new TitledBorder("Major Y Grid"));
        this.minorYPanel.setBorder(new TitledBorder("Minor Y Grid"));
        this.minorXPanel.setCustomEnabled(false);
        this.minorYPanel.setCustomEnabled(false);
        Dimension d = this.getPreferredSize();
        this.setSize(d.width, d.height);
    }

    public void setData(GridProperties gp) {
        this._gridProperties = gp;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void fillPanel() {
        if (this._gridProperties == null) {
            return;
        }
        this.majorXPanel.setCustomEnabled(this._gridProperties.showMajorXGridLines());
        this.majorXPanel.setLineColor(this._gridProperties.getMajorXGridColor());
        this.majorXPanel.setLineStyle(this._gridProperties.getMajorXGridStyle());
        this.majorXPanel.setLineWidth(this._gridProperties.getMajorXGridWeight());
        this.minorXPanel.setCustomEnabled(this._gridProperties.showMinorXGridLines());
        this.minorXPanel.setLineColor(this._gridProperties.getMinorXGridColor());
        this.minorXPanel.setLineStyle(this._gridProperties.getMinorXGridStyle());
        this.minorXPanel.setLineWidth(this._gridProperties.getMinorXGridWeight());
        this.majorYPanel.setCustomEnabled(this._gridProperties.showMajorYGridLines());
        this.majorYPanel.setLineColor(this._gridProperties.getMajorYGridColor());
        this.majorYPanel.setLineStyle(this._gridProperties.getMajorYGridStyle());
        this.majorYPanel.setLineWidth(this._gridProperties.getMajorYGridWeight());
        this.minorYPanel.setCustomEnabled(this._gridProperties.showMinorYGridLines());
        this.minorYPanel.setLineColor(this._gridProperties.getMinorYGridColor());
        this.minorYPanel.setLineStyle(this._gridProperties.getMinorYGridStyle());
        this.minorYPanel.setLineWidth(this._gridProperties.getMinorYGridWeight());
    }

    public void refresh() {
    }

    @Override
    public boolean savePanel() {
        if (this._gridProperties == null) {
            return true;
        }
        this._gridProperties.setShowMajorXGridLines(this.majorXPanel.isCustomEnabled());
        this._gridProperties.setMajorXGridColor(this.majorXPanel.getLineColor());
        this._gridProperties.setMajorXGridWeight(this.majorXPanel.getLineWidth());
        this._gridProperties.setMajorXGridStyle(this.majorXPanel.getLineStyle());
        this._gridProperties.setShowMinorXGridLines(this.minorXPanel.isCustomEnabled());
        this._gridProperties.setMinorXGridColor(this.minorXPanel.getLineColor());
        this._gridProperties.setMinorXGridWeight(this.minorXPanel.getLineWidth());
        this._gridProperties.setMinorXGridStyle(this.minorXPanel.getLineStyle());
        this._gridProperties.setShowMajorYGridLines(this.majorYPanel.isCustomEnabled());
        this._gridProperties.setMajorYGridColor(this.majorYPanel.getLineColor());
        this._gridProperties.setMajorYGridWeight(this.majorYPanel.getLineWidth());
        this._gridProperties.setMajorYGridStyle(this.majorYPanel.getLineStyle());
        this._gridProperties.setShowMinorYGridLines(this.minorYPanel.isCustomEnabled());
        this._gridProperties.setMinorYGridColor(this.minorYPanel.getLineColor());
        this._gridProperties.setMinorYGridWeight(this.minorYPanel.getLineWidth());
        this._gridProperties.setMinorYGridStyle(this.minorYPanel.getLineStyle());
        return true;
    }
}

